<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for theme SimpleMag
 * http://www.videoblogsterpro.com/get/simplemag/
 *
 * This theme uses the video post format with it's own custom meta fields to store the VideoEmbed.
 * This file will only be included if SimpleMag is the active theme.
 *
 */

if ( ! function_exists( 'vb_insert_simplemag_changes' ) ) :

// shows changes on make video feed form:
add_action('vbp_make_feed', 'vb_insert_simplemag_changes', 10, 1);

function vb_insert_simplemag_changes( $args ) {
	$addArgs = array (
		'pPostTemplate'		=> '%VideoDescription%',
	);
	$args = array_merge( $args, $addArgs );

	$addFields = array(
		'add_video_url'         => '%VideoUrl%',
	);
	$args['pMetaFields'] = array_merge( $args['pMetaFields'], $addFields );

	$args['cPostFormat'] = 'video';
	return $args;
}

// dynamic get VB meta field values if missing
//add_filter('get_post_metadata', 'vb_meta_check', 10, 4);
function vb_meta_check( $metadata, $postID, $meta_key, $single ) {
	global $wpdb;
	$metadata = $wpdb->get_var( "SELECT meta_value FROM $wpdb->postmeta WHERE post_id = {$postID} AND meta_key = '{$meta_key}'" );
	if ( $metadata != null ) return null;
	if ( $meta_key == 'add_video_url' ) 	return get_post_meta( $postID, 'VideoUrl', $single );
	return null;
}

// dynamic VB remove any iframe from content - theme uses meta field instead
//add_filter('the_content', 'vb_content_check' );
function vb_content_check( $content ) {
	$content = preg_replace('/<iframe.*?\/iframe>/i','', $content);
	return $content;
}


// dynamic VB ensure post format for new posts is 'video'
//add_filter('vb_create_the_post_finished', 'vb_format_check', 10, 2 );
function vb_format_check( $postID, $videoInfo ) {
	set_post_format( $postID, 'video' );
	return null;
}

endif;
?>
