<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for theme Video from ThemeShop
 * http://mythemeshop.com/themes/video/
 *
 * This theme uses the post format with it's own custom meta fields to store Video information, YouTube only.
 * If you want to import Vimeo or DailyMotion you'll have to change some of th custom meta fields. :(
 * This function hook will set the post format, add those fields to Video Blogster feed form and reset the description.
 * This file will only be included if Video from ThemeShop is the active theme.
 *
 */

if ( ! function_exists( 'vb_insert_videothemeshop_changes' ) ) :

// shows changes on make video feed form:
add_action('vbp_make_feed', 'vb_insert_videothemeshop_changes', 10, 1);

function vb_insert_videothemeshop_changes( $args ) {
	$addArgs = array (
		'pPostTemplate'		=> '%VideoDescription%',
	);
	$args = array_merge( $args, $addArgs );

	$addFields = array(
		'youtube-select'	=> 'video-id',
		'playlist-id'		=> '%VideoID%',
		'_mts_likes'		=> '%VideoLikes%',
		'_mts_dislikes'		=> '%VideoDislikes%',
		'video-views'      	=> '%VideoViews%',
		'autoplay-video'	=> false,	
		'video-service'		=> 'youtube',	
	);
	$args['pMetaFields'] = array_merge( $args['pMetaFields'], $addFields );

	$args['cPostFormat'] = 'video';
	return $args;
}

// dynamic get VB meta field values if missing
//add_filter('get_post_metadata', 'vb_meta_check', 10, 4);
function vb_meta_check( $metadata, $postID, $meta_key, $single ) {
	global $wpdb;
	$metadata = $wpdb->get_var( "SELECT meta_value FROM $wpdb->postmeta WHERE post_id = {$postID} AND meta_key = '{$meta_key}'" );
	if ( $metadata != null ) return null;
	if ( $meta_key == 'youtube-select' ) 	return 'video-id';
	if ( $meta_key == 'playlist-id' ) 	return get_post_meta( $postID, 'VideoID', $single );
	if ( $meta_key == '_mts_likes' )	return get_post_meta( $postID, 'VideoLikes', $single );
	if ( $meta_key == '_mts_dislikes' )	return get_post_meta( $postID, 'VideoDislikes', $single );
	if ( $meta_key == 'video-views' ) 	return get_post_meta( $postID, 'VideoViews', $single );
	return null;
}

// dynamic VB remove any iframe from content - theme uses meta field instead
//add_filter('the_content', 'vb_content_check' );
function vb_content_check( $content ) {
	$content = preg_replace('/<iframe.*?\/iframe>/i','', $content);
	return $content;
}

endif;
?>
