<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for theme Video Member
 * http://www.inkthemes.com/members/aff/go/johnh10/?i=342
 *
 * This theme uses the video_listing post type with it's own custom meta fields to store the VideoUrl, VideoLikes and VideoDislikes.
 * This function hook will set the video_listing post type, add those fields to Video Blogster feed form and reset the description.
 * This file will only be included if Video Member is the active theme.
 *
 */

if ( ! function_exists( 'vb_insert_video_member_changes' ) ) :

// shows changes on make video feed form:
add_action('vbp_make_feed', 'vb_insert_video_member_changes', 10, 1);

function vb_insert_video_member_changes( $args ) {
	$addArgs = array (
		'pPostTemplate'		=> '%VideoDescription%',
	);
	$args = array_merge( $args, $addArgs );

	$addFields = array(
		'_video_url'		=> '%VideoUrl%',
		'post_views_count'	=> '%VideoViews%',
		'likes'			=> '%VideoLikes%',
		'dislikes'		=> '%VideoDislikes%',
		'featured_video'	=> 'off'
	);
	$args['pMetaFields'] = array_merge( $args['pMetaFields'], $addFields );

	$args['cPostType'] = 'video_listing';
	return $args;
}


// dynamic get VB meta field values if missing
//add_filter('get_post_metadata', 'vb_meta_check', 10, 4);
function vb_meta_check( $metadata, $postID, $meta_key, $single ) {
	global $wpdb;
	$metadata = $wpdb->get_var( "SELECT meta_value FROM $wpdb->postmeta WHERE post_id = {$postID} AND meta_key = '{$meta_key}'" );
	if ( $metadata != null ) return null;
	if ( $meta_key == '_video_url' )	return get_post_meta( $postID, 'VideoUrl', $single );
	if ( $meta_key == 'post_views_count' ) 	return get_post_meta( $postID, 'views', $single );
	if ( $meta_key == 'likes' ) 		return get_post_meta( $postID, 'VideoLikes', $single );
	if ( $meta_key == 'dislikes' ) 		return get_post_meta( $postID, 'VideoDislikes', $single );
	if ( $meta_key == 'featured_video' ) 	return 'off';
	return null;
}

// dynamic VB remove any iframe from content - theme uses meta field instead
//add_filter('the_content', 'vb_content_check' );
function vb_content_check( $content ) {
	$content = preg_replace('/<iframe.*?\/iframe>/i','', $content);
	return $content;
}

endif;
?>
