<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for theme Videofly
 * http://www.videoblogsterpro.com/get/videofly/
 *
 * This theme uses the video post format with it's own custom meta fields and only supports YouTube and Vimeo.
 * This function hook will set the video post format, add those fields to Video Blogster feed form and reset the description.
 * This file will only be included if Videofly is the active theme.
 *
 */

if ( ! function_exists( 'vb_insert_videofly_changes' ) ) :

// shows changes on make video feed form:
add_action('vbp_make_feed', 'vb_insert_videofly_changes', 10, 1);

function vb_insert_videofly_changes( $args ) {
	$addArgs = array (
		'pPostTemplate'		=> '%VideoDescription%',
	);
	$args = array_merge( $args, $addArgs );

	$addFields = array(
		'ts-video'         => '{"type":"url","video":"%VideoUrl%"}',
	);
	$args['pMetaFields'] = array_merge( $args['pMetaFields'], $addFields );

	$args['cPostType'] = 'video';
	return $args;
}


endif;
?>
