<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for theme VideoPlus
 *
 * This theme uses the video post format with it's own custom meta fields to store video data.
 * This function hook will set the custom data from VBP.
 * This file will only be included if VideoPlus is the active theme.
 *
 */

if ( ! function_exists( 'vb_insert_videoplus_changes' ) ) :

// shows changes on make video feed form:
add_action('vbp_make_feed', 'vb_insert_videoplus_changes', 10, 1);

function vb_insert_videoplus_changes( $args ) {
	$addArgs = array (
		'pPostTemplate'		=> '%VideoDescription%',
	);
	$args = array_merge( $args, $addArgs );

	$addFields = array(
		'tj_video_embed'	=> '{"embed":"%VideoEmbed%"}',
	);
	$args['pMetaFields'] = array_merge( $args['pMetaFields'], $addFields );

	return $args;
}

add_filter( 'vb_before_process_query_results', 'videoplus_before_process_query_results' );

function videoplus_before_process_query_results( $videoInfo ) {
  $videoInfo['videoEmbed'] = stripslashes(htmlspecialchars(( $videoInfo['videoEmbed']), ENT_QUOTES) );
  return $videoInfo;
}

endif;
?>
