<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for theme VideoPro
 * http://www.videoblogsterpro.com/get/videopro/
 *
 * This theme uses the video post format with it's own custom meta fields to store the VideoEmbed and VideoDuration.
 * This function hook will set the video post format, add those fields to Video Blogster feed form and reset the description.
 * This file will only be included if VideoPro is the active theme.
 *
 */

if ( ! function_exists( 'vb_insert_videopro_changes' ) ) :

// shows changes on make video feed form:
add_action('vbp_make_feed', 'vb_insert_videopro_changes', 10, 1);

function vb_insert_videopro_changes( $args ) {
	$addArgs = array (
		'pPostTemplate'		=> '%VideoDescription%',
	);
	$args = array_merge( $args, $addArgs );

	$addFields = array(
		'tm_video_url'          => '%VideoUrl%',
		'tm_video_code'         => '%VideoEmbed%',
		'time_video'        	=> '%VideoDuration%',
	);
	$args['pMetaFields'] = array_merge( $args['pMetaFields'], $addFields );

	$args['cPostFormat'] = 'video';
	return $args;
}


// VideoPro uses HH:MM:SS for video_duration and seconds for time_video
add_action('added_post_meta', 'vb_video_duration_convert', 10, 4);
function vb_video_duration_convert( $meta_id, $post_id, $meta_key, $meta_value ) {
        if ( 'video_duration' == $meta_key ) {
                sscanf($meta_value, "%d:%d:%d", $hours, $minutes, $seconds);
                $secs = isset($seconds) ? $hours * 3600 + $minutes * 60 + $seconds : $hours * 60 + $minutes;
                add_post_meta( $post_id, 'video_duration', $secs );
        }
}


endif;
?>
