<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for theme VideoTouch
 * http://www.videoblogsterpro.com/get/videotouch/
 *
 * This theme uses the video post format with it's own custom meta fields to store video data.
 * This function hook will set the custom data from VBP.
 * This file will only be included if VideoTouch is the active theme.
 *
 */

if ( ! function_exists( 'vb_insert_videotouch_changes' ) ) :

// shows changes on make video feed form:
add_action('vbp_make_feed', 'vb_insert_videotouch_changes', 10, 1);

function vb_insert_videotouch_changes( $args ) {
	$addArgs = array (
		'pPostTemplate'		=> '%VideoDescription%',
	);
	$args = array_merge( $args, $addArgs );

	$addFields = array(
		'video'		=> '{"embed":"%VideoEmbed%"}',
	);
	$args['pMetaFields'] = array_merge( $args['pMetaFields'], $addFields );

	$args['cPostType'] = 'video';

	return $args;
}

endif;
?>
