<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for theme VideoTube
 * http://www.videoblogsterpro.com/get/videotube/
 *
 * This theme uses the video post format with it's own custom meta fields to store the VideoEmbed, VideoViews, and VideoLikes.
 * This function hook will set the video post format, add those fields to Video Blogster feed form, set layout to 'small' and reset the description.
 * This file will only be included if VideoTube is the active theme.
 *
 */

if ( ! function_exists( 'vb_insert_videotube_changes' ) ) :

// shows changes on make video feed form:
add_action('vbp_make_feed', 'vb_insert_videotube_changes', 10, 1);

function vb_insert_videotube_changes( $args ) {
	$addArgs = array (
		'pPostTemplate'		=> '%VideoDescription%',
	);
	$args = array_merge( $args, $addArgs );

	$addFields = array(
		'video_frame'		=> '%VideoEmbed%',
		'count_viewed'          => '%VideoViews%',
		'like_key'              => '%VideoLikes%',
		'layout'                => 'small'
	);
	$args['pMetaFields'] = array_merge( $args['pMetaFields'], $addFields );

	$args['cPostType'] = 'video';
	$args['cPostFormat'] = 'video';

	return $args;
}


endif;
?>
