<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for theme VideoZine
 * https://themepacific.com/videozine-pro/3778/
 *
 * This theme uses the video post format with it's own custom meta fields to store the VideoEmbed and VideoDuration.
 * This function hook will set the video post format, add those fields to Video Blogster feed form and reset the description.
 * This file will only be included if VideoZine is the active theme.
 *
 */

if ( ! function_exists( 'vb_insert_videozine_changes' ) ) :

// shows changes on make video feed form:
add_action('vbp_make_feed', 'vb_insert_videozine_changes', 10, 1);

function vb_insert_videozine_changes( $args ) {
	$addArgs = array (
		'pPostTemplate'		=> '%VideoDescription%',
	);
	$args = array_merge( $args, $addArgs );

	$addFields = array(
		'tp_video_url'          => '%VideoUrl%',
		'tp_video_embed'        => '%VideoEmbed%',
		'tp_image'        	=> '%VideoImage%',
		'tp_video_duration'     => '%VideoDuration%',
		'tpcrn_like_count'      => '%VideoLikes%',
		'tp_postviews'      	=> '%VideoViews%',
		'tp_img_layout'		=> 'default',		// default, full, or normal
		'tp_single_layout'	=> 'default',		// default, left, right, full
	);
	$args['pMetaFields'] = array_merge( $args['pMetaFields'], $addFields );

	$args['cPostFormat'] = 'video';
	return $args;
}

endif;
?>
