<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/* Support for theme VidoRev
 * https://themeforest.net/collections/7386109-vidorev-video-wordpress-theme?ref=johnh10
 *
 * This example uses the portfolio post format with it's own custom meta fields to store the VideoUrl.
 * This function hook will set the video post format, add those fields to Video Blogster feed form and reset the description.
 * This file will only be included if VidoRev is the active theme.
 *
 */

if ( ! function_exists( 'vb_insert_vidorev_changes' ) ) :

// shows changes on make video feed form:
add_action('vbp_make_feed', 'vb_insert_vidorev_changes', 10, 1);

function vb_insert_vidorev_changes( $args ) {
	$addArgs = array (
		'pPostTemplate'		=> '%VideoDescription%',
	);
	$args = array_merge( $args, $addArgs );

	$addFields = array(

		'vm_video_url'				=> '%VideoUrl%',
		'vm_view_count'				=> '%VideoViews%',

	);
	$args['pMetaFields'] = array_merge( $args['pMetaFields'], $addFields );

	$args['cPostType'] = 'post';
	$args['cPostFormat'] = 'video';

	return $args;
}


endif;
?>
