<?php
/**
 * Remove plugin options and custom database. Automatically called when plugin is deleted.
 */
if( ! defined( 'WP_UNINSTALL_PLUGIN' ) )  {
	exit();
}
if( ! defined( 'VIDEO_BLOGSTER_PREFIX' ) )  {
	define('VIDEO_BLOGSTER_PREFIX', 'video_blogster_');
}

if ( is_multisite() ) {
	global $wpdb;
	$blog_ids = $wpdb->get_col( "SELECT blog_id FROM {$wpdb->prefix}blogs" );
	if ( count ( $blog_ids ) >= 1 ) {
		foreach ( $blog_ids as $blog_id ) {
			switch_to_blog( $blog_id );
			vbp_delete_data();
			restore_current_blog();
		}
	}
} else {
	vbp_delete_data();
}

function vbp_delete_data() {
        delete_option( VIDEO_BLOGSTER_PREFIX . 'db_version' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'sch_start' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'sch_freq' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'util_start' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'sch_checker' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'sch_enabled' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'logfile' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'verbose' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'default_title_template' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'default_post_template' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'license' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'purchase_code' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'status' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'tools' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'max_execution_time' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'messages' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'messages_max' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'running' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'tools' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'video_blacklist' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'beta' );
        delete_option( VIDEO_BLOGSTER_PREFIX . 'dismissible_messages' );

	//drop custom db table
	global $wpdb;
	$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}" . VIDEO_BLOGSTER_PREFIX . "feed" );
	$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}" . VIDEO_BLOGSTER_PREFIX . "log" );
}

?>
