<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/**
 * Class for functions not directly related to handling video feeds
 */
if ( ! class_exists( 'Video_Blogster_Core' ) ) {

    class Video_Blogster_Core {

	public $display_msgs = FALSE;	// internal: sends msgs to error log or display screen
	private $messages = array();            // level of messages to display

	protected $plugin = null;
	public $logger = null;

	private $error_summary = array();

	public function __construct( $params = array() ) {
		$this->plugin = $params;
		$this->get_options_to_vars();

		#SINGLETON $this->logger = Video_Blogster_Log::getInstance();
		$this->logger = new Video_Blogster_Log();
		$this->logger->init( $params );

		add_action( 'admin_notices', array( $this, 'admin_important_messages' ) );
		add_action( 'wp_ajax_dismissed_notice_handler', array( $this, 'ajax_notice_handler' ) );
		add_action( 'vp_hourly_meta_check', array( $this, 'vp_hourly_meta_check' ) );

		$name = $this->get_my_plugin( 'name' );
		if ( $name == 'Video Pornster' ) {
			$hourly_sites = array( 'YouPorn', 'PornHub', 'RedTube' );
			foreach ( $hourly_sites as $site ) {
				$args = array( 'site' => $site );
				if ( ! wp_next_scheduled( 'vp_hourly_meta_check', $args ) )
					wp_schedule_event( time() + mt_rand(0,300), 'hourly', 'vp_hourly_meta_check', $args );
			}
		}
	}

	/**
	 * Add a Settings shortcut link to the description for the plugin on the Plugins dashboard page
	 */
	public function main_settings_link( $links ) {
		$settings_link = '<a href="admin.php?page=' . $this->get_my_plugin( 'id' ) . '">Settings</a>';
		array_unshift( $links, $settings_link );
		return $links;
	}

	/*
	 * Add these menus to the admin dashboard
	 */
	public function add_menus() {
		// create top level menu on dashboard sidebar
        	add_menu_page( 
			$this->get_my_plugin( 'short_name' ) . ': Main Settings',	// page title
			$this->get_my_plugin( 'short_name' ),				// menu title
			'moderate_comments',				// capability required
			$this->get_my_plugin( 'id' ),				// menu id
			array( $this, 'main_settings' ),		// function to call
			'dashicons-video-alt3'				// icon
		);

        	//create submenu items for our menu
        	add_submenu_page( 
			$this->get_my_plugin( 'id' ), 
			$this->get_my_plugin( 'short_name' ) . ': Main Settings', 
			'Main Settings', 
			'moderate_comments', 
			$this->get_my_plugin( 'id' ), 
			array( $this, 'main_settings' ) 
		);
        	add_submenu_page( 
			$this->get_my_plugin( 'id' ),
			$this->get_my_plugin( 'short_name' ) . ': Make Content Feed',
			'Make Content Feed',
			'moderate_comments',
			$this->get_my_plugin( 'prefix' ) . 'video_feed',
			array( $this, 'make_video_feed' )
		);
        	add_submenu_page( 
			$this->get_my_plugin( 'id' ),
			$this->get_my_plugin( 'short_name' ) . ': Show Content Feeds',
			'Show Content Feeds', 
			'moderate_comments', 
			$this->get_my_plugin( 'prefix' ) . 'show_video_feeds', 
			array( $this, 'show_video_feeds' ) 
		);
        	add_submenu_page( 
			$this->get_my_plugin( 'id' ),
			$this->get_my_plugin( 'short_name' ) . ': Import Export Feeds',
			'Import/Export Feeds', 
			'moderate_comments', 
			$this->get_my_plugin( 'prefix' ) . 'import_export_feeds', 
			array( $this, 'import_export_feeds' ) 
		);
        	add_submenu_page( 
			$this->get_my_plugin( 'id' ), 
			$this->get_my_plugin( 'short_name' ) . ': Scheduler', 
			'Scheduler', 
			'moderate_comments', 
			$this->get_my_plugin( 'prefix' ) . 'scheduler', 
			array( $this->scheduler, 'show_scheduler') 
		);
        	add_submenu_page( 
			$this->get_my_plugin( 'id' ), 
			$this->get_my_plugin( 'short_name' ) . ': Log Messages', 
			'Log Messages', 
			'moderate_comments',
			$this->get_my_plugin( 'prefix' ) . 'logfile', 
			array( $this->logger, 'show_logfile' ) 
		);

		$key = $this->get_my_plugin( 'prefix' ) . $this->vbp_decode( 'c3RhdHVz' );
		if ( false === ( $value = get_transient( $key ) ) ) {
			$plugin = $this->get_my_plugin( 'slug' ) . '/' . $this->get_my_plugin( 'slug' ) . ".php";
			add_action("after_plugin_row_{$plugin}", function( $plugin_file, $plugin_data, $status ) {
				echo '<tr class="active"><td>&nbsp;</td><td colspan="2"><div class="notice notice-warning inline"><p>'
				. esc_html__( 'This plugin is not registered. Automatic updates are disabled. Please enter your purchase code in the \'Main Settings\' page to unlock. ', 'video-link-checker')
				. '</p></div></td></tr>';
        		}, 10, 3 );
		}
	} 

	/**
	 * Verify database is up to date and set plugin option defaults
	 */
        public function activate() {

		// check for required versions of WordPress and PHP
		global $wp_version;
		$checks_passed = FALSE;
		$wp = "3.0";
		$php = "5.2";
		if ( version_compare( PHP_VERSION, $php, '<' ) ) {
			$flag = 'PHP';
		}
		elseif ( version_compare( $wp_version, $wp, '<' ) ) {
			$flag = 'WordPress';
		}
		else { // everything passes check
			$checks_passed = TRUE;
		}
		if ( FALSE === $checks_passed ) {
			$version = 'PHP' == $flag ? $php : $wp;
			$current_version = 'PHP' == $flag ? PHP_VERSION : $wp_version;
			deactivate_plugins( basename( $this->get_my_plugin( 'file' ) ) );
			wp_die('<p>Notice! The <strong>' . $this->get_my_plugin( 'name' ) . '</strong> plugin requires '.$flag.'  version '.$version.' or greater. <br />(Currently installed: '.$flag.' version '.$current_version.')</p>','Plugin Activation Error',  array( 'response'=>200, 'back_link'=>TRUE ) );
		}

		if ( get_option( $this->get_my_plugin( 'prefix' ) . 'db_version' ) != $this->get_my_plugin( 'db_version' ) ) { // database has changed
			$this->db_install();
		}
        	add_option( $this->get_my_plugin( 'prefix' ) . 'sch_start', "0" );
        	add_option( $this->get_my_plugin( 'prefix' ) . 'sch_freq', "24" );
        	add_option( $this->get_my_plugin( 'prefix' ) . 'util_start', "0" );
        	add_option( $this->get_my_plugin( 'prefix' ) . 'sch_checker', "12" );
        	add_option( $this->get_my_plugin( 'prefix' ) . 'sch_enabled', FALSE );
        	add_option( $this->get_my_plugin( 'prefix' ) . 'email_to', null );
		$messages = array(
			'video_skip'		=> true,
			'video_import'		=> false,
			'utility_funcs'		=> false,
			'debug'			=> false,
			'critical'		=> true
			);
        	add_option( $this->get_my_plugin( 'prefix' ) . 'messages', $messages );
        	add_option( $this->get_my_plugin( 'prefix' ) . 'messages_max', 1000 );
        	add_option( $this->get_my_plugin( 'prefix' ) . 'default_title_template', "%VideoTitle%" );
$default_post = <<<DEFAULT_POST
<p>%VideoEmbed%</p>
<p>%VideoDescription%</p>
DEFAULT_POST;
        	add_option( $this->get_my_plugin( 'prefix' ) . 'default_post_template', $default_post );
        	add_option( $this->get_my_plugin( 'prefix' ) . 'license', '' );
        	add_option( $this->get_my_plugin( 'prefix' ) . 'purchase_code', '' );
        	add_option( $this->get_my_plugin( 'prefix' ) . $this->vbp_decode( 'c3RhdHVz' ), '' );
		$tools = array(
			'broken_embeds'		=> 'yes',
			'regenerate_thumbnails'	=> 'yes',
			'remove_images'		=> 'yes'
			);
        	add_option( $this->get_my_plugin( 'prefix' ) . 'tools', $tools );
        	add_option( $this->get_my_plugin( 'prefix' ) . 'video_blacklist', array() );
        	add_option( $this->get_my_plugin( 'prefix' ) . 'blacklist_auto', 'TRUE' );
        	add_option( $this->get_my_plugin( 'prefix' ) . 'timeout', '5' );
        	add_option( $this->get_my_plugin( 'prefix' ) . 'beta', false );
		$this->save_apiKeys();

        }

	/**
	 * Check for VP metadata from sites in the background to avoid on demand wait times
	 */
	public function vp_hourly_meta_check( $site = null ) {
		$name = $this->get_my_plugin( 'name' );
		if ( $name != 'Video Pornster' ) return;

		if ( ! $site )
        		wp_clear_scheduled_hook( 'vp_hourly_meta_check' );

		$this->info_message( __FUNCTION__ . " for " . $site, 'notice notice-warning', 'debug' );

		if ( $site == 'YouPorn' ) {
		$this->create_video_source( array( 'videoSource' => 'YouPorn' ) );
		$this->video_source->get_youporn_categories();
		$this->video_source->get_youporn_pornstars();
		}

		else if ( $site == 'PornHub' ) {
		$this->create_video_source( array( 'videoSource' => 'PornHub' ) );
		$this->video_source->get_pornhub_categories();
		$this->video_source->get_pornhub_pornstars();
		}

		else if ( $site == 'RedTube' ) {
		$this->create_video_source( array( 'videoSource' => 'RedTube' ) );
		$this->video_source->get_redtube_categories();
		$this->video_source->get_redtube_pornstars();
		}

		else if ( $site == 'KeezMovies' ) {
		$this->create_video_source( array( 'videoSource' => 'KeezMovies' ) );
		$this->video_source->get_keezmovies_categories();
		$this->video_source->get_keezmovies_pornstars();
		}

		else if ( $site == 'SpankWire' ) {
		$this->create_video_source( array( 'videoSource' => 'SpankWire' ) );
		$this->video_source->get_spankwire_categories( null );
		$this->video_source->get_spankwire_pornstars();
		}

		else if ( $site == 'ExtremeTube' ) {
		$this->create_video_source( array( 'videoSource' => 'ExtremeTube' ) );
		$this->video_source->get_extremetube_categories();
		}

		else if ( $site == 'GayTube' ) {
		$this->create_video_source( array( 'videoSource' => 'GayTube' ) );
		$this->video_source->get_gaytube_categories();
		}

		else if ( $site == 'GotPorn' ) {
		$this->create_video_source( array( 'videoSource' => 'GotPorn' ) );
		$this->video_source->get_gotporn_categories();
		$this->video_source->get_gotporn_tags();
		}

		else if ( $site == 'xTube' ) {
		$this->create_video_source( array( 'videoSource' => 'xTube' ) );
		$this->video_source->get_xtube_categories();
		}
	}

	/**
	 * Check for metadata for videos if required (YouTube every 30 days)
	 */
	public function video_blogster_metadata() {

		$args = $this->get_video_feed_form();
		$modules = array( 'YouTube' );
		$this->info_message( sprintf( esc_html__( '%s: checking modules %s', 'video-blogster' ), __FUNCTION__, print_r( $modules, true ) ), 'notice notice-warning', 'debug' );
		foreach ( $modules as $module ) {
			$args['videoSource'] = $module;
			$this->create_video_source( $args );
			if ( $this->video_source ) {
				$this->video_source->update_metadata();
			}
		}
	}

	/**
	 * Unpublish a post if removed from source (YouTube, etc)
	 */
	public function video_blogster_metadata_unpublish( $postID, $videoID, $source ) {
		$postID = apply_filters( 'vbp_unpublish_video', $postID, $source );
		if ( ! $postID ) return;

		$action = get_option( $this->get_my_plugin( 'prefix' ) . 'youtube_delete' );
		$action = apply_filters( 'vbp_unpublish_video_action', $action, $postID, $source );

		$this->info_message( sprintf( esc_html__( '%s video %s no longer available. Sending post id %s to %s.', 'video-blogster' ), $source, $videoID, $postID, $action ), 'error', 'critical' );
		if ( in_array( $action, array( 'draft', 'pending' ) ) ) {
			$update = array(
				'ID' => $postID,
				'post_status' => $action
			);
			$return = wp_update_post( $update, true );
		}
		else {
			wp_trash_post( $postID );
		}
	}

	/**
	 * Clear any scheduled hooks and make sure scheduler is disabled
	 */
        public function deactivate() {
        	wp_clear_scheduled_hook( $this->get_my_plugin('prefix') . 'Schedule' );
        	wp_clear_scheduled_hook( $this->get_my_plugin('prefix') . 'Check' );
        	wp_clear_scheduled_hook( $this->get_my_plugin('prefix') . 'MetaData' );
		$hourly_sites = array( 'YouPorn', 'PornHub', 'RedTube', 'KeezMovies', 'SpankWire', 'ExtremeTube', 'GayTube', 'GotPorn', 'xTube' );
		foreach ( $hourly_sites as $site ) {
			$args = array( 'site' => $site );
        		wp_clear_scheduled_hook( 'vp_hourly_meta_check', $args );
		}
        	update_option( $this->get_my_plugin('prefix') . 'sch_enabled', FALSE );
        }

	/**
	 * Load custom css into frontend
	 */
	public function enqueue_options_styles_frontend( $hook ) {
		wp_register_style( 'video-blogster-pro-frontend', plugins_url( 'video-blogster-frontend.css', $this->get_my_plugin( 'file' ) ), array(), $this->get_my_plugin( 'version' ) );
        	wp_enqueue_style( 'video-blogster-pro-frontend' );
	}

	/**
	 * Load custom css into admin screen, only for video blogster/pornster pages and post.php (for video preview metabox)
	 */
	public function enqueue_options_styles( $hook ) {

		wp_enqueue_script( 'vbp-dismiss', plugins_url('/js/vbp-dismiss.js', __FILE__), array( 'jquery' ), $this->get_my_plugin( 'version' ) );

		// only load on vbp related pages:
		if ( $hook == 'post.php' || false !== strpos( $hook, 'video_blogster' ) || false !== strpos( $hook, 'video_pornster' ) ) {
			wp_register_style( 'video-blogster-pro', plugins_url( 'video-blogster.css', $this->get_my_plugin( 'file' ) ), array(), $this->get_my_plugin( 'version' ) );
        		wp_enqueue_style( 'video-blogster-pro' );
			wp_style_add_data('video-blogster-pro', 'rtl', 'replace');
			wp_enqueue_script( 'vbp-main-functions', plugins_url('/js/vbp-main-functions.js', __FILE__), array( 'jquery' ), $this->get_my_plugin( 'version' ) );

			$params = array(
					'remove_icon'		=> plugins_url( 'images/list_remove.png', __FILE__ )
			);
			$name = $this->get_my_plugin( 'name' );
			if ( $name == 'Video Pornster' ) {
				// check if both plugins installed (my local development setup).
				$file = str_replace ( 'video-blogster-pro', 'video-pornster', __FILE__ );

				wp_enqueue_script( 'vp-functions', plugins_url('/js/vp-functions.js', $file ), array( 'jquery' ), $this->get_my_plugin( 'version' ) );
				wp_localize_script( 'vp-functions', 'vbp', $params );
			}
			else {
				wp_enqueue_script( 'vbp-functions', plugins_url('/js/vbp-functions.js', __FILE__), array( 'jquery' ), $this->get_my_plugin( 'version' ) );
				wp_localize_script( 'vbp-functions', 'vbp', $params );
			}

			// for selecting an image:
			wp_enqueue_media();
			wp_enqueue_script( 'vbp-image-select', plugins_url('/js/vbp-image-select.js', __FILE__), array( 'jquery' ), $this->get_my_plugin( 'version' ) );
		}
	}

        /*
         * Wrapper to get the plugin params used to create this class object
         */
        public function get_my_plugin( $key ) {
                return isset( $this->plugin[$key] ) ? $this->plugin[$key] : null;
        }

	/**
	 * Save these settings once to class var instead of fetching it for every info_message()
	 */
	public function get_options_to_vars() {
		$this->messages = get_option( $this->get_my_plugin( 'prefix' ) . 'messages', array( 'video_import' => false, 'video_skip' => true, 'utility_funcs' => false, 'debug' => false ) );
		$this->messages['critical'] = true;
		if ( ! isset( $this->messages['video_skip'] ) ) { 
			#added in 2.3.4, use this as default if not set by user
			$this->messages['video_skip'] = true;
		}
	}

	/**
	 * Send message to screen and the log file depending on type and vars
	 *
	 * display_msgs TRUE = interactive mode. display in WP admin.
	 */
	public function info_message( $msg, $class='error', $msgtype = 'critical' ) {
		if ( ( isset( $this->messages[$msgtype] ) && $this->messages[$msgtype]  )
				|| $this->messages['debug'] == true 	/* debug - show ALL msgs */
		) {  
			if ( $this->display_msgs ) {	// interactive - display message to screen
				$dmsg = "<div class='{$class}'><p>" . $msg . "</p></div>";
				echo $dmsg;
				 if( ob_get_level() > 0 ) ob_flush(); flush();
			}
			if ( $this->logger ) {	// always save to log message db
				$this->logger->write_to_log( $msg, $class, $msgtype );
			}
			else {
				error_log( $msg );
			}
			if ( $msgtype != 'debug' 
					&& $class == 'error'
			) {
				$this->error_summary[] = date_i18n('Y-m-d H:i:s') . " - " . $msg;
			}
		}
		return 0;
	}

	public function vbp_encode( $value ) {
		$func = 'base64' . '_encode';
		return $func( $value );
	}

	public function vbp_decode( $value ) {
		$func = 'base64' . '_decode';
		return $func( $value );
	}

	public function is_debug_set() {
		if ( isset( $this->messages['debug'] ) && $this->messages['debug'] ) return 1;
		return 0;
	}

	/**
	 * Return a value from array by key or a default value if it does not exist
	 * noZero - if array[key] is 0 will return default value instead 
	 */
	protected function get_value( $args, $key, $default='', $noZero=0 ) {
		if ( ! isset( $args[$key] ) ) {
			return $default;
		}
		else if ( is_array( $args[$key] ) && empty( $args[$key] ) ) {
			return $default;
		}
		else if ( ! is_array( $args[$key] ) && false === $args[$key] ) {
			return false;
		}
		else if ( is_numeric( $args[$key] ) && $args[$key] == 0 && $noZero ) {
			return $default;
		}

		$value = $args[$key];
		if ( is_string( $value ) ) {
			$value = htmlentities( $value ); # PHP will use default charset (UTF-8 since PHP 5.4)
			#For older PHP versions you might have to specify a different charset
			# See: http://php.net/manual/en/function.htmlentities.php
			#$value = htmlentities( $value, ENT_COMPAT | ENT_HTML401, "ISO-8859-1" );
		}
		return $value;
	}

        /**
         * Very basic utf-8 detection to use until language filter supported in YouTube API
         */
        public function is_utf_8( $string ) {
                if ( strlen( $string ) != mb_strlen( $string, 'utf-8' ) ) {
                        return 0;
                }
                return 1;
        }


	/**
	 * Get WP Users 
	 */
	protected function get_users() {
		$args = array(
				'capability' => array( 'edit_posts' ),
				'fields' => array(
					'ID',
					'display_name' 
				),
				'number' => 1000
			);
		$args = apply_filters( 'vbp_get_users_args', $args );

			// Capability queries were only introduced in WP 5.9.
			if ( version_compare( $GLOBALS['wp_version'], '5.9-alpha', '<' ) ) {
    				$args['who'] = 'authors';
    				unset( $args['capability'] );
			}

			$user_query = new WP_User_Query( $args );
			$users = $user_query->get_results();

		$users = apply_filters( 'vbp_get_users', $users );
		return $users;
	}


	/**
	 * Get WP Post Types - no further processing needed at this time
	 */
	protected function get_post_types() {
		return get_post_types( array( 'public' => true ), 'names' );
	}


	/**
	 * print up to 1000 terms per taxonomy per child level as <option> within a select box
	 */
	private function hierarchicial_term_tree( $taxonomy, $parent_id = 0, $optArray = array(), $level = 0, &$taxCnt = null ) {
		$args = array(
			'taxonomy'	=> $taxonomy,
			'parent'	=> $parent_id,
			'orderby' 	=> 'name',	/* won't work if CPT plugin active */
			'order' 	=> 'ASC',
			'hide_empty' 	=> 0,
			'number'	=> 1000
		);
		// this check allows user to modify get_terms
		// user should use $query_args['number'] to change maximum amount to fetch if running out of memory.
		$args = apply_filters( 'vbp_get_terms', $args );

		$term_query = new WP_Term_Query( $args );
		$children = isset( $term_query->terms ) ? $term_query->terms : null;

                $total = $children ? count( $children ) : 0;

		if ( empty( $children ) ) return null;

		// sometimes WP returns everything... slice it down to number
		// see https://wordpress.stackexchange.com/questions/283664/get-terms-number-parameter-does-not-appear-to-work
                if ( $args['number'] > 0 && $total > $args['number'] ) {
                        $children = array_slice( $children, 0, $args['number'] );
                        $total = count( $children );
                }

		if ( ! $level ) {
			if ( $taxCnt % 2 == 0 ) echo "<tr><td>\n";
			if ( $taxCnt % 2 == 1 ) echo "<div class='video-blogster-block span_2_of_12'></div>\n";
			echo "<div class='video-blogster-block span_2_of_12 video-blogster-vert-top'>\n";
			echo "<span class='video-blogster-label'>Set " . $taxonomy . "</span>\n";
			echo "<a href='#' title='Select taxonomies. Up to 1000 entries per taxonomy will be displayed so that WordPress does not run out of memory. If you need to show more, see the documentation.'><img width='16' height='16' alt='?' src='" . plugins_url( 'images/question.png', __FILE__ ) . "'></a>\n";
			echo "</div>\n";
			echo "<div class='video-blogster-block span_3_of_12'>\n";
                        if ( $total == $args['number'] ) { 
                                echo sprintf( esc_html__( ' (limited to %d per level)', 'video-link-checker' ), $total );
                        }
			echo '<select name="feed_taxterms[]" size="10" multiple class="vb-stretch video-blogster-select-box">';
		}

		foreach ( $children as $child ) {
			$name = htmlspecialchars_decode( $child->name );

			if ( $level ) $name = "&mdash; " . $name;
			for ( $i=0; $i < $level; $i++) $name = "&nbsp;&nbsp;&nbsp;" . $name;

			$value = $child->taxonomy . ":" . htmlspecialchars_decode( $child->name ) . ":" . $child->slug;
			$select = in_array( $value, $optArray ) ? "SELECTED" : "";
			printf( '<option value="%s" %s>%s</option>', $value, $select, $name );
			if ( $child->term_id != 0 ) $this->hierarchicial_term_tree( $taxonomy, $child->term_id, $optArray, $level + 1, $taxCnt );
		}
		if ( ! $level ) {
			echo '</select>';
			echo "</div>\n";
			if ( $taxCnt % 2 == 1 ) echo "</td></tr>\n";
			$taxCnt++;
		}
	}

	public function get_taxonomies() {
		$obj_taxonomies = get_taxonomies();

		// strip some default taxonomies - already shown in form
		$obj_taxonomies = array_diff( $obj_taxonomies, array( 'link_category', 'nav_menu', 'post_format' ) );

		$this->info_message( sprintf( esc_html__( 'Found taxonomies: %s', 'video-blogster' ), print_r( $obj_taxonomies, true ) ), 'notice notice-warning', 'debug' );

		return apply_filters( 'vbp_valid_taxonomies', $obj_taxonomies );
	}

	/**
	 * Create the Posts - > show standard or custom taxonomies
	 */
	protected function show_taxonomies_terms( $args ) {

		wp_suspend_cache_addition(true);

		$valid_taxonomies = $this->get_taxonomies();

		if ( empty( $valid_taxonomies ) ) return null;

		$taxCnt = 0;
		$optArray = $this->get_value( $args, 'cTaxTerms', array() );
		$optArray = array_map( 'stripslashes', $optArray );
		foreach( $valid_taxonomies as $taxonomy ) {
			$this->hierarchicial_term_tree( $taxonomy, 0, $optArray, 0, $taxCnt );
		}
	}



	/**
	 * Use the Spin ReWriter API to spin title and/or description
	 * Gets the Spin ReWriter settings from the Spin Rewriter Plugin which must already be installed
	 * Connected to Core $this->spinner as an object so it doesn't have to be created/initialized for every single video
	 */
	protected function spin_text_spin_rewriter( $args, &$title, &$desc, &$captions ) {
		$spinrewriter_settings_array = get_option( "SpinRewriterWPPlugin_Plugin_spinrewriter_settings" );
		if ( empty( $spinrewriter_settings_array ) ) {
			$spinrewriter_settings_array = get_option( "SpinRewriterWordPressPlugin_Plugin_spinrewriter_settings" );
			if ( empty( $spinrewriter_settings_array ) ) {
				return $this->info_message( esc_html__( 'Error: unable to retrieve spinrewriter_settings! Is Spin Rewriter plugin loaded?', 'video-blogster' ) );
			}
		}
		if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'spinners/SpinRewriterWPPlugin_SpinRewriterAPI.php' ) ) {
			return $this->info_message( esc_html__('Error: Missing Spin Rewriter API file', 'video-blogster' ) );
		}
		// be doubly sure:
		if ( ! class_exists( 'SpinRewriterWPPlugin_SpinRewriterAPI' ) ) {
			return $this->info_message( esc_html__('Error: Missing Spin Rewriter API file', 'video-blogster' ) );
		}
		if ( ! $this->spinner ) {
			$this->spinner = new SpinRewriterWPPlugin_SpinRewriterAPI($spinrewriter_settings_array['email_address'], $spinrewriter_settings_array['api_key']);
			$this->spinner->setAutoProtectedTerms($spinrewriter_settings_array['auto_protected_keywords']);
			if (count($spinrewriter_settings_array['protected_keywords']) > 0) {
				$this->spinner->setProtectedTerms($spinrewriter_settings_array['protected_keywords']);
			}
			$this->spinner->setConfidenceLevel($spinrewriter_settings_array['confidence_level']);
			$this->spinner->setAutoSentences($spinrewriter_settings_array['auto_sentences']);
			$this->spinner->setAutoParagraphs($spinrewriter_settings_array['auto_paragraphs']);
			$this->spinner->setAutoNewParagraphs($spinrewriter_settings_array['auto_new_paragraphs']);
			$this->spinner->setAutoSentenceTrees($spinrewriter_settings_array['auto_sentence_trees']);
			$this->spinner->setUseOnlySynonyms($spinrewriter_settings_array['use_only_synonyms']);
		}

		$spin_title = (strlen($title) > 70) ? mb_substr($title, 0, 69) . "..." : $title;
		$spin_desc = $desc;
		if ( $args['pSpinTitle'] && $args['pSpinDesc'] ) {
			$content_to_spin = trim( $spin_title ) . "\nSPINREWRITER_WP_PLUGIN_POST_TITLE_BODY_SEPARATOR\n" . trim($spin_desc);
		}
		else if ( $args['pSpinTitle'] && ! $args['pSpinDesc'] ) {
			$content_to_spin = trim( $spin_title );
		}
		else if ( ! $args['pSpinTitle'] && $args['pSpinDesc'] ) {
			$content_to_spin = trim( $spin_desc );
		}
		else {
			$content_to_spin = null;
		}

		if ( ! empty( $content_to_spin ) ) {

		$response = $this->spinner->getUniqueVariation( $content_to_spin );

		if ($response['status'] == 'ERROR' ) {
			return $this->info_message( sprintf( esc_html__( 'Error: Spin Rewriter API returned - %s ', 'video-blogster' ), $response['response'] ) );
		}

		$this->info_message( sprintf( esc_html__( '%s called for [%s] - %s api_requests still available (24h reset)', 'video-blogster' ), __FUNCTION__, $title, $response['api_requests_available'] ), 'updated', 'video_import' );

		$spun_content = $response['response'];

		if ( $args['pSpinTitle'] && $args['pSpinDesc'] ) {
			$spun_post_explode = explode("SPINREWRITER_WP_PLUGIN_POST_TITLE_BODY_SEPARATOR", $spun_content);
			$title = trim( $spun_post_explode[0] );
			$desc = trim( $spun_post_explode[1] );
		}
		else if ( $args['pSpinTitle'] && ! $args['pSpinDesc'] ) {
			$title = trim( $spun_content );
		}
		else if ( ! $args['pSpinTitle'] && $args['pSpinDesc'] ) {
			$desc = trim( $spun_content );
		}
		sleep( 7 ); // to avoid Spin Rewriter msg "You can only submit entirely new text for analysis once every 7 seconds."
		} // end spin title/desc 

		if ( $args['pSpinCaptions'] && ! empty( $captions ) ) { 
			# special case - for captions
			$content_to_spin = $captions;

		$response = $this->spinner->getUniqueVariation( $content_to_spin );

		if ($response['status'] == 'ERROR' ) {
			return $this->info_message( sprintf( esc_html__( 'Error: Spin Rewriter API returned - %s ', 'video-blogster' ), $response['response'] ) );
		}

		$this->info_message( sprintf( esc_html__( '%s called for [%s] - %s api_requests still available (24h reset)', 'video-blogster' ), __FUNCTION__, $title, $response['api_requests_available'] ), 'updated', 'video_import' );

		$captions = $response['response'];

		sleep( 7 ); // to avoid Spin Rewriter msg "You can only submit entirely new text for analysis once every 7 seconds."
		} // end spin captions
	}

	/**
	 * Will call the appropriate API class to spin title and/or description before creating the post
	 * Supports: Spin ReWriter
	 * MARK TODO: add more spinners - wordAI, thebestspinner, spinnerchief, etc.
	 */
	protected function spin_text( $args, &$title, &$desc, &$captions ) {
		$time_start = microtime(true);

		$this->info_message( esc_html__( 'Spinning text...', 'video-blogster' ), 'notice notice-warning', 'debug' );

		if ( $args['pSpinner'] == 'Spin Rewriter' ) {
			// old version 1.4
			if ( is_plugin_active( 'spin-rewriter-wp-plugin/spin-rewriter-wp-plugin.php' ) ) {
				$this->spin_text_spin_rewriter( $args, $title, $desc, $captions );
			}
			// new version 2.0+
			else if ( is_plugin_active( 'spin-rewriter-wordpress-plugin/spin-rewriter-wordpress-plugin.php' ) ) {
				$this->spin_text_spin_rewriter( $args, $title, $desc, $captions );
			}
			else {
				return $this->info_message( esc_html__( 'Error: Spin Rewriter plugin not found. Cannot spin.', 'video-blogster' ) );
			}
		}
		$time_end = microtime(true);
		$time = $time_end - $time_start;
		$this->info_message( "Spin complete in {$time} seconds", 'notice notice-warning', 'debug' );
	}

	/**
	 * Simple spintax for the given string like "{Check|Watch} this {awesome|great|amazing} video"
	 */
	protected function spintax( $s ) {
		preg_match( '#\{{(.+?)\}}#uis', $s, $m );
		if ( empty( $m ) ) {
			return $s;
		}
		$t = $m[1];
		if ( strpos( $t, '{{' ) !== FALSE ) {
			$t = mb_substr ($t, mb_strrpos($t,'{{') + 1 );
		}
		$parts = explode( "|", $t );
		$s = preg_replace( "+\{{".preg_quote($t)."\}}+is", $parts[array_rand($parts)], $s, 1 );
		return $this->spintax( $s );
	}

	/**
	 * Remove any urls from the given string
	 */
	public function remove_urls( $string ) {
		$r = preg_replace( '/\b(https?|ftp|file):\/\/[-A-Z0-9+&@#\/%?=~_|$!:,.;]*[A-Z0-9+&@#\/%=~_|$]/i', '', $string );
		return $r;
	}

	/**
	 * Linkify urls in the given string
	 */
	public function linkify_filtered( $text, $linkifyType = 'all' ) {

	if ( $linkifyType == 'all' ) {
    $url_pattern = '/# Rev:20100913_0900 github.com\/jmrware\/LinkifyURL
    # Match http & ftp URL that is not already linkified.
      # Alternative 1: URL delimited by (parentheses).
      (\()                     # $1  "(" start delimiter.
      ((?:ht|f)tps?:\/\/[a-z0-9\-._~!$&\'()*+,;=:\/?#[\]@%]+)  # $2: URL.
      (\))                     # $3: ")" end delimiter.
    | # Alternative 2: URL delimited by [square brackets].
      (\[)                     # $4: "[" start delimiter.
      ((?:ht|f)tps?:\/\/[a-z0-9\-._~!$&\'()*+,;=:\/?#[\]@%]+)  # $5: URL.
      (\])                     # $6: "]" end delimiter.
    | # Alternative 3: URL delimited by {curly braces}.
      (\{)                     # $7: "{" start delimiter.
      ((?:ht|f)tps?:\/\/[a-z0-9\-._~!$&\'()*+,;=:\/?#[\]@%]+)  # $8: URL.
      (\})                     # $9: "}" end delimiter.
    | # Alternative 4: URL delimited by <angle brackets>.
      (<|&(?:lt|\#60|\#x3c);)  # $10: "<" start delimiter (or HTML entity).
      ((?:ht|f)tps?:\/\/[a-z0-9\-._~!$&\'()*+,;=:\/?#[\]@%]+)  # $11: URL.
      (>|&(?:gt|\#62|\#x3e);)  # $12: ">" end delimiter (or HTML entity).
    | # Alternative 5: URL not delimited by (), [], {} or <>.
      (                        # $13: Prefix proving URL not already linked.
        (?: ^                  # Can be a beginning of line or string, or
        | [^=\s\'"\]]          # a non-"=", non-quote, non-"]", followed by
        ) \s*[\'"]?            # optional whitespace and optional quote;
      | [^=\s]\s+              # or... a non-equals sign followed by whitespace.
      )                        # End $13. Non-prelinkified-proof prefix.
      ( \b                     # $14: Other non-delimited URL.
        (?:ht|f)tps?:\/\/      # Required literal http, https, ftp or ftps prefix.
        [a-z0-9\-._~!$\'()*+,;=:\/?#[\]@%]+ # All URI chars except "&" (normal*).
        (?:                    # Either on a "&" or at the end of URI.
          (?!                  # Allow a "&" char only if not start of an...
            &(?:gt|\#0*62|\#x0*3e);                  # HTML ">" entity, or
          | &(?:amp|apos|quot|\#0*3[49]|\#x0*2[27]); # a [&\'"] entity if
            [.!&\',:?;]?        # followed by optional punctuation then
            (?:[^a-z0-9\-._~!$&\'()*+,;=:\/?#[\]@%]|$)  # a non-URI char or EOS.
          ) &                  # If neg-assertion true, match "&" (special).
          [a-z0-9\-._~!$\'()*+,;=:\/?#[\]@%]* # More non-& URI chars (normal*).
        )*                     # Unroll-the-loop (special normal*)*.
        [a-z0-9\-_~$()*+=\/#[\]@%]  # Last char can\'t be [.!&\',;:?]
      )                        # End $14. Other non-delimited URL.
    /imx';
		$url_replace = array( $this, 'self::_linkify_urls_filter_callback' );
	}
	else if ( $linkifyType == 'embeds' ) {
	// embeddable urls only: modified pattern to find only urls on their own line as per WordPress embed rule
    $url_pattern = '/# Rev:20100913_0900 github.com\/jmrware\/LinkifyURL
    # Match http & ftp URL that is not already linkified.
      # Alternative 1: URL delimited by (parentheses).
      (\()                     # $1  "(" start delimiter.
      ((?:ht|f)tps?:\/\/[a-z0-9\-._~!$&\'()*+,;=:\/?#[\]@%]+)  # $2: URL.
      (\))                     # $3: ")" end delimiter.
    | # Alternative 2: URL delimited by [square brackets].
      (\[)                     # $4: "[" start delimiter.
      ((?:ht|f)tps?:\/\/[a-z0-9\-._~!$&\'()*+,;=:\/?#[\]@%]+)  # $5: URL.
      (\])                     # $6: "]" end delimiter.
    | # Alternative 3: URL delimited by {curly braces}.
      (\{)                     # $7: "{" start delimiter.
      ((?:ht|f)tps?:\/\/[a-z0-9\-._~!$&\'()*+,;=:\/?#[\]@%]+)  # $8: URL.
      (\})                     # $9: "}" end delimiter.
    | # Alternative 4: URL delimited by <angle brackets>.
      (<|&(?:lt|\#60|\#x3c);)  # $10: "<" start delimiter (or HTML entity).
      ((?:ht|f)tps?:\/\/[a-z0-9\-._~!$&\'()*+,;=:\/?#[\]@%]+)  # $11: URL.
      (>|&(?:gt|\#62|\#x3e);)  # $12: ">" end delimiter (or HTML entity).
    | # Alternative 5: URL not delimited by (), [], {} or <>.
      (                        # $13: Prefix proving URL not already linked.
        (?: ^                  # Can be a beginning of line or string, or
#        | [^=\s\'"\]]          # a non-"=", non-quote, non-"]", followed by
        ) \s*[\'"]?            # optional whitespace and optional quote;
      | [^=\s]\s+              # or... a non-equals sign followed by whitespace.
      )                        # End $13. Non-prelinkified-proof prefix.
      ( \b                     # $14: Other non-delimited URL.
        (?:ht|f)tps?:\/\/      # Required literal http, https, ftp or ftps prefix.
        [a-z0-9\-._~!$\'()*+,;=:\/?#[\]@%]+ # All URI chars except "&" (normal*).
        (?:                    # Either on a "&" or at the end of URI.
          (?!                  # Allow a "&" char only if not start of an...
            &(?:gt|\#0*62|\#x0*3e);                  # HTML ">" entity, or
          | &(?:amp|apos|quot|\#0*3[49]|\#x0*2[27]); # a [&\'"] entity if
            [.!&\',:?;]?        # followed by optional punctuation then
            (?:[^a-z0-9\-._~!$&\'()*+,;=:\/?#[\]@%]|$)  # a non-URI char or EOS.
          ) &                  # If neg-assertion TRUE, match "&" (special).
          [a-z0-9\-._~!$\'()*+,;=:\/?#[\]@%]* # More non-& URI chars (normal*).
        )*                     # Unroll-the-loop (special normal*)*.
        [a-z0-9\-_~$()*+=\/#[\]@%]  # Last char can\'t be [.!&\',;:?]
$
      )                        # End $14. Other non-delimited URL.
    /imx';
		$url_replace = array( $this, 'self::_linkify_embeds_filter_callback' );
	}
	else { // should never reach here, but just in case...
		return $text;
	}

		return preg_replace_callback( $url_pattern, $url_replace, $text );
	}

	/**
	 * Linkify all URLs callback function
	 */
	protected function _linkify_urls_filter_callback( $m ) {
		$pre  = $m[1].$m[4].$m[7].$m[10].$m[13];
		$url  = $m[2].$m[5].$m[8].$m[11].$m[14];
		$post = $m[3].$m[6].$m[9].$m[12];
		$this->info_message( sprintf( esc_html__( 'Linkifying link %s', 'video-blogster' ), $url ), 'notice notice-warning', 'debug' );
		$link = apply_filters( 'vbp_linkify_link', '<a href="'. $url .'">' . $url .'</a>', $url );
		return $pre . $link . $post;
	}

	/**
	 * Linkify embeddable URLs callback function
	 * MARK TODO: add all possible auto-embed domains
	 * see http://codex.wordpress.org/Embeds#Okay.2C_So_What_Sites_Can_I_Embed_From.3F
	 * see http://develop.svn.wordpress.org/tags/3.6/wp-includes/class-oembed.php
	 */
	protected function _linkify_embeds_filter_callback( $m ) {
		$pre  = $m[1].$m[4].$m[7].$m[10].$m[13];
		$url  = $m[2].$m[5].$m[8].$m[11].$m[14];
		$this->info_message( sprintf( esc_html__( 'Linkifying embed %s', 'video-blogster' ), $url ), 'notice notice-warning', 'debug' );
		$post = $m[3].$m[6].$m[9].$m[12];
		if ( preg_match( '/\b(?:youtube\.com\/watch|youtu\.be\/|vimeo\.com|soundcloud\.com)\b/', $url ) ) { // linkify it
			return $pre .'<a href="'. $url .'">' . $url .'</a>' .$post;
    		}
		else if ( preg_match( '/\b(?:twitter\.com)\b/', $url ) ) { // linkify it
			return $pre .'<a href="'. $url .'">' . $url .'</a>' .$post;
    		}
		return $pre . $url . $post;
	}

	/*
	 * Verify License
	 */
	protected function license_check2() {
		$name = $this->get_my_plugin( 'name' );
		if ( $name == 'Video Blogster Pro' ) {
			return $this->vb_license_check();
		}
		else {
			return $this->vp_license_check();
		}
	}

	/*
	 * Verify VB License
	 */
	protected function vb_license_check() {

		$key = $this->get_my_plugin( 'prefix' ) . $this->vbp_decode( 'c3RhdHVz' );
		$m = get_option( $this->get_my_plugin( 'prefix' ) . $this->vbp_decode( 'c3RhdHVz' ) );
		if (strpos( $m , $this->vbp_decode( 'U1VDQ0VTUw==' ) ) !== FALSE ) {
			set_transient( $key, $m, 3600 * 24 * 3 );
			delete_option( $this->get_my_plugin( 'prefix' ) . $this->vbp_decode( 'c3RhdHVz' ) );
			return 1;
		}

		if ( false !== ( $value = get_transient( $key ) ) ) return 1;

		$lc = $this->get_my_plugin( 'prefix' ) . 'license';
		$l = str_replace( '-beta', '', get_option( $lc ) );
		$pc = $this->get_my_plugin( 'prefix' ) . 'purchase_code';
		$p = get_option( $pc );
		if ( $l == '' ) {
			return $this->info_message( esc_html__( 'Error: Missing Envato Username', 'video-blogster' ) );
		}
		else if ( $p == '' ) {
			return $this->info_message( esc_html__( 'Error: Missing Envato Purchase Code', 'video-blogster' ) );
		}

		if ( substr( $p, 0, 3 ) == 'jph' ) {
			$request = 'http://www.superblogme.com/eenforcer/verify.php?code=' . $p . '&user=' . $l . '&site=' . site_url();
			$response = wp_remote_get( $request );
			if ( is_wp_error( $response ) ) {
				return $this->info_message( sprintf( esc_html__( " %s Error: wp_remote_get returned - %s", 'video-blogster' ), __FUNCTION__, $response->get_error_message() ) );
			}

			if ( strpos( $response['body'], $this->vbp_decode( 'U1VDQ0VTUw==' ) ) !== FALSE ) {
				$value = date( DATE_ISO8601, strtotime('+1 years') );
				set_transient( $key, $value, 3600 * 24 * 3 );
                        	return 1;
             		}
		}
		$msg = EnvatoApiVBP::verifyPurchase( $p, $l );
		if ( ! empty( $msg ) ) {
			return $this->info_message( $msg );
		}
		$this->info_message( esc_html__( 'Video Blogster license verified.', 'video-blogster' ), 'updated', 'critical' );
		return 1;
	}

	/*
	 * Verify VP License
	 */
	protected function vp_license_check() {
		$name = $this->get_my_plugin( 'name' );
		$key = $this->get_my_plugin( 'prefix' ) . $this->vbp_decode( 'c3RhdHVz' );
		$m = get_option( $this->get_my_plugin( 'prefix' ) . $this->vbp_decode( 'c3RhdHVz' ) );
		if (strpos( $m , $this->vbp_decode( 'U1VDQ0VTUw==' ) ) !== FALSE ) {
			set_transient( $key, $m, 3600 * 24 * 3 );
			delete_option( $this->get_my_plugin( 'prefix' ) . $this->vbp_decode( 'c3RhdHVz' ) );
			return 1;
		}
		if ( false !== ( $value = get_transient( $key ) ) ) {
			if ( strpos( $value, $this->vbp_decode( 'U1VDQ0VTUw==' ) ) !== FALSE )  {
				return 1;
			}
		}

		$lc = $this->get_my_plugin( 'prefix' ) . 'license';
		$l = str_replace( '-beta', '', get_option( $lc ) );
		$pc = $this->get_my_plugin( 'prefix' ) . 'purchase_code';
		$p = get_option( $pc );
		if ( $l == '' ) {
			$this->info_message( esc_html__( 'Error: Missing Purchase Email', 'video-blogster' ) );
			return 0;
		}
		else if ( $p == '' ) {
			$this->info_message( esc_html__( 'Error: Missing Order ID', 'video-blogster' ) );
			return 0;
		}

		$request = 'http://videopornster.com/verify.php?license=' . $p . '&username=' . $l . '&site=' . site_url();
		$response = wp_remote_get( $request );
		if ( is_wp_error( $response ) ) {
			return $this->info_message( sprintf( esc_html__( " %s Error: wp_remote_get returned - %s", 'video-blogster' ), __FUNCTION__, $response->get_error_message() ) );
		}

		set_transient( $key, $response['body'], 3600 * 24 * 3 );
		if ( strpos( $response['body'], $this->vbp_decode( 'U1VDQ0VTUw==' ) ) !== FALSE ) {
			$this->info_message( $response['body'], 'updated', 'critical' );
                        return 1;
             	}
		$this->info_message( $response['body'] );

		return 0;
	}

	public function ajax_notice_handler() {
		$type = isset( $_POST['type'] ) ? $_POST['type'] : null;
		if ( ! $type ) return;
		$dms = get_option( $this->get_my_plugin( 'prefix' ) . 'dismissible_messages', array() );
		$dms[ $type ] = 'dismissed';
        	update_option( $this->get_my_plugin('prefix') . 'dismissible_messages', $dms );
		$this->info_message( sprintf( esc_html__( 'YouTube notice dismissed.', 'video-blogster' ) ), 'notice notice-warning', 'debug' );
	}

	public function admin_important_messages() {

		// check dismissible messages:
		$dms = get_option( $this->get_my_plugin( 'prefix' ) . 'dismissible_messages', array() );
		$fms = apply_filters( 'vbp_dismiss_messages', $dms );
		if ( $fms !== $dms ) {	// user wants different so save change
			if ( ! is_array( $fms ) )
				$fms = array();
			$dms = $fms;
        		update_option( $this->get_my_plugin('prefix') . 'dismissible_messages', $dms );
		}
		$version = $this->get_my_plugin( 'version' );
		$name = $this->get_my_plugin( 'name' );
		if ( version_compare( $version, '5.0', '<=' ) 
			&& $name != 'Video Pornster' 
			&& ! array_key_exists( 'vbp_notice_metadata', $dms ) 
		) {
			$msg = '<strong>Video Blogster Pro v' . $version . ' Notice:</strong> YouTube <i>requires</i> all video metadata to be refreshed every 30 days, and if no longer available, all video metadata <i>must</i> be deleted according to <a target="_blank" href="https://developers.google.com/youtube/terms/developer-policies#e.-handling-youtube-data-and-content">ToS Policy #: III.E.4.d</a>.<br><br>Video Blogster Pro now handles this in the background automatically by updating the video metadata every ~30 days (views, likes, etc.) only in the custom meta fields, but not editing the post content itself.<br>If the YouTube video is no longer available, Video Blogster Pro will now unpublish the post automatically, which gives the user a chance to restore and edit the post if desired.<br><br>See <i>Video Blogster -> Main Settings -> YouTube deleted action</i> to set the post status for deleted videos.<br>';
			echo '<div id="vbp_notice_metadata" data-id="vbp_notice_metadata" class="notice notice-vbp notice-info is-dismissible"><p>'. __($msg, 'video-blogster') . '</p></div>';
		}

		// don't show these messages if licensed
		if ( $this->license_check2() ) {
			return;
		}

		if ( isset( $_POST['save_values'] ) && get_option( $this->get_my_plugin( 'prefix' ) . 'purchase_code' ) != '' ) {
			return;
		}
		$msg = sprintf( esc_html__( '%s: Please enter license information in Main Settings to validate plugin', 'video-blogster' ), $this->get_my_plugin( 'name' ) );
		echo "<div id='notice notice-warning' class='error'><p>" . $msg . "</p></div>";
	}

	/*
	 * Turn a URL into a DOMXPath
	 */
	public function get_DOMXpath( $URL = null, $HTML = null, $returnType = 'xpath' ) {

		$this->info_message( sprintf( esc_html__( '%s (%s)', 'video-blogster' ), __FUNCTION__, htmlentities( $URL ) ), 'notice notice-warning', 'debug' );
		$html = new DOMDocument();

		if ( $URL ) {

			$headers = array (
				'user-agent' 	=> 'video blogster pro' . '; ' . home_url()
			);

			// does URL have a protocol? If not try, https
			if ( 0 === stripos( $URL, '//' ) ) {
				$URL = 'https:' . $URL;
			}

			$response = wp_remote_get( $URL, array( 'headers' => $headers ) );
    			if ( is_wp_error( $response ) ) {
				return $this->info_message( sprintf( esc_html__( '%s WP error getting url %s - %s ', 'video-blogster' ), __FUNCTION__, $URL, $response->get_error_message() ) );
			}
			$HTML = $response['body'];
			// remove control codes that #@$%$#% things up
			$HTML = preg_replace('/[^\PC\s]/u', '', $HTML );
			$this->info_message( sprintf( esc_html__( 'Partial response: %s', 'video-blogster' ), htmlentities( substr( $HTML, 0, 1000 ) ) ), 'notice notice-warning', 'debug' );
		}

		if ( ! empty ( $HTML ) ) {
			// turn off internal errors or get lots of html validation warnings....
			libxml_use_internal_errors( true );

			if ( ! $html->loadHTML( $HTML, LIBXML_NOCDATA | LIBXML_COMPACT | LIBXML_PARSEHUGE ) ) {	
				$lines = explode( PHP_EOL, $HTML );
				foreach(libxml_get_errors() as $error) {
					if ( $error->message == "internal error" ) continue;
					$this->info_message( sprintf( esc_html__( 'loadHTML: %s at line %d, col %d: %s', 'video-blogster' ), $error->message, $error->line, $error->column, htmlentities( $lines[$error->line-1] ) ) );
				}
			}

			libxml_use_internal_errors( false );
			libxml_clear_errors();
		}

		if ( $returnType == 'xpath' ) {
			$xpath = new DOMXPath( $html );
			return $xpath;
		}
		return $html;
	}


	public function simplexml_load_string( $response ) {
		libxml_use_internal_errors(true);
		$xml = simplexml_load_string( $response, 'SimpleXMLElement', LIBXML_NOCDATA | LIBXML_COMPACT | LIBXML_PARSEHUGE );
		if ( false === $xml ) {
			$lines = explode( PHP_EOL, $response );
			foreach(libxml_get_errors() as $error) {
				if ( $error->message == "internal error" ) continue;
				$this->info_message( sprintf( esc_html__( 'simplexml_load_string: %s at line %d, col %d: %s', 'video-blogster' ), $error->message, $error->line, $error->column, htmlentities( $lines[$error->line-1] ) ) );
			}
			return array();
		}
		return $xml;
	}

	public function get_meta_tags( $url ) {
		$this->info_message( sprintf( esc_html__( '%s (%s)', 'video-blogster' ), __FUNCTION__, htmlentities( $url ) ), 'notice notice-warning', 'debug' );
		// easy way:
		if ( ini_get( 'allow_url_fopen' ) ) {
			$meta = get_meta_tags( $url );
			$keywords = isset( $meta['keywords'] ) ? $meta['keywords'] : '';
			$this->info_message( sprintf( esc_html__( '%s (allow_furl_open TRUE) returned meta keywords: %s', 'video-blogster' ), __FUNCTION__, $keywords ), 'notice notice-warning', 'debug' );
			return $keywords;
		}
		// harder way:
		$response = wp_remote_get( $url );
    		if ( is_wp_error( $response ) ) {
			return $this->info_message( sprintf( esc_html__( '%s WP error getting meta tags from %s - %s ', 'video-blogster' ), __FUNCTION__, $url, $response->get_error_message() ) );
		}
		else if ( preg_match( "/<meta name\s*=\s*['\"]keywords['\"]\s*content\s*=\s*[^>]*/", $response['body'], $matches ) ) {
			$parts = explode( "<meta name=\"keywords\" content=", $matches[0] ); 
			$keywords = trim( $parts[1], '\'"');
			$this->info_message( sprintf( esc_html__( '%s (allow_furl_open FALSE) returned meta keywords %s', 'video-blogster' ), __FUNCTION__, $keywords ), 'notice notice-warning', 'debug' );
			return $keywords;
		}
		return $this->info_message( sprintf( esc_html__( 'Could not extract meta tags from %s ', 'video-blogster' ), $url ) );
	}

	/*
	 * Make an oEmbed call to a service using json
	 */
	public function queryoEmbed( $url ) {

		$this->info_message( sprintf( '%s : %s%s%s', 
			__FUNCTION__,
			'<a target="_blank" href="' . esc_url( $url ) . '">',
			esc_url( $url ),
			'</a>'
			), 'notice notice-warning', 'debug' );

		$headers = array (
			'httpversion' 		=> '1.1',
			'host'			=> home_url(),
		);
		$response = wp_remote_get( $url, $headers );
                if ( is_wp_error( $response ) ) {
                        return $this->info_message( sprintf( esc_html__( 'WP error in %s(%s) - %s ', 'video-blogster' ), __FUNCTION__, $url, $response->get_error_message() ) );
                }

		$body = trim( wp_remote_retrieve_body( $response ) );

		$this->info_message( sprintf( esc_html__( '%s response body: %s', 'video-blogster' ), __FUNCTION__, htmlentities( print_r($body,true) ) ), 'notice notice-warning', 'debug' );

		if ( empty( $body ) ) {
			return $this->info_message( sprintf( esc_html__( '%s (%s) response code %s : %s', 'video-blogster' ), __FUNCTION__, htmlentities( $url ), wp_remote_retrieve_response_code( $response ), wp_remote_retrieve_response_message( $response ) ) );
		}

		if ( $body == 'Not Found' ) { // worth it's own message
			return $this->info_message( sprintf( esc_html__( '%s (%s) response error: %s', 'video-blogster' ), __FUNCTION__, htmlentities( $url ), $body ) );
		}

		if ( $body == 'Unauthorized' ) { // worth it's own message
			return $this->info_message( sprintf( esc_html__( '%s (%s) response error: %s', 'video-blogster' ), __FUNCTION__, htmlentities( $url ), $body ) );
		}

		// fix for unicode that would break json_decode:
		$body = str_replace( "\U", "\u", $body );

		$data = json_decode( $body );

		if ( ! $data ) {
			$this->info_message( sprintf( esc_html__( '%s for %s could not decode because of: %s. Data is %s.', 'video-blogster' ), __FUNCTION__, $url, json_last_error_msg(), htmlentities(print_r($body,true)) ) );
		}
		$embed = null;
		if ( isset( $data->html ) ) {
			$embed = (string) $data->html;
		}

		if ( empty( $embed ) ) {
			return $this->info_message( sprintf( esc_html__( '%s for %s did not return html field! Response was : %s', 'video-blogster' ), __FUNCTION__, $url, htmlentities( print_r( $response, true ) ) ) );
		}
			
		$embed = $this->getOnlyIframe( $embed );
		$this->info_message( sprintf( esc_html__( '%s embed is : %s', 'video-blogster' ), __FUNCTION__, htmlentities( $embed) ), 'notice notice-warning', 'debug' );
		return $embed;
	}

	/*
	 * Extract only the iframe from an embed string. Useful when video sites add their links under the embeds.
	 */
	public function getOnlyIframe( $string ) {
		$this->info_message( sprintf( esc_html__( '%s full embed string is : %s', 'video-blogster' ), __FUNCTION__, htmlentities( $string) ), 'notice notice-warning', 'debug' );
		$pattern = "#(<iframe[^>]+>).*?(</iframe>)#uis";
		if ( false !== preg_match( $pattern, $string, $matches ) ) {
			if ( ! empty( $matches[1] ) && ! empty( $matches[2] ) ) { 
				$iframe = $matches[1] . $matches[2];
				$this->info_message( sprintf( esc_html__( '%s iframe match: %s', 'video-blogster' ), __FUNCTION__, htmlentities( $iframe ) ), 'notice notice-warning', 'debug' );
				return $iframe;
			}
		}
		// all embed codes should match the iframe code above, but just in case...
		$this->info_message( sprintf( esc_html__( '%s: %s NO MATCH: %s', 'video-blogster' ), __FUNCTION__, htmlentities( $string ), htmlentities( print_r($matches,true) ) ), 'notice notice-warning', 'debug' );
		return $string;
	}


	/*
	 * Turn off WordPress flood check when importing comments, otherwise WordPress will call wp_die
	 * if the same IP/author name is used within the allowed time frame. That's bad.
	 */
	public function comment_flood_filter_off ( $flood_control, $time_last, $time_new ) {
		return false;
	}

	/*
	 * Include once but error message on fail
	 */
	public function vb_include_once( $include ) {
		if ( ! file_exists( $include ) ) {
			return $this->info_message( sprintf( esc_html__( 'Error: include file %s does not exist.', 'video-blogster' ), $include ) );
		}
		if ( ! is_readable ( $include ) ) {
			return $this->info_message( sprintf( esc_html__( 'Error: include file %s is not readable.', 'video-blogster' ), $include ) );
		}
		if ( ! include_once( $include ) ) {
			return $this->info_message( sprintf( esc_html__( 'Error: Unable to include %s', 'video-blogster' ), $include ) );
		} 
		if ( $this->display_msgs ) {	// interactive - display message to screen
			$this->info_message( sprintf( esc_html__( 'Include Once: %s', 'video-blogster' ), $include ), 'notice notice-warning', 'debug' );
		}
		return 1;
	}

	/*
	 * Converts seconds to HH:MM:SS format
	 */
	public function seconds_to_time( $sec = 0 ) {
		if ( floor( $sec / 3600 ) )
			return sprintf( "%02d:%02d:%02d", floor( $sec / 3600 ), ( $sec / 60 ) % 60, $sec % 60 );
		else
			return sprintf( "%02d:%02d", ( $sec / 60 ) % 60, $sec % 60 );
	}

	/*
	 * Gets the theme parent object
	 */
	protected function get_theme() {
		$theme = wp_get_theme();
		if ( is_object( $theme->parent() ) ) {
			$theme = $theme->parent();
		}
		return $theme;
	}

	/*
	 * Gets the theme helper file
	 */
	protected function get_theme_helper( $theme ) {
		$theme_helper = $this->get_my_plugin( 'dir' ) . 'theme-helpers/' . strtolower( $theme->Name ) . '.php';
		$theme_helper = str_replace( ' ', '_', $theme_helper);
		return $theme_helper;
	}

	/*
	 * Save the default API keys - checked at activation, and updates where db has changed.
	 */
	protected function save_apiKeys() {
		$name = $this->get_my_plugin( 'name' );
		if ( $name == 'Video Blogster Pro' ) {
        		add_option( $this->get_my_plugin( 'prefix' ) . 'youtube_key', 'AIzaSyASXdD2VqRO4AXiUaKCpx_12VyyDOD9ai0' );
        		add_option( $this->get_my_plugin( 'prefix' ) . 'soundcloud_key', '10eedf52132cd7a2d0fdbcfc572d5a0f' );
        		add_option( $this->get_my_plugin( 'prefix' ) . 'vimeo_key', '863e1b4f5993234012859ff4faab26c3' );
        		#add_option( $this->get_my_plugin( 'prefix' ) . 'giantbomb_key', '01464071a53b0be761f32a31f8ef3fe0e0235543' );
		}
	}

	/*
	 * DateTime not properly using default timezone, so we need to force it.
	 * This function returns the timezone set in WordPress.
	 */
	protected function getTimeZone() {
		$tzstring = get_option( 'timezone_string' );
		$offset   = get_option( 'gmt_offset' );

		//Manual offset...
		//@see http://us.php.net/manual/en/timezones.others.php
		//@see https://bugs.php.net/bug.php?id=45543
		//@see https://bugs.php.net/bug.php?id=45528
		//IANA timezone database that provides PHP's timezone support uses POSIX (i.e. reversed) style signs
		if( empty( $tzstring ) && 0 != $offset && floor( $offset ) == $offset ) {
			$offset_st = $offset > 0 ? "-$offset" : '+'.absint( $offset );
			$tzstring  = 'Etc/GMT'.$offset_st;
		}

		//Issue with the timezone selected, set to 'UTC'
		if( empty( $tzstring ) ) {
			$tzstring = 'UTC';
		}

		$timezone = new DateTimeZone( $tzstring );
		return $timezone; 
	}

	/*
	 * A common function to check video's publishedAt value, if any, and set a valid DateTime
	 */
	public function getDateTime( $publishedAt, $videoUrl, $useCurrentDefault = 1 ) {

		$timeNow = current_time( 'mysql' );
		$default = $useCurrentDefault ? $timeNow : null;
		$publishedAt = ! empty( $publishedAt ) ? $publishedAt : $default;
		$timezone = $this->getTimeZone();
		try {
			$date = new DateTime( $publishedAt );
			$date->setTimezone( $timezone );
		} catch ( Exception $e ) {
			$this->info_message( $e->getMessage() );
		}

		if ( ! $useCurrentDefault  && empty( $date ) ) { return null; }
		if ( empty( $date ) ) {
			$this->info_message( sprintf (__( "DateTime failure on %s for %s, setting to current_time", 'video-blogster' ), $publishedAt, $videoUrl ), 'error', 'critical' );
			$date = new DateTime( $default );
			$date->setTimezone( $timezone );
		}

		// try to ensure publishedAt time is not in the future...
		$rightNow = new DateTime( 'now' );
		$rightNow->setTimezone( $timezone );
		if ( $date > $rightNow ) {
			$date = $rightNow;
		}

		return $date;
	}



	/*
	 * Used to check for semi-static data from APIs, such as categories
	 * If transient found, return transient data.
	 * Used to minimize APIs returning no data (timeouts)
	 */
	public function transientChecker( $key, $default = null ) {
		$key = substr( $key, 0, 45 ); // keys limited to 45 chars
		$str = sprintf( esc_html__( '%s for key [%s] - ', 'video-blogster' ), __FUNCTION__, $key );
		if ( false !== ( $results = get_transient( $key ) ) ) {
			$data = $results;
			$str .= 'Found';
		}
		else {
			$data = $default;
			$str .= 'Not Found';
		}
		$this->info_message( $str, 'notice notice-warning', 'debug' );
		return $data;
	}

	/*
	 * Used to save semi-static data from APIs, such as categories
	 * Used to minimize APIs returning no data (timeouts)
	 * Default expire is 24 hours
	 */
	public function transientSave( $key, $data, $expire = 86400 ) {
		$key = substr( $key, 0, 45 ); // keys limited to 45 chars
		// store transient data 
		if ( set_transient( $key, $data, $expire ) ) {
			$this->info_message( sprintf( esc_html__( '%s for key [%s] - saved', 'video-blogster' ), __FUNCTION__, $key ), 'notice notice-warning', 'debug' );
		}
		else {
			// note: set_transient fails if the data matches what is already saved
			$this->info_message( sprintf( esc_html__( '%s for key [%s] - already saved', 'video-blogster' ), __FUNCTION__, $key ), 'notice notice-warning', 'debug' );
		}
	}

	/*
	 * The steps taken to create a post from the video data imported
	 * 1. process query results - checking rules and expanding templates, etc.
	 * 2. create the post
	 * 3. Import image, replace in template if needed
	 */
	public function save_the_video( $query_fields, &$videoInfo, $metadata = false ) {

		$saveVideo = apply_filters( 'vbp_save_video', true, $query_fields, $videoInfo );

		if ( $saveVideo <= 0 ) return $saveVideo;

		$query_fields = apply_filters( 'vbp_save_video_args', $query_fields, $videoInfo );

		if ( true === $metadata ) {
			$postID = isset( $videoInfo['postID'] ) ? $videoInfo['postID'] : 0;
			if ( $postID )
				$this->save_the_post_meta( $query_fields, $videoInfo, $postID, $metadata );
			else	// should never happen
				return 0;
		}
		else {
			if ( ! $this->process_query_results( $query_fields, $videoInfo ) ) return 0;

			$postID = $this->create_the_post( $query_fields, $videoInfo );
		}

    		if ( ! $postID || is_wp_error( $postID ) ) {
			unset( $postID );
			return 0;
		}

		$feedID = ! empty ( $query_fields['id'] ) ? "Feed " . $query_fields['id'] . ", " : "";
		$this->info_message( sprintf( 
			esc_html__( '%s %s video: [%s] %s successfully with post id %s%s%s.', 'video-blogster' ), 
			$feedID, 
			$videoInfo['videoSource'], 
			$videoInfo['post_title'], 
			$videoInfo['action'], 
			'<a target="_blank" href="' . get_permalink( $postID ) . '">',
			$postID,
			'</a>'
		), 'updated', 'critical' );

                if ( $this->is_debug_set() ) {
                        $doublecheck = get_post( $postID );
                        $this->info_message( sprintf( esc_html__( '%s - post id %s now has: %s', 'video-blogster' ), __FUNCTION__, $postID, htmlentities( print_r( $doublecheck,true ) ) ), 'notice notice-warning', 'debug' );
                }

		// if updating a post, fetch image again only if missing featured image
		$hasThumbnail = apply_filters( 'vbp_has_post_thumbnail', has_post_thumbnail( $postID ), $videoInfo );
		if ( true == $query_fields['pUpdateExisting'] && true === $hasThumbnail ) {
			$this->info_message( sprintf( esc_html__( '%s - post id %s already has thumbnail, skipping image import.', 'video-blogster' ), __FUNCTION__, $postID ), 'notice notice-warning', 'debug' );
		}
		else {

		$fetchThumb = apply_filters( 'vbp_import_thumbnail', true, $videoInfo );
		if ( $fetchThumb && ! empty( $videoInfo['img'] ) ) {
			$thumbID = 0;
			if ( TRUE == $query_fields['qImageImport'] &&
				$videoInfo['videoSource'] == 'GiantBomb' ) {
				$thumbID = $this->grab_thumbnail2( $postID, $videoInfo );
			}
			else if ( TRUE == $query_fields['qImageImport'] ) {
				$thumbID = $this->grab_thumbnail( $postID, $videoInfo );
			}
			// is there a default image set?
			else if ( isset( $query_fields['qImageId'] ) && $query_fields['qImageId'] > 0 ) {
				$thumbID = $query_fields['qImageId'];
				$this->set_post_thumbnail( $postID, $thumbID );
			}

			if ( $thumbID ) {
				if ( FALSE !== stripos( $videoInfo['post_content'],'%VideoImageLocal%' ) ) {
					//if %VideoImageLocal% tag in template we need to update_post we just created.
					$this->process_the_thumbnail( $postID, $thumbID, $videoInfo );
				}
			}
			else {
				$this->info_message( sprintf( esc_html__( 'No thumb saved for: %s', 'video-blogster' ), htmlentities( $videoInfo['url'] ) ), 'notice notice-warning', 'debug' );
			}

			unset( $thumbID );
		}
		}

		do_action( 'vbp_save_the_video_finished', $postID, $videoInfo );

		return $postID;
	}

	/*
	 * Before importing comments, temporarily turn off comment_moderation and comment_notification, if set
	 */
	public function bulk_comment_start( &$cm, &$cn ) {
		$cm = get_option( 'comment_moderation' );
		$cn = get_option( 'comment_notification' );
		if ( true == $cm ) { 
			if ( true !== update_option( 'comment_moderation', false ) ) {
				$this->info_message( sprintf( esc_html__( '%s - Unable to turn WordPress comment_moderation off!', 'video-blogster' ), __FUNCTION__ ) );
			}
		}
		if ( true == $cn ) { 
			if ( true !== update_option( 'comment_notification', false ) ) {
				$this->info_message( sprintf( esc_html__( '%s - Unable to turn WordPress comment_notification off!', 'video-blogster' ), __FUNCTION__ ) );
			}
		}
	}

	/*
	 * After importing comments, turn back on comment_moderation and comment_notification, if set
	 */
	public function bulk_comment_end( $cm, $cn ) {
		if ( true == $cm ) { update_option( 'comment_moderation', true ); }
		if ( true == $cn ) { update_option( 'comment_notification', true ); }
	}

	/*
	 * a replacement for WP comment_exists which compares author and date
	 * this one compares author and content instead ( no dupes )
	 */
	public function comment_exists( $comment_author, $comment_content ) {
		global $wpdb;

		return $wpdb->get_var( $wpdb->prepare("SELECT comment_ID FROM $wpdb->comments
			WHERE comment_author = %s AND comment_content = %s",
			stripslashes( $comment_author ),
			stripslashes( $comment_content )
		) );
	}


	/*
	 * a wrapper to insert a comment with rule checks and filter
	 */
	public function save_the_comment( $commentdata, $query_fields ) {

		if ( true == $query_fields['pRemoveCommUrls'] ) {
			$commentdata['comment_content'] = $this->remove_urls( $commentdata['comment_content'] );
		}
		if ( true == $query_fields['pLinkifyCommUrls'] ) {
			$commentdata['comment_content'] = $this->linkify_filtered( $commentdata['comment_content'] );
		}

		$commentdata = apply_filters( 'vbp_import_comment', $commentdata );

		$this->info_message( sprintf( esc_html__( '%s: commentdata: %s.', 'video-blogster' ), __FUNCTION__, print_r($commentdata,true) ), 'notice notice-warning', 'debug' );
		
		if ( empty( $commentdata ) ) return 0;  // user hooked in and cleared

		// does this comment already exist? useful when updating a post with new comments

		/* lets compare comments by author/content instead of author/date like WP does */
		/* this is in case user imports comments using date=NOW instead of date=publishedAt */
		$commentID = $this->comment_exists( $commentdata['comment_author'], $commentdata['comment_content'] );
		if ( $commentID ) {
			$this->info_message( sprintf( esc_html__( '%s: comment %s already exists on this post. Skipping.', 'video-blogster' ), __FUNCTION__, $commentID ), 'notice notice-warning', 'debug' );
			return -$commentID;
		}

		$commentID = wp_insert_comment( $commentdata );
		if ( false === $commentID ) {
			global $wpdb;
			return $this->info_message( sprintf( esc_html__( '%s: wp_insert_comment failed: %s - %s', 'video-blogster' ), __FUNCTION__, $wpdb->print_error(), print_r( $commentdata,true ) ) );
		}
		return $commentID;
	}

	/*
	 * after post is created, featured image attached and comments imported, we can publish it
	 */
	public function publish_the_video( $postID, $query_fields, $videoInfo ) {
		if ( $postID 
			&& $query_fields['cPostStatus'] == 'publish' 
			&& get_post_status( $postID ) != 'publish' 
		) {
			$this->info_message( sprintf( esc_html__( '%s video: about to publish.', 'video-blogster' ), $videoInfo['videoSource'] ), 'notice notice-warning', 'debug' );
			$this->publish_the_post( $postID, $query_fields, $videoInfo );
		}
		do_action( 'vbp_publish_the_video_finished', $postID, $videoInfo );
	}

	/*
	 * Make a call to official Google API to translate text
	 */
	protected function googleTranslate( $text, $lang, $apiKey ) {
		$query_args = array(
			'q'			=> $text,
			'target'		=> $lang,
			'format'		=> 'html',
			'key'			=> $apiKey
		);
		$query_args = apply_filters( 'vbp_gtranslate_auth', $query_args );
		$url = "https://www.googleapis.com/language/translate/v2?" . http_build_query( $query_args );
		$response = wp_remote_get( $url, array( 'user-agent'  => 'Video Blogster Pro' ) );
		$this->info_message( sprintf( esc_html__( 'Google Translate response: %s', 'video-blogster' ), print_r($response,true) ), 'notice notice-warning', 'debug' );

		if ( is_wp_error( $response ) ) {
			return $this->info_message( sprintf( esc_html__( 'WP error %s in %s(%s) - %s ', 'video-blogster' ), $response->get_error_code(), __FUNCTION__, $url, $response->get_error_message() ) );
		}
		$data = wp_remote_retrieve_body( $response );
		$data = json_decode( $data );
		return $data;
	}

	/*
	 * Make a call to official MS API to translate text
	 * http://docs.microsofttranslator.com/text-translate.html#!/default/get_Translate
	 */
	protected function msTranslate( $text, $lang, $apiKey ) {

		// MS access token is good for 10 minutes. Store as a transient for 9.
		$key = $this->get_my_plugin( 'prefix' ) . 'msAuthKey';

		$version = 'v2';

		if ( $version == 'v2' ) {
		$token = $this->transientChecker( $key );
		if ( empty ( $token ) ) {
			$url = 'https://api.cognitive.microsoft.com/sts/v1.0/issueToken?Subscription-Key=' . $apiKey;
			$url = apply_filters( 'vbp_mstranslate_token_url', $url );

			$response = wp_remote_post( $url );

			if ( is_wp_error( $response ) ) {
				return $this->info_message( sprintf( esc_html__( 'WP error %s in %s(%s) - %s ', 'video-blogster' ), $response->get_error_code(), __FUNCTION__, $url, $response->get_error_message() ) );
			}
			$token = wp_remote_retrieve_body( $response );
			if ( false !== strpos( $token, 'Access denied' ) ) {
				$this->info_message( sprintf( esc_html__( 'MS Auth Token for %s returned %s', 'video-blogster' ), $url, $token ), 'error', 'critical' );
				return null;
			}
			$this->info_message( sprintf( esc_html__( 'MS Auth Token %s', 'video-blogster' ), $token ), 'notice notice-warning', 'debug' );
			$this->transientSave( $key, $token, 9 * 60 );	// save for 9 minutes
		}

		$query_args = array(
			'text'			=> $text,
			'to'			=> $lang,
			'appid'			=> 'Bearer ' . $token
		);
		$query_args = apply_filters( 'vbp_mstranslate_auth', $query_args );
		$url = "https://api.microsofttranslator.com/V2/Http.svc/Translate?" . http_build_query( $query_args );
		$url = apply_filters( 'vbp_mstranslate_translate_url', $url );
		$response = wp_remote_get( $url );
		}
		else { // v3, has timeout issues
		$query_args = array(
			'text'			=> $text,
			'to'			=> $lang,
			'api-version'		=> '3.0'
		);
		$query_args = apply_filters( 'vbp_mstranslate_auth', $query_args );
		$url = "https://api.cognitive.microsofttranslator.com/translate?" . http_build_query( $query_args );
		$url = apply_filters( 'vbp_mstranslate_translate_url', $url );

		$headers   = array( 
			'Content-type' 			=> 'application/json',
			'Content-length'		=> strlen( $text ),
			'Ocp-Apim-Subscription-Key'	=> $key,
			//'X-ClientTraceId'		=> com_create_guid()
		);

		$response = wp_remote_get( $url, array( 'headers' => $headers, 'sslverify' => false ) );

		}

		$this->info_message( sprintf( esc_html__( 'MS Azure Translate response: %s', 'video-blogster' ), print_r($response,true) ), 'notice notice-warning', 'debug' );

		if ( is_wp_error( $response ) ) {
			return $this->info_message( sprintf( esc_html__( 'WP error %s in %s(%s) - %s ', 'video-blogster' ), $response->get_error_code(), __FUNCTION__, $url, $response->get_error_message() ) );
		}
		$data = wp_remote_retrieve_body( $response );
		if ( $version == 'v3' ) {
			$data = json_decode( $data );
		}
		if ( isset( $data->error ) ) {
			return $this->info_message( sprintf( esc_html__( 'MS Azure error %s in %s(%s) - %s ', 'video-blogster' ), $data->error->code, __FUNCTION__, $url, $data->error->message ) );
		}
		return $data;
	}

        /*
         * Format schedule time to a readable format
         */
        protected function format_scheduled_time ( $scheduledtime, $which ) {
                $readable = 'Not set.';
                if ( $scheduledtime ) {
                        $readable = date( "Y-m-d H:i:s", $scheduledtime + ( get_option( 'gmt_offset' ) * HOUR_IN_SECONDS ) ) . " " . get_option( 'timezone_string' );
                }
                else if ( get_option( $which ) != 0 ) {
                        $readable = $which . ' hook not found, likely another plugin misuse of cron_schedules. See FAQ.';
                }
                return $readable;
        }

	/*
	 * Message summary after every import
	 */
	public function import_finished( $videoSource, $num_skipped, $num_updated, $num_imported, $total, $feed, $behavior ) {
		if ( $num_skipped ) $this->info_message( sprintf( esc_html__( '%s %s skipped.', 'video-blogster' ), $num_skipped, $videoSource ), 'notice notice-warning', 'video_skip' );
		if ( $num_updated ) $this->info_message( sprintf( esc_html__( '%s %s updated.', 'video-blogster' ), $num_updated, $videoSource ), 'updated', 'video_import' );
		if ( $num_imported ) $this->info_message( sprintf( esc_html__( '%s %s imported.', 'video-blogster' ), $num_imported, $videoSource ), 'updated', 'video_import' );
                if ( $total > 0
                                && ( $num_skipped + $num_updated + $num_imported ) >= $total
                ) {
                        $feedID = ! empty ( $feed ) ? "Feed " . $feed . " - " : "";
                        $this->info_message( sprintf( 
				esc_html__( 'NOTICE! %s All %s results returned from query have been imported. Perhaps %schange the feed%s to save on time/resources/quota.', 'video-blogster' ), 
				$feedID, 
				$total, 
				'<a target="_blank" href="' . esc_url( 'http://videoblogsterpro.com/documentation/#!/make_video_feed' ) . '">',
				'</a>'
			), 'notice notice-warning' );
                }
	}

	/*
	 * Message summary after every import
	 */
	public function reached_import_limit( $qNumVideos, $num_processed, $num_imported, $qQueryBehavior, $total = 0 ) {
		$fail = false;

		// strict: X total skipped/updated/imported
		if ( $qNumVideos > 0
				&& $qQueryBehavior == 'strict'
				&& $num_processed >= $qNumVideos 
		) {
			$fail = true;
		}
		// continuous: X total imported
		else if ( $qNumVideos > 0
				&& $qQueryBehavior == 'continuous'
				&& $num_imported >= $qNumVideos 
		) {
			$fail = true;
		}
		// if API told us total results so check.
		if ( $total 
				&& $num_processed >= $total
		) {
			$fail = true;
		}

		if ( true === $fail )
			$this->info_message( sprintf( esc_html__( " %s (qNumVideos %s, num_processed %s, num_imported %s, qQueryBehavior %s, total %s) ... FAILED", 'video-blogster' ), __FUNCTION__, $qNumVideos, $num_processed, $num_imported, $qQueryBehavior, $total ), 'notice notice-warning', 'debug' );
		else
			$this->info_message( sprintf( esc_html__( " %s (qNumVideos %s, num_processed %s, num_imported %s, qQueryBehavior %s, total %s) ... PASSED", 'video-blogster' ), __FUNCTION__, $qNumVideos, $num_processed, $num_imported, $qQueryBehavior, $total ), 'notice notice-warning', 'debug' );

		return $fail;
	}


	/* 
	 * In beta just check for my email for testing...
	 */
	protected function email_error_summary() {

		if ( empty( $this->error_summary ) ) return;

		$email_to = get_option( $this->get_my_plugin( 'prefix' ) . 'email_to' );
		if ( empty( $email_to ) ) return;

		$admin_email = get_bloginfo( 'admin_email' );

		$email_to = apply_filters( 'vbp_email_to', $email_to );
		$email_from = apply_filters( 'vbp_email_from', $admin_email );

		$name = $this->get_my_plugin( 'name' );
		$i = $name == 'Video Blogster Pro' ? 'VBP' : 'VP';
		$subject = "{$i} error summary - " . get_bloginfo( 'name' );

		$headers = 'From: ' . $email_from . "\r\n";
		$headers .= 'Reply-To: ' . $email_to . "\r\n";
		$headers .= 'MIME-Version: 1.0' . "\r\n";
		$headers .= 'Content-type: text/html; charset=UTF-8' . "\r\n";

		$body = $name . " v" . $this->get_my_plugin( 'version' ) . "<br><br>\n";

		$body .= implode( "<br><br>\n\n", $this->error_summary );

		$body .= "<hr>\n";

		// check for easy errors to explain:
		if ( false !== stripos( $body, 'cURL error 6: name lookup timed out' ) ) {
			$body .= '<br><br>* cURL error 6: name lookup timed out - Your DNS server failed to return a response in time when resolving the domain.';
		}
		if ( false !== stripos( $body, 'cURL error 28: Operation timed out' ) ) {
			$body .= '<br><br>* cURL error 28: Operation timed out... - Your server timed out while waiting for a response. You can increase the default timeout value in Main Settings.';
		}
		if ( false !== stripos( $body, 'cURL error 18: transfer closed with outstanding read data remaining' ) ) {
			$body .= '<br><br>* cURL error 18: transfer closed with outstanding read data remaining - This happens when the remote server first reports an expected transfer size, and then delivers data that does not match the previously given size. In almost all cases this should not effect imports.';
		}
		if ( false !== stripos( $body, 'Missing header/body separator' ) ) {
			$body .= '<br><br>* Missing header/body separator - The remote server is returning a malformed response for unknown reason. I think it may be DDOS protection.';
		}
		if ( false !== stripos( $body, 'no longer available' ) ) {
			if ( false !== stripos( $body, 'YouTube video' ) ) {
				$body .= '<br><br>* YouTube video X no longer available - YouTube Terms of Service Policy #: III.E.4.d requires all local API data from deleted videos to also be deleted. By default, VBP will send posts with a deleted video to trash, giving users a chance to restore those posts and remove any API data manually. See FAQ in docs for other options.';
			}
		}

		if ( wp_mail( $email_to, $subject, $body, $headers ) ) {
			$this->info_message( sprintf( esc_html__( 'Error summary sent to %s', 'video-blogster' ), $email_to ), 'updated', 'critical' );
		}
		else {
			$this->info_message( sprintf( esc_html__( 'Could not send email to %s, subject %s', 'video-blogster' ), $email_to, $subject ), 'error', 'critical' );
		}

		$this->error_summary = array();
	}

    } // END class Video_Blogster_Core
} // END if ( ! class_exists( 'Video_Blogster_Core' ) )


////////////////////////////////////////////////////////////////////////////////////////////

if(!class_exists('EnvatoApiVBP'))
{

    class EnvatoApiVBP {

	// Bearer, no need for OAUTH token, change this to your bearer string
	// https://build.envato.com/my-apps/#tokens
	// old: private static $bearer = "JPk0M1gUHXFr9cw60bIvqht2SXRsiXbZ";
	private static $bearer = "deoPfiwVpOCaZrTZPe1cn9BoTLEnxCoE";

	static function getPurchaseData( $code ) {
    
		//setting the header for the rest of the api
		$bearer   = 'Bearer ' . self::$bearer;
		$header   = array( 'Authorization' => $bearer );
    
		$verify_url = 'https://api.envato.com/v3/market/author/sale?code=' . $code;

		$response = wp_remote_get( $verify_url, array( 'headers' => $header, 'user-agent'  => 'Video Blogster Pro' ) );

		return $response;

	}
  
	static function verifyPurchase( $code, $username ) {

		$response = self::getPurchaseData( $code ); 

		if ( is_wp_error( $response ) ) {
			return sprintf( esc_html__( 'WP error %s in %s - %s ', 'video-blogster' ), $response->get_error_code(), __FUNCTION__, $response->get_error_message() );
		}

		$verify_obj = json_decode( wp_remote_retrieve_body( $response ) );

		$verify_obj = apply_filters( 'vbp_verify', $verify_obj );

		$msg = null;

		// Check for correct verify code
		if ( 
			(false === $verify_obj) || 
			!is_object($verify_obj)
		)
			$msg = sprintf( esc_html__('Video Blogster: Envato API server not responding. Unable to get license info. Please try again later. Response was: %s', 'video-blogster' ), print_r( $response,true ) );
		else if (
			isset( $verify_obj->error ) &&
			isset( $verify_obj->description )
		)
			$msg = sprintf( esc_html__('Video Blogster: Envato error response for %s/%s: %s', 'video-blogster' ), 
				$username,
				$code,
				print_r($verify_obj,true)
			);
		else if (
			!isset($verify_obj->item) ||
			!isset($verify_obj->item->name)
		)
			$msg = sprintf( esc_html__('Video Blogster: Envato API did not return item information. Response was: %s', 'video-blogster' ), print_r( $response,true ) );

		// Check for proper item name
		else if (
			FALSE === stripos( $verify_obj->item->name, 'Video Blogster Pro' )
		)
			$msg = sprintf( esc_html__('Envato API states the Video Blogster purchase code is for: %s', 'video-blogster' ), $verify_obj->item->name );

		// Check for proper item id
		else if (
			$verify_obj->item->id != 9497256
		)
			$msg = esc_html__( "Envato API states the Video Blogster purchase code is for another product id.", 'video-blogster' );
			
		// Check for username match
		else if (
			! empty( $verify_obj->buyer ) && 
			strcasecmp( $verify_obj->buyer, $username )
		)
			$msg = esc_html__( "Envato states the Video Blogster purchase code is for another username.", 'video-blogster' );

		else if ( isset( $verify_obj->supported_until ) && ! empty( $verify_obj->supported_until ) ) {
			$vb = Video_Blogster_Engine::getInstance( array() );
			set_transient( 'video_blogster_' . $vb->vbp_decode( 'c3RhdHVz' ), $verify_obj->supported_until, 3600 * 24 * 30 );
		}
		else 
			$msg = sprintf( esc_html__('Video Blogster: Strange. Envato API did not return a support field. Response was: %s', 'video-blogster' ), print_r( $response,true ) );
		return $msg;
	}

    }
}

?>
