<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/**
 * Class for Video Blogster Engine
 */
if ( ! class_exists( 'Video_Blogster_Engine' ) ) {

    class Video_Blogster_Engine extends Video_Blogster_Core {

	public $video_source 		= null;		// will point to the instance of the current video source
	private $modules 		= null;		// array of installed video modules
	protected $spinner 		= null;
	public $VBPUpdateChecker 	= null;
	public $scheduler 		= null;
	protected static $instance 	= null;
	private $blacklist		= null;

////////////////////////////////////////////////////////////////////////////////////////////

	public function __construct() { }

        /* If SINGLETON is used, then both VBP and VP share it :( */
        public static function getInstance( $params ) {
                if ( !isset( self::$instance ) ) {
                        self::$instance = new self();
                        self::$instance->init( $params );
                }
                return self::$instance;
        }

        public static function newInstance( $params ) {
		$vb = new self();
		$vb->init( $params );
		return $vb;
	}

	/*
	 * Register actions and filters when object created
	 */
        public function init( $params = array() ) {
		parent::__construct( $params );
		// admin hooks:
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_options_styles' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_options_styles_frontend' ) );
		add_action( 'admin_menu', array( $this, 'add_menus' ) );
		add_action( 'admin_init', array( $this, 'check_import_export' ) );
		add_action( 'before_delete_post', array( $this, 'add_to_blacklist' ) );
		add_action( 'add_meta_boxes', array( $this, 'vbp_preview_metabox' ), 10, 2 );

    		$plugin = plugin_basename( $this->get_my_plugin('file') ); 
    		add_filter( "plugin_action_links_$plugin", array( $this, 'main_settings_link' ) );

		add_filter( 'http_request_timeout', array( $this, 'vb_extend_http_request_timeout' ) );
		add_action( 'wp_loaded', array( $this, 'process_video_feed' ) );

		add_action( 'plugins_loaded', array( $this, 'check_for_update' ) );

		if ( is_admin() || defined( 'WP_CLI' ) ) {
			add_action( 'plugins_loaded', array( $this, 'plugin_init' ) );
		}

		add_action( 'wp_ajax_vbp_get_image', array( $this, 'vbp_get_image' ) );

		// non-admin hooks:
		$prefix = $this->get_my_plugin('prefix');
		add_action( $prefix . 'Schedule', array( $this, 'grab_video_feeds' ) );
		if ( $prefix == 'video_blogster_' )
			add_action( $prefix . 'metadata', array( $this, 'video_blogster_metadata' ) );

		// Scheduler singleton use check:
		if ( isset( $params['singleton'] ) ) {
			$this->scheduler = Video_Blogster_Scheduler::getInstance();
		}
		else {
			$this->scheduler = new Video_Blogster_Scheduler();
		}
		$this->scheduler->init( $this->plugin );
        }

	/*
	 * Show and process main settings page
	 */
	public function main_settings() {
		if( ! current_user_can( 'moderate_comments' ) ) {
			wp_die( esc_html__( 'You do not have sufficient permissions to access settings.' ) );
		}

		$this->get_options_to_vars();
		$this->display_msgs = 1;

		if ( isset( $_POST['save_values'] ) ) {
			$prefix = $this->get_my_plugin( 'prefix' );
			$license = isset( $_POST['video_blogster_license'] ) ? trim( stripslashes( $_POST['video_blogster_license'] ) ) : '';
			$purchase_code = isset( $_POST['video_blogster_purchase_code'] ) ? trim( stripslashes( $_POST['video_blogster_purchase_code'] ) ) : '';
			$blacklist = isset( $_POST['video_blogster_blacklist'] ) ? trim( stripslashes( $_POST['video_blogster_blacklist'] ) ) : '';
			$blacklist = str_replace( ",", "\n", $blacklist ); // in case user typed commas instead of newlines
			$blacklist = explode( PHP_EOL, $blacklist );
			$blacklist_auto = isset( $_POST['video_blogster_blacklist_auto'] ) ? $_POST['video_blogster_blacklist_auto'] : FALSE;

			update_option( $prefix . 'license', $license );
			update_option( $prefix . 'purchase_code', $purchase_code);
			update_option( $prefix . 'video_blacklist', $blacklist);
			update_option( $prefix . 'blacklist_auto', $blacklist_auto);

			$name = $this->get_my_plugin( 'name' );
			if ( $name == 'Video Blogster Pro' ) {
				if ( preg_match("#\\s#", $license )) {
					// should not be spaces in Envato username
					$this->info_message( sprintf( 
						esc_html__( 'An Envato Username is one word, and you have entered [%s]. Check %sdocumentation%s for more info.', 'video-blogster' ), 
						$license, 
						'<a target=_blank" href="' . esc_url( 'http://videoblogsterpro.com/documentation/#!/main_settings' ) . '">',
						'</a>'
					) );
				}
				$youtube_key = ! empty( $_POST['video_blogster_youtube_key'] ) ? trim( stripslashes( $_POST['video_blogster_youtube_key'] ) ) : 'AIzaSyASXdD2VqRO4AXiUaKCpx_12VyyDOD9ai0';
				$soundcloud_key = ! empty( $_POST['video_blogster_soundcloud_key'] ) ? trim( stripslashes( $_POST['video_blogster_soundcloud_key'] ) ) : '10eedf52132cd7a2d0fdbcfc572d5a0f';
				$vimeo_key = ! empty( $_POST['video_blogster_vimeo_key'] ) ? trim( stripslashes( $_POST['video_blogster_vimeo_key'] ) ) : '863e1b4f5993234012859ff4faab26c3';
				$giantbomb_key = ! empty( $_POST['video_blogster_giantbomb_key'] ) ? trim( stripslashes( $_POST['video_blogster_giantbomb_key'] ) ) : '';

				update_option( $prefix . 'youtube_key', $youtube_key );
				update_option( $prefix . 'soundcloud_key', $soundcloud_key );
				update_option( $prefix . 'vimeo_key', $vimeo_key );
				update_option( $prefix . 'giantbomb_key', $giantbomb_key );

				$youtube_delete = isset( $_POST['video_blogster_youtube_delete'] ) ? $_POST['video_blogster_youtube_delete'] : 'trash';
				update_option( $prefix . 'youtube_delete', $youtube_delete );
			}
			$gtranslate_key = ! empty( $_POST['video_blogster_gtranslate_key'] ) ? trim( stripslashes( $_POST['video_blogster_gtranslate_key'] ) ) : '';
			update_option( $prefix . 'gtranslate_key', $gtranslate_key );
			$mstranslate_key = ! empty( $_POST['video_blogster_mstranslate_key'] ) ? trim( stripslashes( $_POST['video_blogster_mstranslate_key'] ) ) : '';
			update_option( $prefix . 'mstranslate_key', $mstranslate_key );
			$timeout = ! empty( $_POST['video_blogster_timeout'] ) ? trim( stripslashes( $_POST['video_blogster_timeout'] ) ) : '';
			if ( $timeout < 5 ) $timeout = 5;
			if ( $timeout > 60 ) $timeout = 60;
			update_option( $prefix . 'timeout', $timeout );
			update_option( $prefix . 'beta', isset( $_POST['video_blogster_beta'] ) ? $_POST['video_blogster_beta'] : false );

			$this->info_message( esc_html__( 'Settings saved.', 'video-blogster' ) , 'updated', 'critical' );
			$this->license_check2();
		}
		include ( sprintf( "%s/templates/main-settings.php", $this->get_my_plugin('dir') ) );
		$str = php_sapi_name();
		$this->info_message( sprintf( esc_html__( 'php_sapi_name: %s.', 'video-blogster' ), $str ), 'notice notice-warning', 'debug' );

		$this->display_msgs = 0;
	}

	/*
	 * Determine which video modules are installed in the /sources subdir
	 */
	public function determine_video_modules() {
		if ( isset ( $this->modules ) ) {
			return;
		}
		$sources = $this->get_my_plugin('dir') . "sources/";
		if ( $handle = opendir( $sources ) ) {
			while ( false !== ( $entry = readdir( $handle ) ) ) {
				if ( $entry != "." && $entry != ".." && $entry[0] != '.') {
					// Mainstream:
					if ( stripos( $entry, 'class-YouTube' ) !== FALSE ) {
						$this->modules[] = 'YouTube';
					}
					else if ( stripos( $entry, 'class-DailyMotion' ) !== FALSE ) {
						$this->modules[] = 'DailyMotion';
					}
					else if ( stripos( $entry, 'class-GiantBomb' ) !== FALSE ) {
						$this->modules[] = 'GiantBomb';
					}
					else if ( stripos( $entry, 'class-MixCloud' ) !== FALSE ) {
						$this->modules[] = 'MixCloud';
					}
					/* DEPRECATED - api went oauth
					else if ( stripos( $entry, 'class-SoundCloud' ) !== FALSE ) {
						$this->modules[] = 'SoundCloud';
					}
					 */
					else if ( stripos( $entry, 'class-Spotify' ) !== FALSE ) {
						$this->modules[] = 'Spotify';
					}
					else if ( stripos( $entry, 'class-Vimeo' ) !== FALSE ) {
						$this->modules[] = 'Vimeo';
					}

					// Adult:
					else if ( stripos( $entry, 'class-GotPorn' ) !== FALSE ) {
						$this->modules[] = 'GotPorn';
					}
					else if ( stripos( $entry, 'class-PornerBros' ) !== FALSE ) {
						$this->modules[] = 'PornerBros';
					}
					else if ( stripos( $entry, 'class-PornHub' ) !== FALSE ) {
						$this->modules[] = 'PornHub';
					}
					else if ( stripos( $entry, 'class-PornTube2' ) !== FALSE ) {
						$this->modules[] = 'PornTube2';
					}
					else if ( stripos( $entry, 'class-RedTube' ) !== FALSE ) {
						$this->modules[] = 'RedTube';
					}
					else if ( stripos( $entry, 'class-Tube8' ) !== FALSE ) {
						$this->modules[] = 'Tube8';
					}
					else if ( stripos( $entry, 'class-xTube' ) !== FALSE ) {
						$this->modules[] = 'xTube';
					}
					else if ( stripos( $entry, 'class-xHamster2' ) !== FALSE ) {
						$this->modules[] = 'xHamster2';
					}
					else if ( stripos( $entry, 'class-YouPorn' ) !== FALSE ) {
						$this->modules[] = 'YouPorn';
					}

					// Both:
					else if ( stripos( $entry, 'class-RSS' ) !== FALSE ) {
						$this->modules[] = 'RSS';
					}
					else if ( stripos( $entry, 'class-contentfeed' ) !== FALSE ) {
						$this->modules[] = 'ContentFeed';
					}
				}
			}
			$this->info_message( sprintf( esc_html__( 'Video Modules detected: %s', 'video-blogster' ), print_r($this->modules,true) ), 'notice notice-warning', 'debug' );
		}
		else {
			$this->info_message( sprintf( esc_html__( 'Error: plugin missing directory %s ', 'video-blogster' ), $sources ) );
		}
	}

	/*
	 * Verify our hook events are still scheduled
	 */
	public function video_blogster_verify_schedule() {
		$prefix = $this->get_my_plugin('prefix');
		if ( ! $prefix ) return;

		// v5.0, check YT metadata every 30 days. Check hook every X seconds, auto adjusts as needed.
		$hook = $this->get_my_plugin('prefix') . 'metadata';
		if ( $prefix == 'video_blogster_' && false === wp_next_scheduled( $hook ) ) {
			$yt_meta_check_time = $this->transientChecker( 'vbp_youtube_metadata', MONTH_IN_SECONDS );
			$this->info_message( sprintf( esc_html__( '%s: scheduling metadata hook for %s seconds from now.', 'video-blogster' ), __FUNCTION__, $yt_meta_check_time ), 'notice notice-warning', 'debug' );
			wp_schedule_single_event( time() + $yt_meta_check_time, $hook );
		}

		if ( get_option( $prefix . 'sch_enabled' ) == FALSE ) return;

		$hours = get_option( $prefix . 'sch_freq' );
		if ( $hours ) {
			if ( false === wp_next_scheduled( $prefix . 'Schedule' ) ) {
				// missing event for some reason... reset it
				$this->info_message( sprintf( esc_html__( 'Scheduler Event was not rescheduled by WordPress - most likely database issue. Trying to reschedule Event again... ', 'video-blogster' ) ) );
				// there may be 2 cron instances conflicting. try to separate them
				sleep(rand(0,5));	// give db some time to catch up as that is likely the problem.
				wp_schedule_event( time(), $prefix . 'scheduler', $prefix . 'Schedule' );
			}
		}
		$hours = get_option( $prefix . 'checker' );
		if ( $hours ) {
			if ( false === wp_next_scheduled( $prefix . 'Check' ) ) {
				// missing event for some reason... reset it
				$this->info_message( sprintf( esc_html__( 'Utility Event was not rescheduled by WordPress - most likely database issue. Trying to reschedule Event again... ', 'video-blogster' ) ) );
				// there may be 2 cron instances conflicting. try to separate them
				sleep(rand(0,5));	// give db some time to catch up as that is likely the problem.
				wp_schedule_event( time(), $prefix . 'checker', $prefix . 'Check' );
			}
		}
	}

	/*
	 * Verify not more than 1 event scheduled
	 * Verify cron is not already running
	 */
	private function verify_valid_cronjob( $shorthook ) {
		global $doing_wp_cron;

		$prefix = $this->get_my_plugin('prefix');
		if ( ! $prefix ) return;
		$hook = $prefix . $shorthook;

		$crons = get_option( 'cron' );
		$events = 0;
		foreach ( $crons as $timestamp => $cron ) {
			if ( isset( $cron[$hook] ) ) {
				$events++;
			}
		}
		if ( $events > 1 ) {	// only 1 event should be scheduled for the hook. slow db issue/bug?
			// clear all hook events
			wp_clear_scheduled_hook( $hook );

			// set a fresh event in 60 seconds
			$freq = ( $shorthook == 'Schedule' ) ? $prefix . 'scheduler' : $prefix . 'checker';
			wp_schedule_event( time() + 60, $freq, $hook );

			return $this->info_message( sprintf( esc_html__( '%s: %s hook had %s events (probable reason: database too slow/timed out when WordPress sets events). Resetting.', 'video-blogster' ), __FUNCTION__, $hook, $events ) );
		}

		$doing_cron_transient = get_transient( 'doing_cron' );
		if ( $doing_cron_transient != $doing_wp_cron ) {
			return $this->info_message( sprintf( esc_html__( '%s: cron transient did not match cron lock, indicating multiple cron jobs (probable reason: database too slow/timed out when WordPress sets cron transient). Skipping this one.', 'video-blogster' ), __FUNCTION__ ) );
		}
		return 1;
	}

	/*
	 * is cron event already running? shouldn't ever be, but check anyway in case of WP-Cron hiccup or process failure.
	 */
	private function set_running_transient( $which ) {
		$transient = $this->get_my_plugin( 'prefix' ) . 'running_' . $which;
		$running = $this->transientChecker( $transient );
		if ( ! empty ( $running  ) ) {
			return $this->info_message( sprintf( esc_html__( '%s: Error! Scheduler marked as already running [%s] probably slow database write. Skipping this event just in case.', 'video-blogster' ), __FUNCTION__, $running ), 'error', 'critical' );
		}
		$running = current_time( 'Y-m-d H:i:s' ) . " " . get_option( 'timezone_string' );
		$this->transientSave( $transient, $running, 3600 + 30 );

		return 1;
	}

	private function get_running_transient( $which ) {
		$transient = $this->get_my_plugin( 'prefix' ) . 'running_' . $which;
		$running = $this->transientChecker( $transient );
		return $running;
	}

	private function delete_running_transient( $which ) {
		$transient = $this->get_my_plugin( 'prefix' ) . 'running_' . $which;
		delete_transient( $transient );
	}

	/*
	 * Process a list of feeds. This is for mod_php servers with no script timeouts
	 */
	private function process_video_feeds( $results = array() ) {
                foreach ( $results as $feed ) {
			$this->process_video_feed( $feed );
			sleep( 1 );
		}
		$this->process_video_feeds_done();
	}

	/*
	 * Process a single content feed.
	 * non mod_php servers will call this on every 'wp_loaded' action.
	 */
	public function process_video_feed( $feed = null ) {

		// for non mod_php servers, load the next feed and save the rest:
		$check_done = false;
		if ( ! $feed ) {
			$feeds = get_transient( 'vbp_feeds' );
			if ( empty( $feeds ) ) {
				return; // nothing to do
			}
			$feed = array_shift( $feeds );
			set_transient( 'vbp_feeds', $feeds, 3600 * 24 );
			$check_done = true;
		}

		if ( $feed ) {
			$args = get_object_vars( $feed );
			$args['singleRequest'] = '';
			if ( $args['feedStatus'] != 'Active' ) {
				$this->info_message( sprintf( esc_html__( '===> %s: Skipping inactive feedID %s, source %s', 'video-blogster' ), __FUNCTION__, $args['id'], $args['videoSource'] ), 'notice notice-warning', 'debug' );
			}
			else {
				$this->info_message( sprintf( esc_html__( '===> %s: feed %s ID %s, source %s', 'video-blogster' ), __FUNCTION__, $args['feedName'], $args['id'], $args['videoSource'] ), 'updated', 'critical' );
				$this->create_video_source( $args );
				$this->grab_videos( $args );
			}
		}

		// for non mod_php servers, check if done
		if ( $check_done && empty( $feeds ) ) $this->process_video_feeds_done();
	}

	/*
	 * When done processing all feeds, clean up and email summary
	 */
	private function process_video_feeds_done() {
		$this->delete_running_transient( 'sched' );
		$this->info_message( sprintf( esc_html__( 'Scheduler %s: End', 'video-blogster' ), __FUNCTION__ ), 'updated', 'critical' );
		$this->email_error_summary();
	}

	/*
	 * The Scheduler trigger that sequentially queries the video feeds
	 */
	public function grab_video_feeds() {

// JPH MARK add filter for custom Scheduler check based on date/time?
		if ( ! $this->license_check2() ) {
			return 0;
		}

		$this->info_message( sprintf( esc_html__( 'Scheduler %s: Start', 'video-blogster' ), __FUNCTION__ ), 'updated', 'critical' );

		// in case of multiple cron jobs of same event spawned, separate them by slight amount to catch them
		sleep(rand(0,5));	// give db some time to catch up as that is likely the problem.

		if ( ! $this->verify_valid_cronjob( 'Schedule' ) ) {
			return 0;
		}

		if ( ! $this->set_running_transient( 'sched' ) ) {
			return 0;
		}

		// set custom error handling from server
		set_error_handler( array( $this, 'custom_error_handler' ) );
		register_shutdown_function( array( $this, 'custom_shutdown_handler' ) );

		$this->check_for_custom_includes();
		$this->get_options_to_vars();

		$results = $this->get_video_feed_details( "", "time DESC", 1 );

		if ( $this->mod_php() || defined( 'DISABLE_WP_CRON' ) || defined( 'VBP_PROCESS_ALL' ) ) {
			$this->info_message( sprintf( esc_html__( 'Scheduler %s: End - %d feeds ready to process', 'video-blogster' ), __FUNCTION__, count($results) ), 'notice notice-warning', 'debug' );
			$this->process_video_feeds( $results );
		}
		else {
			$feeds = get_transient( 'vbp_feeds' );
			// only start processing feeds if previous run is finished.
			if ( empty( $feeds ) ) {
				$this->info_message( sprintf( esc_html__( 'Scheduler %s: End - saved %d transient vbp_feeds to process', 'video-blogster' ), __FUNCTION__, count($results) ), 'updated', 'critical' );
				set_transient( 'vbp_feeds', $results, 3600 * 24 );
			}
			else {
				$this->info_message( sprintf( esc_html__( 'Scheduler %s: End - previous run of vbp_feeds not finished. Skipping.', 'video-blogster' ), __FUNCTION__ ), 'updated', 'critical' );
			}
		}


	}

	/*
	 * Create and set query object depending on the video source
	 */
	public function create_video_source( $args ) {
		$name = $this->get_my_plugin( 'name' );

		// set any ranges
		if ( isset( $args['qNumVideos'] ) )
			$args['qNumVideos'] = $this->number_range_select( $args['qNumVideos'] );
		if ( isset( $args['qNumComments'] ) )
			$args['qNumComments'] = $this->number_range_select( $args['qNumComments'] );

		$args = apply_filters( 'vbp_video_feed', $args );
		// Mainstream:
		if ( $args['videoSource'] == "YouTube" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-youtube.php' ) ) {
				return 0;
			}
			$apiKey = get_option( $this->get_my_plugin( 'prefix' ) . 'youtube_key' );
			$this->video_source = new Video_Blogster_YouTube( $this, $args, $apiKey );
		}
		else if ( $args['videoSource'] == "DailyMotion" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-dailymotion.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Blogster_DailyMotion( $this, $args );
		}
		else if ( $args['videoSource'] == "GiantBomb" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-giantbomb.php' ) ) {
				return 0;
			}
			$apiKey = get_option( $this->get_my_plugin( 'prefix' ) . 'giantbomb_key' );
			$this->video_source = new Video_Blogster_GiantBomb( $this, $args, $apiKey ); 
		}
		else if ( $args['videoSource'] == "MixCloud" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-mixcloud.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Blogster_MixCloud( $this, $args );
		}
		else if ( $args['videoSource'] == "SoundCloud" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-soundcloud.php' ) ) {
				return 0;
			}
			$apiKey = get_option( $this->get_my_plugin( 'prefix' ) . 'soundcloud_key' );
			$this->video_source = new Video_Blogster_SoundCloud( $this, $args, $apiKey );
		}
		else if ( $args['videoSource'] == "Spotify" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-spotify.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Blogster_Spotify( $this, $args );
		}
		else if ( $args['videoSource'] == "Vimeo" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-vimeo.php' ) ) {
				return 0;
			}
			$apiKey = get_option( $this->get_my_plugin( 'prefix' ) . 'vimeo_key' );
			$this->video_source = new Video_Blogster_Vimeo( $this, $args, $apiKey, '', null );
		}

		// Adult:
		else if ( $args['videoSource'] == "ExtremeTube" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-extremetube.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Pornster_ExtremeTube( $this, $args );
		}
		else if ( $args['videoSource'] == "GayTube" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-gaytube.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Pornster_GayTube( $this, $args );
		}
/* DEPRECATED
		else if ( $args['videoSource'] == "GotPorn" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-gotporn.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Pornster_GotPorn( $this, $args );
		}
*/
		else if ( $args['videoSource'] == "KeezMovies" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-keezmovies.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Pornster_KeezMovies( $this, $args );
		}
		else if ( $args['videoSource'] == "PornerBros" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-pornerbros.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Pornster_PornerBros( $this, $args );
		}
		else if ( $args['videoSource'] == "PornHub" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-pornhub.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Pornster_PornHub( $this, $args );
		}
		else if ( $args['videoSource'] == "PornTube2" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-porntube2.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Pornster_PornTube2( $this, $args );
		}
/* DEPRECATED
		else if ( $args['videoSource'] == "PornTube" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-porntube.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Pornster_PornTube( $this, $args );
		}
*/
		else if ( $args['videoSource'] == "RedTube" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-redtube.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Pornster_RedTube( $this, $args );
		}
		else if ( $args['videoSource'] == "SpankWire" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-spankwire.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Pornster_SpankWire( $this, $args );
		}
		else if ( $args['videoSource'] == "Tube8" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-tube8.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Pornster_Tube8( $this, $args );
		}
		else if ( $args['videoSource'] == "xTube" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-xtube.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Pornster_xTube( $this, $args );
		}
		else if ( $args['videoSource'] == "xHamster2" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-xhamster2.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Pornster_xHamster2( $this, $args );
		}
/* DEPRECATED
		else if ( $args['videoSource'] == "xHamster" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-xhamster.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Pornster_xHamster( $this, $args );
		}
*/
		else if ( $args['videoSource'] == "xVideos2" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-xvideos2.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Pornster_xVideos2( $this, $args );
		}
/* DEPRECATED
		else if ( $args['videoSource'] == "xVideos" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-xvideos.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Pornster_xVideos( $this, $args );
		}
*/
		else if ( $args['videoSource'] == "YouPorn" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-youporn.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Pornster_YouPorn( $this, $args );
		}
		// Both:
		else if ( $args['videoSource'] == "ContentFeed" || $args['videoSource'] == "ContentDump" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-contentfeed.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Blogster_ContentFeed( $this, $args );
		}
		else if ( $args['videoSource'] == "RSS" ) {
			if ( ! $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'sources/class-rss.php' ) ) {
				return 0;
			}
			$this->video_source = new Video_Blogster_RSS( $this, $args );
		}
		else { // shouldn't happen
			$this->info_message( sprintf( esc_html__( 'Error: video source %s not recognized.', 'video-blogster' ), $args['videoSource'] ) );
			$this->video_source = 0;
		}
	}

	/*
	 * Extract form data into an array.
	 * Query form data mostly depends on module type (YouTube, Vimeo, etc)
	 */
	protected function get_video_feed_form() {
		// pre-process multiple post categories if set
		if ( isset( $_POST['feed_search_category'] ) && ! empty( $_POST['feed_search_category'] ) ) {
			if ( is_array( $_POST['feed_search_category'] ) ) {
				$cats = array();
				foreach ( $_POST['feed_search_category'] as $name => $value ) {
					$cats[] = $value;
				}
				$searchCats = implode( "," ,$cats );
			}
			else {
				$searchCats = trim( stripslashes( $_POST['feed_search_category'] ) );
			}
			if ( ! empty( $searchCats ) ) $searchCats = mb_strimwidth( $searchCats, 0, 255 );
		}
		else $searchCats = '';

			$args = array(
				'func'			=>	isset( $_POST['func'] ) ? $_POST['func'] : '',
				'id'			=>	isset( $_POST['feedID'] ) ? $_POST['feedID'] : '',
				'videoSource'		=>	isset( $_POST['switch_video_source'] ) ? $_POST['switch_video_source'] : ( isset( $_POST['video_source'] ) ? $_POST['video_source'] : '' ),
				'feedName'		=>	isset( $_POST['feed_name'] ) ? trim( stripslashes( $_POST['feed_name'] ) ) : '',
				'feedStatus'		=>	isset( $_POST['feed_status'] ) ? $_POST['feed_status'] : FALSE,
				'feedSchedule'		=>	isset( $_POST['feed_schedule'] ) ? $_POST['feed_schedule'] : FALSE,

//				--- Build the Query -------------------------------------

				'singleRequest'		=>	isset( $_POST['single_request'] ) ? trim( stripslashes( $_POST['single_request'] ) ) : '',
				'qNumVideos'		=>	isset( $_POST['feed_numVideos'] ) ? $_POST['feed_numVideos'] : '',
				'qKeyphrase'		=>	isset( $_POST['feed_keyphrase'] ) ? trim( stripslashes( $_POST['feed_keyphrase'] ) ) : '',
				'qAssocType'		=>	isset( $_POST['feed_assoc_type'] ) ? $_POST['feed_assoc_type'] : '',
				'qAssoc'		=>	isset( $_POST['feed_assoc'] ) ? trim( stripslashes( $_POST['feed_assoc'] ) ) : '',
				'qPublishedAfter'	=>	isset( $_POST['feed_pub_after'] ) ? trim( stripslashes( $_POST['feed_pub_after'] ) ) : '',
				'qPublishedBefore'	=>	isset( $_POST['feed_pub_before'] ) ? trim( stripslashes( $_POST['feed_pub_before'] ) ) : '',
				'qOrderBy'		=>	isset( $_POST['feed_orderby'] ) ? $_POST['feed_orderby'] : '',
				'qOrderDirection'	=>	isset( $_POST['feed_order_direction'] ) ? $_POST['feed_order_direction'] : '',
				'qQueryBehavior'	=>	isset( $_POST['feed_query_behavior'] ) ? $_POST['feed_query_behavior'] : '',
				'qCategory'		=>	isset( $_POST['feed_search_category'] ) ? $searchCats : '',
				'qDuration'		=>	isset( $_POST['feed_search_duration'] ) ? $_POST['feed_search_duration'] : '',
				'qDefinition'		=>	isset( $_POST['feed_search_definition'] ) ? $_POST['feed_search_definition'] : 'any',
				'qImageImport'		=>	isset( $_POST['feed_image_import'] ) ? $_POST['feed_image_import'] : FALSE,
				'qRegionCode'		=>	isset( $_POST['feed_region_code'] ) ? trim( stripslashes( $_POST['feed_region_code'] ) ) : '',
				'qLanguage'		=>	isset( $_POST['feed_language'] ) ? trim( stripslashes( $_POST['feed_language'] ) ) : '',
				'qSafeSearch'		=>	isset( $_POST['feed_safesearch'] ) ? trim( stripslashes( $_POST['feed_safesearch'] ) ) : '',
				'qLicense'		=>	isset( $_POST['feed_video_license'] ) ? $_POST['feed_video_license'] : 'any',
				'qCaption'		=>	isset( $_POST['feed_video_caption'] ) ? $_POST['feed_video_caption'] : 'any',
				'qNumComments'		=>	isset( $_POST['feed_num_comments'] ) ? $_POST['feed_num_comments'] : '',
				'qCommentOrderBy'	=>	isset( $_POST['feed_comment_orderby'] ) ? $_POST['feed_comment_orderby'] : 'time',
				'qCommentSearchTerms'	=>	isset( $_POST['feed_comment_search'] ) ? trim( stripslashes( $_POST['feed_comment_search'] ) ) : '',
				'qCommentReplies'	=>	isset( $_POST['feed_comment_replies'] ) ? $_POST['feed_comment_replies'] : FALSE,
				'qCaptions'		=>	isset( $_POST['feed_captions'] ) ? $_POST['feed_captions'] : FALSE,
				'qCaptionsLanguage'	=>	isset( $_POST['feed_captions_language'] ) ? trim( stripslashes( $_POST['feed_captions_language'] ) ) : '',
				'qExtraParams'		=>	isset( $_POST['feed_extra_params'] ) ? trim( stripslashes( $_POST['feed_extra_params'] ) ) : '',
				'qExtraParams2'		=>	isset( $_POST['feed_extra_params2'] ) ? trim( stripslashes( $_POST['feed_extra_params2'] ) ) : '',
				'qExtraParams3'		=>	isset( $_POST['feed_extra_params3'] ) ? trim( stripslashes( $_POST['feed_extra_params3'] ) ) : '',
				'qContentFields' 	=>	isset( $_POST['feed_content_fields'] ) ? $_POST['feed_content_fields'] : array(),
				'qImageId'		=>	isset( $_POST['feed_image_attachment_id'] ) ? absint( $_POST['feed_image_attachment_id'] ) : 0,


//				--- Process the Results -------------------------------------

				'pTranslateApi'		=>	isset( $_POST['feed_translate_api'] ) ? trim( stripslashes( $_POST['feed_translate_api'] ) ) : '',
				'pTranslateTo'		=>	isset( $_POST['feed_translate_to'] ) ? $_POST['feed_translate_to'] : '',
				'pTranslateContent'	=>	isset( $_POST['feed_translate_content'] ) ? $_POST['feed_translate_content'] : '',
				'pUpdateExisting'	=>	isset( $_POST['feed_update_existing'] ) ? $_POST['feed_update_existing'] : FALSE,
				'pSkipTitle'		=>	isset( $_POST['feed_skip_titles'] ) ? $_POST['feed_skip_titles'] : FALSE,
				'pStrictTitle'		=>	isset( $_POST['feed_strict_title'] ) ? trim( stripslashes( $_POST['feed_strict_title'] ) ) : '',
				'pNegateTitle'		=>	isset( $_POST['feed_negate_title'] ) ? trim( stripslashes( $_POST['feed_negate_title'] ) ) : '',
				'pMinViews'		=>	isset( $_POST['feed_min_views'] ) && is_numeric( $_POST['feed_min_views'] ) ? (int)$_POST['feed_min_views'] : 0,
				'pCutoffDate'		=>	isset( $_POST['feed_cutoff_date'] ) ? trim( stripslashes( $_POST['feed_cutoff_date'] ) ) : '',
				'pDurationMin'		=>	isset( $_POST['feed_duration_min'] ) ? trim( stripslashes( $_POST['feed_duration_min'] ) ) : '',
				'pDurationMax'		=>	isset( $_POST['feed_duration_max'] ) ? trim( stripslashes( $_POST['feed_duration_max'] ) ) : '',
				'pNoThumbnails'		=>	isset( $_POST['feed_no_thumbnails'] ) ? $_POST['feed_no_thumbnails'] : FALSE,
				'pLimitTitleChars'	=>	isset( $_POST['feed_limit_title_chars'] ) && is_numeric( $_POST['feed_limit_title_chars'] ) ? (int)$_POST['feed_limit_title_chars'] : 0,
				'pLimitTitleWord'	=>	isset( $_POST['feed_limit_title_word'] ) ? trim( stripslashes( $_POST['feed_limit_title_word'] ) ) : '',
				'pRemoveTitleChars'	=>	isset( $_POST['feed_remove_title_chars'] ) ? trim( stripslashes( $_POST['feed_remove_title_chars'] ) ) : '',
				'pReplacePhrases'	=>	isset( $_POST['feed_replace_phrases'] ) ? stripslashes( $_POST['feed_replace_phrases'] ) : '',
				'pLimitDescChars'	=>	isset( $_POST['feed_limit_desc_chars'] ) && is_numeric( $_POST['feed_limit_desc_chars'] ) ? (int)$_POST['feed_limit_desc_chars'] : 0,
				'pLimitDescWord'	=>	isset( $_POST['feed_limit_desc_word'] ) ? trim( stripslashes( $_POST['feed_limit_desc_word'] ) ) : '',
				'pSentenceRemove'	=>	isset( $_POST['feed_sentence_remove'] ) && is_numeric( $_POST['feed_sentence_remove'] ) ?  (int)$_POST['feed_sentence_remove'] : 0,
				'pSentenceRemovePhrase'	=>	isset( $_POST['feed_sentence_remove_phrase'] ) ? trim( stripslashes( $_POST['feed_sentence_remove_phrase'] ) ) : '',
				'pRemoveDescUrls'	=>	isset( $_POST['feed_remove_desc_urls'] ) ? $_POST['feed_remove_desc_urls'] : FALSE,
				'pRemoveCommUrls'	=>	isset( $_POST['feed_remove_comm_urls'] ) ? $_POST['feed_remove_comm_urls'] : FALSE,
				'pLinkifyDescUrls'	=>	isset( $_POST['feed_linkify_desc_urls'] ) ? $_POST['feed_linkify_desc_urls'] : FALSE,
				'pLinkifyCommUrls'	=>	isset( $_POST['feed_linkify_comm_urls'] ) ? $_POST['feed_linkify_comm_urls'] : FALSE,
				'pSpinTitle'		=>	isset( $_POST['feed_spin_title'] ) ? $_POST['feed_spin_title'] : FALSE,
				'pSpinDesc'		=>	isset( $_POST['feed_spin_desc'] ) ? $_POST['feed_spin_desc'] : FALSE,
				'pSpinCaptions'		=>	isset( $_POST['feed_spin_captions'] ) ? $_POST['feed_spin_captions'] : FALSE,
				'pSpinner'		=>	isset( $_POST['feed_spinner'] ) ? $_POST['feed_spinner'] : '',
				'pTitleTemplate'	=>	isset( $_POST['feed_title_template'] ) ? trim( stripslashes( $_POST['feed_title_template'] ) ) : '',
				'pPostTemplate'		=>	isset( $_POST['feed_post_template'] ) ? trim( stripslashes( $_POST['feed_post_template'] ) ) : '',
				'pResponsiveVideo'	=>	isset( $_POST['feed_responsive_video'] ) ? $_POST['feed_responsive_video'] : FALSE,
				'pImageTemplate'	=>	isset( $_POST['feed_image_template'] ) ? trim( stripslashes( $_POST['feed_image_template'] ) ) : '',
				'pCreateExcerpt'	=>	isset( $_POST['feed_create_excerpt'] ) ? $_POST['feed_create_excerpt'] : FALSE,
				'pGrabTags'		=>	isset( $_POST['feed_grab_tags'] ) ? $_POST['feed_grab_tags'] : FALSE,
				'pGrabPornstars'	=>	isset( $_POST['feed_grab_pornstars'] ) ? $_POST['feed_grab_pornstars'] : FALSE,
				'pCatFilter'		=>	isset( $_POST['feed_cat_filter'] ) ? $_POST['feed_cat_filter'] : '',
				'pMinTagLength'		=>	isset( $_POST['feed_min_tag_length'] ) && is_numeric( $_POST['feed_min_tag_length'] ) ? (int)$_POST['feed_min_tag_length'] : 0,
				'pIgnoreTags'		=>	isset( $_POST['feed_ignore_tags'] ) ? trim( stripslashes( $_POST['feed_ignore_tags'] ) ) : '',
				'pProcessRetro'		=>	isset( $_POST['feed_process_retro'] ) ? $_POST['feed_process_retro'] : FALSE,
				'pThemeHelper'		=>	isset( $_POST['feed_theme_helper'] ) ? $_POST['feed_theme_helper'] : FALSE,

//				--- Create the Post -------------------------------------

				'cUser'			=>	isset( $_POST['feed_user'] ) ? $_POST['feed_user'] : null,
				'cPostType'		=>	isset( $_POST['feed_post_type'] ) ? $_POST['feed_post_type'] : 'post',
				'cPostStatus'		=>	isset( $_POST['feed_post_status'] ) ? $_POST['feed_post_status'] : 'publish',
				'cPostFormat'		=>	isset( $_POST['feed_post_format'] ) ? $_POST['feed_post_format'] : 'standard',
				'cCategories'		=>	'',
				'cTaxTerms'             =>      isset( $_POST['feed_taxterms'] ) ? (array) $_POST['feed_taxterms'] : array(),
				'cAddSourceCategory'	=>	isset( $_POST['feed_add_source_cat'] ) ? $_POST['feed_add_source_cat'] : FALSE,
				'cUsePublishedDate'	=>	isset( $_POST['feed_use_publish_date'] ) ? $_POST['feed_use_publish_date'] : FALSE,
				'cClearTaxonomies'	=>	isset( $_POST['feed_clear_taxonomies'] ) ? $_POST['feed_clear_taxonomies'] : FALSE,
				'cQuickTags'		=>	isset( $_POST['feed_quick_tags'] ) ? trim( stripslashes( $_POST['feed_quick_tags'] ) ) : '',
			);

			// get custom fields here:
			$cnt=0;
			$args['pMetaFields'] = array();
			$metakeys = isset( $_POST['feed_metakey'] ) ? $_POST['feed_metakey'] : array();
			foreach ( $metakeys as $m ) {
				if ( $m ) {
					$m = trim( stripslashes( $m ) );
					$m = str_replace(array('\'', '"'), '', $m ); 
					$val = trim( stripslashes( $_POST['feed_metavalue'][$cnt] ) );
					$args['pMetaFields'][$m] = $val;
				}
				$cnt++;
			}

		$this->info_message( sprintf( esc_html__( '%s values: %s ', 'video-blogster' ), __FUNCTION__, htmlentities( print_r($args,true) ) ), 'notice notice-warning', 'debug' );
		return $args;
	}

	/*
	 * Re-Process all previous videos imported on this feed
	 * Apply changes to existing content
	 */
	private function process_retroactively( $args ) {
		if ( ! $args['id'] ) {
			return $this->info_message( esc_html__( 'Error: Cannot apply changes because feed ID is 0', 'video-blogster' ) );
		}

		$args = apply_filters( 'vbp_video_feed', $args );

		$getMore = true;
		$chunksize = apply_filters( 'vbp_posts_chunksize', 1000 );
		$query_args = array(
			'posts_per_page' 	=> $chunksize,
			'post_type' 		=> 'any',
			'post_status' 		=> array( 'pending', 'draft', 'publish', 'private' ),
			'meta_key' 		=> 'VideoFeed',
			'meta_value' 		=> $args['id'],
			'no_found_rows'		=> true,
			'cache_results'		=> false,
			'update_post_meta_cache' => false,
			'update_post_term_cache' => false,
			'fields'		=> 'ids'
			);
		$query_args = apply_filters( 'vbp_process_retroactively', $query_args );


		$offset = isset( $query_args['offset'] ) ? $query_args['offset'] : 0;

		wp_suspend_cache_addition(true);

		$this->extend_execution_time();

		$total = 0;
		while ( $getMore ) {
			$posts = get_posts( $query_args );
			$num_results = count( $posts );

			$this->info_message( sprintf( esc_html__( 'Applying changes to %d videos previously imported on feed ID %s at offset %d ', 'video-blogster' ), $num_results, $args['id'], $offset ), 'updated', 'critical' );


			foreach ( $posts as $post_id ) {
			$taglist = "";
			$posttags = get_the_tags( $post_id );
			if ( ! empty( $posttags ) ) {
				foreach ( $posttags as $tag ) {
					$taglist .= $tag->name . ',';
				}
			}
			$taglist = rtrim( $taglist, ",");
			// these are the only fields that may be used/updated:
			$videoInfo = array(
				'postID' 	=> $post_id,
				'association' 	=> get_post_meta( $post_id, 'VideoAssoc', TRUE ),
				'channelID' 	=> get_post_meta( $post_id, 'VideoChannelID', TRUE ),
				'duration' 	=> get_post_meta( $post_id, 'VideoDuration', TRUE ),
				'videoID' 	=> get_post_meta( $post_id, 'VideoID', TRUE ),
				'videoEmbed' 	=> get_post_meta( $post_id, 'VideoEmbed', TRUE ),
				'img' 		=> get_post_meta( $post_id, 'VideoImage', TRUE ),
				'desc' 		=> get_post_meta( $post_id, 'VideoOrigDesc', TRUE ),
				'title' 	=> get_post_meta( $post_id, 'VideoOrigTitle', TRUE ),
				'orig_desc' 	=> get_post_meta( $post_id, 'VideoOrigDesc', TRUE ),
				'orig_title' 	=> get_post_meta( $post_id, 'VideoOrigTitle', TRUE ),
				'url' 		=> get_post_meta( $post_id, 'VideoUrl', TRUE ),
				'skip'		=> get_post_meta( $post_id, 'VideoSkip', TRUE ),
				'viewCount'	=> get_post_meta( $post_id, 'views', TRUE ),
				'likeCount'	=> get_post_meta( $post_id, 'VideoLikes', TRUE ),
				'dislikeCount'	=> get_post_meta( $post_id, 'VideoDislikes', TRUE ),
				'favoriteCount'	=> get_post_meta( $post_id, 'VideoFavorites', TRUE ),
				'publishedAt'	=> get_post_meta( $post_id, 'VideoPublish', TRUE ),
				'videoSource'	=> get_post_meta( $post_id, 'VideoSource', TRUE ),
				'tags' 		=> $taglist
			);
			if ( empty( $videoInfo['publishedAt'] ) ) {
				// then use post date
				$videoInfo['publishedAt'] = get_the_date( '', $post_id );
			}

			$this->info_message( sprintf( esc_html__( 'Processing video %s ', 'video-blogster' ), htmlentities(print_r($videoInfo,true)) ), 'notice notice-warning', 'debug' );
			if ( ! empty( $videoInfo['skip'] ) ) { // do not preprocess videos with this meta set
				$this->info_message( esc_html__( 'VideoSkip meta field detected', 'video-blogster' ), 'notice notice-warning', 'debug' );
				continue;
			}
			if ( ! $this->process_query_results( $args, $videoInfo ) ) {
				continue;
			}
			$postID = $this->create_the_post( $args, $videoInfo );
			if ( $postID && FALSE !== stripos( $videoInfo['post_content'],'%VideoImageLocal%' ) ) {
				//if %VideoImageLocal% tag in template we need to update_post 
				$thumbID = get_post_thumbnail_id( $postID );
				$this->process_the_thumbnail( $postID, $thumbID, $videoInfo );
			}
			$total++;

			// update comments too? ugh 
			if ( TRUE == $args['pRemoveCommUrls'] || TRUE == $args['pLinkifyCommUrls'] ) {
				$comment_args = array(
					'post_id'	=> $post_id
					);
				$comments = get_comments( $comment_args );
				foreach ( $comments as $comment ) {
					if ( TRUE == $args['pRemoveCommUrls'] ) {
						$comment->comment_content = $this->remove_urls( $comment->comment_content );
					}
					if ( TRUE == $args['pLinkifyCommUrls'] ) {
						$comment->comment_content = $this->linkify_filtered( $comment->comment_content );
					}
					wp_update_comment( ( array )$comment );
				}
				unset( $comments );
			}
			unset( $videoInfo );
			} // end foreach posts
			unset( $posts );
			$offset += $chunksize;
			$query_args['offset'] = $offset;
			if ( $num_results < $chunksize ) $getMore = false;
		} // end getMore
		$this->info_message( sprintf( esc_html__( 'Processing results finished - %s videos updated', 'video-blogster' ), $total ), 'updated', 'critical' );
	}

	/*
	 * default postTemplate depends on Blogster/Pornster and videoSource
	 */

	public function get_default_post_template( $videoSource = 'YouTube' ) {
		$name = $this->get_my_plugin( 'name' );
		$default_post = null;
		if ( $videoSource == 'RSS' ) {
$default_post = <<<RSS
<p>%VideoDescription%</p>
RSS;
		}
		else if ( $videoSource == 'MixCloud' 
			|| $videoSource == 'SoundCloud'
			|| $videoSource == 'Spotify'
		) {
$default_post = <<<BLOGSTER
<p>%TrackEmbed%</p>
<p>%TrackDescription%</p>
BLOGSTER;
		}
		else {
$default_post = <<<BLOGSTER
<p>%VideoEmbed%</p>
<p>%VideoDescription%</p>
BLOGSTER;
		}
		$default_post = apply_filters( 'vbp_default_post_template', $default_post, $videoSource );
		return $default_post; 
	}


	private function check_theme_helper( $args ) {
		$name = $this->get_my_plugin( 'name' );
		if ( empty( $args['pMetaFields'] ) ) {
			$args['pMetaFields'] = array();
		}
		$args = apply_filters( 'vbp_make_feed', $args );
		return $args;
	}

	private function mod_php() {
		if ( function_exists( 'apache_get_modules' ) ) {
			$modules = apache_get_modules();
			$search = 'mod_php';
			if ( in_array( $search, $modules ) ) return 1;
			return 0;
		}
		return 1; // not checked
	}

	private function get_shorthand_bytes( $val ) {
		if ( is_numeric( $val ) )
			return $val;

		$last = strtolower($val[strlen($val)-1]);
		$val  = substr($val, 0, -1); // necessary since PHP 7.1; otherwise optional
		switch($last) {
			case 'g':
				$val *= 1024;
			case 'm':
				$val *= 1024;
			case 'k':
				$val *= 1024;
		}
		return $val;
	}

	/*
	 * Show and process make video feed page
	 */
	public function make_video_feed() {
		$this->display_msgs = 1;
		$this->determine_video_modules();
		$this->get_options_to_vars();

		$post_max_size = $this->get_shorthand_bytes( ini_get( 'post_max_size' ) );

		$current_post_size = isset( $_SERVER['CONTENT_LENGTH'] ) ? $_SERVER['CONTENT_LENGTH'] : 0;
		if ( $current_post_size ) {
			$this->info_message( sprintf( esc_html__( 'Post max size is %s, current post size is %s', 'video-blogster' ), $post_max_size, $current_post_size ), 'notice notice-warning', 'debug' );
		}
		if ( $current_post_size >= $post_max_size ) {
			$this->info_message( sprintf( esc_html__( 'PHP cannot handle this amount of data, suggest raising post_max_size in php.ini. Post max size is %s, current post size is %s', 'video-blogster' ), $post_max_size, $current_post_size ) );
		}

		$max_input_vars = $this->get_shorthand_bytes( ini_get( 'max_input_vars' ) );
		$current_input_vars = isset( $_POST ) ? count($_POST, COUNT_RECURSIVE) : 0;
		if ( $current_input_vars ) {
			$this->info_message( sprintf( esc_html__( 'Max input vars is %s, current input vars is %s', 'video-blogster' ), $max_input_vars, $current_input_vars ), 'notice notice-warning', 'debug' );
		}
		if ( $current_input_vars >= $max_input_vars ) {
			$this->info_message( sprintf( esc_html__( 'PHP cannot handle this amount of variables, suggest raising max_input_vars in php.ini. Max input vars is %s, current input vars is %s', 'video-blogster' ), $max_input_vars, $current_input_vars ) );
		}


		$this->info_message( sprintf( esc_html__( 'PHP version is %s', 'video-blogster' ), PHP_VERSION ), 'notice notice-warning', 'debug' );

		if ( ! defined( 'DISABLE_WP_CRON' ) && ! $this->mod_php() ) {
				$this->info_message( sprintf( 
					esc_html__( 'Video Blogster notice: %s and DISABLE_WP_CRON not defined. This means server will terminate script if timeout limit reached. See %sFAQ%s.', 'video-blogster' ), 
				'mod_php', 
				'<a target="_blank" href="' . esc_url( 'http://videoblogsterpro.com/documentation/#script-timeout' ) . '">',
				'</a>' 
				), 'notice notice-warning', 'critical' );
		}


		// default args to show:
		$args = array( 
			'func' 			=> 'Make', 
			'videoSource' 		=> in_array( 'YouTube', $this->modules ) ? 'YouTube' : 'YouPorn', 
			'feedStatus'		=> 'Active',
			'qImageImport'		=> true,
			'pTitleTemplate' 	=> '%VideoTitle%',
			'pImageTemplate' 	=> '%VideoTitle%',
			'pMetaFields'		=> array(),
			'cUser' 		=> '(random)',
			'cPostType' 		=> 'post',
			'cPostStatus' 		=> 'draft',
			'cPostFormat' 		=> 'standard'
		);     // defaults 
		$args['pPostTemplate']		= $this->get_default_post_template( $args['videoSource'] );

		$theme = $this->check_for_custom_includes();
		$theme_helper = $this->get_theme_helper( $theme );
		$this->info_message( sprintf( esc_html__( 'Theme Detected: %s', 'video-blogster' ), $theme->Name ), 'notice notice-warning', 'debug' );

		if ( file_exists( $theme_helper ) || is_link( $theme_helper ) ) {
			$this->info_message( sprintf( esc_html__( 'Including File: %s', 'video-blogster' ), $theme_helper ), 'notice notice-warning', 'debug' );
		}
		else {
			$this->info_message( sprintf( esc_html__( 'Theme helper %s not found or not required.', 'video-blogster' ), $theme_helper ), 'notice notice-warning', 'debug' );
		}

		if ( ! $this->license_check2() ) {
		}
		else if ( isset( $_POST['change_source'] ) ) {
		// change video_source selected
			$this->info_message( sprintf( esc_html__( 'Got switch source request to %s', 'video-blogster' ), $_POST['switch_video_source'] ), 'notice notice-warning', 'debug' );
			$args = $this->get_video_feed_form();
			unset( $args['qAssocType'] );
			unset( $args['qOrderBy'] );
			$args['pPostTemplate'] = $this->get_default_post_template( $args['videoSource'] );
			$args = $this->check_theme_helper( $args );
			// change %Video to %Track if needed
			if ( in_array( $args['videoSource'], array( 'MixCloud', 'SoundCloud', 'Spotify' ) ) ) {
				$args['pTitleTemplate'] = str_ireplace( "%Video", "%Track", $args['pTitleTemplate'] );
				$args['pPostTemplate'] = str_ireplace( "%Video", "%Track", $args['pPostTemplate'] );
				$args['pImageTemplate'] = str_ireplace( "%Video", "%Track", $args['pImageTemplate'] );
				$args['pMetaFields'] = str_ireplace( "%Video", "%Track", $args['pMetaFields'] );
			}
			else {
				$args['pTitleTemplate'] = str_ireplace( "%Track", "%Video", $args['pTitleTemplate'] );
				$args['pPostTemplate'] = str_ireplace( "%Track", "%Video", $args['pPostTemplate'] );
				$args['pImageTemplate'] = str_ireplace( "%Track", "%Video", $args['pImageTemplate'] );
				$args['pMetaFields'] = str_ireplace( "%Track", "%Video", $args['pMetaFields'] );
			}
		}

		else if ( isset( $_GET['editID'] ) && ! isset( $_POST['feedID'] ) ) {	
		// user clicked edit link on show video feed summary page
			$feedID = $_GET['editID'];
			$this->info_message( sprintf( esc_html__( 'Got edit request for feed %s', 'video-blogster' ), $feedID ), 'notice notice-warning', 'debug' );
			$results = $this->get_video_feed_details( $feedID );
			if ( $results ) {
				$args = (array)$results[0];
				$args['func'] = 'Edit';
			}
			$name = $this->get_my_plugin( 'name' );
			$args = apply_filters( 'vbp_edit_feed', $args );
		}
		else if ( isset( $_POST['grab_feed'] ) ) {
		// the Import Videos now button was pressed
			$this->info_message( esc_html__( 'Got import request', 'video-blogster' ), 'notice notice-warning', 'debug' );
			$args = $this->get_video_feed_form();
			$this->create_video_source( $args );
			$this->grab_videos( $args );
		}
		else if ( isset( $_POST['save_feed'] ) ) {
		// an Add or Edit form was submitted

			$this->info_message( esc_html__( 'Got save request', 'video-blogster' ), 'notice notice-warning', 'debug' );

			$args = $this->get_video_feed_form();
			if ( empty( $args['pPostTemplate'] ) && $this->get_my_plugin( 'name' ) == 'Video Pornster' ) {
				$args['pPostTemplate']		= $this->get_default_post_template( $args['videoSource'] );
			}
			if ( true == $args['pThemeHelper'] ) {
				$args = $this->check_theme_helper( $args );
			}
                        $feedID = isset( $_POST['feedID'] ) ? $_POST['feedID'] : 0;
			if ( $feedID ) {	// this is an Edit
				$this->info_message( sprintf( esc_html__( 'Save request is for feed %s', 'video-blogster' ), $feedID ), 'notice notice-warning', 'debug' );
				$args['id'] = $feedID;
				$this->video_feed_db_edit( $args );
				if ( $args['pProcessRetro'] ) {
					$this->process_retroactively( $args );
				}
			}
			else if ( ! $feedID ) {	// this is an Add
				$this->info_message( esc_html__( 'Save request is for a new feed', 'video-blogster' ), 'notice notice-warning', 'debug' );
				$this->video_feed_db_add( $args );
			}
		}
		else if ( isset( $_POST['copy_feed'] ) ) {
			$this->info_message( sprintf( esc_html__( 'Feed %s copied.', 'video-blogster' ), $_POST['feedID'] ), 'notice notice-warning', 'debug' );
			$args = $this->get_video_feed_form();
                        $args['id'] = $feedID = '';
			$args['func'] = 'Make';
		}
		else if ( isset( $_POST['del_feed'] ) ) {
                        $feedID = isset( $_POST['feedID'] ) ? $_POST['feedID'] : 0;
			if ( $feedID ) {
				$this->video_feed_db_delete( $feedID );
				$args = $this->check_theme_helper( $args );
				unset( $_POST['video_source'] );
				unset( $_POST['switch_video_source'] );
				$this->info_message( sprintf( esc_html__( 'Feed %s deleted.', 'video-blogster' ), $feedID ), 'notice notice-warning', 'debug' );
			}
		}
		else {
		// Make a new video feed 
			$args = $this->check_theme_helper( $args );

			$this->info_message( sprintf( esc_html__( 'New feed. Setting form defaults: %s .', 'video-blogster' ), htmlentities( print_r( $args,true ) ) ), 'notice notice-warning', 'debug' );

		}

		include( sprintf( "%s/templates/video-feed.php", $this->get_my_plugin('dir') ) );
		$this->display_msgs = 0;
	}

	/*
	 * Check for custom plugins or themes and load their filter functions automatically
	 */
	private function check_for_custom_includes() {

		// check for theme helper file, if any
		$theme = $this->get_theme();
		$theme_helper = $this->get_theme_helper( $theme );
		if ( file_exists( $theme_helper ) || is_link( $theme_helper) ) {
			$this->vb_include_once( $theme_helper );
		}

		// check for specific plugin support - have to check each one individually.
		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		if ( is_plugin_active( 'baw-post-views-count/bawpv.php' ) ) {
			$this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'plugin-helpers/baw-post-views-count.php' );
		}
		if ( is_plugin_active( 'wti-like-post/wti_like_post.php' ) ) { 	// plugin WTI Like Post
			$this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'plugin-helpers/wti-like-post.php' );
		}
		if ( is_plugin_active( 'wordpress-seo/wp-seo.php' ) ) {
			$this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'plugin-helpers/yoast-seo.php' );
		}
		if ( is_plugin_active( 'entry-views/entry-views.php' ) ) {
			$this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'plugin-helpers/entry-views.php' );
		}
		if ( is_plugin_active( 'wordpress-popular-posts/wordpress-popular-posts.php' ) ) {
			$this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'plugin-helpers/wordpress-popular-posts.php' );
		}
		return $theme;
	}

	/*
	 * A wrapper for video_source->grab_videos
	 */
	private function grab_videos( $args ) {
		if ( ! $this->video_source ) {
			return $this->info_message( sprintf( esc_html__( 'Error: video source is undefined. Contact support.', 'video-blogster' ) ) );
		}

		if ( $args['qNumComments'] ) {
			$this->info_message( sprintf( esc_html__( 'Removing WordPress flood filter check', 'video-blogster' ) ), 'notice notice-warning', 'debug' );
			add_filter( 'comment_flood_filter', array( $this, 'comment_flood_filter_off' ), 10, 3 );
		}

		$this->extend_execution_time();

		$more = $this->video_source->grab_videos();

		if ( $args['qNumComments'] ) {
			$this->info_message( sprintf( esc_html__( 'Restoring WordPress flood filter check', 'video-blogster' ) ), 'notice notice-warning', 'debug' );
			remove_filter( 'comment_flood_filter', array( $this, 'comment_flood_filter_off' ) );
		}

		return $more;
	}

	/*
	 * Retrieve video feed(s) from the database
	 */
	private function get_video_feed_details( $feedID="", $orderby="", $activeOnly = false ) {
                global $wpdb;
		$wpdb->suppress_errors( false );
		$wpdb->show_errors();
                $table_name = $wpdb->prefix . $this->get_my_plugin( 'prefix' ) . 'feed';
                $sql = "SELECT * FROM " . $table_name;
		if ( $feedID ) {
			$sql .= " WHERE id = " . $feedID;
		}
		else if ( $activeOnly ) {
			$sql .= " WHERE feedStatus = 'Active'";
		}
		if ( $orderby ) {
			$sql .= " ORDER BY " . $orderby;
		}
		$this->info_message( sprintf( esc_html__( '%s SQL statement: %s', 'video-blogster' ), __FUNCTION__, $sql ), 'notice notice-warning', 'debug' );
                $results = $wpdb->get_results( $sql );

		if ( empty( $results ) ) return array();

		foreach ( $results as $index => $result ) {

			// unserialize content fields
			$results[$index]->qContentFields = isset( $results[$index]->qContentFields ) ? maybe_unserialize( $results[$index]->qContentFields ) : array();

			// unserialize meta fields
			$results[$index]->pMetaFields = isset( $results[$index]->pMetaFields ) ? maybe_unserialize( $results[$index]->pMetaFields ) : array();

			// unserialize taxonomies
			$results[$index]->cTaxTerms = isset( $results[$index]->cTaxTerms ) ? maybe_unserialize( $results[$index]->cTaxTerms ) : array();

			// set default for previous feeds. v4.0
			if ( empty( $results[$index]->qAssocType ) ) {
				$results[$index]->qAssocType = 'search';
			}
			if ( empty( $results[$index]->qQueryBehavior ) ) {
				$results[$index]->qQueryBehavior = 'strict';
			}
		}
		$wpdb->hide_errors();
		$wpdb->suppress_errors( true );
		return $results;
	}

	/*
	 * Process import/export feeds page
	 */
	public function check_import_export() {
		if ( isset( $_POST['import_feeds'] ) ) {
			if ( empty( $_FILES['vbp_import_file'] ) )
				wp_die( esc_html__( "No file selected.", 'video-blogster-pro' ) );

			$file = $_FILES['vbp_import_file'];

			if ( $file["type"] != "application/json" )
				wp_die( sprintf( esc_html__( "There was an error importing the file. File type detected: '%s'. 'application/json' expected", 'video-blogster-pro' ), $file['type'] ) );

			if( $file["error"] > 0 )
				wp_die( sprintf( esc_html__( "Error encountered: %d", 'video-blogster-pro' ), $file["error"] ) );

			$this->info_message( sprintf( esc_html__( 'Importing from file %s', 'video-blogster' ), $file['tmp_name'] ) , 'notice notice-warning', 'debug' );

			$feeds = file( $file['tmp_name'] );
			$feeds = array_reverse( $feeds );
			foreach( $feeds as $feed ) {
				$data = json_decode( $feed );
				$this->info_message( sprintf( esc_html__( 'Importing feed: %s', 'video-blogster' ), $data[0]->id) , 'notice notice-warning', 'debug' );

				$data = (array) $data[0];
				if ( isset( $data['pMetaFields'] ) )
					$data['pMetaFields'] = (array) $data['pMetaFields'];
				$this->video_feed_db_add( $data );
			}
			unset( $_POST['import_feeds'] ); // otherwise called more than once.
		}
		if ( isset( $_POST['export_feeds'] ) ) {
			if ( empty( $_POST['select'] ) ) {
				wp_die( esc_html__( "No feeds selected. Cannot export.", 'video-blogster-pro' ) );
			}
			else {
			$file_name = 'vbp-export-' . date('Y-m-d') . '.json';
			header( "Content-Description: File Transfer" );
			header( "Content-Disposition: attachment; filename={$file_name}" );
			header( "Content-Type: application/json; charset=utf-8" );
			foreach ($_POST['select'] as $s) {
				$results = $this->get_video_feed_details( $s );
				echo json_encode( $results ) . PHP_EOL;
			}
			die();
			}
		}
	}

	/*
	 * Show import/export feeds page
	 */
	public function import_export_feeds() {
		include( sprintf( "%s/templates/import-export-feeds.php", $this->get_my_plugin('dir') ) );
	}

	/*
	 * Show and process show video feeds page
	 */
	public function show_video_feeds() {
		$this->get_options_to_vars();
		$this->display_msgs = 1;
		if ( isset( $_GET['importID'] ) ) {	
		// user clicked import now link on show video feed summary page
			$feedID = $_GET['importID'];
			$results = $this->get_video_feed_details( $feedID );
			if ( $results ) {
				$args = (array)$results[0];
				$this->create_video_source( $args );
				$this->grab_videos( $args );
			}
		}
		if ( isset( $_POST['mass_import'] ) && isset( $_POST['select'] ) ) {
			// mass import selections
			foreach ($_POST['select'] as $s) {
				$results = $this->get_video_feed_details( $s );
				if ( $results ) {
					$args = (array)$results[0];
					$this->create_video_source( $args );
					$this->grab_videos( $args );
				}
			}
		}
		else if ( isset( $_POST['mass_delete'] ) && isset( $_POST['select'] ) ) {
			// mass delete selections
			foreach ($_POST['select'] as $s) {
				$this->video_feed_db_delete( $s );
			}
		}
		else if ( isset( $_POST['mass_edit'] ) ) {
			// mass edit selections
			$args_edit = $this->get_video_feed_form();
			// only merge items with filled out values
			foreach ( $args_edit as $key => $value ) {
				if ( is_array( $args_edit[$key] ) && empty( $args_edit[$key] ) ) {
					unset ( $args_edit[$key] );
				}
				else if ( empty( $args_edit[$key] ) && strlen($args_edit[$key]) <= 0 ) { 
					unset ( $args_edit[$key] );
				}
				else if ( ! is_array( $args_edit[$key] ) && $args_edit[$key] === 'inherit' ) { 
					unset ( $args_edit[$key] );
				}
			}
			$this->info_message( sprintf( esc_html__( 'Mass Edit, form args detected: %s', 'video-blogster' ), htmlentities( print_r( $args_edit,true ) ) ), 'notice notice-warning', 'debug' );
			foreach ($_POST['select'] as $s) {
				$results = $this->get_video_feed_details( $s );
				if ( ! $results ) {
					continue;	// should never happen
				}
				$args_db = (array)$results[0];
				$args = array_merge( $args_db, $args_edit );
				$this->video_feed_db_edit( $args );
				if ( isset( $args['pProcessRetro'] ) && $args['pProcessRetro'] ) {
					$this->process_retroactively( $args );
				}
			}
		}
		else if ( isset( $_GET['delID'] ) ) {
			// delete button was pressed
			$this->video_feed_db_delete( $_GET['delID'] );
		}
		include( sprintf( "%s/templates/show-video-feeds.php", $this->get_my_plugin('dir') ) );
		$this->display_msgs = 0;
	}

	private function wpdb_print_error( $pre ) {
		global $wpdb;
		if ( $wpdb->last_error !== '' && is_string( $wpdb->last_result) ) {
			$str = htmlspecialchars( $wpdb->last_result, ENT_QUOTES );
			$query = htmlspecialchars( $wpdb->last_query, ENT_QUOTES );
			$this->info_message( sprintf( '%s - %s<br><code>%s</code>', $pre, $str, $query ) );
		}
	}

	/*
	 * Delete a video feed from the database
	 */
	private function video_feed_db_delete( $delID ) {
	        global $wpdb;
		$wpdb->suppress_errors( false );
		$wpdb->show_errors();
        	$table_name = $wpdb->prefix . $this->get_my_plugin( 'prefix' ) . 'feed';
		$result = $wpdb->delete(
			$table_name,
			array( 'ID' => $delID ),
			array( '%d' )
			);
		if ( FALSE !== $result ) {
			$this->info_message( sprintf( esc_html__( 'Video feed %s deleted successfully.', 'video-blogster' ), $delID ), 'updated', 'critical' );
		}
		else {
			$this->wpdb_print_error( esc_html__( 'Error: Unable to delete content feed in database', 'video-blogster' ) );
		}
		$wpdb->hide_errors();
		$wpdb->suppress_errors( true );
	}

	/*
	 * Save an edited video feed to the database
	 */
	private function video_feed_db_edit( &$args ) {
	        global $wpdb;
		$wpdb->suppress_errors( false );
		$wpdb->show_errors();
		$feedID = $args['id'];
		$table_name = $wpdb->prefix . $this->get_my_plugin( 'prefix' ) . 'feed';
		$data =	array(
				'videoSource'		=>	$args['videoSource'],
				'feedName'		=>	$args['feedName'],
				'feedStatus'		=>	$args['feedStatus'],
				'feedSchedule'		=>	$args['feedSchedule'],
				'qNumVideos'		=>	$args['qNumVideos'],
				'qKeyphrase'		=>	$args['qKeyphrase'],
				'qAssocType'		=>	$args['qAssocType'],
				'qAssoc'		=>	$args['qAssoc'],
				'qPublishedAfter'	=>	$args['qPublishedAfter'],
				'qPublishedBefore'	=>	$args['qPublishedBefore'],
				'qOrderBy'		=>	$args['qOrderBy'],
				'qOrderDirection'	=>	$args['qOrderDirection'],
				'qQueryBehavior'	=>	$args['qQueryBehavior'],
				'qCategory'		=>	$args['qCategory'],
				'qDuration'		=>	$args['qDuration'],
				'qDefinition'		=>	$args['qDefinition'],
				'qImageImport'		=>	$args['qImageImport'],
				'qRegionCode'		=>	$args['qRegionCode'],
				'qLanguage'		=>	$args['qLanguage'],
				'qSafeSearch'		=>	$args['qSafeSearch'],
				'qLicense'		=>	$args['qLicense'],
				'qCaption'		=>	$args['qCaption'],
				'qNumComments'		=>	$args['qNumComments'], 
				'qCommentOrderBy'	=>	$args['qCommentOrderBy'], 
				'qCommentSearchTerms'	=>	$args['qCommentSearchTerms'], 
				'qCommentReplies'	=>	$args['qCommentReplies'], 
				'qCaptions'		=>	$args['qCaptions'], 
				'qCaptionsLanguage'	=>	$args['qCaptionsLanguage'], 
				'qExtraParams'		=>	$args['qExtraParams'], 
				'qExtraParams2'		=>	$args['qExtraParams2'], 
				'qExtraParams3'		=>	$args['qExtraParams3'], 
				'qContentFields'	=>	serialize( $args['qContentFields'] ),
				'qImageId'		=>	$args['qImageId'], 
				'pTranslateApi'		=>	$args['pTranslateApi'],
				'pTranslateTo'		=>	$args['pTranslateTo'],
				'pTranslateContent'	=>	$args['pTranslateContent'],
				'pUpdateExisting'	=>	$args['pUpdateExisting'],
				'pSkipTitle'		=>	$args['pSkipTitle'],
				'pStrictTitle'		=>	$args['pStrictTitle'],
				'pNegateTitle'		=>	$args['pNegateTitle'],
				'pMinViews'		=>	$args['pMinViews'],
				'pCutoffDate'		=>	$args['pCutoffDate'],
				'pDurationMin'		=>	$args['pDurationMin'],
				'pDurationMax'		=>	$args['pDurationMax'],
				'pNoThumbnails'		=>	$args['pNoThumbnails'],
				'pLimitTitleChars'	=>	$args['pLimitTitleChars'],
				'pLimitTitleWord'	=>	$args['pLimitTitleWord'],
				'pRemoveTitleChars'	=>	$args['pRemoveTitleChars'],
				'pReplacePhrases'	=>	$args['pReplacePhrases'],
				'pLimitDescChars'	=>	$args['pLimitDescChars'],
				'pLimitDescWord'	=>	$args['pLimitDescWord'],
				'pSentenceRemove'	=>	$args['pSentenceRemove'],
				'pSentenceRemovePhrase'	=>	$args['pSentenceRemovePhrase'],
				'pRemoveDescUrls'	=>	$args['pRemoveDescUrls'],
				'pRemoveCommUrls'	=>	$args['pRemoveCommUrls'],
				'pLinkifyDescUrls'	=>	$args['pLinkifyDescUrls'],
				'pLinkifyCommUrls'	=>	$args['pLinkifyCommUrls'],
				'pSpinTitle'		=>	$args['pSpinTitle'],
				'pSpinDesc'		=>	$args['pSpinDesc'],
				'pSpinCaptions'		=>	$args['pSpinCaptions'],
				'pSpinner'		=>	$args['pSpinner'],
				'pTitleTemplate'	=>	$args['pTitleTemplate'],
				'pPostTemplate'		=>	$args['pPostTemplate'],
				'pResponsiveVideo'	=>	$args['pResponsiveVideo'],
				'pImageTemplate'	=>	$args['pImageTemplate'],
				'pMetaFields'		=>	serialize( $args['pMetaFields'] ),
				'pCreateExcerpt'	=>	$args['pCreateExcerpt'],
				'pGrabTags'		=>	$args['pGrabTags'],
				'pGrabPornstars'	=>	$args['pGrabPornstars'],
				'pCatFilter'		=>	$args['pCatFilter'],
				'pMinTagLength'		=>	$args['pMinTagLength'],
				'pIgnoreTags'		=>	$args['pIgnoreTags'],
				'cUser'			=>	$args['cUser'],
				'cPostType'		=>	$args['cPostType'],
				'cPostStatus'		=>	$args['cPostStatus'],
				'cPostFormat'		=>	$args['cPostFormat'],
				'cCategories'		=>	$args['cCategories'],
				'cTaxTerms'		=>	serialize( $args['cTaxTerms'] ),
				'cAddSourceCategory'	=>	$args['cAddSourceCategory'],
				'cUsePublishedDate'	=>	$args['cUsePublishedDate'],
				'cClearTaxonomies'	=>	$args['cClearTaxonomies'],
				'cQuickTags'		=>	$args['cQuickTags']
				);
		$this->info_message( sprintf( esc_html__( 'Updating data for feed %s into database table %s - %s', 'video-blogster' ), $feedID, $table_name, htmlentities( print_r( $data, true ) ) ), 'notice notice-warning', 'debug' );
		$result = $wpdb->update(
			$table_name,
			$data,
			array( 'ID' => $feedID ),
			array(
				'%s',	// videoSource
				'%s',	// feedName
				'%s',	// feedStatus
				'%s',	// feedSchedule
				'%s',	// qNumVideos
				'%s',	// qKeyphrase
				'%s',	// qAssocType
				'%s',	// qAssoc
				'%s',	// qPublishedAfter
				'%s',	// qPublishedBefore
				'%s',	// qOrderBy
				'%s',	// qOrderDirection
				'%s',	// qQueryBehavior
				'%s',	// qCategory
				'%s',	// qDuration
				'%s',	// qDefinition
				'%d',	// qImageImport
				'%s',	// qRegionCode
				'%s',	// qLanguage
				'%s',	// qSafeSearch
				'%s',	// qLicense
				'%s',	// qCaption
				'%s',	// qNumComments
				'%s',	// qCommentOrderBy
				'%s',	// qCommentSearchTerms
				'%d',	// qCommentReplies
				'%d',	// qCaptions
				'%s',	// qCaptionsLanguage
				'%s',	// qExtraParams
				'%s',	// qExtraParams2
				'%s',	// qExtraParams3
				'%s',	// qContentFields
				'%d',	// qImageId
				'%s',	// pTranslateApi
				'%s',	// pTranslateTo
				'%s',	// pTranslateContent
				'%d',	// pUpdateExisting
				'%d',	// pSkipTitle
				'%s',	// pStrictTitle
				'%s',	// pNegateTitle
				'%d',	// pMinViews
				'%s',	// pCutoffDate
				'%s',	// pDurationMin
				'%s',	// pDurationMax
				'%d',	// pNoThumbnails
				'%d',	// pLimitTitleChars
				'%s',	// pLimitTitleWord
				'%s',	// pRemoveTitleChars
				'%s',	// pReplacePhrases
				'%d',	// pLimitDescChars
				'%s',	// pLimitDescWord
				'%d',	// pSentenceRemove
				'%s',	// pSentenceRemovePhrase
				'%d',	// pRemoveDescUrls
				'%d',	// pRemoveCommUrls
				'%d',	// pLinkifyDescUrls
				'%d',	// pLinkifyCommUrls
				'%d',	// pSpinTitle
				'%d',	// pSpinDesc
				'%d',	// pSpinCaptions
				'%s',	// pSpinner
				'%s',	// pTitleTemplate
				'%s',	// pPostTemplate
				'%d',	// pResponsiveVideo
				'%s',	// pImageTemplate
				'%s',	// pMetaFields
				'%d',	// pCreateExcerpt
				'%s',	// pGrabTags
				'%s',	// pGrabPornstars
				'%s',	// pCatFilter
				'%d',	// pMinTagLength
				'%s',	// pIgnoreTags
				'%s',	// cUser
				'%s',	// cPostType
				'%s',	// cPostStatus
				'%s',	// cPostFormat
				'%s',	// cCategories
				'%s',	// cTaxTerms
				'%s',	// cAddSourceCategory
				'%d',	// cUsePublishedDate
				'%d',	// cClearTaxonomies
				'%s'	// cQuickTags
				),
			array( '%d' ) 
			);
		if ( false !== $result ) {
			$this->info_message( sprintf( esc_html__( 'Video feed %s edited successfully.', 'video-blogster' ), $feedID ), 'updated', 'critical' );
		}
		else if ( false === $result ) { // result will be 0 if data is the same, so don't report that as an error.
			$this->wpdb_print_error( sprintf( esc_html__( 'Error: Unable to edit content feed in database. WordPress error: %s', 'video-blogster' ), $wpdb->last_error ) );
		}
		$wpdb->hide_errors();
		$wpdb->suppress_errors( true );
	}

	/*
	 * Add a new video feed to the database
	 */
	private function video_feed_db_add( $args ) {
	        global $wpdb;
		$wpdb->suppress_errors( false );
		$wpdb->show_errors();
        	$table_name = $wpdb->prefix . $this->get_my_plugin( 'prefix' ) . 'feed';
		$data =	array(
				'videoSource'		=>	$args['videoSource'],
				'feedName'		=>	$args['feedName'],
				'feedStatus'		=>	$args['feedStatus'],
				'feedSchedule'		=>	$args['feedSchedule'],
				'qNumVideos'		=>	$args['qNumVideos'],
				'qKeyphrase'		=>	$args['qKeyphrase'],
				'qAssocType'		=>	$args['qAssocType'],
				'qAssoc'		=>	$args['qAssoc'],
				'qPublishedAfter'	=>	$args['qPublishedAfter'],
				'qPublishedBefore'	=>	$args['qPublishedBefore'],
				'qOrderBy'		=>	$args['qOrderBy'],
				'qOrderDirection'	=>	$args['qOrderDirection'],
				'qQueryBehavior'	=>	$args['qQueryBehavior'],
				'qCategory'		=>	$args['qCategory'],
				'qDuration'		=>	$args['qDuration'],
				'qDefinition'		=>	$args['qDefinition'],
				'qImageImport'		=>	$args['qImageImport'],
				'qRegionCode'		=>	$args['qRegionCode'],
				'qLanguage'		=>	$args['qLanguage'],
				'qSafeSearch'		=>	$args['qSafeSearch'],
				'qLicense'		=>	$args['qLicense'],
				'qCaption'		=>	$args['qCaption'],
				'qNumComments'		=>	$args['qNumComments'], 
				'qCommentOrderBy'	=>	$args['qCommentOrderBy'], 
				'qCommentSearchTerms'	=>	$args['qCommentSearchTerms'], 
				'qCommentReplies'	=>	$args['qCommentReplies'], 
				'qCaptions'		=>	$args['qCaptions'], 
				'qCaptionsLanguage'	=>	$args['qCaptionsLanguage'], 
				'qExtraParams'		=>	$args['qExtraParams'], 
				'qExtraParams2'		=>	$args['qExtraParams2'], 
				'qExtraParams3'		=>	$args['qExtraParams3'], 
				'qContentFields'	=>	serialize( $args['qContentFields'] ),
				'qImageId'		=>	$args['qImageId'], 
				'pTranslateApi'		=>	$args['pTranslateApi'],
				'pTranslateTo'		=>	$args['pTranslateTo'],
				'pTranslateContent'	=>	$args['pTranslateContent'],
				'pUpdateExisting'	=>	$args['pUpdateExisting'],
				'pSkipTitle'		=>	$args['pSkipTitle'],
				'pStrictTitle'		=>	$args['pStrictTitle'],
				'pNegateTitle'		=>	$args['pNegateTitle'],
				'pMinViews'		=>	$args['pMinViews'],
				'pCutoffDate'		=>	$args['pCutoffDate'],
				'pDurationMin'		=>	$args['pDurationMin'],
				'pDurationMax'		=>	$args['pDurationMax'],
				'pNoThumbnails'		=>	$args['pNoThumbnails'],
				'pLimitTitleChars'	=>	$args['pLimitTitleChars'],
				'pLimitTitleWord'	=>	$args['pLimitTitleWord'],
				'pRemoveTitleChars'	=>	$args['pRemoveTitleChars'],
				'pReplacePhrases'	=>	$args['pReplacePhrases'],
				'pLimitDescChars'	=>	$args['pLimitDescChars'],
				'pLimitDescWord'	=>	$args['pLimitDescWord'],
				'pSentenceRemove'	=>	$args['pSentenceRemove'],
				'pSentenceRemovePhrase'	=>	$args['pSentenceRemovePhrase'],
				'pRemoveDescUrls'	=>	$args['pRemoveDescUrls'],
				'pRemoveCommUrls'	=>	$args['pRemoveCommUrls'],
				'pLinkifyDescUrls'	=>	$args['pLinkifyDescUrls'],
				'pLinkifyCommUrls'	=>	$args['pLinkifyCommUrls'],
				'pSpinTitle'		=>	$args['pSpinTitle'],
				'pSpinDesc'		=>	$args['pSpinDesc'],
				'pSpinCaptions'		=>	$args['pSpinCaptions'],
				'pSpinner'		=>	$args['pSpinner'],
				'pTitleTemplate'	=>	$args['pTitleTemplate'],
				'pPostTemplate'		=>	$args['pPostTemplate'],
				'pResponsiveVideo'	=>	$args['pResponsiveVideo'],
				'pImageTemplate'	=>	$args['pImageTemplate'],
				'pMetaFields'		=>	serialize( $args['pMetaFields'] ),
				'pCreateExcerpt'	=>	$args['pCreateExcerpt'],
				'pGrabTags'		=>	$args['pGrabTags'],
				'pGrabPornstars'	=>	$args['pGrabPornstars'],
				'pCatFilter'		=>	$args['pCatFilter'],
				'pMinTagLength'		=>	$args['pMinTagLength'],
				'pIgnoreTags'		=>	$args['pIgnoreTags'],
				'cUser'			=>	$args['cUser'],
				'cPostType'		=>	$args['cPostType'],
				'cPostStatus'		=>	$args['cPostStatus'],
				'cPostFormat'		=>	$args['cPostFormat'],
				'cCategories'		=>	$args['cCategories'],
				'cTaxTerms'		=>	serialize( $args['cTaxTerms'] ),
				'cAddSourceCategory'	=>	$args['cAddSourceCategory'],
				'cUsePublishedDate'	=>	$args['cUsePublishedDate'],
				'cClearTaxonomies'	=>	$args['cClearTaxonomies'],
				'cQuickTags'		=>	$args['cQuickTags']
				);
		$this->info_message( sprintf( esc_html__( 'Inserting data into database table %s - %s', 'video-blogster' ), $table_name, htmlentities( print_r( $data, true ) ) ), 'notice notice-warning', 'debug' );
		$result = $wpdb->insert(
			$table_name,
			$data,
			array(
				'%s',	// videoSource
				'%s',	// feedName
				'%s',	// feedStatus
				'%s',	// feedSchedule
				'%s',	// qNumVideos
				'%s',	// qKeyphrase
				'%s',	// qAssocType
				'%s',	// qAssoc
				'%s',	// qPublishedAfter
				'%s',	// qPublishedBefore
				'%s',	// qOrderBy
				'%s',	// qOrderDirection
				'%s',	// qQueryBehavior
				'%s',	// qCategory
				'%s',	// qDuration
				'%s',	// qDefinition
				'%d',	// qImageImport
				'%s',	// qRegionCode
				'%s',	// qLanguage
				'%s',	// qSafeSearch
				'%s',	// qLicense
				'%s',	// qCaption
				'%s',	// qNumComments
				'%s',	// qCommentOrderBy
				'%s',	// qCommentSearchTerms
				'%d',	// qCommentReplies
				'%d',	// qCaptions
				'%s',	// qCaptionsLanguage
				'%s',	// qExtraParams
				'%s',	// qExtraParams2
				'%s',	// qExtraParams3
				'%s',	// qContentFields
				'%d',	// qImageId
				'%s',	// pTranslateApi
				'%s',	// pTranslateTo
				'%s',	// pTranslateContent
				'%d',	// pUpdateExisting
				'%d',	// pSkipTitle
				'%s',	// pStrictTitle
				'%s',	// pNegateTitle
				'%d',	// pMinViews
				'%s',	// pCutoffDate
				'%s',	// pDurationMin
				'%s',	// pDurationMax
				'%d',	// pNoThumbnails
				'%d',	// pLimitTitleChars
				'%s',	// pLimitTitleWord
				'%s',	// pRemoveTitleChars
				'%s',	// pReplacePhrases
				'%d',	// pLimitDescChars
				'%s',	// pLimitDescWord
				'%d',	// pSentenceRemove
				'%s',	// pSentenceRemovePhrase
				'%d',	// pRemoveDescUrls
				'%d',	// pRemoveCommUrls
				'%d',	// pLinkifyDescUrls
				'%d',	// pLinkifyCommUrls
				'%d',	// pSpinTitle
				'%d',	// pSpinDesc
				'%d',	// pSpinCaptions
				'%s',	// pSpinner
				'%s',	// pTitleTemplate
				'%s',	// pPostTemplate
				'%d',	// pResponsiveVideo
				'%s',	// pImageTemplate
				'%s',	// pMetaFields
				'%d',	// pCreateExcerpt
				'%s',	// pGrabTags
				'%s',	// pGrabPornstars
				'%s',	// pCatFilter 
				'%d',	// pMinTagLength
				'%s',	// pIgnoreTags
				'%s',	// cUser
				'%s',	// cPostType
				'%s',	// cPostStatus
				'%s',	// cPostFormat
				'%s',	// cCategories
				'%s',	// cTaxTerms
				'%s',	// cAddSourceCategory
				'%d',	// cUsePublishedDate
				'%d',	// cClearTaxonomies
				'%s'	// cQuickTags
				)
			);
		if ( FALSE !== $result ) {
                       	$this->info_message( esc_html__( 'Video feed added successfully.', 'video-blogster' ), 'updated', 'critical' );
		}
		else {
			$this->wpdb_print_error( esc_html__( 'Error: Unable to insert content feed in database', 'video-blogster' ) );
		}
		$wpdb->hide_errors();
		$wpdb->suppress_errors( true );
	}

	public function vb_extend_http_request_timeout( $current ) {
		// how long should we wait for remote requests?
		$name = $this->get_my_plugin( 'prefix' ) . 'timeout';
		$timeout = get_option( $name );
		$num = $timeout ? $timeout : $current;
		return $num;
	}

	/*
	 * Check private server for VB updates
	 */
	public function check_for_update() {
		if ( get_option( $this->get_my_plugin( 'prefix' ) . $this->vbp_decode( 'c3RhdHVz' ), null ) !== FALSE ) {
			// use a custom update checker for new releases
			$url = "https://www.superblogme.com/wp-update-server/?action=get_metadata&slug=";
			$license = get_option( $this->get_my_plugin( 'prefix' ) . 'license' );
			$beta = get_option( $this->get_my_plugin( 'prefix' ) . 'beta', false );
			if ( $beta || stripos( $license, "-beta" ) !== FALSE ) {
				// look for beta versions instead
				$url = "https://www.superblogme.com/test-update-server/?action=get_metadata&slug=";
			}
			if ( $this->vb_include_once( $this->get_my_plugin( 'dir' ) . 'plugin-updates/plugin-update-checker.php' ) ) {
				$this->VBPUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
					$url . $this->get_my_plugin( 'slug' ) ,
					$this->get_my_plugin( 'file' ),
					$this->get_my_plugin( 'slug' ) 	
				);
				$this->VBPUpdateChecker->addQueryArgFilter( array( $this, 'PUC_callback' ) );
			}
		}
	}

	/*
	 * When plugins are loaded:
	 * Create Log and Scheduler objects
	 * Initialize the Plugin Update Checker
	 * Check to see if database structure needs to be updated
	 * Load the i18n file for translations
	 */
	public function plugin_init() { 

		// verify scheduled events are running, in case cron has problems
		$this->video_blogster_verify_schedule();

		// check for plugin update which requires separate check for any db install/changes
		if ( get_option( $this->get_my_plugin( 'prefix' ) . 'db_version' ) != $this->get_my_plugin( 'db_version' ) ) { // database has changed
			$this->db_install();
		}

		// load i18n file
		$plugin_dir = basename( $this->get_my_plugin( 'dir' ) ) . '/languages';
		load_plugin_textdomain( 'video-blogster', false, $plugin_dir );
	}

	/*
	 * Will show a video preview metabox on the post page if custom field VideoEmbed has an iframe,embed or object
	 */
	public function vbp_preview_metabox( $post_type, $post )  {

		$videoEmbed = get_post_meta( $post->ID, 'VideoEmbed', true );
		if ( false === stripos( $videoEmbed, 'iframe' ) 
			&& false === stripos( $videoEmbed, 'embed' )
			&& false === stripos( $videoEmbed, 'object' )
			) return;

		$name = 'Video Blogster Preview';

		add_meta_box( 
			'vbp_video_preview',
			__( $name, 'video-blogster' ),
			array( $this, 'vbp_video_preview' ),
			$post_type,
			#'post',
			'side',
			'high',
			array( $videoEmbed )
    		);
	}

	/*
	 * Will show the VideoEmbed preview in the metabox
	 */
	public function vbp_video_preview( $post, $obj )  {
		$videoEmbed = isset( $obj['args'][0] ) ? $obj['args'][0] : null;
		echo "<div class='video-blogster-responsive-video'>" . htmlspecialchars_decode( $videoEmbed ) . "</div>";
	}


	/*
	 * Will create custom tables or alter the existing tables if needed
	 */
	protected function db_install()  {

		$this->save_apiKeys(); // ensure api keys are set when plugin updated from pre v2.4.0 - activation hook not called :(

	        global $wpdb;

        	if ( ! $this->vb_include_once( ABSPATH . 'wp-admin/includes/upgrade.php' ) ) {
			return 0;
		}

		$wpdb->suppress_errors( false );
		$wpdb->show_errors();

        	$charset_collate = '';	// Set default charset and collation 

        	if ( ! empty( $wpdb->charset ) ) {
                	$charset_collate = "DEFAULT CHARACTER SET {$wpdb->charset}";
		}
        	if ( ! empty( $wpdb->collate ) )  {
                	$charset_collate .= " COLLATE {$wpdb->collate}";
		}

        	$table_name = $wpdb->prefix . $this->get_my_plugin( 'prefix' ) . 'feed';

		/// use camelCode for sql variables
        	$sql = "CREATE TABLE $table_name (
	        id smallint unsigned NOT NULL AUTO_INCREMENT,
       		time timestamp DEFAULT CURRENT_TIMESTAMP NOT NULL,
		videoSource VARCHAR(32) NOT NULL,
		feedName VARCHAR(128),
		feedStatus VARCHAR(16) DEFAULT 'Active',
		feedSchedule VARCHAR(16),
		qNumVideos VARCHAR(16),
		qKeyphrase VARCHAR(1024),
		qAssocType VARCHAR(256),
		qAssoc text,
		qPublishedAfter VARCHAR(32),
		qPublishedBefore VARCHAR(32),
		qOrderBy VARCHAR(32),
		qOrderDirection VARCHAR(8),
		qQueryBehavior VARCHAR(16),
		qCategory VARCHAR(256) NOT NULL,
		qDuration VARCHAR(16) NOT NULL,
		qDefinition VARCHAR(16) NOT NULL,
		qImageImport tinyint DEFAULT TRUE,
		qRegionCode VARCHAR(8),
		qLanguage VARCHAR(8),
		qSafeSearch VARCHAR(16),
		qLicense VARCHAR(16),
		qCaption VARCHAR(16),
		qNumComments VARCHAR(16),
		qCommentOrderBy VARCHAR(16),
		qCommentSearchTerms VARCHAR(256),
		qCommentReplies tinyint DEFAULT FALSE,
		qCaptions tinyint DEFAULT FALSE,
		qCaptionsLanguage VARCHAR(8),
		qExtraParams VARCHAR(256),
		qExtraParams2 VARCHAR(256),
		qExtraParams3 VARCHAR(256),
		qContentFields VARCHAR(256),
		qImageId mediumint,
		pTranslateApi VARCHAR(16),
		pTranslateTo VARCHAR(8),
		pTranslateContent VARCHAR(16),
		pUpdateExisting tinyint,
		pSkipTitle tinyint,
		pStrictTitle VARCHAR(256),
		pNegateTitle VARCHAR(256),
		pMinViews mediumint unsigned,
		pCutoffDate VARCHAR(32),
		pDurationMin VARCHAR(4),
		pDurationMax VARCHAR(4),
		pNoThumbnails tinyint,
		pLimitTitleChars smallint unsigned,
		pLimitTitleWord VARCHAR(32),
		pRemoveTitleChars VARCHAR(256),
		pReplacePhrases text,
		pLimitDescChars smallint unsigned,
		pLimitDescWord VARCHAR(128),
		pSentenceRemove tinyint,
		pSentenceRemovePhrase VARCHAR(256),
		pRemoveDescUrls tinyint,
		pRemoveCommUrls tinyint,
		pLinkifyDescUrls tinyint,
		pLinkifyCommUrls tinyint,
		pSpinTitle tinyint,
		pSpinDesc tinyint,
		pSpinCaptions tinyint,
		pSpinner VARCHAR(32) NOT NULL,
		pTitleTemplate VARCHAR(256),
		pPostTemplate text NOT NULL,
		pResponsiveVideo tinyint DEFAULT TRUE,
		pImageTemplate VARCHAR(256),
		pMetaFields text,
		pCreateExcerpt tinyint,
		pGrabTags VARCHAR(64),
		pGrabPornstars VARCHAR(64),
		pCatFilter text,
		pMinTagLength tinyint,
		pIgnoreTags VARCHAR(256),
		cUser VARCHAR(64) NOT NULL,
		cPostType VARCHAR(32) NOT NULL,
		cPostStatus VARCHAR(16) NOT NULL,
		cPostFormat VARCHAR(16) NOT NULL,
		cCategories VARCHAR(256) NOT NULL,
		cTaxTerms text,
		cAddSourceCategory VARCHAR(64),
		cUsePublishedDate tinyint,
		cClearTaxonomies tinyint,
		cQuickTags VARCHAR(256),
        	UNIQUE KEY id (id)
        	) $charset_collate;";

        	dbDelta( $sql );

		// now log mesages:
        	$table_name = $wpdb->prefix . $this->get_my_plugin( 'prefix' ) . 'log';
		$sql = "CREATE TABLE $table_name (
			id int(11) unsigned NOT NULL AUTO_INCREMENT,
			date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
			msg longtext NOT NULL,
			level tinyint(2) unsigned NOT NULL,
			UNIQUE KEY id (id)
		) $charset_collate;";

        	dbDelta( $sql );

        	update_option( $this->get_my_plugin( 'prefix' ) . 'db_version', $this->get_my_plugin( 'db_version' ) );
		if ( $this->logger ) {
			$this->logger->write_to_log( sprintf( esc_html__( '%s table verified - db version %s', 'video-blogster' ), $table_name, $this->get_my_plugin( 'db_version' ) ), 'updated', 'critical' );
		}
		$wpdb->hide_errors();
		$wpdb->suppress_errors( true );
	}

	/*
	 * Replace template tags with the video info
	 */
  
  	// modified by ryan yang
	private function expand_template( $template, $args, $videoInfo, $spintax = true, $rules = null ) {
		$template = str_ireplace( array( "%VideoAssociation%", "%TrackAssociation%" ), $videoInfo['association'], $template);

		$value = isset( $videoInfo['artists'] ) ? $videoInfo['artists'] : '';
		$template = str_ireplace( array( "%TrackArtists%" ), $value, $template);

		$value = isset( $videoInfo['channelID'] ) ? $videoInfo['channelID'] : ''; // YouTube only
		$template = str_ireplace( "%VideoChannelId%", $videoInfo['channelID'], $template);

		$template = str_ireplace( array( "%VideoDescription%", "%TrackDescription%" ), $videoInfo['desc'], $template);
		// support for durations in ISO 8601 format
		if ( ( strpos( $template, '%VideoDuration8601%' ) !== false 
			|| strpos( $template, '%TrackDuration8601%' ) !== false )
			&& preg_match( "#^([0-9]+):([0-9]+)(:[0-9]+)?$#", $videoInfo['duration'], $matches )
		) {
			// DateTime is rather picky... ensure video durations are in right format
			$cnt = count( $matches );
			if ( $cnt == 3 ) {	// turn mm:ss into hh:mm:ss if needed
				$videoInfo['duration'] = sprintf( "00:%02d:%02d", $matches[1], $matches[2] );
			}
			else {
				$videoInfo['duration'] = sprintf( "%02d:%02d:%02d", $matches[1], $matches[2], $matches[3] );
			}
			try {
				$vduration = new DateTime( $videoInfo['duration'] );
			} catch ( Exception $e ) {
    				$this->info_message( __FUNCTION__ . " DateTime from Duration8601 - " . $e->getMessage() );
			}
			if ( $vduration ) {
				$duration8601 = "P" . $vduration->format('\TH\Hi\Ms\S');
				$template = str_ireplace( array( "%VideoDuration8601%", "%TrackDuration8601%" ), $duration8601, $template);
				unset( $duration8601 );
			}
			unset( $cnt );
			unset( $matches );
			unset( $vduration );
		}
		$template = str_ireplace( array( "%VideoDuration%", "%TrackDuration%" ), $videoInfo['duration'], $template );
		$template = str_ireplace( array( "%VideoSource%", "%TrackSource%" ), $videoInfo['videoSource'], $template );
		$template = str_ireplace( array( "%VideoTitle%", "%TrackTitle%" ), $videoInfo['title'], $template );
		$template = str_ireplace( array( "%VideoID%", "%TrackID%" ), $videoInfo['videoID'], $template );
		$template = str_ireplace( array( "%VideoUrl%", "%TrackUrl%" ), $videoInfo['url'], $template );
		$template = str_ireplace( array( "%VideoImage%", "%TrackImage%" ), $videoInfo['img'], $template );
		if ( $args && $args[ 'pResponsiveVideo' ] == true ) {
			// enclose embed in responsive CSS in case theme doesn't have it.
			$theEmbed = sprintf( "<div class='%s'>%s</div>",
				"vbp-16-9",
				addslashes($videoInfo['videoEmbed'])
			);
		}
		else {
			$theEmbed = addslashes($videoInfo['videoEmbed']);
		}
			
		$template = str_ireplace( array( "%VideoEmbed%", "%TrackEmbed%" ), $theEmbed, $template );

		$template = str_ireplace( array( "%VideoTags%", "%TrackTags%" ), addslashes($videoInfo['tags']), $template );
		$template = str_ireplace( array( "%VideoCats%", "%TrackCats%" ), addslashes($videoInfo['sourceCategoryName']), $template );

		$template = str_ireplace( array( "%VideoViews%", "%TrackViews%" ), $videoInfo['viewCount'], $template );
		$template = str_ireplace( array( "%VideoLikes%", "%TrackLikes%" ), $videoInfo['likeCount'], $template );
		$template = str_ireplace( array( "%VideoDislikes%", "%TrackDislikes%" ), $videoInfo['dislikeCount'], $template );
		$template = str_ireplace( array( "%VideoFavorites%", "%TrackFavorites%" ), $videoInfo['favoriteCount'], $template );
		$template = str_ireplace( array( "%VideoPublish%", "%TrackPublish%" ), $videoInfo['publishedAt'], $template );
		$template = str_ireplace( array( "%VideoRating%", "%TrackRating%" ), $videoInfo['rating'], $template );
		if ( isset( $videoInfo['scheduledAt'] ) )
			$template = str_ireplace( array( "%VideoScheduledAt%", "%TrackScheduledAt%" ), $videoInfo['scheduledAt'], $template );
		if ( isset( $videoInfo['concurrentViewers'] ) )
			$template = str_ireplace( array( "%VideoConcurrentViewers%", "%TrackRating%" ), $videoInfo['concurrentViewers'], $template );

		$value = isset( $videoInfo['rssEnclosure'] ) ? $videoInfo['rssEnclosure'] : '';
		$template = str_ireplace( array( "%RssEnclosure%" ), $value, $template );
		
		$value = isset( $videoInfo['pornstars'] ) ? $videoInfo['pornstars'] : ''; 
		$template = str_ireplace( "%VideoPornstars%", $value, $template );

		// support for publishedAt in ISO 8601 format
		if ( ( strpos( $template, '%VideoPublish8601%' ) !== false 
			|| strpos( $template, '%TrackPublish8601%' ) !== false )
			&& ! empty( $videoInfo['publishedAt'] ) 
		) {
			$timezone = $this->getTimeZone();
			try {
				$date = new DateTime( $videoInfo['publishedAt'] );
				$date->setTimezone( $timezone );
			} catch ( Exception $e ) {
    				$this->info_message( __FUNCTION__ . " Datetime from Publish8601 - " . $e->getMessage() );
			}
			$videoInfo['publishedAt8601'] = isset( $date ) ? $date->format( 'c' ) : '';
			$template = str_ireplace( array( "%VideoPublish8601%", "%TrackPublish8601%" ), $videoInfo['publishedAt8601'], $template);
			unset( $date );
		}

		$value = isset( $videoInfo['file'] ) ? $videoInfo['file'] : ''; 
		$template = str_ireplace( array( "%VideoFile%", "%TrackFile%" ), $value, $template );
		
		if ( isset( $videoInfo['images'] ) ) { // not supported on all video sites
			$commas = implode( ',', $videoInfo['images'] );
			$template = str_ireplace( array( "%VideoImagesCommas%", "%TrackImagesCommas%" ), $commas, $template );
		}

		$this->info_message( sprintf( esc_html__( 'Template expanded to:  %s', 'video-blogster' ), htmlentities( $template ) ), 'notice notice-warning', 'debug' );

		$template = $this->replace_phrases( $rules, $template );

    		// modified by ryan yang
    		if ( true === $spintax ) {
      			$new_template = $this->spintax( $template );
			if ( $new_template != $template ) {
				$template = $new_template;
				$this->info_message( sprintf( esc_html__( 'Template with replaced spintax:  %s', 'video-blogster' ), htmlentities( $template ) ), 'notice notice-warning', 'debug' );
			}
    		}

		
		return $template;
	}


	public function extend_execution_time() {

		$skip = apply_filters( 'vbp_extend_execution_time', false );
		if ( true == $skip ) return;

		// first, check our script execution time
		$this->info_message( sprintf( esc_html__( 'Setting script time limit to [No Limit].', 'video-blogster' ) ), 'notice notice-warning', 'debug' );
		if ( ! set_time_limit( 0 ) ) { // set no time limit
			$this->info_message( sprintf( esc_html__( 'VBP %s warning: Set script time limit FAILED due to server configuration. Script may time out.', 'video-blogster' ), __FUNCTION__ ), 'notice notice-warning', 'video_skip' );
		}
	}

	/*
	 * Check skip rules when importing a new video
	 */
	public function passed_skip_rules( $args, $videoInfo ) {

		if ( $videoInfo['postID'] ) {
			return 1;		// this is an update so do not apply skip rules
		}

		if ( $args['pStrictTitle'] ) {
			$stricts = explode( ",", $args['pStrictTitle'] );
			$which = apply_filters( 'vbp_skip_search_locations', array( 'title','desc','association', 'channelID', 'tags' ), $postID, $videoInfo );
			if ( ! is_array( $which ) ) {
				$this->info_message( sprintf( esc_html__( 'Filter \'vbp_skip_search_locations\' used to return a non-array for StrictSearch. Ignoring.', 'video-blogster' ) ) );
				$which = array( 'title','desc','association', 'channelID', 'tags' );
			}
			$found = false;
			foreach ( $stricts as $keyphrase ) {
				$qkeyphrase = preg_quote( trim( $keyphrase ), '#' );
				$match = preg_match( '#\b' . $qkeyphrase . '\b#ui', $videoInfo['title'] );
				if ( $match && in_array( 'title', $which ) ) {
					$this->info_message( sprintf( esc_html__( 'Found strict keyphrase [%s] in title [%s].', 'video-blogster' ), $keyphrase, $videoInfo['title'] ), 'notice notice-warning', 'video_skip' );
					$found = true;
					break;
				}
				$match = preg_match( '#\b' . $keyphrase . '\b#ui', $videoInfo['desc'] );
				if ( $match && in_array( 'desc', $which ) ) {
					$this->info_message( sprintf( esc_html__( 'Found strict keyphrase [%s] in desc [%s].', 'video-blogster' ), $keyphrase, $videoInfo['desc'] ), 'notice notice-warning', 'video_skip' );
					$found = true;
					break;
				}
				$match = preg_match( '#\b' . $keyphrase . '\b#ui', $videoInfo['association'] );
				if ( $match && in_array( 'association', $which ) ) {
					$this->info_message( sprintf( esc_html__( 'Found strict keyphrase [%s] in association [%s].', 'video-blogster' ), $keyphrase, $videoInfo['association'] ), 'notice notice-warning', 'video_skip' );
					$found = true;
					break;
				}
				if ( ! empty( $videoInfo['channelID'] ) ) {
					$match = preg_match( '#\b' . $keyphrase . '\b#ui', $videoInfo['channelID'] );
					if ( $match && in_array( 'channelID', $which ) ) {
						$this->info_message( sprintf( esc_html__( 'Found strict keyphrase [%s] in channelID [%s].', 'video-blogster' ), $keyphrase, $videoInfo['channelID'] ), 'notice notice-warning', 'video_skip' );
						$found = true;
						break;
					}
				}
				if ( ! empty( $videoInfo['tags'] ) ) {
					$match = preg_match( '#\b' . $keyphrase . '\b#ui', $videoInfo['tags'] );
					if ( $match && in_array( 'tags', $which ) ) {
						$this->info_message( sprintf( esc_html__( 'Found strict keyphrase [%s] in tags [%s].', 'video-blogster' ), $keyphrase, $videoInfo['tags'] ), 'notice notice-warning', 'video_skip' );
						$found = true;
						break;
					}
				}
			}
			unset( $stricts );
			if ( ! $found ) {
				return $this->info_message( sprintf( esc_html__( 'None of the keyphrases [%s] was found in the locations [%s] for [%s]. Skipping.', 'video-blogster' ), $args['pStrictTitle'], implode( ',', $which ), $videoInfo['title'] ), 'notice notice-warning', 'video_skip' );
			}
		}

		if ( $args['pNegateTitle'] ) {
			$stricts = explode( ",", $args['pNegateTitle'] );
			$which = apply_filters( 'vbp_skip_search_locations', array( 'title','desc','association', 'channelID', 'tags' ), $postID, $videoInfo );
			if ( ! is_array( $which ) ) {
				$this->info_message( sprintf( esc_html__( 'Filter \'vbp_skip_search_locations\' used to return a non-array for NegateSearch. Ignoring.', 'video-blogster' ) ) );
				$which = array( 'title','desc','association', 'channelID', 'tags' );
			}
			foreach ( $stricts as $keyphrase ) {
				$qkeyphrase = preg_quote( trim( $keyphrase ), '#' );
				$found = preg_match( '#\b' . $qkeyphrase . '\b#ui', $videoInfo['title'] );
				if ( $found && in_array( 'title', $which ) ) {
					return $this->info_message( sprintf( esc_html__( 'Keyphrase [%s] was found in the title [%s]. Skipping.', 'video-blogster' ), $keyphrase, $videoInfo['title'] ), 'notice notice-warning', 'video_skip' );
				}
				$found = preg_match( '#\b' . $keyphrase . '\b#ui', $videoInfo['desc'] );
				if ( $found && in_array( 'desc', $which ) ) {
					return $this->info_message( sprintf( esc_html__( 'Keyphrase [%s] was found in the description [%s]. Skipping.', 'video-blogster' ), $keyphrase, $videoInfo['desc'] ), 'notice notice-warning', 'video_skip' );
				}
				$found = preg_match( '#\b' . $keyphrase . '\b#ui', $videoInfo['association'] );
				if ( $found && in_array( 'association', $which ) ) {
					return $this->info_message( sprintf( esc_html__( 'Keyphrase [%s] was found in the association [%s]. Skipping.', 'video-blogster' ), $keyphrase, $videoInfo['association'] ), 'notice notice-warning', 'video_skip' );
				}
				if ( ! empty( $videoInfo['channelID'] ) ) {
					$found = preg_match( '#\b' . $keyphrase . '\b#ui', $videoInfo['channelID'] );
					if ( $found && in_array( 'channelID', $which ) ) {
						return $this->info_message( sprintf( esc_html__( 'Keyphrase [%s] was found in the channelID [%s]. Skipping.', 'video-blogster' ), $keyphrase, $videoInfo['channelID'] ), 'notice notice-warning', 'video_skip' );
					}
				}
				if ( ! empty( $videoInfo['tags'] ) ) {
					$found = preg_match( '#\b' . $keyphrase . '\b#ui', $videoInfo['tags'] );
					if ( $found && in_array( 'tags', $which ) ) {
						return $this->info_message( sprintf( esc_html__( 'Keyphrase [%s] was found in the tags [%s]. Skipping.', 'video-blogster' ), $keyphrase, $videoInfo['tags'] ), 'notice notice-warning', 'video_skip' );
					}
				}
			}
		}

		if ( $args['pMinViews'] && (int) $videoInfo['viewCount'] < $args['pMinViews'] ) {
			return $this->info_message( sprintf( esc_html__( '%s video [%s] has %d views, less than the required %d minimum views. Skipping.', 'video-blogster' ), $videoInfo['videoSource'], $videoInfo['title'], $videoInfo['viewCount'], $args['pMinViews'] ), 'notice notice-warning', 'video_skip' );
		}

		if ( $args['pCutoffDate'] ) {
			$timezone = $this->getTimeZone();
			$viddate = new DateTime( $videoInfo['publishedAt'] );
			$viddate->setTimezone( $timezone );
			try {
				$cutoff = new DateTime( $args['pCutoffDate'] );
				$cutoff->setTimezone( $timezone );
			} catch ( Exception $e ) {
    				$this->info_message( __FUNCTION__ . " DateTime from pCutoffDate - " . $e->getMessage() );
			}
			if ( ! empty( $cutoff ) && $cutoff > $viddate ) {
				return $this->info_message( sprintf( esc_html__( '%s video [%s] date %s older than %s (%s). Skipping.', 'video-blogster' ), $videoInfo['videoSource'], $videoInfo['title'], $viddate->format( 'Y-m-d H:i:s' ), $args['pCutoffDate'], $cutoff->format( 'Y-m-d H:i:s' ) ), 'notice notice-warning', 'video_skip' );
			}
			unset( $cutoff );
			unset( $viddate );
		}

		if ( ! empty( $videoInfo['duration'] ) && ( ! empty( $args['pDurationMin'] ) || ! empty( $args['pDurationMax'] ) ) ) {
			$vMin = (int)$args['pDurationMin'];
			$vMax = (int)$args['pDurationMax'];
			sscanf($videoInfo['duration'], "%d:%d:%d", $hours, $minutes, $seconds);
			$dSecs = isset($seconds) ? $hours * 3600 + $minutes * 60 + $seconds : $hours * 60 + $minutes;
			$vidLT = $vMin * 60;
			$vidGT = $vMax * 60;

			$this->info_message( sprintf( esc_html__( '%s - comparing video duration of %s to match min/max - %s/%s', 'video-blogster' ), __FUNCTION__, $videoInfo['duration'], $vidLT, $vidGT ), 'notice notice-warning', 'debug' );

			if ( $vidLT && $dSecs < $vidLT ) {
				return $this->info_message( sprintf( esc_html__( '%s video [%s] duration %s less than %s minutes. Skipping.', 'video-blogster' ), $videoInfo['videoSource'], $videoInfo['title'], $videoInfo['duration'], $vMin ), 'notice notice-warning', 'video_skip' );
			}
			else if ( $vidGT && $dSecs > $vidGT ) {
				return $this->info_message( sprintf( esc_html__( '%s video [%s] duration %s greater than %s minutes. Skipping.', 'video-blogster' ), $videoInfo['videoSource'], $videoInfo['title'], $videoInfo['duration'], $vMax ), 'notice notice-warning', 'video_skip' );
			}
		}

		if ( $args['pNoThumbnails'] == true && empty( $videoInfo['img'] ) ) {
			return $this->info_message( sprintf( esc_html__( '%s video [%s] did not have any valid thumbnails. Skipping.', 'video-blogster' ), $videoInfo['videoSource'], $videoInfo['title'] ), 'notice notice-warning', 'video_skip' );
		}

		return 1;
	}

	public function check_post_duplicate( $args, &$videoInfo ) {
		if ( $this->video_on_blacklist( $videoInfo['videoID'] ) ) {
			return ! $this->info_message( sprintf( esc_html__( '%s video ID [%s] is on the blacklist. Skipping.', 'video-blogster' ), $videoInfo['videoSource'], $videoInfo['videoID'] ), 'notice notice-warning', 'video_skip' );
		}
		if ( $postID = $this->post_already_exists( $videoInfo['videoSource'], $videoInfo['videoID'], $status ) ) {
			$skip = true;
			if ( $status == 'trash' ) {
				return ! $this->info_message( sprintf( esc_html__( '%s video [%s] already imported, but in trash. Skipping.', 'video-blogster' ), $videoInfo['videoSource'], $videoInfo['title'] ), 'notice notice-warning', 'video_skip' );
			}
			if ( true == $args['pUpdateExisting'] && $status != 'trash' ) {
				$this->info_message( sprintf( esc_html__( 'Updating existing %s %s post %s [%s] previously imported.', 'video-blogster' ), $videoInfo['videoSource'], $status, $postID, $videoInfo['title'] ), 'updated', 'video_import' );
				$skip = false;
			}

			$skip = apply_filters( 'vbp_post_already_exists_result', $skip, $postID, $videoInfo );

			if ( true === $skip ) {
				return ! $this->info_message( sprintf( esc_html__( '%s video [%s] already imported. Skipping.', 'video-blogster' ), $videoInfo['videoSource'], $videoInfo['title'] ), 'notice notice-warning', 'video_skip' );
			}

			$videoInfo['postID'] = $postID;	// if we're not skipping, then update this post
			$videoInfo['post_title'] = get_the_title( $postID );	
			$videoInfo['action'] = 'updated';
		}
		return 0;
	}


	/*
	 * Filter video categories, VP only
	 */
	private function category_filter( $args, &$videoInfo ) {
		$this->info_message( sprintf( esc_html__( '%s - video cats are - %s', 'video-blogster' ), __FUNCTION__, $videoInfo['sourceCategoryName'] ), 'notice notice-warning', 'debug' );

		// first, replace all commas with newlines
		$filter = str_replace( ",", "\n", $args['pCatFilter'] );

		// now explode on newline
		$entries = explode( "\n", $filter );

		$video_cats = explode( ",", $videoInfo['sourceCategoryName'] );
		$strict_cats = array();
		$use_strict = false;

		foreach ( $entries as $entry ) {
			$entry = trim( $entry );

			$wildcard = ( "*" === mb_substr($entry, -1, 1, 'utf-8') ) ? true : false;
			$entry = rtrim( $entry, "*" );

			if ( "-" === mb_substr($entry, 0, 1, 'utf-8') ) {
				$entry = ltrim( $entry, "-" );
				if ( true === $wildcard ) {
					foreach ( $video_cats as $key => $video ) {
						if ( preg_match( "#{$entry}#ui", $video ) ) {
							unset( $video_cats[$key] );
							$this->info_message( sprintf( esc_html__( '%s - video cat* %s removed.', 'video-blogster' ), __FUNCTION__, $video ), 'notice notice-warning', 'debug' );
						}
					}
				}
				else if ( false !== ( $key = array_search( strtolower($entry), array_map('strtolower', $video_cats ) ) ) ) {
					unset( $video_cats[$key] );
					$this->info_message( sprintf( esc_html__( '%s - video cat %s removed.', 'video-blogster' ), __FUNCTION__, $entry ), 'notice notice-warning', 'debug' );
				}
			}
			else if ( false === strpos( $entry, '=>' ) ) { // strict check only
				$use_strict = true;
				if ( true === $wildcard ) {
					foreach ( $video_cats as $key => $video ) {
						if ( preg_match( "#{$entry}#ui", $video ) ) {
							$strict_cats[] = $video_cats[$key];
							$this->info_message( sprintf( esc_html__( '%s - video cat* %s included.', 'video-blogster' ), __FUNCTION__, $video_cats[$key] ), 'notice notice-warning', 'debug' );
						}
					}
				}
				else if ( in_array( $entry, $video_cats ) ) {
					$strict_cats[] = $entry;
					$this->info_message( sprintf( esc_html__( '%s - video cat %s included.', 'video-blogster' ), __FUNCTION__, $entry ), 'notice notice-warning', 'debug' );
				}
			}
		}

		if ( true === $use_strict )
			$video_cats = $strict_cats;

		// process any renames last! i.e. Teen => Teens
		foreach ( $entries as $entry ) {
			if ( false !== strpos( $entry, '=>' ) ) {
				$rename = explode( '=>', $entry );
				$from = trim( $rename[0] );
				$to = trim( $rename[1] );
				if ( false !== ( $key = array_search( strtolower($from), array_map('strtolower', $video_cats ) ) ) ) {
					$video_cats[$key] = $to;
					$this->info_message( sprintf( esc_html__( '%s - video cat %s renamed to %s.', 'video-blogster' ), __FUNCTION__, $from, $to ), 'notice notice-warning', 'debug' );
				}
			}
		}

		$videoInfo['sourceCategoryName'] = implode( ",", $video_cats );

		$this->info_message( sprintf( esc_html__( '%s - video cats are now - %s', 'video-blogster' ), __FUNCTION__, $videoInfo['sourceCategoryName'] ), 'notice notice-warning', 'debug' );
	}


	/*
	 * Process any replace phrases
	 */
	private function replace_phrases( $the_rules, $content ) {
		if ( empty( $the_rules ) ) {
			return $content;
		}
		$orig_content = $content;
		$rules = explode( PHP_EOL, $the_rules );
		foreach ( $rules as $rule ) {
			if ( empty( $rule ) ) {
				continue;
			}
			$marker = '=>';	// new marker check
			if ( strpos( $rule, $marker ) === FALSE ) {
				$marker = '::';		// old marker check
			}
			$pos = strpos( $rule, $marker );
			if ( $pos === FALSE ) {
				$this->info_message( sprintf( esc_html__( "Error with replace phrase rule: [%s] missing the '%s' marker. Rule Skipped.", 'video-blogster' ), $rule, '=>' ) );
				continue;
			}

			$this->info_message( sprintf( esc_html__( 'Position %d found for rule:  %s', 'video-blogster' ), $pos, htmlentities( $rule ) ), 'notice notice-warning', 'debug' );

			// let's be very very careful...
			$spinrule = explode( $marker, $rule );

			if ( empty( $spinrule ) ) {
				$this->info_message( sprintf( esc_html__( "Error with replace phrase rule: [%s] incomplete. Rule Skipped.", 'video-blogster' ), $rule ) );
				continue;
			}

			$regexFlags = apply_filters( 'vbp_replace_phrases_regex_flags', '', $rule );
			$preppedRule = preg_quote( trim( $spinrule[0] ) ) . $regexFlags;
			$preppedReplace = trim( $spinrule[1] );

			$result = preg_replace( '~(?![^<]*>)' . $preppedRule . '~u', $preppedReplace, $content );
			if ( $result != $content ) {
				$this->info_message( sprintf( esc_html__( '=> applying replacement rule: %s', 'video-blogster' ), $rule ), 'notice notice-warning', 'debug' );
				$content = $result;
			}

		}
		if ( $content != $orig_content ) {
			$this->info_message( sprintf( esc_html__( 'Template with replaced phrases:  %s', 'video-blogster' ), htmlentities( $content ) ), 'notice notice-warning', 'debug' );
		}

		return $content;
	}

	/*
	 * Process the video info depending on video feed settings
	 */
	public function process_query_results( $args, &$videoInfo ) {

		// some APIs don't supply some fields so set these defaults to avoid warnings
		$defaults = array(
			'url'			=> null,
			'videoID'		=> null,
			'orig_title'		=> null,
			'title'			=> null,
			'orig_desc'		=> null,
			'desc'			=> null,
			'likeCount'		=> 0,
			'dislikeCount'		=> 0,
			'favoriteCount'		=> 0,
			'viewCount'		=> 0,
			'rating'		=> 0,
			'channelID'		=> null,
			'duration'		=> '00:00',
			'association'		=> null,
			'img'			=> null,
			'videoEmbed'		=> null,
			'postID'		=> 0,
			'sourceCategoryName'	=> null,
			'tags'			=> null,
		);

		$videoInfo = array_merge( $defaults, $videoInfo );
		unset( $defaults );

		// let user do any pre-checks before processing:
		$videoInfo = apply_filters( 'vbp_before_process_query_results', $videoInfo, $args );

		if ( empty( $videoInfo ) ) {
			return $this->info_message( sprintf( esc_html__( '%s - %s filter returned null. Skipping.', 'video-blogster' ), __FUNCTION__, 'vb_before_process_query_results' ), 'notice notice-warning', 'video_skip' );
		}

		$this->info_message( sprintf( esc_html__( '%s - Begin - %s', 'video-blogster' ), __FUNCTION__, htmlentities( print_r($videoInfo, true) ) ), 'notice notice-warning', 'debug' );

		if ( ! empty( $videoInfo['postID'] ) ) {        // applying changes to previous results
			$videoInfo['action'] = 'updated';
		}
		else {
			$videoInfo['action'] = 'saved';
		}

		if ( ! $this->passed_skip_rules( $args, $videoInfo ) ) { 
			return 0;
		}


		// Google is default translator
		if ( $args['pTranslateTo'] && ( empty( $args['pTranslateApi'] ) || $args['pTranslateApi'] == 'google' ) ) {
		  $apiKey = get_option( $this->get_my_plugin( 'prefix' ) . 'gtranslate_key' );
		  if ( empty( $apiKey ) ) {
			$this->info_message( sprintf( esc_html__( 'Unable to Google translate on feed %s - missing apiKey', 'video-blogster' ), $args['id'] ) );
		  }
		  if ( ! empty( $apiKey ) && ! empty( $videoInfo['title'] ) && false !== strpos( $args['pTranslateContent'], 'Title' ) ) {
			$data = $this->googleTranslate( $videoInfo['title'], $args['pTranslateTo'], $apiKey );
			if ( isset( $data->data->translations[0]->translatedText ) ) {
				$translate = $data->data->translations[0]->translatedText;
				$videoInfo['title'] = $translate;
				$this->info_message( sprintf( esc_html__( '%s video title %s has been Google (%s) translated to %s.', 'video-blogster' ), $videoInfo['videoSource'], $videoInfo['orig_title'], $args['pTranslateTo'], $translate ), 'updated', 'video_import' );
			}
			else if ( isset( $data->error->errors[0]->reason ) ) {
				$this->info_message( sprintf( esc_html__( 'Unable to Google translate video title to %s. Reason: %s ', 'video-blogster' ), $args['pTranslateTo'], $data->error->errors[0]->reason ) );
			}
			else {
				$this->info_message( sprintf( esc_html__( 'Unable to Google translate video title to %s. Reason unknown', 'video-blogster' ), $args['pTranslateTo'] ) );
			}
		  }
		  if ( ! empty( $apiKey ) && ! empty( $videoInfo['desc'] ) && false !== strpos( $args['pTranslateContent'], 'Desc' ) ) {
			$data = $this->googleTranslate( $videoInfo['desc'], $args['pTranslateTo'], $apiKey );
			if ( isset( $data->data->translations[0]->translatedText ) ) {
				$translate = $data->data->translations[0]->translatedText;
				$videoInfo['desc'] = $translate;
				$this->info_message( sprintf( esc_html__( '%s video description has been Google (%s) translated to %s.', 'video-blogster' ), $videoInfo['videoSource'], $args['pTranslateTo'], htmlentities( $translate ) ), 'updated', 'video_import' );
			}
			else if ( isset( $data->error->errors[0]->reason ) ) {
				$this->info_message( sprintf( esc_html__( 'Unable to Google translate video description to %s. Reason: %s ', 'video-blogster' ), $args['pTranslateTo'], $data->error->errors[0]->reason ) );
			}
			else {
				$this->info_message( sprintf( esc_html__( 'Unable to translate video description to %s. Reason unknown.', 'video-blogster' ), $args['pTranslateTo'] ) );
			}
		  }
		}

		// MS Azure Translator
		if ( $args['pTranslateTo'] && $args['pTranslateApi'] == 'ms azure' ) {
		  	$apiKey = get_option( $this->get_my_plugin( 'prefix' ) . 'mstranslate_key' );
		  	if ( ! empty( $apiKey ) && ! empty( $videoInfo['title'] ) && false !== strpos( $args['pTranslateContent'], 'Title' ) ) {
				$translate = $this->msTranslate( $videoInfo['title'], $args['pTranslateTo'], $apiKey );
				if ( ! empty( $translate ) ) {
					$videoInfo['title'] = $translate;
					$this->info_message( sprintf( esc_html__( '%s video title has been MS Azure (%s) translated to %s.', 'video-blogster' ), $videoInfo['videoSource'], $args['pTranslateTo'], htmlentities( $translate ) ), 'updated', 'video_import' );
				}
			}
		  	if ( ! empty( $apiKey ) && ! empty( $videoInfo['desc'] ) && false !== strpos( $args['pTranslateContent'], 'Desc' ) ) {
				$translate = $this->msTranslate( $videoInfo['desc'], $args['pTranslateTo'], $apiKey );
				if ( ! empty( $translate ) ) {
					$videoInfo['desc'] = $translate;
					$this->info_message( sprintf( esc_html__( '%s video description has been MS Azure (%s) translated to %s.', 'video-blogster' ), $videoInfo['videoSource'], $args['pTranslateTo'], htmlentities( $translate ) ), 'updated', 'video_import' );
				}
			}
		}

		// check duration field to make sure it's a format DateTime will recognize, like mm:ss or hh:mm:ss
		// xVideos uses format 124:21 instead of 02:04:21
		if ( preg_match( "#^([0-9]+):([0-9]+)(:[0-9]+)?$#", $videoInfo['duration'], $matches ) ) {
			$cnt = count( $matches );
			if ( $cnt == 3 && $matches[1] > 60 ) { // mm:ss with mm > 60
				$redo = $matches[1] * 60 + $matches[2];
				$v = $videoInfo['duration'];
				$videoInfo['duration'] = sprintf( '%02d:%02d:%02d', ($redo/3600),($redo/60%60), $redo%60 );
				$this->info_message( sprintf( esc_html__( 'Note: converting video duration from %s to %s', 'video-blogster' ), $v, $videoInfo['duration'] ), 'notice notice-warning', 'debug' );
			}
			unset( $matches );
			unset( $cnt );
		}

		if ( TRUE == $args['pRemoveDescUrls'] ) {
			$videoInfo['desc'] = $this->remove_urls( $videoInfo['desc'] );
		}
		if ( $args['pLimitTitleChars'] && ( mb_strlen( $videoInfo['title'] ) > $args['pLimitTitleChars'] ) ) {
			$last_space = mb_strrpos( mb_substr($videoInfo['title'], 0, $args['pLimitTitleChars']), ' ' );
			if ( $last_space ) {
				$new_string = mb_substr($videoInfo['title'], 0, $last_space);
				$this->info_message( sprintf( esc_html__( 'Limiting %s title to %s chars - %s. Last space was at pos %d', 'video-blogster' ), $videoInfo['title'], $args['pLimitTitleChars'], $new_string, $last_space ), 'notice notice-warning', 'debug' );
				if ( ! empty( $new_string) ) {
					$videoInfo['title'] = $new_string;
				}
			}
			else {
				$this->info_message( sprintf( esc_html__( 'Could not limit %s title to %s chars - No space was detected in first %s characters.', 'video-blogster' ), $videoInfo['title'], $args['pLimitTitleChars'], $args['pLimitTitleChars'] ), 'notice notice-warning', 'debug' );
			}
		}
		if ( $args['pLimitTitleWord'] ) {
			$found = stripos( $videoInfo['title'], $args['pLimitTitleWord'] );
			if ( $found !== FALSE ) {
				$videoInfo['title'] = mb_substr( $videoInfo['title'], 0, $found );
				$this->info_message( sprintf( esc_html__( 'Limiting title to %s word - %s', 'video-blogster' ), $args['pLimitTitleWord'], $videoInfo['title'] ), 'notice notice-warning', 'debug' );
			}
		}

		if ( $args['pRemoveTitleChars'] ) {
			$str = $args['pRemoveTitleChars'];
/* MARK needed? 
*&^%$#@!-",'~    is fine but
*&^%$#@!-",'~    	gives strange results
			$str = iconv( "UTF-8", "ISO-8859-1//TRANSLIT", $str );
Aha! those are not UTF-8 chars
*/
			$str = preg_quote( $str );
			$new_string = preg_replace("![" . $str . "]!", '', $videoInfo['title'] );
			$new_string = trim( $new_string );
			$new_string = preg_replace( '/\s+/', ' ', $new_string );
			$videoInfo['title'] = $new_string;
			$this->info_message( sprintf( esc_html__( 'Removed chars %s from title - %s', 'video-blogster' ), $args['pRemoveTitleChars'], $videoInfo['title'] ), 'notice notice-warning', 'debug' );
		}

		// break on the word the limit falls on
		if ( $args['pLimitDescChars'] && ( mb_strlen( $videoInfo['desc'] ) > $args['pLimitDescChars'] ) ) {
			$last_space = mb_strrpos(mb_substr($videoInfo['desc'], 0, $args['pLimitDescChars']), ' ');
			if ( $last_space ) {
				$new_string = mb_substr( $videoInfo['desc'], 0, $last_space );
				$this->info_message( sprintf( esc_html__( 'Limiting desc to %s chars - %s', 'video-blogster' ), $args['pLimitDescChars'], $videoInfo['desc'] ), 'notice notice-warning', 'debug' );
				if ( ! empty( $new_string ) ) {
					$videoInfo['desc'] = $new_string;
				}
			}
		}
		// the phrase to end at IS NOT included.
		if ( $args['pLimitDescWord'] ) {
			$found = mb_stripos( $videoInfo['desc'], $args['pLimitDescWord'] );
			if ( $found !== FALSE ) {
				// to include phrase:
				// $found += mb_strlen( $args['pLimitDescWord'] );
				$videoInfo['desc'] = mb_substr( $videoInfo['desc'], 0, $found );
				$this->info_message( sprintf( esc_html__( 'Ending desc at phrase [%s] - %s', 'video-blogster' ), $args['pLimitDescWord'], $videoInfo['desc'] ), 'notice notice-warning', 'debug' );
			}
		}

		if ( $args['pSentenceRemove'] || $args['pSentenceRemovePhrase'] ) {
			$re = '/# Split sentences on whitespace between them.
    				(?<=                # Begin positive lookbehind.
      				[.!?]               # Either an end of sentence punct
    				| [.!?][\'"]        # or end of sentence punct and quote.
				| \n                # or a line break,
    				)                   # End positive lookbehind.
    				(?<!                # Begin negative lookbehind.
      				Mr\.                # Skip either "Mr."
    				| Mrs\.             # or "Mrs.",
    				| Ms\.              # or "Ms.",
    				| Jr\.              # or "Jr.",
    				| Dr\.              # or "Dr.",
    				| Prof\.            # or "Prof.",
    				| Sr\.              # or "Sr.",
				| \s\w\.            # an initial like in "First M. Last"
				| \s\w\.\w\.        # double initial like in "F.M. Last"
				| \s\w.\w\.\w\.     # triple initial like in "F.M.L."
    				)                   # End negative lookbehind.
    				(\s+)               # Split on whitespace between sentences.
    				/mix';

			$sentences = preg_split( $re, $videoInfo['desc'], -1, PREG_SPLIT_DELIM_CAPTURE );
			$remove_phrases = explode( ',', $args['pSentenceRemovePhrase'] );
			$remove_phrases = array_map( 'trim', $remove_phrases);
			for ( $i=$j=0; $i < count( $sentences ); ++$i ) {
				$check = trim( $sentences[$i] );
				if ( empty( $check ) ) {
					continue;
				}
				$j++;
				$this->info_message( sprintf( esc_html__( 'Sentence %d removal check: %s', 'video-blogster' ), $j, $check ), 'notice notice-warning', 'debug' );
				if ( $j <= $args['pSentenceRemove'] ) {
					$this->info_message( sprintf( esc_html__( 'pSentenceRemove <= %d is true. Sentence removed.', 'video-blogster' ), $args['pSentenceRemove'] ), 'notice notice-warning', 'debug' );
					$sentences[$i] = "";
					continue;
				}
				foreach( $remove_phrases as $rp ) {
					if ( stripos( $sentences[$i], $rp ) !== FALSE ) {
						$this->info_message( sprintf( esc_html__( 'pRemovePhrase for [%s] is true. Sentence removed.', 'video-blogster' ), $rp ), 'notice notice-warning', 'debug' );
						$sentences[$i] = " ";
						break;
					}
				}
			}
			$videoInfo['desc'] = implode( $sentences );
		}

		if ( TRUE == $args['pLinkifyDescUrls'] ) {
			$videoInfo['desc'] = $this->linkify_filtered( $videoInfo['desc'] );
		}


		if ( ! empty ( $args['pSpinner'] ) && ( true == $args['pSpinTitle'] || true == $args['pSpinDesc'] || true == $args['pSpinCaptions'] ) ) {
			$this->spin_text( $args, $videoInfo['title'], $videoInfo['desc'], $videoInfo['captions'] );
		}

		if ( isset( $videoInfo['sourceCategoryName'] ) && ! empty( $args['pCatFilter'] ) ) {
			$this->category_filter( $args, $videoInfo );
			if ( empty( $videoInfo ) ) return;
		}

		if ( isset( $videoInfo['tags'] ) && $args['pMinTagLength'] ) {
			$tags = explode( ',', $videoInfo['tags'] );
			foreach( $tags as $key => $value ) {
				if ( strlen( trim( $value ) ) < $args['pMinTagLength'] ) {
					unset( $tags[$key] );
				}
			}
			$videoInfo['tags'] = implode( ",", $tags );
		}
		if ( isset( $videoInfo['tags'] ) && $args['pIgnoreTags'] ) {
			$tags = explode( ',', $videoInfo['tags'] );
			$tags = array_map( 'trim', $tags );
			$ignore_tags = explode( ',', $args['pIgnoreTags'] );
			$ignore_tags = array_map( 'trim', $ignore_tags );
			$diff = array_udiff( $tags, $ignore_tags, 'strcasecmp' );
			$videoInfo['tags'] = implode( ',', $diff );
		}

		// ====================== done with most rules. expand templates

		$this->info_message( sprintf( esc_html__( 'About to expand title template -  %s', 'video-blogster' ), $args['pTitleTemplate'] ), 'notice notice-warning', 'debug' );
		if ( empty( $args['pTitleTemplate'] ) ) $videoInfo['post_title'] = $videoInfo['title'];
		else $videoInfo['post_title'] = $this->expand_template( $args['pTitleTemplate'], null, $videoInfo, true, $args['pReplacePhrases'] );
		$this->info_message( sprintf( esc_html__( 'Title template now -  %s', 'video-blogster' ), htmlentities( $videoInfo['post_title'] ) ), 'notice notice-warning', 'debug' );

		$this->info_message( sprintf( esc_html__( 'About to expand post content template -  %s', 'video-blogster' ), htmlentities( $args['pPostTemplate'] ) ), 'notice notice-warning', 'debug' );
		$videoInfo['post_content'] = $this->expand_template( $args['pPostTemplate'], $args, $videoInfo, true, $args['pReplacePhrases'] );
		$videoInfo['post_content'] .= "\n<!-- Video Blogster Pro -->\n";
		$this->info_message( sprintf( esc_html__( 'Content template now -  %s', 'video-blogster' ), htmlentities( $videoInfo['post_content'] ) ), 'notice notice-warning', 'debug' );


		// rule: now see if expanded title is a dupe
		if ( ! $videoInfo['postID'] && $args['pSkipTitle'] ) {
			if ( $this->post_title_already_exists( $videoInfo['post_title'] ) ) {
				return $this->info_message( sprintf( esc_html__( 'New %s video post title [%s] already exists for another post. Skipping.', 'video-blogster' ), $videoInfo['videoSource'], $videoInfo['title'] ), 'notice notice-warning', 'video_skip' );
			}
			else {
				$this->info_message( sprintf( esc_html__( '%s video post title [%s] is unique.', 'video-blogster' ), $videoInfo['videoSource'], $videoInfo['title'] ), 'updated', 'video_import' );
			}
		}

		// rule: create excerpt from expanded content
		if ( TRUE == $args['pCreateExcerpt'] ) {
			$excerpt = $videoInfo['post_content'];
			$excerpt = strip_shortcodes( $excerpt );
			$excerpt = apply_filters( 'the_content', $excerpt );
			if ( ! empty( $args['pExcerptLength'] ) ) {
				$videoInfo['post_excerpt'] = wp_trim_words( $excerpt, $args['pExcerptLength'] );
			}
			else {
				$videoInfo['post_excerpt'] = wp_trim_words( $excerpt );
			}
			$this->info_message( sprintf( esc_html__( '%s - created excerpt - %s', 'video-blogster' ), __FUNCTION__, htmlentities( $videoInfo['post_excerpt'] ) ), 'notice notice-warning', 'debug' );
		}

		if ( $args['pImageTemplate'] ) { // custom image name
			$this->info_message( sprintf( esc_html__( 'About to expand image template -  %s', 'video-blogster' ), $args['pImageTemplate'] ), 'notice notice-warning', 'debug' );
			if ( stripos( $args['pImageTemplate'], "%VideoImageLocal%" ) !== FALSE ) {
				$args['pImageTemplate'] = str_replace( "%VideoImageLocal%", "%VideoTitle%", $args['pImageTemplate'] ); 
				$this->info_message( sprintf( esc_html__( '%s - VideoImageLocal is a url, not valid for Post Image Template. Using VideoTitle instead.', 'video-blogster' ), __FUNCTION__ ) );
			}

			// just in case custom filename has a directory or an extension - strip it out
			$args['pImageTemplate'] = pathinfo( $args['pImageTemplate'], PATHINFO_FILENAME ); 

			$img = strtok( $videoInfo['img'] );
			// make sure it has same extension as downloaded image:
			$ext = pathinfo( $img, PATHINFO_EXTENSION); 
			if ( ! $ext ) { // Hulu, Spotify images have no extension
				$ext = "jpg";
			}
			$args['pImageTemplate'] .= "." . $ext;
			$videoInfo['custom_name'] = $this->expand_template( $args['pImageTemplate'], null, $videoInfo, true, $args['pReplacePhrases'] );

			// replace any spaces
			$videoInfo['custom_name'] = str_replace( ' ', '-', $videoInfo['custom_name'] );

			// remove any non-word chars
			$args['pImageTemplate'] = preg_replace( "/[^\w\-\.]/", '',  $args['pImageTemplate'] );

			$this->info_message( sprintf( esc_html__( 'Image template now - %s', 'video-blogster' ), htmlentities( $videoInfo['custom_name'] ) ), 'notice notice-warning', 'debug' );
			unset( $img );
			unset( $ext );
		}

		// all templates expanded.

		$videoInfo = apply_filters('vbp_after_process_query_results', $videoInfo );

		if ( empty( $videoInfo ) ) {
			return $this->info_message( sprintf( esc_html__( '%s - %s filter returned null. Skipping.', 'video-blogster' ), __FUNCTION__, 'vb_after_process_query_results' ), 'notice notice-warning', 'video_skip' );
		}

		$this->info_message( sprintf( esc_html__( '%s - End - %s', 'video-blogster' ), __FUNCTION__, htmlentities( print_r($videoInfo, true) ) ), 'notice notice-warning', 'debug' );

		return 1;
	}

	/*
	 * if postID, key, value exist then add or update the meta value
	 */
	private function maybe_add_update_post_meta( $postID, $key, $value = null ) {
		if ( empty( $postID ) || empty( $key ) ) return;

		$this->info_message( sprintf( esc_html__( 'Attaching custom meta field [%s] with value [%s] to post id %s', 'video-blogster' ), $key, htmlentities( print_r( $value,true ) ), $postID ), 'notice notice-warning', 'debug' );

		add_post_meta( $postID, $key, $value, true ) || update_post_meta( $postID, $key, $value );
	}

	/*
	 * Create the post with the video info using the video feed settings
	 * if postID/updateID is not 0, then it is an update 
	 */
	public function create_the_post( $args, $videoInfo ) {
		if ( empty( $videoInfo ) ) {
			return new WP_Error( esc_html__( 'videoInfo is empty - contact support', 'video-blogster' ) );
		}

		$videoInfo['feedID'] = $args['id'];
		$this->info_message( sprintf( esc_html__( '%s - feed details: %s', 'video-blogster' ), __FUNCTION__, htmlentities( print_r( $args, TRUE ) ) ), 'notice notice-warning', 'debug' );
		$this->info_message( sprintf( esc_html__( '%s - videoInfo: %s', 'video-blogster' ), __FUNCTION__, htmlentities( print_r( $videoInfo, TRUE ) ) ), 'notice notice-warning', 'debug' );

		$updateID = isset( $videoInfo['postID'] ) ? $videoInfo['postID'] : 0;

		$user = $args['cUser'];
		if ( $args['cUser'] == "(random)" ) {
			$users = $this->get_users();
			shuffle( $users );
			$user = $users[0]->ID;
		}
		else if ( $args['cUser'] == "(content author)" ) {
			if ( empty( $videoInfo['authorUrl'] ) || empty( $videoInfo['authorTitle'] ) ) {
				$this->info_message( sprintf( esc_html__( 'Content does not have author info. Could not set post author to content author.', 'video-blogster' ) ), 'notice notice-warning', 'video_skip' );
			}
			else {
				// first see if user exists
				if ( false !== $userID = username_exists( $videoInfo['authorTitle'] ) ) {
					$user = $userID;
					$this->info_message( sprintf( esc_html__( '%s - setting post author to existing user ID %s from content author.', 'video-blogster' ), __FUNCTION__, $userID ), 'notice notice-warning', 'debug' );
				}
				// else create user
				else {
					$userdata = array(
						'user_pass'	=> wp_generate_password(),
						'user_login'	=> sanitize_user( $videoInfo['authorTitle'] ),
						'user_url'	=> $videoInfo['authorUrl'],
						'role'		=> 'editor'
					);
					$userdata = apply_filters( 'vbp_insert_user', $userdata );
					$userID = wp_insert_user( $userdata );
					if ( is_wp_error( $userID ) ) {
						$this->info_message( sprintf( esc_html__( 'Error %s, %s: unable to insert wp user from content author info - %s', 'video-blogster' ), $userID->get_error_code(), $userID->get_error_message(), print_r($userdata,true)  ) );
						$user = 0;
					}
					else {
						$user = $userID;
						$this->info_message( sprintf( esc_html__( '%s - inserting wp user with ID %s from content author info: %s', 'video-blogster' ), __FUNCTION__, $userID, print_r($userdata,true) ), 'notice notice-warning', 'debug' );
					}
				}
			}
		}
		if ( empty( $args['cPostStatus'] ) ) {
			$args['cPostStatus'] = 'draft';
		}
		if ( empty( $args['cPostType'] ) ) {
			$args['cPostType'] = 'post';
		}
		if ( empty( $args['cPostFormat'] ) ) {
			$args['cPostFormat'] = 'standard';
		}


		// don't publish on post creation - wait for featured image to be set, then publish after
		$post_status = ( $args['cPostStatus'] == 'publish' ) ? 'draft' : $args['cPostStatus'];

		$postID = 0;
		kses_remove_filters();
		if ( $updateID ) {	// update an existing post 
			if ( true == $args['cClearTaxonomies'] ) {
				// lets clear taxonomies for this post then so user can re-do
				$valid_taxonomies = $this->get_taxonomies();
				foreach( $valid_taxonomies as $taxonomy ) {
					wp_set_object_terms( $updateID, '', $taxonomy );
				}
			}
                	$vidpost = array(
				'ID'     	=> $updateID,
				'post_name'     => sanitize_title( $videoInfo['post_title'] ),
				'post_title'    => $videoInfo['post_title'],
				'post_content'  => $videoInfo['post_content'],
				'post_type'     => $args['cPostType'],
				'post_excerpt'  => TRUE == $args['pCreateExcerpt'] ? $videoInfo['post_excerpt'] : '',
				'filter' => true 
			);
			$vb_filter = 'vbp_update_the_post';
			$vidpost = apply_filters( $vb_filter, $vidpost, $videoInfo );
			if ( ! is_numeric( $vidpost ) && ! empty( $vidpost ) ) {
				$this->info_message( sprintf( esc_html__( '%s - wp_update_post: %s', 'video-blogster' ), __FUNCTION__, htmlentities( print_r( $vidpost, TRUE ) ) ), 'notice notice-warning', 'debug' );
				$postID = wp_update_post( $vidpost, TRUE );
			}
		}
		else {			// add a new post

			$time_now = current_time( 'mysql' );
			$vidpost = array(
				'post_name'     => sanitize_title( $videoInfo['post_title'] ),
				'post_title'    => $videoInfo['post_title'],
				'post_content'  => $videoInfo['post_content'],
				'post_status'   => $post_status,
				'post_author' 	=> $user,
				'post_type'     => $args['cPostType'],
				'post_excerpt'  => TRUE == $args['pCreateExcerpt'] ? $videoInfo['post_excerpt'] : '',
				'post_date'	=> TRUE == $args['cUsePublishedDate'] ? $videoInfo['publishedAt'] : $time_now,
				'post_date_gmt'	=> TRUE == $args['cUsePublishedDate'] ? get_gmt_from_date( $videoInfo['publishedAt'] ) : get_gmt_from_date( $time_now ),
				'filter' => true 
				);

			$vb_filter = 'vbp_create_the_post';
			$vidpost = apply_filters( $vb_filter, $vidpost, $videoInfo );

			// if above filter returns the data array, VB will create the post and all attachment data
			// if above filter returns a post ID, VB will not create the post but still attach data
			// if above filter returns null, VB will not create the post or attachment data
			if ( ! is_numeric( $vidpost ) && ! empty( $vidpost ) ) {
				$this->info_message( sprintf( esc_html__( '%s - wp_insert_post: %s', 'video-blogster' ), __FUNCTION__, htmlentities( print_r( $vidpost, TRUE ) ) ), 'notice notice-warning', 'debug' );
				$postID = wp_insert_post( $vidpost, TRUE );
			}
			else
				$postID = null;
		}

		kses_init_filters();

		if ( is_numeric( $vidpost ) ) {
			// external code created the post through a filter 
			// and returned the post id for VB to attach meta, thumbnail, comments, etc
			$this->info_message( sprintf( esc_html__( '%s - %s filter returned: %s', 'video-blogster' ), __FUNCTION__, $vb_filter, htmlentities( print_r( $vidpost, TRUE ) ) ), 'notice notice-warning', 'debug' );
			$postID = $vidpost;
		}
		else if ( empty( $vidpost ) ) { 
			// external code created the post through a filter and they don't want further processing
			$this->info_message( sprintf( esc_html__( '%s - %s filter returned null. Skipping.', 'video-blogster' ), __FUNCTION__, $vb_filter, htmlentities( print_r( $vidpost, TRUE ) ) ), 'notice notice-warning', 'debug' );
			return new WP_Error('skip_post_creation');
		}

		if ( is_wp_error( $postID ) ) {
			if ( $updateID ) {
				$this->info_message( sprintf( esc_html__( 'Error %s: wp_update_post for [%s] returned - %s', 'video-blogster' ), $postID->get_error_code(), htmlentities( print_r($vidpost,true) ), $postID->get_error_message() ) );
			}
			else {
				$this->info_message( sprintf( esc_html__( 'Error %s: wp_insert_post for [%s] returned - %s', 'video-blogster' ), $postID->get_error_code(), htmlentities( print_r($vidpost,true) ), $postID->get_error_message() ) );
			}
			return $postID;
		}

		if ( empty( $vidpost ) )
			$this->info_message( sprintf( esc_html__( '%s - update/insert aborted by user filter call', 'video-blogster' ), __FUNCTION__ ), 'notice notice-warning', 'debug' );
		else {
			$this->info_message( sprintf( esc_html__( '%s - update/insert finished, postID %d', 'video-blogster' ), __FUNCTION__, $postID ), 'notice notice-warning', 'debug' );

			$this->save_the_taxonomies( $args, $videoInfo, $postID );
			$this->save_the_post_meta( $args, $videoInfo, $postID );
			$this->save_the_post_format( $args, $videoInfo, $postID );
		}

		do_action( 'vbp_create_the_post_finished', $postID, $videoInfo );

		unset( $vidpost );

		return $postID;
	}

	public function save_the_taxonomies( $args, $videoInfo, $postID ) {

		// any categories imported? set taxonomies here 
		if ( ! empty( $videoInfo['sourceCategoryName'] ) && ! empty( $args['cAddSourceCategory'] ) ) {
			if ( $args['cAddSourceCategory'] == "1" ) $args['cAddSourceCategory'] == 'category'; // backwards compat
				
			$this->info_message( sprintf( esc_html__( '%s - Attaching imported categories [%s] to taxonomy [%s] on postID %d', 'video-blogster' ), __FUNCTION__, $videoInfo['sourceCategoryName'], $args['cAddSourceCategory'], $postID ), 'notice notice-warning', 'debug' );
			$terms = explode( ",", $videoInfo['sourceCategoryName'] );
			wp_set_object_terms( $postID, $terms, $args['cAddSourceCategory'], true );
		}
		// any tags imported? set taxonomies here 
		if ( ! empty( $videoInfo['tags'] ) && ! empty( $args['pGrabTags'] ) ) {
			if ( $args['pGrabTags'] == "1" ) $args['pGrabTags'] == 'post_tag'; // backwards compat
			$this->info_message( sprintf( esc_html__( '%s - Attaching imported tags [%s] to taxonomy [%s] on postID %d', 'video-blogster' ), __FUNCTION__, $videoInfo['tags'], $args['pGrabTags'], $postID ), 'notice notice-warning', 'debug' );
			$terms = explode( ",", $videoInfo['tags'] );
			wp_set_object_terms( $postID, $terms, $args['pGrabTags'], true );
		}
		// any ps imported? set taxonomies here 
		if ( ! empty( $videoInfo['pornstars'] ) && ! empty( $args['pGrabPornstars'] ) ) {
			if ( $args['pGrabPornstars'] == "1" ) $args['pGrabPornstars'] == 'post_tag'; // backwards compat
			$this->info_message( sprintf( esc_html__( '%s - Attaching imported pornstars [%s] to taxonomy [%s] on postID %d', 'video-blogster' ), __FUNCTION__, $videoInfo['pornstars'], $args['pGrabPornstars'], $postID ), 'notice notice-warning', 'debug' );
			$tags = explode( ",", $videoInfo['pornstars'] );
			wp_set_object_terms( $postID, $tags, $args['pGrabPornstars'], true );
		}

		// any selected categories from old feeds pre v4.0 ?
		if ( ! empty( $args['cCategories'] ) ) {
			$catIDs = explode( ',', $args['cCategories'] );
			wp_set_post_categories( $postID, $catIDs, true );
		}

		// any taxonomies selected on 'Create the Posts' tab?
		if ( ! empty( $args['cQuickTags'] ) ) {
			$terms = explode( ',', $args['cQuickTags'] );
			$tax = 'post_tag';
			$this->info_message( sprintf( esc_html__( '%s - Attaching selected quick tags [%s] to taxonomy [%s] to post id %s', 'video-blogster' ), __FUNCTION__, $args['cQuickTags'], $tax, $postID ), 'notice notice-warning', 'debug' );
			$result = wp_set_object_terms( $postID, $terms, $tax, true );
			if ( is_wp_error( $result ) ) {
				$this->info_message( sprintf( esc_html__( 'Error %s: wp_set_object_terms returned - %s', 'video-blogster' ), $result->get_error_code(), $result->get_error_message() ) );
			}
			else if ( is_string( $result ) ) {
				$this->info_message( sprintf( esc_html__( 'Error: wp_set_object_terms returned - %s is named incorrectly.', 'video-blogster' ), $result ) );
			}
		}
		if ( ! empty( $args['cTaxTerms'] ) && is_array( $args['cTaxTerms'] ) ) {
			foreach ( $args['cTaxTerms'] as $taxterm ) {
				// have to gather all terms first then add
				$parts = explode( ':', $taxterm ); // in format 'taxonomy:term:slug'
				$cTaxTerms[$parts[0]][] = $parts[2];
			}
			foreach ( $cTaxTerms as $tax => $terms ) {
				$t = implode( ',', $terms );
				$this->info_message( sprintf( esc_html__( '%s - Attaching selected terms [%s] to taxonomy [%s] to post id %s', 'video-blogster' ), __FUNCTION__, $t, $tax, $postID ), 'notice notice-warning', 'debug' );
				$result = wp_set_object_terms( $postID, $terms, $tax, true );
				if ( is_wp_error( $result ) ) {
					$this->info_message( sprintf( esc_html__( 'Error %s: wp_set_object_terms returned - %s', 'video-blogster' ), $result->get_error_code(), $result->get_error_message() ) );
				}
				else if ( is_string( $result ) ) {
					$this->info_message( sprintf( esc_html__( 'Error: wp_set_object_terms returned - %s is named incorrectly.', 'video-blogster' ), $result ) );
				}
			}
		}

		// if category taxonomies imported or selected, then remove the default category selection
		$cats = get_the_category( $postID );
		if ( count( $cats ) > 1 ) {
			wp_remove_object_terms( $postID, (int)get_option( 'default_category' ), 'category' );
			$this->info_message( sprintf( esc_html__( '%s - Category imported/selected for post id %s, so removing the default_category.', 'video-blogster' ), __FUNCTION__, $postID ), 'notice notice-warning', 'debug' );
		}
	}

	public function save_the_post_meta( $args, $videoInfo, $postID, $metadata = false ) {

		// update all post meta
		$this->info_message( sprintf( esc_html__( '%s - adding post meta to postID %d', 'video-blogster' ), __FUNCTION__, $postID ), 'notice notice-warning', 'debug' );

		$this->maybe_add_update_post_meta( $postID, 'VideoLastChecked', date( "Y-m-d" ) );

		// make sure some fields are numbers.  5,555 is not a number so convert to 5555
		$videoInfo['likeCount'] = str_replace( ',', '', $videoInfo['likeCount'] );
		$videoInfo['dislikeCount'] = str_replace( ',', '', $videoInfo['dislikeCount'] );
		$videoInfo['viewCount'] = str_replace( ',', '', $videoInfo['viewCount'] );
		$this->maybe_add_update_post_meta( $postID, 'VideoLikes', $videoInfo['likeCount'] );
		$this->maybe_add_update_post_meta( $postID, 'VideoDislikes', $videoInfo['dislikeCount'] );


		if ( false === $metadata ) {
			$this->maybe_add_update_post_meta( $postID, 'VideoFeed', $videoInfo['feedID'] );
			$this->maybe_add_update_post_meta( $postID, 'VideoImage', $videoInfo['img'] );
			$this->maybe_add_update_post_meta( $postID, 'VideoImageImport', $args['qImageImport'] );
		}

		$this->maybe_add_update_post_meta( $postID, 'VideoSource', $videoInfo['videoSource'] );
		$this->maybe_add_update_post_meta( $postID, 'VideoID', $videoInfo['videoID'] );
		$this->maybe_add_update_post_meta( $postID, 'VideoDuration', $videoInfo['duration'] );
		$this->maybe_add_update_post_meta( $postID, 'VideoFavorites', $videoInfo['favoriteCount'] );
		$this->maybe_add_update_post_meta( $postID, 'VideoOrigTitle', $videoInfo['orig_title'] );
		$this->maybe_add_update_post_meta( $postID, 'VideoOrigDesc', $videoInfo['orig_desc'] );
		$this->maybe_add_update_post_meta( $postID, 'VideoAssoc', $videoInfo['association'] );
		$this->maybe_add_update_post_meta( $postID, 'VideoChannelID', $videoInfo['channelID'] );
		$this->maybe_add_update_post_meta( $postID, 'VideoUrl', $videoInfo['url'] );
		$this->maybe_add_update_post_meta( $postID, 'VideoEmbed', $videoInfo['videoEmbed'] );
		$this->maybe_add_update_post_meta( $postID, 'VideoPublish', $videoInfo['publishedAt'] );
		
		if ( isset( $videoInfo['file'] ) ) { // direct link to video file like an MP4. Not all sites support.
			$this->maybe_add_update_post_meta( $postID, 'VideoFile', $videoInfo['file'] );
		}
		if ( isset( $videoInfo['images'] ) ) { 
			$this->maybe_add_update_post_meta( $postID, 'VideoImages', $videoInfo['images'] );
		}

		// use compatible name with WP-PostViews. easy.
		$this->maybe_add_update_post_meta( $postID, 'views', $videoInfo['viewCount'] );

		// make compatible with WP-PostRatings. a little more difficult
		if ( isset( $videoInfo['likeCount'] ) 
				&& is_plugin_active( 'wp-postratings/wp-postratings.php' ) 
		) { // convert stats to WP-PostRatings
			$postratings_max = intval( get_option( 'postratings_max' ) );
			$post_ratings_users = $videoInfo['likeCount'] + $videoInfo['dislikeCount'];
			$post_ratings_score = $videoInfo['likeCount'] * $postratings_max;
			$post_ratings_average = $post_ratings_users ? round($post_ratings_score/$post_ratings_users, 2) : 0;
			$this->maybe_add_update_post_meta( $postID, 'ratings_users', $post_ratings_users );
			$this->maybe_add_update_post_meta( $postID, 'ratings_score', $post_ratings_score );
			$this->maybe_add_update_post_meta( $postID, 'ratings_average', $post_ratings_average );
			$videoInfo['rating'] = $post_ratings_average;
		}
		if ( isset( $videoInfo['rating'] ) && ! empty( $videoInfo['rating'] ) ) {
			$this->maybe_add_update_post_meta( $postID, 'VideoRating', $videoInfo['rating'] );
		}

		if ( isset( $videoInfo['pornstars'] ) ) $this->maybe_add_update_post_meta( $postID, 'VideoPornstars', $videoInfo['pornstars'] );

		do_action( 'vbp_pre_custom_meta', $postID, $videoInfo );

		// add or update any CUSTOM meta fields:
		if ( isset( $args['pMetaFields'] ) && is_array( $args['pMetaFields'] ) ) {
			foreach ( $args['pMetaFields'] as $metakey => $metavalue ) {

				// modified by ryan yang
				$metavalue = $this->expand_template( $metavalue, null, $videoInfo, false );
				if ( json_decode( $metavalue ) == true ) {
					$metavalue = json_decode( $metavalue, true );
				}
				$this->maybe_add_update_post_meta( $postID, $metakey, $metavalue );
			}
		}
	}

	public function save_the_post_format( $args, $videoInfo, $postID ) {

		// finally, set the post format
		if ( $args['cPostFormat'] ) {
			$this->info_message( sprintf( esc_html__( 'Setting post id %s format to [%s]', 'video-blogster' ), $postID, $args['cPostFormat'] ), 'notice notice-warning', 'debug' );
			$result = set_post_format( $postID, $args['cPostFormat'] );
			if ( is_wp_error( $result ) ) {
				$this->info_message( sprintf( esc_html__( 'Error %s: set_post_format returned - %s', 'video-blogster' ), $result->get_error_code(), $result->get_error_message() ) );
			}
		}
	}

	/*
	 * This function is called if video feed is set to publish posts.
	 * We can't publish when we insert the post because filters would fire before thumbnail/comments were attached.
	 * So we need this function to update the post to publish with video publish date change (if specified).
	 */
	public function publish_the_post( $postID, $args, $videoInfo ) {
		$vidpost = array(
			'ID'		=> $postID,
			'post_status'	=> 'publish',
			'edit_date'	=> true,
			'post_date'     => TRUE == $args['cUsePublishedDate'] ? $videoInfo['publishedAt'] : current_time( 'mysql' ),
		);
		$vidpost = apply_filters( 'vbp_publish_the_post', $vidpost, $videoInfo );
		$this->info_message( sprintf( esc_html__( '%s - vidpost: %s', 'video-blogster' ), __FUNCTION__, htmlentities( print_r( $vidpost, TRUE ) ) ), 'notice notice-warning', 'debug' );
		kses_remove_filters();
		$postID = wp_update_post( $vidpost, TRUE );
		kses_init_filters();
		if ( is_wp_error( $postID ) ) {
			$this->info_message( sprintf( esc_html__( 'Error %s: wp_update_post returned - %s', 'video-blogster' ), $postID->get_error_code(), $postID->get_error_message() ) );
		}
		else {
			$this->info_message( sprintf( 
				esc_html__( 'Post: [%s] published successfully with post id %s%s%s.', 'video-blogster' ), 
				$videoInfo['post_title'], 
				'<a target="_blank" href="' . get_permalink( $postID ) . '">',
				$postID,
				'</a>'
			), 'updated', 'video_import' );
		}
		unset( $vidpost );
		do_action( 'vbp_publish_the_post_finished', $postID, $videoInfo );
	}


	/*
	 * Expands post template with the thumbnail if %VideoImageLocal% tag is used
	 * Have to do this AFTER post was created so thumb could be fetched and attached.
	 */
	public function process_the_thumbnail ( $postID, $thumbID, $videoInfo ) {
		$this->info_message( sprintf( esc_html__( '%s for postID %s, thumbID %s, videoInfo: %s', 'video-blogster' ), __FUNCTION__, $postID, $thumbID, htmlentities( print_r( $videoInfo, TRUE ) ) ), 'notice notice-warning', 'debug' );
		if ( ! $thumbID ) { // no thumb to process
			return $postID;
		}
		// if %VideoImageLocal% tag is in post template we need to update_post we just created.
		$thumburl = wp_get_attachment_url( $thumbID );
		$videoInfo['post_content'] = str_ireplace( array( '%VideoImageLocal%', '%TrackImageLocal%' ), $thumburl, $videoInfo['post_content'] );
		if ( isset( $videoInfo['post_excerpt'] ) ) {
			$videoInfo['post_excerpt'] = str_ireplace( array( '%VideoImageLocal%', '%TrackImageLocal%' ), $thumburl, $videoInfo['post_excerpt'] );
		}
		$vidpost = array(
			'post_content'  => $videoInfo['post_content'],
			'post_excerpt'  => isset( $videoInfo['post_excerpt'] ) ? $videoInfo['post_excerpt'] : '',
			'ID'		=> $postID
			);
		kses_remove_filters();
		$postID = wp_update_post( $vidpost, TRUE );
		kses_init_filters();
		if ( is_wp_error( $postID ) ) {
			$this->info_message( sprintf( esc_html__( 'Error %s: wp_update_post returned - %s', 'video-blogster' ), $postID->get_error_code(), $postID->get_error_message() ) );
		}
		return $postID;
	}

	/*
	 * Takes an ordered array of video image urls from the API in cascading order.
	 * Returns the first verified video image url that returns a 200 response code.
	 * ( This is used because sometimes YouTube specifies an image url that does not exist. )
	 */
	public function verify_thumbnails( $imgs ) {
		$this->info_message( sprintf( esc_html__( '%s: %s', 'video-blogster' ), __FUNCTION__, print_r($imgs,true) ), 'notice notice-warning', 'debug' );
		// in case user wants to save all possible imgs somewhere:
		$imgs = apply_filters( 'vbp_verify_thumbnails', $imgs );
		foreach ( $imgs as $img ) {

			if ( false !== strpos( $img, 'video_converting' ) ) {
				$this->info_message( sprintf( esc_html__( '%s: %s skipped', 'video-blogster' ), __FUNCTION__, $img ), 'notice notice-warning', 'debug' );
				continue;
			}
			// fix for protocol-less urls:
			if ( strpos( $img,'//' ) === 0 ) {
				$img = "http:" . $img;
			}

			$args = array( 
				'headers' => array( 'user-agent'    => 'video blogster pro' . '; ' . home_url() )
			);
			$this->info_message( sprintf( esc_html__( '%s wp_remote_head for %s with args %s', 'video-blogster' ), __FUNCTION__, $img, print_r($args,true) ), 'notice notice-warning', 'debug' );

			$response = wp_remote_head( $img, $args );
			if ( wp_remote_retrieve_response_code( $response ) == 200 ) {
				$this->info_message( sprintf( esc_html__( '%s got 200 OK: returning image: %s', 'video-blogster' ), __FUNCTION__, $img ), 'notice notice-warning', 'debug' );
				return $img; 
			}
			else $this->info_message( sprintf( esc_html__( '%s: skipping %s because it did not return 200 OK: %s', 'video-blogster' ), __FUNCTION__, $img, print_r($response,true) ), 'notice notice-warning', 'debug' );
		}
		$this->info_message( sprintf( esc_html__( '%s Error: none of these urls has valid thumbnails: %s', 'video-blogster' ), __FUNCTION__, print_r($imgs,true) ), 'error', 'debug' );
		return null;
	}


	/*
	 * Fetches the thumbnail from the video site using wp_remote_get()
	 * Saves thumbnail in the media library using wp_upload_bits()
	 */
	public function grab_thumbnail2( $postID, $videoImage ) {

		$img = $videoImage['img'] ? strtok( $videoImage['img'], '?' ) : null;

		// fix for protocol-less urls:
		if ( strpos( $img,'//' ) === 0 ) {
			$img = "http:" . $img;
		}

		// get rid of image name params, if any 
		// (ex: https://i.vimeocdn.com/video/475216365_1280x720.jpg?r=pad)
		// to avoid "Sorry, this file type is not permitted for security reasons"
		$parts = explode( 'jpg?', $img );
		$img = $parts[0];


		$post_title = $videoImage['post_title'] ? $videoImage['post_title'] : null;
		$custom_name = isset( $videoImage['custom_name'] ) ? $videoImage['custom_name'] : null;
		$this->info_message( sprintf( esc_html__( '%s fetching image: [%s] for %s, post id %s', 'video-blogster' ), __FUNCTION__, htmlentities( $img ), $post_title, $postID ), 'notice notice-warning', 'debug' );
		if ( ! $postID || ! $post_title || ! $img ) {
			return 0;
		}
		if ( $thumbID = get_post_thumbnail_id( $postID ) ) { // does post already have a thumbnail?
			$this->info_message( sprintf( esc_html__( '%s: post %s already has thumbnail.', 'video-blogster' ), __FUNCTION__, $postID ), 'notice notice-warning', 'debug' );
			// return $thumbID;	// uncomment to not fetch a new thumb
		}
		$ext = pathinfo( $img, PATHINFO_EXTENSION );
		if ( ! $ext ) {	// handles dynamic images for example Hulu, Spotify - pain in the ass
			$this->info_message( sprintf( esc_html__( '%s: No extension found, enabling unsafe_urls flag and assuming jpg extension.', 'video-blogster' ), __FUNCTION__, $img ), 'notice notice-warning', 'debug' );
			$ext = apply_filters( 'vbp_thumbnail_ext_default', "jpg" );
			$unsafe = TRUE;
			add_filter('http_request_reject_unsafe_urls', '__return_false');
		}

		$args = array( 
			'headers' => array( 'user-agent'    => 'video blogster pro' . '; ' . home_url() )
		);
		$response = wp_remote_get( $img, $args );
    		if ( is_wp_error( $response ) ) {	// this usually means the given thumb was not found on remote site
			return $this->info_message( sprintf( esc_html__( 'WP error %s in %s for post id %s wp_remote_get() of %s - %s', 'video-blogster' ), $response->get_error_code(), __FUNCTION__, $postID, $img, $response->get_error_message() ) );
		}
		$img_bits = $response['body'];

		$filename = $custom_name ? $custom_name : 'vbp-' . $postID . '-' . $post_title . '.' . $ext;
		$filename = sanitize_file_name( $filename );
		// remove any unsafe characters:
		$filename = preg_replace( "/[^a-zA-Z0-9_\-.]/", '', $filename );

		$this->info_message( sprintf( esc_html__( '%s: about to upload bits for %s', 'video-blogster' ), __FUNCTION__, $filename ), 'notice notice-warning', 'debug' );
		$upload = wp_upload_bits( $filename, null, $img_bits );

		if ( isset( $unsafe ) ) {
			add_filter('http_request_reject_unsafe_urls', '__return_true');
		}

		if ( $upload['error'] ) {
			return $this->info_message( sprintf( esc_html__( 'wp_upload_bits error for %s: %s', 'video-blogster' ), $filename, $upload['error'] ) );
		}

		$filetype = wp_check_filetype( basename( $upload['file'] ), null );

		$upload = apply_filters( 'wp_handle_upload', array(
			'file' => $upload['file'],
			'url'  => $upload['url'],
			'type' => $filetype['type']
		), 'sideload' );


		$attachment = array(
			'post_mime_type'        => $upload['type'],
			'post_title'            => get_the_title( $postID ),
			'post_content'          => '',
			'post_status'           => 'inherit'
		);

		$this->info_message( sprintf( esc_html__( '%s: about to insert attachments %s.', 'video-blogster' ), __FUNCTION__, print_r( $attachment,true ) ), 'notice notice-warning', 'debug' );

		$attach_id = wp_insert_attachment( $attachment, $upload['file'], $postID );

		// Make sure that this file is included, as wp_generate_attachment_metadata() depends on it.
		require_once( ABSPATH . 'wp-admin/includes/image.php' );

		// Generate the metadata for the attachment, and update the database record.
		$attach_data = wp_generate_attachment_metadata( $attach_id, $upload['file'] );
		wp_update_attachment_metadata( $attach_id, $attach_data );

		$this->set_post_thumbnail( $postID, $attach_id );

		$this->info_message( sprintf( esc_html__( 'Image [%s] added to media library for post id %s.', 'video-blogster' ), $filename, $postID ), 'updated', 'video_import' );

		return $attach_id;
	}

	/*
	 * Fetches the thumbnail from the video site using download_url()
	 * Saves thumbnail in the media library using media_handle_sideload()
	 */
	public function grab_thumbnail( $postID, $videoImage ) {

		$memthumb = false;
		$memthumb = apply_filters( 'vbp_alternate_thumb_fetch', $memthumb );
		if ( $memthumb ) {
			return $this->grab_thumbnail2( $postID, $videoImage ); 
		}
	
		$img = $videoImage['img'];
		// fix for protocol-less urls:
		if ( strpos( $img,'//' ) === 0 ) {
			$img = "http:" . $img;
		}

		// get rid of image name extra params/data, if any 
		// to avoid "Sorry, this file type is not permitted for security reasons"
		// (ex: https://i.vimeocdn.com/video/475216365_1280x720.jpg?r=pad)
		// (ex: http://thumb-v1.xhcdn.com/a/8X8YF-cEl1_qgGu1EVUwGA/010/105/661/2000x2000.c.jpg.v1536063060)

		if ( false !== stripos( $img, '.jpg' ) ) {
			$parts = explode( '.jpg', $img );
			$img = $parts[0] . ".jpg";
		}

		$post_title = $videoImage['post_title'] ? $videoImage['post_title'] : null;
		$custom_name = isset( $videoImage['custom_name'] ) ? $videoImage['custom_name'] : null;
		$this->info_message( sprintf( esc_html__( '%s fetching image: [%s] for %s, post id %s', 'video-blogster' ), __FUNCTION__, htmlentities( $img ), $post_title, $postID ), 'updated', 'video_import' );
		if ( ! $postID || ! $post_title || ! $img ) {
			return 0;
		}
		if ( $thumbID = get_post_thumbnail_id( $postID ) ) { // does post already have a thumbnail?
			$this->info_message( sprintf( esc_html__( '%s: post %s already has thumbnail.', 'video-blogster' ), __FUNCTION__, $postID ), 'notice notice-warning', 'debug' );
			// return $thumbID;	// uncomment to not fetch a new thumb
		}
		if ( ! function_exists( 'download_url' ) || ! function_exists( 'media_handle_sideload' ) || ! function_exists( 'wp_read_image_metadata' ) )  {
			$this->info_message( sprintf( esc_html__( '%s: adding required functions.', 'video-blogster' ), __FUNCTION__ ), 'notice notice-warning', 'debug' );
			if ( ! $this->vb_include_once( ABSPATH . 'wp-admin' . '/includes/image.php' ) ) {
				return 0;
			}
			if ( ! $this->vb_include_once( ABSPATH . 'wp-admin' . '/includes/file.php' ) ) {
				return 0;
			}
			if ( ! $this->vb_include_once( ABSPATH . 'wp-admin' . '/includes/media.php' ) ) {
				return 0;
			}
		}
		$ext = pathinfo( $img, PATHINFO_EXTENSION );
		if ( ! $ext ) {	// handles dynamic images for example Hulu, Spotify - pain in the ass
			$ext = apply_filters( 'vbp_thumbnail_ext_default', "jpg" );
			$unsafe = TRUE;
			add_filter('http_request_reject_unsafe_urls', '__return_false');
			$this->info_message( sprintf( esc_html__( '%s: No extension found, enabling unsafe_urls flag and assuming %s extension.', 'video-blogster' ), $img, $ext ), 'notice notice-warning', 'debug' );
		}
		$this->info_message( sprintf( esc_html__( '%s: about to download img %s', 'video-blogster' ), __FUNCTION__, $img ), 'notice notice-warning', 'debug' );
    		$tmp = download_url( $img );
    		if ( is_wp_error( $tmp ) ) {	// this usually means the given thumb was not found on remote site
			if ( $tmp->get_error_code() == 'http_404' ) {
				// don't fetch again...
				update_post_meta( $postID, 'VideoImageImport', false );
			}
			return $this->info_message( sprintf( esc_html__( 'WP error %s in %s for post id %s download_url() of %s - %s', 'video-blogster' ), $tmp->get_error_code(), __FUNCTION__, $postID, $img, $tmp->get_error_message() ) );
		}
		if ( ! file_exists( $tmp ) ) {
			return $this->info_message( sprintf( esc_html__( 'tmp file %s does not exist! check that WordPress can create a file in that directory...', 'video-blogster' ), $tmp ) );
		}

		$filename = $custom_name ? $custom_name : 'vbp-' . $postID . '-' . $post_title . '.' . $ext;
		$filename = sanitize_file_name( $filename );
		// remove any unsafe characters:
		$filename = preg_replace( "/[^a-zA-Z0-9_\-.]/", '', $filename );
    		$file_array = array(
			'name' => $filename,
			'tmp_name' => $tmp
		);

		$this->info_message( sprintf( esc_html__( '%s: about to handle sideload of %s, size is %d', 'video-blogster' ), __FUNCTION__, print_r( $file_array,true ), filesize( $tmp ) ), 'notice notice-warning', 'debug' );
    		$thumbID = media_handle_sideload( $file_array, $postID );
    		if ( is_wp_error( $thumbID ) )  {
			@unlink( $tmp );
			return $this->info_message( sprintf( esc_html__( 'WP error %s in %s for post id %s media_handle_sideload() of %s to %s - %s', 'video-blogster' ), $thumbID->get_error_code(), __FUNCTION__, $postID, $img, $tmp, $thumbID->get_error_message() ) );
		}
		if ( ! $thumbID ) {
			@unlink( $tmp );
			return $this->info_message( sprintf( esc_html__( '0 returned in %s from media_handle_sideload() of %s to %s - %s', 'video-blogster' ), __FUNCTION__, $img, $tmp, $thumbID->get_error_message() ) );
		}

		if ( isset( $unsafe ) ) {
			add_filter('http_request_reject_unsafe_urls', '__return_true');
		}

		$this->set_post_thumbnail( $postID, $thumbID );

		if ( file_exists( $tmp ) ) {
			@unlink( $tmp );	
		}

		$this->info_message( sprintf( esc_html__( 'Image [%s] added to media library for post id %s.', 'video-blogster' ), $filename, $postID ), 'updated', 'video_import' );

		return $thumbID;
	}

	/*
	 * Sets the featured image with set_post_thumbnail()
	 */
	protected function set_post_thumbnail( $postID, $thumbID ) {
		$this->info_message( sprintf( esc_html__( '%s: about to set_post_thumbnail for thumbID %s.', 'video-blogster' ), __FUNCTION__, $thumbID ), 'notice notice-warning', 'debug' );
		$mediaID = set_post_thumbnail( $postID, $thumbID );
		if ( ! $mediaID ) {
			return $this->info_message( sprintf( esc_html__( 'Error: set_post_thumbnail (%s, %s) returned FALSE ', 'video-blogster' ), $postID, $thumbID ) );
		}
		return 1;
	}

	/*
	 * Get a list of posts for video site
	 */
	public function get_posts_by_site( $videoSite = 'YouTube', $offset = 0, $meta = array() ) {
		$chunksize = apply_filters( 'vbp_posts_chunksize', 50 );

		$meta_query = array(
			'relation'		=> 'AND',	// AND is default
			array(
				'key' 		=> 'VideoSource',
				'value'		=> $videoSite,
			),
		);
		array_push( $meta_query, $meta );

		$query_args = array(
			'posts_per_page' 	=> $chunksize,
			'offset'		=> $offset,
			'post_type' 		=> 'any',
			'post_status' 		=> array( 'pending', 'draft', 'publish', 'private' ),
			'order'			=> 'rand',
			'cache_results'		=> false,
			'no_found_rows'		=> true,
			'update_post_meta_cache' => false,
			'update_post_term_cache' => false,
			'meta_query' 		=> $meta_query,
			'fields'		=> 'ids'
		);
		$query_args = apply_filters( 'vbp_get_posts_by_site', $query_args );

		$this->info_message( sprintf( esc_html__( '%s(%s), query args: %s', 'video-blogster' ), __FUNCTION__, $videoSite, print_r($query_args,true) ), 'notice notice-warning', 'debug' );

		wp_suspend_cache_addition(true);
		$posts = get_posts( $query_args );
		if ( empty( $posts ) ) {
			return $this->info_message( sprintf( esc_html__( '%s call to get_posts returned no results. query_args were %s', 'video-blogster' ), __FUNCTION__, print_r($query_args,true) ), 'updated', 'utility_funcs' );
		}
		$this->info_message( sprintf( esc_html__( 'Found %d videos, offset %d.', 'video-blogster' ), count($posts), $offset ), 'notice notice-warning', 'debug' );
		unset( $query_args );
		return $posts;
	}

	/*
	 * See if specific post title already exists
	 */
	public function post_title_already_exists( $title ) {
		global $wpdb;
		#MARK needed? $name = sanitize_title( $title );
		$title = addslashes( $title );
		$dbstring = "SELECT ID,post_title,post_status FROM $wpdb->posts WHERE post_title = '{$title}' AND post_status != 'inherit'";
		$dbstring = apply_filters( 'vbp_post_title_already_exists', $dbstring, $title );
		$this->info_message( sprintf( esc_html__( '%s - %s', 'video-blogster' ), __FUNCTION__, $dbstring ), 'notice notice-warning', 'debug' );
		$query = $wpdb->get_results( $dbstring );
		if ( ! empty( $query ) ) {
			$postID = $query[0]->ID;
			$link = get_edit_post_link( $postID );
			if ( $link )	// valid
				$fullLink = '<a target="_blank" href="' . $link . '">' . $postID . '</a>';
			else
				$fullLink = $postID;
			$this->info_message( sprintf( 
				esc_html__( '%s - Found duplicate title [%s] already in %s post id: %s. %s', 'video-blogster' ), 
				__FUNCTION__, 
				$title, 
				$query[0]->post_status, 
				$fullLink,
				print_r($query,true)
			), 'notice notice-warning', 'debug' );
			unset( $title );
			unset( $query );
			return 1;
		}
		$this->info_message( sprintf( esc_html__( '%s - title [%s] was not found in any existing posts.', 'video-blogster' ), __FUNCTION__, $title ), 'notice notice-warning', 'debug' );
		unset( $query );
		unset( $title );
		unset( $dbstring );
		return 0;
	}

	/*
	 * See if specific video is on the blacklist
	 * should use video ID
	 */
	public function video_on_blacklist( $videoID ) {
		if ( empty( $videoID ) ) return 0; // should never happen
		// only load blacklist once per instance
		if ( null == $this->blacklist ) {
			$this->blacklist = get_option( $this->get_my_plugin( 'prefix' ) . 'video_blacklist', array() );
		}
		foreach ( $this->blacklist as $bl ) {
			$bl = trim( $bl );
			if ( empty( $bl ) ) continue; // user entered empty line
			if ( stripos( (string)$bl, (string)$videoID ) !== FALSE ) {
				$this->info_message( sprintf( esc_html__( '%s - videoID [%s] was found in blacklist entry [%s].', 'video-blogster' ), __FUNCTION__, $videoID, $bl ), 'notice notice-warning', 'debug' );
				return 1;
			}
		}
		return 0;
	}


	/*
	 * See if specific video already exists
	 * Video Blogster - Checks using meta 'VideoSource' and the unique 'VideoID'
	 * My PHP Video Blog - Checks using meta 'mvb_vid_source' and the unique 'mvb_vid_code'
	 */
	public function post_already_exists( $videoSource, $videoID, &$status ) {

		if ( empty( $videoID ) ) {
			$this->info_message( sprintf( esc_html__( 'Video does not have a unique ID. Cannot check for videoID duplicate.', 'video-blogster' ) ), 'notice notice-warning', 'video_skip' );
		}

		$post_stati = get_post_stati();
		
	   $query_args = array(
		 	'post_type' 		=> $this->get_post_types( array( 'public' => true ), 'names' ),
		 	'post_status' 		=> $post_stati,
		 	'posts_per_page' 	=> 1,
			'cache_results'		=> false,
			'update_post_meta_cache' => false,
			'update_post_term_cache' => false,
	   );

		// Video Blogster default query check:
		$query_args['meta_query'] = array(
			array(
				'key' => 'VideoSource',
				'value' => $videoSource,
			),
			array(
				'key' => 'VideoID',
				'value' => $videoID
			)
		);
		$query_args = apply_filters( 'vbp_post_already_exists', $query_args, $videoSource, $videoID );
		if ( empty( $query_args['meta_query'] ) ) { // user did not set a meta_query so abort
			return 0;
		}

		$this->info_message( sprintf( esc_html__( 'Post already exists() get_posts query: %s', 'video-blogster' ), print_r($query_args,true) ), 'notice notice-warning', 'debug' );

 		$result = get_posts( $query_args );
		if ( is_wp_error( $result ) ) {
			return $this->info_message( sprintf( esc_html__( 'Error %s: get_posts returned - %s', 'video-blogster' ), $result->get_error_code(), $result->get_error_message() ) );
		}

		if ( empty( $result ) ) {
			return $this->info_message( sprintf( esc_html__( '%s videoID %s was not found in existing posts. No duplicate post detected.', 'video-blogster' ), $videoSource, $videoID ), 'notice notice-warning', 'debug' );
		}

		$found = array_shift( $result );	// get 1st/only result

		$postID = isset( $found->ID ) ? $found->ID : 0;
		$status = isset( $found->post_status ) ? $found->post_status : 0;

		if ( $postID ) {
			$link = get_edit_post_link( $postID );
			if ( $link )	// valid
				$fullLink = '<a target="_blank" href="' . $link . '">' . $postID . '</a>';
			else
				$fullLink = $postID;
			$this->info_message( sprintf( 
				esc_html__( 'Found duplicate videoID [%s] already in %s post id: %s.', 'video-blogster' ), 
				$videoID, 
				$status, 
				$fullLink,
			), 'notice notice-warning', 'debug' );
			return $postID;
		}
	return 0;
	}

	/*
	 * Add our own arguments onto the PUC Checker
	 */
	public function PUC_callback( $queryArgs ) {
		if ( empty( $queryArgs ) ) $queryArgs = array();
		$queryArgs['license'] = get_option( $this->get_my_plugin( 'prefix' ) . 'license' );
		$queryArgs['code'] = get_option( $this->get_my_plugin( 'prefix' ) . 'purchase_code' );
		return $queryArgs;
	}

	private function get_schedule_type( $hours, $hook ) {
		switch ( $hours ) {
			case '1':
				return 'hourly';
			case '12':
				return 'twicedaily';
			case '24':
				return 'daily';
			default:
				return $this->get_my_plugin( 'prefix' ) . $hook;
		}
	}


	/**
	 * Checks post before it is deleted to see if video should be added to video blacklist
	 */
	public function add_to_blacklist( $post_id ) {
		$blacklist_auto = get_option( $this->get_my_plugin( 'prefix' ) . 'blacklist_auto' );
		if ( FALSE == $blacklist_auto ) {
			return $post_id;
		}
		$videoID = get_post_meta( $post_id, 'VideoID', TRUE );

		if ( empty( $videoID ) ) {
			return $post_id;
		}

		$blacklist = get_option( $this->get_my_plugin( 'prefix' ) . 'video_blacklist' );

		if ( in_array( $videoID, $blacklist ) ) {
			return $post_id;
		}

		$blacklist[] = trim( $videoID );

		update_option( $this->get_my_plugin( 'prefix' ) . 'video_blacklist', $blacklist);

		return $post_id;
	}


	/*
	 * This does not catch all fatal errors like I expected.
	 */
	public function custom_shutdown_handler() {
		$error = error_get_last();
		if ( $error && $error['type'] == E_ERROR ) {
			echo 'Script shutdown error: ' . print_r( $error,true );
		}
		$this->delete_running_transient( 'sched' );
		return false;
	}

	public function custom_error_handler( $code, $string, $file, $line ) {
		if ( E_USER_ERROR == $code ) {
			$this->info_message( sprintf( esc_html__( 'Server error: %s in file %s, line %d', 'video-blogster' ), $code, $string, $file, $line ) );
		}
		return false;
	}

	/*
	 * Update image preview when selected for the Video Image
	 */
	public function vbp_get_image() {
    		if ( isset( $_GET['id'] ) ) {
        		$image = wp_get_attachment_image( filter_input( INPUT_GET, 'id', FILTER_VALIDATE_INT ), 'medium', false, array( 'id' => 'vbp-preview-image' ) );
        		$data = array(
            			'image'    => $image,
        		);
        		wp_send_json_success( $data );
    		} else {
        		wp_send_json_error();
    		}
	}

	public function number_range_select( $qNum ) {
		if ( $qNum == "-1" ) return $qNum;
		$matches = explode( '-', $qNum );
		if ( isset( $matches[1] ) ) {		// found X-Y range.
			$newNum = mt_rand( (int) $matches[0], (int) $matches[1] );
			$qNum = $newNum;
		}

		return $qNum;
		
	}

    } // END class Video_Blogster_Engine
} // END if ( ! class_exists( 'Video_Blogster_Engine' ) )

////////////////////////////////////////////////////////////////////////////////////////////

?>
