<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/**
 * Class for handling the log file
 */
if ( ! class_exists( 'Video_Blogster_Log' ) ) {
    class Video_Blogster_Log {

	private $plugin = null;
	private $logfile = null;

	protected static $instance = null;

	public function __construct() { }

	public static function getInstance() {
		if ( !isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/*
	 * Register actions and filters when object created
	 */
	public function init( $params = array() ) {
		$this->plugin = $params;
		$this->logfile = get_option( $this->get_my_plugin('prefix') . 'logfile' );
		if ( ! $this->logfile ) {
			$this->logfile = '/tmp/logfile.log';	// catchall if settings are boinked
		}
	}

	/*
	 * Wrapper to get the plugin params used to create this class object
	 */
	public function get_my_plugin( $key ) {
		return isset( $this->plugin[$key] ) ? $this->plugin[$key] : null;
	}

	/**
	 * Clear log file if 'Clear Log' pressed.
	 * Load the log-file template to display logfile.
	 */
	public function show_logfile() {
		if ( isset( $_POST['save_values'] ) )  {
			$prefix = $this->get_my_plugin( 'prefix' );
			$messages = array(
				'video_skip'		=> isset( $_POST['messages_video_skip'] ) ? true : false,
				'video_import'		=> isset( $_POST['messages_video_import'] ) ? true : false,
				'utility_funcs'		=> isset( $_POST['messages_utility_funcs'] ) ? true : false,
				'debug'			=> isset( $_POST['messages_debug'] ) ? true : false
			);
			update_option( $prefix . 'messages', $messages );

			$max = isset( $_POST['messages_max'] ) ? (int) $_POST['messages_max'] : 1000;
			update_option( $prefix . 'messages_max', $max );

			echo "<div id='message' class='updated'><p>" . esc_attr__( 'Settings saved.', 'video-blogster' ) . "</p></div>";
		}
		else if ( isset( $_POST['clear_log'] ) )  {
			$this->clear_messages();
		}

		$this->check_log_size();
		$output = $this->get_messages();
		include( sprintf( "%s/templates/log-messages.php", $this->get_my_plugin('dir') ) );
	}

	/**
	 * Writes a string to the log file
	 */
	public function write_to_log( $msg, $class = 'error', $msgtype = 'critical' ) {

		global $wpdb;
		$table_name = $wpdb->prefix . $this->get_my_plugin( 'prefix' ) . 'log';
		if ( $class == 'error' ) $level = 0;
		else if ( $msgtype == 'critical' ) $level = 1;
		else if ( $msgtype == 'video_skip' ) $level = 2;
		else if ( $msgtype == 'video_import' ) $level = 3;
		else if ( $msgtype == 'utility_funcs' ) $level = 4;
		else if ( $msgtype == 'debug' ) $level = 5;
		$logItem = array(
			'date'  => date_i18n('Y-m-d H:i:s'),
			'level'  => $level,
			'msg'   => $msg
		);
		$wpdb->insert( $table_name, $logItem );
		return 1;
	}

		/*
		 * Call after a spin to trim log db size if needed
		 */
		protected function check_log_size() {
			global $wpdb;

			$table_name = $wpdb->prefix . $this->get_my_plugin( 'prefix' ) . 'log';
			$max = (int) get_option( $this->plugin['prefix'] . 'messages_max', 1000 ); 
			if ( ! $max ) return;	// no limit
			$last_id = $wpdb->get_var( "SELECT MAX(ID) FROM ". $table_name );
			$last_id -= $max;
			if ( $last_id > 0 ) {
				$wpdb->query( 'DELETE FROM '. $table_name . ' WHERE id<=' . $last_id );
			}
		}

		/*
		 * Display any log messages
		 */
		public function get_messages( $level = 10 ) {
			global $wpdb;
			$table_name = $wpdb->prefix . $this->get_my_plugin( 'prefix' ) . 'log';
			$log = $wpdb->get_results( "SELECT * FROM ". $table_name . " WHERE level <= " . $level . " ORDER BY id", ARRAY_A );
			if ( ! is_array( $log ) || empty( $log ) ) {
				return "No entries.";
			}
			$output = '';
			#foreach ( array_reverse( $log ) as $logline ) {
			foreach ( $log as $logline ) {
				if ( $logline['level'] == 0 ) 		$output .= "<span class='vbp-error'>{$logline['date']}</span>";
				else if ( $logline['level'] == 1 ) 	$output .= "<span class='vbp-critical'>{$logline['date']}</span>";
				else $output .= "<span class='vbp-date'>{$logline['date']}</span>";
				#$output .= " - " . htmlspecialchars_decode( $logline['msg']) ;
				$output .= " - " . $logline['msg'];
				$output .= "<br>\n";
			}
			return $output;
		}


		/*
		 * Ajax call to clear history log
		 */
		public function clear_messages() {
			global $wpdb;
			if( ! current_user_can( 'moderate_comments' ) ) return;
			$table_name = $wpdb->prefix . $this->get_my_plugin( 'prefix' ) . 'log';
			$wpdb->query( 'DELETE FROM ' . $table_name );
		}



    } // END class Video_Blogster_Log
} // END if ( ! class_exists( 'Video_Blogster_Log' ) )
?>
