<?php
/**
 * Plugin Name: Video Blogster Pro
 * Plugin URI: http://www.videoblogsterpro.com/
 * Description: Queries video sites like YouTube for content and automatically creates posts from the results. 
 * Version: 4.9.0.4
 * Released: November 15th, 2025
 * Author: Super Blog Me
 * Author URI: http://www.superblogme.com/
 * This class defines the main functionality that interfaces with WordPress.
 * Following https://make.wordpress.org/core/handbook/coding-standards/php/
 * Following http://en.wikipedia.org/wiki/PHPDoc
 * License: http://codecanyon.net/licenses/terms/regular
 * Any attempt to redistribute or resell will be considered a breach of this license.
 */

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/*
 * Video Blogster Pro uses the Video Blogster Engine
 */

if ( ! class_exists( 'Video_Blogster_Engine' ) ) {
	$plugin_dir = plugin_dir_path( __FILE__ );
	require_once $plugin_dir . 'video-blogster-scheduler.php';
	require_once $plugin_dir . 'video-blogster-logfile.php';
	require_once $plugin_dir . 'video-blogster-core.php';
	require_once $plugin_dir . 'video-blogster-engine.php';
}

if ( ! function_exists('is_plugin_inactive')) {
    require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
}
$vbp_use_singleton = is_plugin_active( 'video-pornster/video-pornster.php' ) ? 0 : 1;

// instantiate the plugin class
$vbp_params = array (
	'name'		=> 'Video Blogster Pro',
	'short_name'	=> 'Video Blogster',
	'slug'		=> 'video-blogster-pro',
	'version'	=> '4.9.0.4',
	'id'		=> 'video_blogster',
	'prefix'	=> 'video_blogster_',
	'db_version'	=> '4.9',
	'dir'		=> plugin_dir_path( __FILE__ ),
	'file'          => __FILE__,
	'singleton'     => $vbp_use_singleton 
	);

$video_blogster = $vbp_use_singleton ? Video_Blogster_Engine::getInstance( $vbp_params ) : Video_Blogster_Engine::newInstance( $vbp_params );

register_activation_hook( __FILE__, array( $video_blogster, 'activate' ) );
register_deactivation_hook( __FILE__, array( $video_blogster, 'deactivate' ) );

////////////////////////////////////////////////////////////////////////////////////////////
?>
