<?php

defined( 'ABSPATH' ) or die( "Oops! This is a WordPress plugin and should not be called directly.\n" );

/*
 * Class for the Scheduler
 */
if ( ! class_exists( 'Video_Blogster_Scheduler' ) ) {
    class Video_Blogster_Scheduler {

	private $plugin = null;
	private $prefix = null;
	private $dir = null;
	protected static $instance = null;

	public function __construct() { }

	/* If SINGLETON is used, then both VBP and VP share it :( */
	public static function getInstance() {
		if ( !isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/*
	 * Register actions and filters when object created
	 */
	public function init( $params = array() ) {
		$this->plugin = $params;
		add_filter( 'cron_schedules', array( $this, 'set_schedule' ), 99 );
	}

	/*
	 * Wrapper to get the plugin params used to create this class object
	 */
	public function get_my_plugin( $key ) {
		return isset( $this->plugin[$key] ) ? $this->plugin[$key] : null;
	}

	/*
	 * Format schedule time to a readable format
	 */
	private static function format_scheduled_time ( $scheduledtime, $which ) {
		$readable = 'Not set.';
		if ( $scheduledtime ) {
			$readable = date( "Y-m-d H:i:s", $scheduledtime + ( get_option( 'gmt_offset' ) * HOUR_IN_SECONDS ) ) . " " . get_option( 'timezone_string' );
		}
		else if ( get_option( $which ) != 0 ) {
			$readable = $which . ' hook not found, likely another plugin misuse of cron_schedules. See FAQ.';
		}
		return $readable;
	}

	/*
	 * Load the scheduler template to show current status
	 */
	public function show_scheduler() {
		$this->check_for_scheduler_change();
		$current_server_time = date( 'Y-m-d H:i:s', current_time( "timestamp" ) ) . " " . get_option( 'timezone_string' );
		if ( get_option( $this->get_my_plugin('prefix') . 'sch_enabled' ) == TRUE ) {
			$transient = $this->get_my_plugin( 'prefix' ) . 'running_sched';
			$running = get_transient( $transient );
			$freq = get_option( $this->get_my_plugin('prefix') . 'sch_freq', 0 );
			$checker = get_option( $this->get_my_plugin('prefix') . 'sch_checker', 0 );
			$checker = null; // deprecated v5.0
			$next_schedule = $next_checker = 'none';

			if ( $freq ) {
				$scheduledtime = wp_next_scheduled( $this->get_my_plugin('prefix') . 'Schedule' );
				$next_schedule = $this->format_scheduled_time( $scheduledtime, $this->get_my_plugin( 'prefix' ) . 'sch_freq' );
			}
			if ( $checker ) {
				$scheduledtime = wp_next_scheduled( $this->get_my_plugin('prefix') . 'Check' );
				$next_checker = $this->format_scheduled_time( $scheduledtime, $this->get_my_plugin( 'prefix' ) . 'sch_checker' );
			}
		}
		include( sprintf( "%s/templates/scheduler.php", $this->get_my_plugin('dir') ) );
	}

	private function get_schedule_type( $hours, $hook ) {
		switch ( $hours ) {
			case '1':
				return 'hourly';
			case '12':
				return 'twicedaily';
			case '24':
				return 'daily';
			default:
				return $this->get_my_plugin( 'prefix' ) . $hook;
		}
	}

	/*
	 * Checks if a status button was pressed
	 * Enable - calculates next schedule hook times
	 * Disable - clears the schedule hooks
	 * Save - saves Scheduler options
	 */
	public function check_for_scheduler_change() {
                if ( isset( $_POST['enable_scheduler'] ) ) {
			wp_clear_scheduled_hook( $this->get_my_plugin('prefix') . 'Schedule' );
			wp_clear_scheduled_hook( $this->get_my_plugin('prefix') . 'Check' );
                        update_option( $this->get_my_plugin('prefix') . 'sch_enabled', TRUE );

			// queries:
			$start = get_option( $this->get_my_plugin('prefix') . 'sch_start' );
			$start = $this->get_schedule_time( $start );

			$freq = get_option( $this->get_my_plugin('prefix') . 'sch_freq', 0 );
			if ( ! empty( $freq ) ) {
				$scheduleType = $this->get_schedule_type( $freq, 'scheduler' );
				
                        	wp_schedule_event( time() + $start, $scheduleType, $this->get_my_plugin('prefix') . 'Schedule' );
			}

			// utility funcs:
			$start = get_option( $this->get_my_plugin('prefix') . 'util_start', 0 );
			$start = $this->get_schedule_time( $start );

			$checker = get_option( $this->get_my_plugin('prefix') . 'sch_checker' );
			$checker = null; // deprecated v5.0
			if ( ! empty( $checker ) ) {
				$scheduleType = $this->get_schedule_type( $checker, 'checker' );
                        	wp_schedule_event( time() + $start, $scheduleType, $this->get_my_plugin('prefix') . 'Check' );
			}
			echo "<div id='message' class='updated'><p>" . esc_attr__( 'Scheduler Enabled.', 'video-blogster' ) . "</p></div>";

			if ( defined( 'DISABLE_WP_CRON' ) ) {
				echo "<div id='message-cron' class='notice notice-warning'><p>" . esc_attr__( 'DISABLE_WP_CRON detected - Scheduler will only run from a cron job.', 'video-blogster' ) . "</p></div>";
			}
                }
                else if ( isset( $_POST['disable_scheduler'] ) ) {
			wp_clear_scheduled_hook( $this->get_my_plugin('prefix') . 'Schedule' );
			wp_clear_scheduled_hook( $this->get_my_plugin('prefix') . 'Check' );
                        update_option( $this->get_my_plugin('prefix') . 'sch_enabled', FALSE );

			$transient = $this->get_my_plugin( 'prefix' ) . 'running_sched';
			$running = get_transient( $transient );
			delete_transient( $transient );

			if ( empty( $running ) ) {
				echo "<div id='message' class='updated'><p>" . esc_attr__( 'Scheduler Disabled.', 'video-blogster' ) . "</p></div>";
			}
			else {
				echo "<div id='message' class='updated'><p>" . esc_attr__( 'Scheduler will be Disabled after current import is finished.', 'video-blogster' ) . "</p></div>";
			}
                }
                else if ( isset( $_POST['save_scheduler'] ) ) {
			$delay = isset( $_POST['video_blogster_sch_start'] ) ? $_POST['video_blogster_sch_start'] : 0;
			$freq = isset( $_POST['video_blogster_sch_freq'] ) ? $_POST['video_blogster_sch_freq'] : 0;
			$utildelay = isset( $_POST['video_blogster_util_start'] ) ? $_POST['video_blogster_util_start'] : 0;
			$checker = isset( $_POST['video_blogster_sch_checker'] ) ? $_POST['video_blogster_sch_checker'] : 0;
			$email_to = isset( $_POST['video_blogster_email_to'] ) ? $_POST['video_blogster_email_to'] : null;
			update_option( $this->get_my_plugin('prefix') . 'sch_start', $delay );
			update_option( $this->get_my_plugin('prefix') . 'sch_freq', $freq );
			update_option( $this->get_my_plugin('prefix') . 'util_start', $utildelay );
			update_option( $this->get_my_plugin('prefix') . 'sch_checker', $checker );
			update_option( $this->get_my_plugin('prefix') . 'email_to', $email_to );
			echo "<div id='message' class='updated'><p>" . esc_attr__( 'Settings saved.', 'video-blogster' ) . "</p></div>";
		}
	}

	/*
	 * Called by WordPress to get global schedules
	 * If scheduler Enabled, calculate and add our custom hook times
	 */
	public function set_schedule( $schedules )  {
		$prefix = $this->get_my_plugin('prefix');
		if ( ! $prefix ) {
			// Scheduler has not yet been initialized.
			return $schedules;
		}

		// add schedule entry for meta data checks
    		$scheduleName = $this->get_my_plugin( 'prefix' ) . 'metadata';
		if ( ! in_array( $scheduleName, $schedules ) ) {
			$timesecs = get_transient( 'vbp_youtube_metadata' );
			if ( ! $timesecs ) $timesecs = 60;
			if ( $timesecs > DAY_IN_SECONDS ) $timesecs = DAY_IN_SECONDS;
    			$schedules[$scheduleName] = array(
       	 			'interval' => $timesecs, 'display' => $this->get_my_plugin('short_name') . ' MetaData'
    			);
		}

		if ( get_option( $prefix . 'sch_enabled' ) == FALSE ) {
			return $schedules;
		}

		// add schedule entry for video feeds
		$hours = get_option( $this->get_my_plugin('prefix') . 'sch_freq' );
    		$scheduleName = $this->get_my_plugin( 'prefix' ) . 'scheduler';
		if ( $hours && ! in_array( $scheduleName, $schedules ) ) {
			$timesecs = $this->get_schedule_time( $hours );
    			$schedules[$scheduleName] = array(
       	 			'interval' => $timesecs, 'display' => $this->get_my_plugin('short_name') . ' Scheduler'
    			);
		}

		// add schedule entry for video checker
		$hours = get_option( $this->get_my_plugin('prefix') . 'sch_checker' );
    		$scheduleName = $this->get_my_plugin( 'prefix' ) . 'checker';
		if ( $hours && ! in_array( $scheduleName, $schedules ) ) {
			$timesecs = $this->get_schedule_time( $hours );
    			$schedules[$scheduleName] = array(
       	 			'interval' => $timesecs, 'display' => $this->get_my_plugin('short_name') . ' Utility'
    			);
		}

    		return $schedules;
	}

	private function get_schedule_time( $hours ) {
		if ( preg_match( "/(\d+)\s*-\s*(\d+)/", $hours, $matches ) ) {
			$timesecs = mt_rand( (int) $matches[1] * 3600, (int) $matches[2] * 3600 );
		}
		else {
   	 		$timesecs = $hours * 3600;
		}
		return $timesecs;
	}

    } // END class Video_Blogster_Scheduler
} // END if ( ! class_exists( 'Video_Blogster_Scheduler' ) )
?>
