jQuery(document).ready(($) => {
  const licenseForm = $('#wcvp-license-form')
  const licenseKey = $('#wcvendors_pro_license_key')
  const licenseEmail = $('#wcvendors_pro_license_email')
  const licenseStatusStr = $('.license_status')
  const button = $('#vendors_pro_license_action')
  const spinner = button.parent().find('.spinner')
  const requestNotice = $('.wcv_request_notice')

  licenseForm.on('submit', (event) => {
    event.preventDefault()

    const { nonce, action, i18n } = wcvProLicense

    $.ajax({
      url: ajaxurl,
      method: 'POST',
      data: {
        action,
        wcvendors_license_nonce: nonce,
        license_key: licenseKey.val(),
        license_email: licenseEmail.val()
      },
      success: (response) => {
        requestNotice.removeClass('color-red color-green')
        licenseStatusStr.removeClass('color-red color-green')
        if (response.success) {
          const { status, message, licenseStatus } = response.data

          switch (status) {
            case 'success':
              licenseStatusStr
                .text(i18n[licenseStatus])
                .addClass('color-green')
              requestNotice
                .text(message)
                .addClass('color-green')
                .show()
                .delay(5000)
                .fadeOut()
              break
            case 'fail':
              const expires = response.data.expires
              const statusStr =
                licenseStatus === 'expired'
                  ? `${i18n[licenseStatus]} (${expires})`
                  : i18n[licenseStatus]
              licenseStatusStr.text(statusStr).addClass('color-red')
              requestNotice
                .text(message)
                .addClass('color-red')
                .show()
                .delay(5000)
                .fadeOut()
              break
          }
        } else {
          requestNotice
            .text(response.data.message)
            .addClass('color-red')
            .show()
            .delay(5000)
            .fadeOut()
        }
      },
      error: (xhr, status, error) => {
        requestNotice
          .text(i18n.error)
          .addClass('color-red')
          .show()
          .delay(5000)
          .fadeOut()
      },
      complete: (xhr, status) => {
        button.prop('disabled', false)
        licenseEmail.prop('disabled', false)
        licenseKey.prop('disabled', false)
        spinner.css('visibility', 'hidden')
      },
      beforeSend: () => {
        button.prop('disabled', true)
        licenseEmail.prop('disabled', true)
        licenseKey.prop('disabled', true)
        spinner.css('visibility', 'visible')
      }
    })
  })

  $('.wcv-license-notice').on('click', '.notice-dismiss', function () {
    const { nonce } = wcvProLicense
    const notice = $(this).parent()

    $.ajax({
      url: ajaxurl,
      method: 'POST',
      data: {
        action: 'wcvp_dismiss_notice',
        wcvendors_license_nonce: nonce
      },
      success: (response) => {
        if (response.success) {
          notice.slideUp()
        }
      }
    })
  })
})
