<?php

/**
 * The admin country rate shipping for user and product pages
 *
 * This file is used to display the shipping type override in the edit user screen
 *
 * @link       http://www.wcvendors.com
 * @since      1.3.3
 * @version    1.8.0
 *
 * @package    WCVendors_Pro
 * @subpackage WCVendors_Pro/admin/partials/store
 */

$all_continets = WC()->countries->get_continents();
$all_countries = ( WC()->countries->get_shipping_countries() ) ? WC()->countries->get_shipping_countries() : WC()->countries->get_allowed_countries();
$row_count     = 0;
$regions       = array();
$allow_ewe     = false;
if ( 'specific' !== get_option( 'woocommerce_ship_to_countries' ) ) {
    $regions = $all_continets;
    if ( ! isset( $all_countries['EWE'] ) ) {
        $all_countries['EWE'] = __( 'Everywhere else', 'wcvendors-pro' );
        $allow_ewe            = true;
    }
} else {
    $regions = WC()->countries->get_shipping_continents();
}

$all_countries = apply_filters( 'wcvendors_shipping_table_regions', $all_countries );
?>

    <!-- Country Rate Table -->
<?php
if ( isset( $user ) ) {
    do_action( 'wcv_admin_user_before_country_rate_shipping', $user );
}
?>
    <div class="wcv-country_rate_shipping wcv-shipping-rates wcv-shipping-country">
        <?php if ( 'user-edit' === $screen->id ) : ?>
            <h3><?php esc_html_e( 'Country Rate Shipping', 'wcvendors-pro' ); ?></h3>
        <?php endif; ?>

        <div id="shipping">
            <div class="form-field wcv_shipping_rates">
                <table>
                    <thead>
                    <tr>
                        <th class="sort">&nbsp;</th>
                        <th align="left"><?php esc_html_e( 'Method Name', 'wcvendors-pro' ); ?></th>
                        <th align="left"><?php esc_html_e( 'Region / Country', 'wcvendors-pro' ); ?></th>
                        <th align="left"><?php esc_html_e( 'State', 'wcvendors-pro' ); ?> </th>
                        <th align="left"><?php esc_html_e( 'Postcode', 'wcvendors-pro' ); ?> </th>
                        <th align="left"><?php esc_html_e( 'Fee', 'wcvendors-pro' ); ?></th>
                        <th align="left"><?php esc_html_e( 'Override', 'wcvendors-pro' ); ?></th>
                        <th>&nbsp;</th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php if ( $shipping_rates ) : ?>
                        <?php foreach ( $shipping_rates as $rate ) : ?>

                            <!-- required for pro 1.4 and above -->
                            <?php
                            if ( ! array_key_exists( 'qty_override', $rate ) ) {
                                $rate['qty_override'] = '';
                            }
                            ?>
                            <?php
                            if ( ! array_key_exists( 'postcode', $rate ) ) {
                                $rate['postcode'] = '';
                            }
                            ?>
                            <?php
                            if ( ! array_key_exists( 'method_name', $rate ) ) {
                                $rate['method_name'] = '';
                            }
                            ?>

                            <tr>
                                <td class="sort"><svg class="wcv-icon wcv-icon-sm"><use xlink:href="<?php echo esc_url( WCV_PRO_PUBLIC_ASSETS_URL ); ?>svg/wcv-icons.svg#wcv-icon-sort"></use></svg></td>
                                <td class="method-name"><input type="text"
                                                        style="width: 100%;"
                                                        placeholder="<?php esc_attr_e( 'Method Name', 'wcvendors-pro' ); ?>"
                                                        name="_wcv_shipping_method_names[]"
                                                        value="<?php echo esc_attr( $rate['method_name'] ); ?>"/></td>
                                <td class="country">
                                    <select name="_wcv_shipping_countries[]" id="_wcv_shipping_countries[]"
                                            class="country_to_state country_select">
                                        <option value=""><?php esc_html_e( 'Select a country or region&hellip;', 'wcvendors-pro' ); ?></option>

                                        <?php
                                        foreach ( $regions as $key => $region ) {
                                            $countries = array_intersect( array_keys( $all_countries ), $region['countries'] );
                                            echo '<option value="continent:' . esc_attr( $key ) . '" ' . selected( esc_attr( 'continent:' . $rate['region'] ), 'continent:' . $key, false ) . '>' . esc_html( $region['name'] ) . '</option>';
                                            foreach ( $countries as $ckey ) {
                                                echo '<option value="country:' . esc_attr( $ckey ) . '" ' . selected( esc_attr( 'country:' . $rate['country'] ), 'country:' . $ckey, false ) . '>' . esc_html( '&nbsp;&nbsp;' . $all_countries[ $ckey ] ) . '</option>';
                                            }
                                        }
                                        echo $allow_ewe && isset( $all_countries['EWE'] ) ? '<option value="country:EWE" ' . selected( esc_attr( 'country:' . $rate['country'] ), 'country:EWE', false ) . '>' . esc_html__( 'Everywhere else', 'wcvendors-pro' ) . '</option>' : '';
                                        ?>

                                    </select>

                                </td>
                                <td class="state"><input type="text"
                                                        placeholder="<?php esc_attr_e( 'State', 'wcvendors-pro' ); ?>"
                                                        class="shipping_state" name="_wcv_shipping_states[]"
                                                        value="<?php echo esc_attr( $rate['state'] ); ?>"/></td>
                                <td class="postcode"><input type="text"
                                                            placeholder="<?php esc_attr_e( 'Postcode', 'wcvendors-pro' ); ?>"
                                                            name="_wcv_shipping_postcodes[]"
                                                            value="<?php echo esc_attr( $rate['postcode'] ); ?>"/></td>
                                <td class="fee"><input type="text" data-rules="decimal"
                                                        data-error="<?php esc_attr_e( 'This should be a number.', 'wcvendors-pro' ); ?>"
                                                        placeholder="<?php esc_attr_e( 'Fee', 'wcvendors-pro' ); ?>"
                                                        name="_wcv_shipping_fees[]"
                                                        value="<?php echo esc_attr( $rate['fee'] ); ?>"/></td>
                                <td class="override"><input type="checkbox"
                                                            name="_wcv_shipping_overrides[]" <?php checked( $rate['qty_override'], 'yes' ); ?> />
                                    <label><?php esc_html_e( 'QTY', 'wcvendors-pro' ); ?></label></td>
                                <td width="1%">
                                    <a href="#" class="delete">
                                        <svg class="wcv-icon wcv-icon-sm">
                                                <use xlink:href="<?php echo esc_url( WCV_PRO_PUBLIC_ASSETS_URL ); ?>svg/wcv-icons.svg#wcv-icon-times"></use>
                                        </svg>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <th colspan="8">
                            <br/>
                            <a href="#" class="button insert" style="float: left;" data-row="
                            <?php
                            ob_start();
                            require 'wcvendors-pro-shipping-country-rate-row.php';
                            $file_data_row = ob_get_clean();
                            echo esc_attr( $file_data_row );
                            ?>
                            ">
                                <?php esc_html_e( 'Add Rate', 'wcvendors-pro' ); ?></a><br/><br/>
                        </th>
                    </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
<?php if ( isset( $user ) ) {
    do_action( 'wcv_admin_user_after_country_rate_shipping', $user );
} ?>
