<?php
/**
 * Provide a meta box view for the settings page
 *
 * @link       http://www.wcvendors.com
 * @since      1.2.3
 * @version    1.5.2
 *
 * @package    WCVendors_Pro
 * @subpackage WCVendors_Pro/admin/partials
 */

?>

<table class="wc_status_table widefat" cellspacing="0">
    <thead>
    <tr>
        <th colspan="3" data-export-label="WC Vendors Pro">
            <h2>
                <?php esc_html_e( 'WC Vendors Pro', 'wcvendors-pro' ); ?>
                <?php echo wc_help_tip( __( 'This section shows information about WC Vendors Pro requirements.', 'wcvendors-pro' ) );  // phpcs:ignore ?>
            </h2>
        </th>
    </tr>
    </thead>
    <tbody>
    <tr>
        <td data-export-label="Theme compatability"><?php esc_html_e( 'Theme compatability', 'wcvendors-pro' ); ?>:</td>
        <td class="help">&nbsp;</td>
        <td>
            <?php
            if ( '' !== $woocommerce_override ) {
                echo '<mark class="error">&#10005; ' . sprintf(
                    /* translators: 1: Vendor name 2: URL to theme compatibility doc */
                    wp_kses_post( 'Your theme is not 100% WooCommerce compatible and will not display %1$s stores properly. Please show this page ( <a href="%2$s">https://docs.woothemes.com/document/third-party-custom-theme-compatibility/</a> ) to your theme author and instruct them to provide full WooCommerce compatibility, not the limited WooCommerce compatibility they currently provide by using woocommerce.php instead of full templates.', 'wcvendors-pro' ),
                    esc_html( wcv_get_vendor_name( true, false ) ),
                    'https://docs.woothemes.com/document/third-party-custom-theme-compatibility/'
                ) . '</mark>';
            } else {
                echo '-';
            }
            ?>
        </td>
    </tr>
    <tr>
        <td data-export-label="Pro Dashboard Page"><a
                    href="admin.php?page=wcv-settings&tab=display"><?php esc_html_e( 'Pro dasboard page', 'wcvendors-pro' ); ?>
                :</a></td>
        <td class="help">&nbsp;</td>
        <td>
            <?php
            if ( is_null( $vendor_dashboard_page ) ) {
                echo '<mark class="error">&#10005; - ' . sprintf(
                    /* translators: %s: URL to settings page */
                    wp_kses_post( 'WC Vendors Pro WILL NOT FUNCTION without this set. <a href="%s">Click here to set the page</a>.', 'wcvendors-pro' ),
                    'admin.php?page=wcv-settings&tab=display'
                ) . '</mark>';
            } else {
                echo '<mark class="yes">&#10004; - #' . esc_html( $vendor_dashboard_page ) . '</mark>';
            }
            ?>
        </td>
    </tr>
    <tr>
        <td data-export-label="Feedback form page"><a
                    href="admin.php?page=wcv-settings&tab=display"><?php esc_html_e( 'Feedback form page', 'wcvendors-pro' ); ?>
                :</a></td>
        <td class="help">&nbsp;</td>
        <td>
        <?php
        if ( ! $feedback_form_page ) {
            echo '<mark class="error">&#10005;  ' . sprintf(
                /* translators: 1: Vendor name 2: URL to settings page */
                wp_kses_post( '%1$s ratings will not work without this page set. <a href="%2$s">Click here to set the page</a>.', 'wcvendors-pro' ),
                esc_html( wcv_get_vendor_name( true, true ) ),
                'admin.php?page=wcv-settings&tab=display'
            ) . '</mark>';
        } else {
            echo '<mark class="yes">&#10004; - #' . esc_html( $feedback_form_page ) . '</mark>';
        }
        ?>
            </td>
    </tr>
    <tr>
        <td data-export-label="<?php echo esc_attr( wcv_get_vendor_name() ); ?> Shop Permalink"><a
                    href="admin.php?page=wcv-settings&tab=display">
                    <?php
                    printf(
                    /* translators: %s: Vendor name */
                        esc_html__( '%s Shop Permalink', 'wcvendors-pro' ),
                        esc_html( wcv_get_vendor_name() )
                    );
                        ?>
                :</a></td>
        <td class="help">&nbsp;</td>
        <td>
        <?php
        if ( '' === $vendor_shop_permalink ) {
            echo '<mark class="error">&#10005; -' . sprintf(
                /* translators: 1: Vendor name 2: URL to settings page */
                wp_kses_post( 'You need to set a %1$s store permalink. <a href="%2$s">Click here to set the slug</a>.', 'wcvendors-pro' ),
                esc_html( wcv_get_vendor_name() ),
                'admin.php?page=wcv-settings&tab=display'
            ) . '</mark>';
        } else {
            echo '<mark class="yes">&#10004; - ' . esc_html( $vendor_shop_permalink ) . '</mark>';
        }
        ?>
            </td>
    </tr>
    </tbody>
</table>
