<?php
/**
 * Product Reports reasons html
 *
 * @package WCVendors_Pro
 * @author WCVendors
 */

if ( ! defined( 'ABSPATH' ) ) {
    return;
}

$data_row = '<tr>
<td class="sort" width="20">
	<svg class="wcv-icon wcv-icon-sm" style="cursor: move; color: #999;"><use xlink:href="' . WCV_PRO_PUBLIC_ASSETS_URL . 'svg/wcv-icons.svg#wcv-icon-sort"></use></svg>
</td>
<td>
	<input type="text" class="regular-text" name="wcvendors_pro_product_reports_reasons[]" value="" placeholder="' . esc_attr__( 'Enter a report reason', 'wcvendors-pro' ) . '" style="width: 300px;" />
	<a href="#" class="delete button" title="' . esc_attr__( 'Remove', 'wcvendors-pro' ) . '" style="margin-left: 5px;">
		<span class="dashicons dashicons-no-alt" style="line-height: 28px; color: #a00;"></span>
	</a>
</td>
</tr>';
?>

<tr valign="top">
    <th class="titledesc" scope="row">
        <?php esc_html_e( 'Product Reports Reasons', 'wcvendors-pro' ); ?>
    </th>
    <td class="forminp">
        <table class="report_reason_table widefat striped" style="border: none; box-shadow: none;">
            <tbody id="wcv-report-reasons-list">
            <?php if ( ! empty( $reasons ) ) : ?>
                <?php foreach ( $reasons as $reason ) : ?>
                    <tr>
                        <td class="sort" width="20">
                            <svg class="wcv-icon wcv-icon-sm" style="cursor: move; color: #999;"><use xlink:href="<?php echo esc_attr( WCV_PRO_PUBLIC_ASSETS_URL ); ?>svg/wcv-icons.svg#wcv-icon-sort"></use></svg>
                        </td>
                        <td>
                            <input type="text" class="regular-text" name="wcvendors_pro_product_reports_reasons[]" value="<?php echo esc_attr( $reason ); ?>" style="width: 300px;" />
                            <a href="#" class="delete button" title="<?php esc_attr_e( 'Remove', 'wcvendors-pro' ); ?>" style="margin-left: 5px;">
                                <span class="dashicons dashicons-no-alt" style="line-height: 28px; color: #a00;"></span>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="2" style="padding-top: 15px;">
                        <a href="#" class="button button-primary insert" data-row="<?php echo esc_attr( $data_row ); ?>">
                            <span class="dashicons dashicons-plus-alt2" style="vertical-align: text-top; margin-right: 3px;"></span>
                            <?php esc_html_e( 'Add Reason', 'wcvendors-pro' ); ?>
                        </a>
                        <p class="description" style="margin-top: 8px;">
                            <?php esc_html_e( 'Drag and drop to reorder the reasons. These options will appear in the product report dropdown.', 'wcvendors-pro' ); ?>
                        </p>
                    </td>
                </tr>
            </tfoot>
        </table>
    </td>
</tr>
