<?php
/**
 * License Activation Section Template.
 *
 * @since 1.9.0
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<hr/>
<form method="POST" id="wcvp-license-form">
    <div class="wcv-form-row">
    <div style="width: 33%;" class="wcv-from-row-full">
        <label for="wcvendors_pro_license_key" class="wcv-form-row-label">
        <strong><?php esc_html_e( 'License Key:', 'wcvendors-pro' ); ?></strong>
        </label>
        <input type="text" name="wcvendors_pro_license_key" id="wcvendors_pro_license_key" value="<?php echo esc_attr( $license_key ); ?>" required style="width: 100%; margin-top:1em;" placeholder="<?php esc_attr_e( 'Enter your license key', 'wcvendors-pro' ); ?>">
    </div>
    <div style="width: 33%;" class="wcv-from-row-full">
        <label for="wcvendors_pro_license_email" class="wcv-form-row-label">
        <strong><?php esc_html_e( 'Activation Email:', 'wcvendors-pro' ); ?></strong>
        </label>
        <input type="email" name="wcvendors_pro_license_email" id="wcvendors_pro_license_email" value="<?php echo esc_attr( $license_email ); ?>" required style="width: 100%;margin-top:1em;" placeholder="<?php esc_attr_e( 'Enter your email address', 'wcvendors-pro' ); ?>">
    </div>
    <div style="width: 33%;align-self:flex-end;" class="wcv-from-row-full">
        <button class="button button-primary" id="vendors_pro_license_action" style="margin-top:1em;align-self:flex-end;">
            <?php echo esc_html( $button_text ); ?>
        </button>
        <span class="spinner" style="float: none;vertical-align:bottom;"></span>
    </div>
    </div>
    <p class="color-green wcv_request_notice"></p>
    <?php
    printf(
        '<br>%s <a href="%s" target="_blank">%s</a>',
        esc_html__( 'Can\'t find your license key?', 'wcvendors-pro' ),
        'https://www.wcvendors.com/my-account/?utm_source=proplugin&utm_medium=license&utm_campaign=loginmyaccountlink',
        esc_html__( 'Login to your account', 'wcvendors-pro' )
    );
    ?>
</form>
