/**
 * Retrieves the translation of text.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-i18n/
 */
import { __ } from '@wordpress/i18n';

/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */
import { useBlockProps } from '@wordpress/block-editor';
import { TextControl, CheckboxControl } from '@wordpress/components';


/**
 * The edit function describes the structure of your block in the context of the
 * editor. This represents what the editor will render when the block is used.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#edit
 *
 * @return {WPElement} Element to render.
 */
export default function Edit( { attributes, setAttributes } ) {
	const { title, showCount, showAsDropdown } = attributes;
	return (
		<div { ...useBlockProps() }>
			<TextControl
				label={ __( 'Title', 'wcvendors-pro' ) }
				onChange={ ( title ) => setAttributes( { title } ) }
				value={ title }
			/>
			<CheckboxControl
				label={ __( 'Show count', 'wcvendors-pro' ) }
				onChange={ ( showCount ) => setAttributes( { showCount } ) }
				checked={ showCount }
			/>

			<CheckboxControl
				label={ __( 'Show as dropdown', 'wcvendors-pro' ) }
				onChange={ ( showAsDropdown ) => setAttributes( { showAsDropdown } ) }
				checked={ showAsDropdown }
			/>

		</div>
	);
}
