/**
 * Retrieves the translation of text.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-i18n/
 */
import { __ } from '@wordpress/i18n';

/**
 * React hook that is used to mark the block wrapper element.
 * It provides all the necessary props like the class name.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/packages/packages-block-editor/#useblockprops
 */
import { useBlockProps } from '@wordpress/block-editor';
import { TextControl, SelectControl, CheckboxControl } from "@wordpress/components";

/**
 * The edit function describes the structure of your block in the context of the
 * editor. This represents what the editor will render when the block is used.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#edit
 *
 * @return {WPElement} Element to render.
 */
export default function Edit( { attributes, setAttributes } ) {
	const { title, heading, iconSize, showHeading, showFacebook, showTwitter, showInstagram, showPinterest, showYoutube, showLinkedin, showSnapchat, showTelegram } = attributes;
	return (
		<div { ...useBlockProps() }>
			<TextControl
				label={ __( 'Title', 'wcvendors-pro' ) }
				value={ title }
				onChange={ ( title ) => setAttributes( { title } ) }
			/>
			<SelectControl
				label={ __( 'Icon Size', 'wcvendors-pro' ) }
				value={ iconSize }
				options={ [
					{ label: __( 'Small', 'wcvendors-pro' ), value: 'sm' },
					{ label: __( 'Medium', 'wcvendors-pro' ), value: 'md' },
					{ label: __( 'Large', 'wcvendors-pro' ), value: 'lg' },
				] }
				onChange={ ( iconSize ) => setAttributes( { iconSize } ) }
			/>
			<CheckboxControl
				label={ __( 'Show Heading', 'wcvendors-pro' ) }
				checked={ showHeading }
				onChange={ ( showHeading ) => setAttributes( { showHeading } ) }
			/>
			{ showHeading && (
				<TextControl
					label={ __( 'Heading', 'wcvendors-pro' ) }
					value={ heading }
					onChange={ ( heading ) => setAttributes( { heading } ) }
				/>
			) }
			<CheckboxControl
				label={ __( 'Show Facebook', 'wcvendors-pro' ) }
				checked={ showFacebook }
				onChange={ ( showFacebook ) => setAttributes( { showFacebook } ) }
			/>
			<CheckboxControl
				label={ __( 'Show Twitter', 'wcvendors-pro' ) }
				checked={ showTwitter }
				onChange={ ( showTwitter ) => setAttributes( { showTwitter } ) }
			/>
			<CheckboxControl
				label={ __( 'Show Instagram', 'wcvendors-pro' ) }
				checked={ showInstagram }
				onChange={ ( showInstagram ) => setAttributes( { showInstagram } ) }
			/>
			<CheckboxControl
				label={ __( 'Show Pinterest', 'wcvendors-pro' ) }
				checked={ showPinterest }
				onChange={ ( showPinterest ) => setAttributes( { showPinterest } ) }
			/>
			<CheckboxControl
				label={ __( 'Show Youtube', 'wcvendors-pro' ) }
				checked={ showYoutube }
				onChange={ ( showYoutube ) => setAttributes( { showYoutube } ) }
			/>
			<CheckboxControl
				label={ __( 'Show Linkedin', 'wcvendors-pro' ) }
				checked={ showLinkedin }
				onChange={ ( showLinkedin ) => setAttributes( { showLinkedin } ) }
			/>
			<CheckboxControl
				label={ __( 'Show Snapchat', 'wcvendors-pro' ) }
				checked={ showSnapchat }
				onChange={ ( showSnapchat ) => setAttributes( { showSnapchat } ) }
			/>
			<CheckboxControl
				label={ __( 'Show Telegram', 'wcvendors-pro' ) }
				checked={ showTelegram }
				onChange={ ( showTelegram ) => setAttributes( { showTelegram } ) }
			/>
		</div>
	);
}
