<?php
/**
 * Manager blocks helper function
 */

if ( ! function_exists( 'wcv_get_store_vendor_id' ) ) {
    /**
     * Get vendor id from store
     *
     * @return int|bool
     * @version 1.8.7
     * @since   1.8.7
     */
    function wcv_get_store_vendor_id() {
        global $post;
        $vendor_id = false;
		if ( WCV_Vendors::is_vendor_page() ) {
			$vendor_shop = urldecode( get_query_var( 'vendor_shop' ) );
			$vendor_id   = WCV_Vendors::get_vendor_id( $vendor_shop );
		} elseif ( is_singular( 'product' ) && WCV_Vendors::is_vendor_product_page( $post->post_author ) ) {
			$vendor_id = $post->post_author;
		} elseif ( isset( $_GET['wcv_vendor_id'] ) ) {
			// phpcs:ignore
				$vendor_id = $_GET['wcv_vendor_id']; // phpcs:ignore

		}
        return $vendor_id;
    }
}

if ( ! function_exists( 'wcv_get_vendor_product_max_price' ) ) {
    /**
     * Get vendor product max price
     *
     * @param int $vendor_id vendor id.
     *
     * @return int
     * @version 1.8.7
     * @since   1.8.7
     */
    function wcv_get_vendor_product_max_price( $vendor_id ) {
        global $wpdb;
        $max_price = $wpdb->get_var(
            $wpdb->prepare(
                "SELECT MAX(meta_value + 0) FROM {$wpdb->postmeta} WHERE meta_key = '_price' AND post_id IN ( SELECT ID FROM {$wpdb->posts} WHERE post_author = %d AND post_type = 'product' AND post_status = 'publish' )",
                $vendor_id
            )
        );
        return round( $max_price );
    }
}

if ( ! function_exists( 'wcv_get_vendor_product_min_price' ) ) {
    /**
     * Get vendor product min price
     *
     * @param int $vendor_id vendor id.
     *
     * @return int
     * @version 1.8.7
     * @since   1.8.7
     */
    function wcv_get_vendor_product_min_price( $vendor_id ) {
        global $wpdb;
        $min_price = $wpdb->get_var(
            $wpdb->prepare(
                "SELECT MIN(meta_value + 0) FROM {$wpdb->postmeta} WHERE meta_key = '_price' AND post_id IN ( SELECT ID FROM {$wpdb->posts} WHERE post_author = %d AND post_type = 'product' AND post_status = 'publish' )",
                $vendor_id
            )
        );
        return round( $min_price );
    }
}

if ( ! function_exists( 'wcv_get_vendor_store_product_attributes' ) ) {
    /**
     * Get vendor store product attributes
     *
     * @param int   $vendor_id vendor id.
     * @param array $taxonomy_ids taxonomy ids.
     *
     * @return array
     * @version 1.8.7
     * @since   1.8.7
     */
    function wcv_get_vendor_store_product_attributes( $vendor_id, $taxonomy_ids = array() ) {
        global $wpdb;
        $attributes = array();
        foreach ( $taxonomy_ids as $taxonomy_id ) {
            $attribute = wc_get_attribute( $taxonomy_id );

            if ( ! $attribute ) {
                continue;
            }

            $slug = isset( $attribute->slug ) ? $attribute->slug : sanitize_title( $attribute->name );

            $terms_sql  = "SELECT DISTINCT t.slug, t.name, t.term_id FROM {$wpdb->terms} t INNER JOIN {$wpdb->term_taxonomy} tt ON t.term_id = tt.term_id";
            $terms_sql .= " INNER JOIN {$wpdb->term_relationships} tr ON tt.term_taxonomy_id = tr.term_taxonomy_id";
            $terms_sql .= " INNER JOIN {$wpdb->posts} p ON tr.object_id = p.ID";
            $terms_sql .= " WHERE p.post_author = %d AND p.post_type = 'product' AND p.post_status = 'publish' AND tt.taxonomy = %s";
            $terms      = $wpdb->get_results( $wpdb->prepare( $terms_sql, $vendor_id, $slug ) );  // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared
            if ( ! empty( $terms ) ) {
                $attributes[] = array(
                    'id'    => $attribute->id,
                    'slug'  => $slug,
                    'name'  => $attribute->name,
                    'terms' => $terms,
                );
            }
        }
        return $attributes;
    }
}

if ( ! function_exists( 'wcv_get_vendors_product_ratings' ) ) {
    /**
     * Get vendors product ratings
     *
     * @param int $vendor_id vendor id.
     *
     * @return array
     * @version 1.8.7
     * @since   1.8.7
     */
    function wcv_get_vendor_product_ratings( $vendor_id ) {
        global $wpdb;

        $ratings_sql  = "SELECT comment_post_ID, meta_value FROM {$wpdb->comments} c";
        $ratings_sql .= " INNER JOIN {$wpdb->commentmeta} cm ON c.comment_ID = cm.comment_id WHERE c.comment_post_ID";
        $ratings_sql .= " IN ( SELECT ID FROM {$wpdb->posts} WHERE post_author = %d AND post_type = 'product' AND post_status = 'publish' )";
        $ratings_sql .= " AND cm.meta_key = 'rating' AND c.comment_approved = '1' AND cm.meta_value != '0'";

        $ratings = $wpdb->get_results( $wpdb->prepare( $ratings_sql, $vendor_id ) ); // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared
        return $ratings;
    }
}
