<?php

use WC_Vendors\Classes\Front\WCV_Table_Helper;

/**
 * Table Helper Class
 *
 * Defines relevant methods for generating a display table for public facing pages.
 *
 * @package    WCVendors_Pro
 * @subpackage WCVendors_Pro/public
 * @author     Jamie Madden <support@wcvendors.com>
 */
class WCVendors_Pro_Table_Helper extends WCV_Table_Helper { //phpcs:ignore

    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string $wcvendors_pro The ID of this plugin.
     */
    private $wcvendors_pro;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string $version The current version of this plugin.
     */
    private $version;

    /**
     * The table id.
     *
     * @since    1.0.0
     * @access   private
     * @var      string $id The table id
     */
    private $id;

    /**
     * The tables header rows
     *
     * @since    1.0.0
     * @access   private
     * @var      array $columns The table columns
     */
    private $columns;

    /**
     * The table rows
     *
     * @since    1.0.0
     * @access   private
     * @var      array $rows The table rows
     */
    private $rows;

    /**
     * The tables row action
     *
     * @since    1.0.0
     * @access   private
     * @var      array $actions The table row actions
     */
    private $actions;

    /**
     * The column to display action
     *
     * @since    1.0.0
     * @access   private
     * @var      string $action_column The column key from $this->actions
     */
    private $action_column;

    /**
     * The post_type for this table
     *
     * @since    1.0.0
     * @access   private
     * @var      string $post_type The post type to display
     */
    private $post_type;

    /**
     * The vendor id of the products for this table
     *
     * @since    1.0.0
     * @access   private
     * @var      int $vendor The vendor id of the post type.
     */
    private $vendor_id;

    /**
     * The max number of pages for the results
     *
     * @since    1.0.0
     * @access   private
     * @var      int $vendor The vendor id of the post type.
     */
    public $max_num_pages;

    /**
     * The wrapper HTML element.
     *
     * @var string
     * @version 1.0.0
     * @since   1.0.0
     */
    public $container_wrap;

    /**
     * Initialize the class and set its properties.
     *
     * @since    1.0.0
     *
     * @param string $wcvendors_pro The name of the plugin.
     * @param string $version       The version of this plugin.
     * @param string $id            The table id used to reference the table.
     * @param string $post_type     The post type.
     * @param int    $vendor_id     The vendor id.
     */
    public function __construct( $wcvendors_pro, $version, $id, $post_type, $vendor_id ) {

        $this->wcvendors_pro  = $wcvendors_pro;
        $this->version        = $version;
        $this->id             = $id;
        $this->post_type      = $post_type;
        $this->vendor_id      = $vendor_id;
        $this->container_wrap = true;

        $this->set_defaults();
        parent::__construct( $this->wcvendors_pro, $this->version, $this->id, $this->post_type, $this->vendor_id );
    }
}
