<?php
/**
 * Store opening hours form
 *
 * This file is used to load the store opening hours form
 *
 * @link       http://www.wcvendors.com
 * @since      1.5.9
 * @version    1.7.4
 *
 * @package    WCVendors_Pro
 * @subpackage WCVendors_Pro/public/partials/settings
 */

$time_format = apply_filters( 'wcv_opening_hours_time_format', wc_time_format() );
$labels      = wcv_days_labels();
$times       = apply_filters(
    'wcv_store_opening_times',
    array_merge(
        get_time_interval_options(),
        array(
            array( 'closed' => __( 'Closed', 'wcvendors-pro' ) ),
            array( 'open' => __( 'Open All Day', 'wcvendors-pro' ) ),
        )
    )
);
unset( $labels['closed'] );
unset( $labels['open'] );
?>

<div class="wcv-column-group wcv-horizontal-gutters wcv-opening-hours-wrapper">
    <p class="blue-title text-blue"><?php esc_html_e( 'Store opening hours', 'wcvendors-pro' ); ?></p>

    <?php wp_nonce_field( 'save_vendor_opening_hours' ); ?>

    <table class="form-table has-background">
        <thead>
        <tr>
            <th><?php esc_html_e( '&nbsp;', 'wcvendors-pro' ); ?></th>
            <th style="width:50%;"><?php esc_html_e( 'Business Days', 'wcvendors-pro' ); ?></th>
            <th style="width:25%;"><?php esc_html_e( 'Opening', 'wcvendors-pro' ); ?></th>
            <th style="width:25%;"><?php esc_html_e( 'Closing', 'wcvendors-pro' ); ?></th>
            <th><?php esc_html_e( 'Actions', 'wcvendors-pro' ); ?></th>
        </tr>
        </thead>
        <tbody id="opening-hours">
        <?php foreach ( $hours as $opening ) : ?>
            <?php
            if ( ! isset( $labels[ $opening['day'] ] ) ) {
                continue;
            }
            $hide_closing = 'open' === $opening['open'] || 'closed' === $opening['open'] ? 'hide-closing' : '';
            ?>
            <tr>
                <td class="col-status">
                    <label class="mobile_header"><?php esc_html_e( 'Status', 'wcvendors-pro' ); ?></label>
                    <input type="hidden" name="status[]" value="<?php echo esc_attr( $opening['status'] ); ?>" />
                    <label class="wcv-checkbox-container">
                        <input type="checkbox" 
                                class="status" 
                                <?php checked( $opening['status'], '1' ); ?> />
                        <span class="checkmark"></span>
                    </label>
                </td>
                <td class="col-business-days">
                    <label class="mobile_header"><?php esc_html_e( 'Business Days', 'wcvendors-pro' ); ?></label>
                    <select name="days[]" class="opening-day-select">
                        <?php foreach ( $labels as $key => $label ) : ?>
                            <option value="<?php echo esc_attr( $key ); ?>" <?php selected( $opening['day'], $key ); ?>><?php echo esc_html( $label ); ?></option>
                        <?php endforeach; ?>
                    </select>
                </td>
                <td class="col-opening">
                    <label class="mobile_header"><?php esc_html_e( 'Opening', 'wcvendors-pro' ); ?></label>
                    <select name="open[]" class="opening-hours-select">
                        <?php foreach ( $times as $time_option ) : ?>
                            <?php
                            $time_value = key( $time_option );
                            $time_label = current( $time_option );
                            ?>
                            <option value="<?php echo esc_attr( $time_value ); ?>" 
                                <?php selected( $time_value, $opening['open'] ); ?>>
                                <?php echo esc_html( $time_label ); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
 
                </td>
                <td class="col-closing <?php echo esc_attr( $hide_closing ); ?>">
                    <?php $hidden_class = 'closed' === $opening['open'] || 'open' === $opening['open'] ? 'hidden' : ''; ?>
                    <label class="mobile_header"><?php esc_html_e( 'Closing', 'wcvendors-pro' ); ?></label>
                    <select name="close[]" class="closing-hours-select <?php echo esc_attr( $hidden_class ); ?>">
                        <?php foreach ( $times as $time_option ) : ?>
                            <?php
                            $time_value = key( $time_option );
                            $time_label = current( $time_option );
                            if ( 'open' === $time_value || 'closed' === $time_value ) {
                                continue;
                            }
                            ?>
                            <option value="<?php echo esc_attr( $time_value ); ?>" 
                                <?php selected( $time_value, $opening['close'] ); ?>>
                                <?php echo esc_html( $time_label ); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </td>
                <td class="wcv-actions">
                    <div class="wcv-actions-wrapper">
                        <a href="#" class="remove-row row-action" title="<?php esc_attr_e( 'Remove this Row', 'wcvendors-pro' ); ?>">
                            <?php wcvp_get_icon( 'wcv-icon wcv-icon-24 wcv-icon-middle', 'wcv-icon-trash' ); ?>
                            <span class="wcv-tooltiptext"><?php esc_html_e( 'Remove', 'wcvendors-pro' ); ?></span>
                        </a>
                        <div class="more-actions row-action">
                            <div class="more-actions-trigger">
                                <?php wcvp_get_icon( 'wcv-icon wcv-icon-24 wcv-icon-middle', 'wcv-icon-three-dots' ); ?>
                                <span class="wcv-tooltiptext"><?php esc_html_e( 'More Actions', 'wcvendors-pro' ); ?></span>
                            </div>
                            <ul class="sub-actions hidden">
                                <li>
                                    <a href="#" class="add-row-above" title="<?php esc_attr_e( 'Add Row Above', 'wcvendors-pro' ); ?>">
                                        <?php wcvp_get_icon( 'wcv-icon wcv-icon-sm wcv-icon-middle wcv-icon-left', 'wcv-icon-plus-circle' ); ?>
                                        <span class="vertical-middle"><?php esc_html_e( 'Add Row Above', 'wcvendors-pro' ); ?></span>
                                    </a>
                                </li>
                                <li>
                                    <a href="#" class="add-row-below" title="<?php esc_attr_e( 'Add Row Below', 'wcvendors-pro' ); ?>">
                                        <?php wcvp_get_icon( 'wcv-icon wcv-icon-sm wcv-icon-middle wcv-icon-left', 'wcv-icon-plus-circle' ); ?>
                                        <span class="vertical-middle"><?php esc_html_e( 'Add Row Below', 'wcvendors-pro' ); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
    <div class="align-center top-space bottom-space">
        <a href="#" id="add-work-hours" class="wcv-button text-blue wcv-button-link-secondary" title="<?php esc_html_e( 'Add New Hour', 'wcvendors-pro' ); ?>">
            <?php echo wp_kses( wcv_get_icon( 'wcv-icon wcv-icon-left wcv-icon-24 wcv-icon-middle', 'wcv-icon-plus-circle' ), wcv_allowed_html_tags() ); ?>
            <span class="vertical-middle"><?php esc_html_e( 'Add New Hour', 'wcvendors-pro' ); ?></span>
        </a>
    </div>
</div>
