<?php
/**
 * Class for Rank Math SEO Compatibility
 *
 * @package WCVendors_Pro
 *
 * @since 1.8.7
 * @version 1.8.7
 */
class WCV_RankMath_Compatibility extends WCV_SEO_Compatibility {

    /**
     * Construct
     *
     * @since 1.8.7
     * @version 1.8.7
     */
    public function __construct() {
        parent::__construct();
        $this->init_hooks();
    }

    /**
     * Init hooks
     *
     * @since 1.8.7
     * @version 1.8.7
     */
    public function init_hooks() {
        global $post;
        if ( $this->is_vendor_store_page ) {
            add_filter( 'rank_math/frontend/title', array( $this, 'override_site_title' ), 10, 1 );
            add_filter( 'rank_math/frontend/description', array( $this, 'override_store_description' ), 10, 1 );
            add_filter( 'rank_math/opengraph/facebook/og_site_name', array( $this, 'override_site_name_title' ), 10, 1 );
            add_filter( 'rank_math/opengraph/facebook/og_title', array( $this, 'override_store_og_title' ), 10, 1 );
            add_filter( 'rank_math/opengraph/facebook/og_description', array( $this, 'override_store_og_description' ), 10, 1 );
            add_filter( 'rank_math/opengraph/facebook/og_url', array( $this, 'override_store_og_url' ), 10, 1 );
            add_filter( 'rank_math/opengraph/facebook/og_image', array( $this, 'override_store_og_image' ), 10, 1 );
            add_filter( 'rank_math/opengraph/twitter/twitter_title', array( $this, 'override_store_twitter_title' ), 10, 1 );
            add_filter( 'rank_math/opengraph/twitter/twitter_description', array( $this, 'override_store_twitter_description' ), 10, 1 );
            add_filter( 'rank_math/opengraph/twitter/twitter_image', array( $this, 'override_store_twitter_image' ), 10, 1 );
        }

        if ( $this->is_product_page ) {

            add_filter( 'rank_math/frontend/description', array( $this, 'override_product_og_description' ), 10, 1 );

            if ( $this->is_og_enable() ) {
                add_filter( 'rank_math/opengraph/facebook/og_title', array( $this, 'override_product_og_title' ), 10, 1 );
                add_filter( 'rank_math/opengraph/facebook/og_url', array( $this, 'override_product_og_url' ), 10, 1 );
                add_filter( 'rank_math/opengraph/facebook/og_site_name', array( $this, 'override_site_name_title' ), 10, 1 );
            }

            if ( $this->is_twitter_card_enable() ) {
                add_filter( 'rank_math/opengraph/twitter/twitter_title', array( $this, 'override_product_twitter_title' ), 10, 1 );
                add_filter( 'rank_math/opengraph/twitter/twitter_description', array( $this, 'override_product_twitter_description' ), 10, 1 );
            }
        }
    }

    /**
     * Is enable
     *
     * @since 1.8.7
     * @version 1.8.7
     *
     * @return bool
     */
    public function is_enable() {
        return is_plugin_active( 'seo-by-rank-math/rank-math.php' );
    }
}
new WCV_RankMath_Compatibility();
