<?php
/**
 * Class for Yoast SEO Compatibility
 *
 * @package WCVendors_Pro
 *
 * @since 1.8.7
 * @version 1.8.7
 */
class WCV_Yoast_Compatibility extends WCV_SEO_Compatibility {
    /**
     * Construct
     *
     * @since 1.8.7
     * @version 1.8.7
     */
    public function __construct() {
        parent::__construct();
        $this->init_hooks();
    }

    /**
     * Init hooks
     *
     * @since 1.8.7
     * @version 1.8.7
     */
    public function init_hooks() {
        if ( $this->is_vendor_store_page ) {
            add_filter( 'wpseo_title', array( $this, 'override_site_title' ), 10, 1 );
            add_filter( 'wpseo_metadesc', array( $this, 'override_store_description' ), 10, 1 );
            add_filter( 'wpseo_opengraph_title', array( $this, 'override_store_og_title' ), 10, 1 );
            add_filter( 'wpseo_opengraph_desc', array( $this, 'override_store_og_description' ), 10, 1 );
            add_filter( 'wpseo_opengraph_url', array( $this, 'override_store_og_url' ), 10, 1 );
            add_filter( 'wpseo_opengraph_site_name', array( $this, 'override_site_name_title' ), 10, 1 );
            add_filter( 'wpseo_opengraph_image', array( $this, 'override_store_og_image' ), 10, 1 );
            add_filter( 'wpseo_twitter_image', array( $this, 'override_store_twitter_image' ), 10, 1 );
            add_filter( 'wpseo_twitter_site', array( $this, 'override_twitter_site' ), 10, 1 );
        }

        if ( $this->is_product_page ) {
            add_filter( 'wpseo_title', array( $this, 'override_product_og_title' ), 10, 1 );

            if ( $this->is_og_enable() ) {

                add_filter( 'wpseo_opengraph_title', array( $this, 'override_product_og_title' ), 10, 1 );
                add_filter( 'wpseo_metadesc', array( $this, 'override_product_og_description' ), 10, 1 );
                add_filter( 'wpseo_opengraph_desc', array( $this, 'override_product_og_description' ), 10, 1 );
                add_filter( 'wpseo_opengraph_site_name', array( $this, 'override_product_og_site_name' ), 10, 1 );
                add_filter( 'wpseo_opengraph_url', array( $this, 'override_product_og_url' ), 10, 1 );

            }

            if ( $this->is_twitter_card_enable() ) {
                add_filter( 'wpseo_twitter_site', array( $this, 'override_twitter_site' ), 10, 1 );
            }
        }
    }

    /**
     * Is enable
     *
     * @return bool
     * @since 1.8.7
     * @version 1.8.7
     */
    public function is_enable() {
        return is_plugin_active( 'wordpress-seo/wp-seo.php' );
    }
}
new WCV_Yoast_Compatibility();
