<?php
/**
 * The shipping country rate row template
 *
 * This file is used to generate new shipping rate rows via JavaScript
 *
 * @link       http://www.wcvendors.com
 * @since      1.8.0
 * @version    1.8.0
 *
 * @package    WCVendors_Pro
 * @subpackage WCVendors_Pro/admin/partials/vendor
 */

// Default empty rate.
$rate = array(
    'region'       => '',
    'country'      => '',
    'method_name'  => '',
    'state'        => '',
    'postcode'     => '',
    'fee'          => '',
    'qty_override' => '',
);
?>
<tr>
    <td class="sort"><svg class="wcv-icon wcv-icon-sm"><use xlink:href="<?php echo esc_url( WCV_PRO_PUBLIC_ASSETS_URL ); ?>svg/wcv-icons.svg#wcv-icon-sort"></use></svg></td>
    <td class="method-name"><input style="width: 100%;" type="text" placeholder="<?php esc_attr_e( 'Method Name', 'wcvendors-pro' ); ?>" name="_wcv_shipping_method_names[]" value="<?php echo esc_attr( $rate['method_name'] ); ?>" /></td>
    <td class="country" data-title="<?php esc_attr_e( 'Country', 'wcvendors-pro' ); ?>">
        <select name="_wcv_shipping_countries[]" id="_wcv_shipping_countries[]" class="country_to_state country_select">
            <option value=""><?php esc_html_e( 'Select a country or region&hellip;', 'wcvendors-pro' ); ?></option>
            <?php
            foreach ( $regions as $key => $region ) {
                $countries = array_intersect( array_keys( $all_countries ), $region['countries'] );
                echo '<option value="continent:' . esc_attr( $key ) . '" ' . selected( esc_attr( $rate['country'] ), $key, false ) . '>' . esc_html( $region['name'] ) . '</option>';
                foreach ( $countries as $ckey ) {
                    echo '<option value="country:' . esc_attr( $ckey ) . '" ' . selected( esc_attr( $rate['country'] ), $ckey, false ) . '>' . esc_html( '&nbsp;&nbsp;' . $all_countries[ $ckey ] ) . '</option>';
                }
            }
            echo $allow_ewe && isset( $all_countries['EWE'] ) ? '<option value="country:EWE" ' . selected( esc_attr( 'country:' . $rate['country'] ), 'country:EWE', false ) . '>' . esc_html__( 'Everywhere else', 'wcvendors-pro' ) . '</option>' : '';
            ?>
        </select>
    </td>
    <td class="state"><input type="text" placeholder="<?php esc_attr_e( 'State', 'wcvendors-pro' ); ?>" class="shipping_state" name="_wcv_shipping_states[]" value="<?php echo esc_attr( $rate['state'] ); ?>" /></td>
    <td class="postcode"><input type="text" placeholder="<?php esc_attr_e( 'Postcode', 'wcvendors-pro' ); ?>" name="_wcv_shipping_postcodes[]" value="<?php echo esc_attr( $rate['postcode'] ); ?>" /></td>
    <td class="fee"><input type="text" data-error="<?php esc_attr_e( 'This should be a number.', 'wcvendors-pro' ); ?>" data-rules="decimal" placeholder="<?php esc_attr_e( 'Fee', 'wcvendors-pro' ); ?>" name="_wcv_shipping_fees[]" value="<?php echo esc_attr( $rate['fee'] ); ?>" /></td>
    <td class="override"><input type="checkbox" name="_wcv_shipping_overrides[]" <?php checked( $rate['qty_override'], 'yes' ); ?> /><label><?php esc_html_e( 'QTY', 'wcvendors-pro' ); ?></label></td>
    <td width="1%"><a href="#" class="delete"><svg class="wcv-icon wcv-icon-sm"><use xlink:href="<?php echo esc_url( WCV_PRO_PUBLIC_ASSETS_URL ); ?>svg/wcv-icons.svg#wcv-icon-times"></use></svg></a></td>
</tr>
