<?php
/**
 * Settings: Product Reports
 *
 * @package     WCVendors_Pro
 * @author      WC Vendors
 */

/**
 * Class WCVendors_Pro_Settings_Product_Reports
 */
class WCvendors_Pro_Setting_Product_Reports extends WCVendors_Settings_Page {

        /**
         * Constructor.
         */
    public function __construct() {
        $this->id    = 'product_reports';
        $this->label = __( 'Product Reports', 'wcvendors-pro' );

        parent::__construct();
    }

    /**
     * Get sections.
     *
     * @return array
     */
    public function get_sections() {
        $sections = array(
            '' => __( 'General', 'wcvendors-pro' ),
        );

        return apply_filters( 'wcvendors_get_sections_' . $this->id, $sections );
    }

    /**
     * Get settings array.
     *
     * @param string $current_section Current section name.
     * @return array
     */
    public function get_settings( $current_section = '' ) {

        if ( '' === $current_section ) {

            $settings = apply_filters(
                'wcvendors_pro_settings_product_reports_general',
                array(
                    array(
                        'title' => __( 'General', 'wcvendors-pro' ),
                        'type'  => 'title',
                        'desc'  => 'General options for the report product system.',
                        'id'    => 'product_reports_options',
                    ),
                    array(
                        'type'    => 'checkbox',
                        'id'      => 'wcvendors_pro_product_reports_enabled',
                        'name'    => __( 'Enable Product Reports', 'wcvendors-pro' ),
                        'desc'    => __( 'Enable product reports feature.', 'wcvendors-pro' ),
                        'default' => 'no',
                    ),
                    array(
                        'type'        => 'text',
                        'id'          => 'wcvendors_pro_product_reports_button_label',
                        'name'        => __( 'Button Label', 'wcvendors-pro' ),
                        'desc'        => __( 'The text to display on the report button or link.', 'wcvendors-pro' ),
                        'default'     => __( 'Report this product', 'wcvendors-pro' ),
                        'placeholder' => __( 'Report this product', 'wcvendors-pro' ),
                    ),
                    array(
                        'type'        => 'text',
                        'id'          => 'wcvendors_pro_product_reports_popup_title',
                        'name'        => __( 'Popup Title', 'wcvendors-pro' ),
                        'desc'        => __( 'The title text displayed in the report popup.', 'wcvendors-pro' ),
                        'default'     => __( 'Report product', 'wcvendors-pro' ),
                        'placeholder' => __( 'Report product', 'wcvendors-pro' ),
                    ),
                    array(
                        'type'        => 'text',
                        'id'          => 'wcvendors_pro_product_reports_select_reason_label',
                        'name'        => __( 'Select Reason Label', 'wcvendors-pro' ),
                        'desc'        => __( 'The label text displayed in the select reason dropdown.', 'wcvendors-pro' ),
                        'default'     => __( 'Select a reason', 'wcvendors-pro' ),
                        'placeholder' => __( 'Select a reason', 'wcvendors-pro' ),
                    ),
                    array(
                        'type'        => 'text',
                        'id'          => 'wcvendors_pro_product_reports_description_input_label',
                        'name'        => __( 'Description Input Label', 'wcvendors-pro' ),
                        'desc'        => __( 'The label text displayed in the description input field.', 'wcvendors-pro' ),
                        'default'     => __( 'Tell us about the issue', 'wcvendors-pro' ),
                        'placeholder' => __( 'Tell us about the issue', 'wcvendors-pro' ),
                    ),
                    array(
                        'type'    => 'select',
                        'id'      => 'wcvendors_pro_product_reports_display_style',
                        'name'    => __( 'Display Style', 'wcvendors-pro' ),
                        'desc'    => __( 'Choose how the report option is displayed on the product page.', 'wcvendors-pro' ),
                        'default' => 'link',
                        'options' => array(
                            'button' => __( 'Button', 'wcvendors-pro' ),
                            'link'   => __( 'Link', 'wcvendors-pro' ),
                        ),
                    ),
                    array(
                        'type'    => 'checkbox',
                        'id'      => 'wcvendors_pro_product_reports_visibility_loggedin',
                        'name'    => __( 'Show for Logged-in Users', 'wcvendors-pro' ),
                        'desc'    => __( 'Show the report option to logged-in users.', 'wcvendors-pro' ),
                        'default' => 'yes',
                    ),
                    array(
                        'type'    => 'checkbox',
                        'id'      => 'wcvendors_pro_product_reports_visibility_loggedout',
                        'name'    => __( 'Show for Logged-out Users', 'wcvendors-pro' ),
                        'desc'    => __( 'Show the report option to logged-out users (will require login to submit).', 'wcvendors-pro' ),
                        'default' => 'no',
                    ),
                    array(
                        'type' => 'product_reports_reason',
                        'id'   => 'wcvendors_pro_product_reports_reasons',
                    ),
                    array(
                        'title'   => __( 'Enable New Report Email Notification', 'wcvendors-pro' ),
                        'desc'    => __( 'Send an email to the admin when a new report is submitted.', 'wcvendors-pro' ),
                        'id'      => 'wcvendors_pro_product_reports_email_notification',
                        'default' => 'yes',
                        'type'    => 'checkbox',
                    ),
                    array(
                        'type' => 'sectionend',
                        'id'   => 'product_reports_options_end',
                    ),
                )
            );
            return apply_filters( 'wcvendors_get_settings_' . $this->id, $settings, $current_section );
        }
    }
}
return new WCvendors_Pro_Setting_Product_Reports();
