<?php

/**
 * The feedback edit form
 *
 * This file is used to display the feedback edit form on the backend.
 *
 * @link       http://www.wcvendors.com
 * @since      1.0.0
 * @version    1.3.3
 *
 * @package    WCVendors_Pro
 * @subpackage WCVendors_Pro/includes/partials/ratings
 */

$user      = get_userdata( stripslashes( $feedback->vendor_id ) );
$vendor_id = '<a href="' . esc_url( admin_url( 'user-edit.php?user_id=' . stripslashes( $feedback->vendor_id ) ) ) . '">' . esc_html( WCV_Vendors::get_vendor_shop_name( stripslashes( $feedback->vendor_id ) ) ) . '</a>';

$product_title = get_the_title( stripslashes( $feedback->product_id ) );
// Handle deleted products gracefully.
if ( empty( $product_title ) ) {
    $product_link = esc_html__( 'Deleted Product', 'wcvendors-pro' );
} else {
    $product_link = '<a href="' . esc_url( admin_url( 'post.php?post=' . stripslashes( $feedback->product_id ) . '&action=edit' ) ) . '">' . esc_html( $product_title ) . '</a>';
}

$order_link = '<a href="' . esc_url( admin_url( 'post.php?post=' . stripslashes( $feedback->order_id ) . '&action=edit' ) ) . '">' . esc_html( stripslashes( $feedback->order_id ) ) . '</a>';

$customer_user = get_userdata( stripslashes( $feedback->customer_id ) );
// Handle deleted customers gracefully.
if ( $customer_user && ! empty( $customer_user->display_name ) ) {
    $customer = '<a href="' . esc_url( admin_url( 'user-edit.php?user_id=' . stripslashes( $feedback->customer_id ) ) ) . '">' . esc_html( $customer_user->display_name ) . '</a>';
} else {
    $customer = esc_html__( 'Unknown Customer', 'wcvendors-pro' );
}

$postdate = date_i18n( get_option( 'date_format' ), strtotime( $feedback->postdate ) );


?>

<form action="" method="post">
    <input type="hidden" name="rating_id" value="<?php echo esc_attr( $feedback->id ); ?>"/>
    <input type="hidden" name="action" value="save"/>

    <h3>
        <?php
        // translators: %s is the vendor name.
        printf( esc_html__( 'Edit %s Rating', 'wcvendors-pro' ), esc_html( wcv_get_vendor_name() ) );
        ?>
    </h3>
    <h4><?php esc_html_e( 'Rating Details', 'wcvendors-pro' ); ?></h4>
    <p>
        <?php
        // translators: 1: Order link, 2: Customer name, 3: Product link, 4: Post date.
        printf(
            /* translators: 1: Order link, 2: Customer name, 3: Product link, 4: Post date. */
            wp_kses_post( __( '<strong>Order #: %1$s</strong>| Posted by : %2$s for %3$s on %4$s', 'wcvendors-pro' ) ),
            wp_kses_post( $order_link ),
            wp_kses_post( $customer ),
            wp_kses_post( $product_link ),
            esc_html( $postdate )
        );
        ?>
    </p>

    <table class="form-table wcv-form-table">
        <tbody>
        <tr>
            <th scope="row">
                <label for="rating"><?php esc_html_e( 'Feedback rating', 'wcvendors-pro' ); ?></label>
            </th>

            <td>
                <?php
                $rating       = '';
                $rating_value = (int) stripslashes( $feedback->rating );
                $rating_max   = 5;

                for ( $i = 1; $i <= $rating_value; $i++ ) {
                    $rating .= '<svg class="wcv-icon wcv-icon-sm">
						<use xlink:href="' . esc_url( WCV_PRO_PUBLIC_ASSETS_URL . 'svg/wcv-icons.svg' ) . '#wcv-icon-star"></use>
					</svg>';
                }
                for ( $i = $rating_value; $i < $rating_max; $i++ ) {
                    $rating .= '<svg class="wcv-icon wcv-icon-sm">
						<use xlink:href="' . esc_url( WCV_PRO_PUBLIC_ASSETS_URL . 'svg/wcv-icons.svg' ) . '#wcv-icon-star-o"></use>
					</svg>';
                }
                echo wp_kses(
                    $rating,
                    array(
                        'svg' => array(
                            'class' => array(),
                        ),
                        'use' => array(
                            'xlink:href' => array(),
                        ),
                    )
                );
                ?>
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="rating_title"><?php esc_html_e( 'Feedback title', 'wcvendors-pro' ); ?></label>
            </th>

            <td>
                <input type="text" value="<?php echo esc_attr( $feedback->rating_title ); ?>" id="rating_title" name="rating_title">
                <br>
                <span class="description"><?php esc_html_e( 'The feedback title.', 'wcvendors-pro' ); ?></span>
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="comments"><?php esc_html_e( 'Feedback comment', 'wcvendors-pro' ); ?></label>
            </th>

            <td>
                <textarea id="rating_comments" name="rating_comments"><?php echo esc_textarea( $feedback->comments ); ?></textarea>
                <br>
                <span class="description"><?php esc_html_e( 'The feedback comment.', 'wcvendors-pro' ); ?></span>
            </td>
        </tr>
        </tbody>
    </table>
    <p class="submit"><input type="submit" value="Save changes" class="button-primary" name="Submit"></p>
</form>
