<?php
/**
 * Ratings link
 *
 * This file is used to display the ratings link
 *
 * @link       http://www.wcvendors.com
 * @since      1.0.0
 * @version    1.4.5
 *
 * @package    WCVendors_Pro
 * @subpackage WCVendors_Pro/includes/partials/ratings
 */

$ratings_text  = sprintf( _n( 'rating', 'ratings', $ratings_count, 'wcvendors-pro' ), number_format_i18n( $ratings_count ) );
$ratings_count = (int) $ratings_count;
?>

<?php if ( 0 === $ratings_count && $feedback_system ) { ?>
    <?php for ( $i = 1; $i <= 5; $i++ ) { ?>
        <svg class="wcv-icon wcv-icon-sm">
            <use xlink:href="<?php echo esc_url_raw( WCV_PRO_PUBLIC_ASSETS_URL ); ?>svg/wcv-icons.svg#wcv-icon-star"></use>
        </svg>
    <?php } ?>
<?php } elseif ( 0 === $ratings_count && ! $feedback_system ) { ?>
    <?php for ( $i = 1; $i <= 5; $i++ ) { ?>
        <svg class="wcv-icon wcv-icon-sm">
            <use xlink:href="<?php echo esc_url_raw( WCV_PRO_PUBLIC_ASSETS_URL ); ?>svg/wcv-icons.svg#wcv-icon-star-o"></use>
        </svg>
    <?php } ?>
    <?php printf( '( %s %s )', esc_attr( $ratings_count ), esc_attr( $ratings_text ) ); ?>
<?php } else { ?>
    <?php
    if ( $link ) {
        ?>
        <a href="<?php echo esc_url_raw( $url ); ?>"><?php } ?>
    <?php for ( $i = 1; $i <= number_format( $ratings_average ); $i++ ) { //phpcs:ignore ?>
        <svg class="wcv-icon wcv-icon-sm">
            <use xlink:href="<?php echo esc_url_raw( WCV_PRO_PUBLIC_ASSETS_URL ); ?>svg/wcv-icons.svg#wcv-icon-star"></use>
        </svg>
    <?php } ?>
    <?php for ( $i = number_format( $ratings_average ); $i < 5; $i++ ) { ?>
        <svg class="wcv-icon wcv-icon-sm">
            <use xlink:href="<?php echo esc_url_raw( WCV_PRO_PUBLIC_ASSETS_URL ); ?>svg/wcv-icons.svg#wcv-icon-star-o"></use>
        </svg>
    <?php } ?>
    <span class="text">
        <?php printf( '( %s %s ) %s', esc_attr( $ratings_count ), esc_attr( $ratings_text ), wp_kses_post( $link_text ) ); ?>
    </span>
    <?php
    if ( $link ) {
        ?>
        </a>
    <?php } ?>

<?php } ?>
