<?php

/**
 * The shipping rates table
 *
 * This file is used to show the shipping rates for a product or store
 *
 * @link       http://www.wcvendors.com
 * @since      1.1.0
 * @version    1.8.0
 *
 * @package    WCVendors_Pro
 * @subpackage WCVendors_Pro/public/forms/partials/
 */

$all_continets = WC()->countries->get_continents();
$all_countries = ( WC()->countries->get_shipping_countries() ) ? WC()->countries->get_shipping_countries() : WC()->countries->get_allowed_countries();
$row_count     = 0;
$regions       = array();
$allow_ewe     = false;
if ( 'specific' !== get_option( 'woocommerce_ship_to_countries' ) ) {
    $regions = $all_continets;
    if ( ! isset( $all_countries['EWE'] ) ) {
        $all_countries['EWE'] = __( 'Everywhere else', 'wcvendors-pro' );
        $allow_ewe            = true;
    }
} else {
    $regions = WC()->countries->get_shipping_continents();
}

$all_countries = apply_filters( 'wcvendors_shipping_table_regions', $all_countries );

wp_nonce_field( 'wcvendors_save_shipping_table' );
?>

<div id="shipping-country-rates" class="form-field wcv_shipping_rates">
    <table id="wcv_shipping_rates_table">
        <thead>
        <tr>
            <th class="sort">&nbsp;</th>
            <th class="method-name">
                <?php esc_html_e( 'Method Name', 'wcvendors-pro' ); ?>
                <span class="wcv-tip">
                    <?php wcvp_get_icon( 'wcv-icon wcv-setting-icon', 'wcv-icon-info' ); ?>
                    <div class="content">
                        <?php esc_html_e( 'Enter a name for this shipping method (e.g., Standard Shipping, Express Shipping). This will be displayed to customers on the product page. If left blank, a default name will be used.', 'wcvendors-pro' ); ?>
                        <span class="arrow"></span>
                    </div>
                </span>
            </th>
            <th class="country"><?php esc_html_e( 'Region / Country', 'wcvendors-pro' ); ?></th>
            <th class="state"><?php esc_html_e( 'State', 'wcvendors-pro' ); ?> </th>
            <th class="postcode"><?php esc_html_e( 'Postcode', 'wcvendors-pro' ); ?> </th>
            <th class="fee"><?php esc_html_e( 'Shipping Fee', 'wcvendors-pro' ); ?></th>
            <th class="override"><?php esc_html_e( 'Override', 'wcvendors-pro' ); ?></th>
            <th class="del">&nbsp;</th>
        </tr>
        </thead>
        <tbody>

        <?php if ( $shipping_rates ) : ?>
            <?php $count_shipping_rates = count( $shipping_rates ); ?>

            <?php for ( $i = 0; $i < $count_shipping_rates; $i++ ) : ?>

                <?php $rate = $shipping_rates[ $i ]; ?>

                <!-- required for pro 1.4 and above -->
                <?php
                if ( ! array_key_exists( 'qty_override', $rate ) ) {
                    $rate['qty_override'] = '';
                }
                ?>
                <?php
                if ( ! array_key_exists( 'postcode', $rate ) ) {
                    $rate['postcode'] = '';
                }
                ?>
                <?php
                if ( ! array_key_exists( 'method_name', $rate ) ) {
                    $rate['method_name'] = '';
                }
                ?>

                <tr>
                    <td class="sort">
                        <?php wcvp_get_icon( 'wcv-icon wcv-icon-sm', 'wcv-icon-sort' ); ?>
                    </td>
                    <td class="method-name" data-title="<?php esc_attr_e( 'Method Name', 'wcvendors-pro' ); ?>">
                        <input type="text" placeholder="<?php esc_attr_e( 'Method Name', 'wcvendors-pro' ); ?>"
                                name="_wcv_shipping_method_names[]" value="<?php echo esc_attr( $rate['method_name'] ); ?>"/>
                    </td>

                    <td class="country" data-title="<?php esc_attr_e( 'Country', 'wcvendors-pro' ); ?>">
                        <select name="_wcv_shipping_countries[]" id="_wcv_shipping_countries[]"
                                class="country_to_state country_select">
                            <option value=""><?php esc_html_e( 'Select a country or region&hellip;', 'wcvendors-pro' ); ?></option>
                            <?php
                            foreach ( $regions as $key => $region ) {
                                $countries = array_intersect( array_keys( $all_countries ), $region['countries'] );
                                echo '<option value="continent:' . esc_attr( $key ) . '" ' . selected( esc_attr( 'continent:' . $rate['region'] ), 'continent:' . $key, false ) . '>' . esc_html( $region['name'] ) . '</option>';
                                foreach ( $countries as $ckey ) {
                                    echo '<option value="country:' . esc_attr( $ckey ) . '" ' . selected( esc_attr( 'country:' . $rate['country'] ), 'country:' . $ckey, false ) . '>' . esc_html( '&nbsp;&nbsp;' . $all_countries[ $ckey ] ) . '</option>';
                                }
                            }
                            echo $allow_ewe && isset( $all_countries['EWE'] ) ? '<option value="country:EWE" ' . selected( esc_attr( 'country:' . $rate['country'] ), 'country:EWE', false ) . '>' . esc_attr( __( 'Everywhere else', 'wcvendors-pro' ) ) . '</option>' : '';
                            ?>
                        </select>
                    </td>
                    <td class="state" data-title="<?php esc_attr_e( 'State', 'wcvendors-pro' ); ?>">
                        <input type="text" placeholder="<?php esc_attr_e( 'State', 'wcvendors-pro' ); ?>" class="shipping_state"
                                name="_wcv_shipping_states[]" value="<?php echo esc_attr( $rate['state'] ); ?>"/>
                    </td>
                    <td class="postcode" data-title="<?php esc_attr_e( 'Postcode', 'wcvendors-pro' ); ?>">
                        <input type="text" placeholder="<?php esc_attr_e( 'Postcode', 'wcvendors-pro' ); ?>"
                                name="_wcv_shipping_postcodes[]" value="<?php echo esc_attr( $rate['postcode'] ); ?>"/>
                    </td>
                    <td class="fee" data-title="<?php esc_attr_e( 'Shipping Fee', 'wcvendors-pro' ); ?>">
                        <input type="text" placeholder="<?php esc_attr_e( 'Fee', 'wcvendors-pro' ); ?>"
                                name="_wcv_shipping_fees[]" value="<?php echo esc_attr( $rate['fee'] ); ?>"
                                data-parsley-price/>
                    </td>
                    <td class="override" data-title="<?php esc_attr_e( 'Override', 'wcvendors-pro' ); ?>">
                        <label class="wcv-checkbox-container">
                            <input type="checkbox" name="_wcv_shipping_overrides_<?php echo esc_attr( $i ); ?>"
                                    id="_wcv_shipping_overrides_<?php echo esc_attr( $i ); ?>" <?php checked( $rate['qty_override'], 'yes' ); ?> />
                            <span class="checkmark"></span>
                            <?php esc_html_e( 'QTY', 'wcvendors-pro' ); ?>
                        </label>
                    </td>
                    <td class="del">
                        <a href="#" class="delete">
                            <?php wcvp_get_icon( 'wcv-icon wcv-icon-sm', 'wcv-icon-times' ); ?>
                        </a>
                    </td>
                </tr>
                <?php $row_count = $i; ?>
            <?php endfor; ?>
        <?php endif; ?>
        </tbody>

        <tfoot>
            <tr>
                <th colspan="8">
                    <a href="#" class="button insert" data-row="
                    <?php

                    $rate = array(
                        'region'       => '',
                        'country'      => '',
                        'method_name'  => '',
                        'state'        => '',
                        'postcode'     => '',
                        'fee'          => '',
                        'qty_override' => '',
                    );

                    $file_data_row = '<tr>
                                <td class="sort"><svg class="wcv-icon wcv-icon-sm"><use xlink:href="' . WCV_PRO_PUBLIC_ASSETS_URL . 'svg/wcv-icons.svg#wcv-icon-sort"></use></svg></td>
                                <td class="method-name" data-title="' . __( 'Method Name', 'wcvendors-pro' ) . '"><input type="text" placeholder="' . __( 'Method Name', 'wcvendors-pro' ) . '" name="_wcv_shipping_method_names[]" value="' . esc_attr( $rate['method_name'] ) . '" /></td>
                                 <td class="country" data-title="' . __( 'Country', 'wcvendors-pro' ) . '">
                                 <select name="_wcv_shipping_countries[]" id="_wcv_shipping_countries[]" class="country_to_state country_select">
                                    <option value="">' . __( 'Select a country or region&hellip;', 'wcvendors-pro' ) . '</option>';
                    foreach ( $regions as $key => $region ) {
                        $countries      = array_intersect( array_keys( $all_countries ), $region['countries'] );
                        $file_data_row .= '<option value="continent:' . esc_attr( $key ) . '" ' . selected( esc_attr( $rate['country'] ), $key, false ) . '>' . $region['name'] . '</option>';
                        foreach ( $countries as $ckey ) {
                            $file_data_row .= '<option value="country:' . esc_attr( $ckey ) . '" ' . selected( esc_attr( $rate['country'] ), $ckey, false ) . '>' . esc_html( '&nbsp;&nbsp;' . $all_countries[ $ckey ] ) . '</option>';
                        }
                    }

                    $file_data_row .= $allow_ewe && isset( $all_countries['EWE'] ) ? '<option value="country:EWE" ' . selected( esc_attr( 'country:' . $rate['country'] ), 'country:EWE', false ) . '>' . __( 'Everywhere else', 'wcvendors-pro' ) . '</option>' : '';
                    $file_data_row .= '</select></td>
                                <td class="state" data-title="' . __( 'State', 'wcvendors-pro' ) . '"><input type="text" placeholder="' . __( 'State', 'wcvendors-pro' ) . '" class="shipping_state" name="_wcv_shipping_states[]" value="' . esc_attr( $rate['state'] ) . '" /></td>
                                <td class="postcode" data-title="' . __( 'Postcode', 'wcvendors-pro' ) . '"><input type="text" placeholder="' . __( 'Postcode', 'wcvendors-pro' ) . '" name="_wcv_shipping_postcodes[]" value="' . esc_attr( $rate['postcode'] ) . '" /></td>
                                <td class="fee" data-title="' . __( 'Shipping Fee', 'wcvendors-pro' ) . '"><input type="text" data-parsley-price placeholder="' . __( 'Fee', 'wcvendors-pro' ) . '" name="_wcv_shipping_fees[]" value="' . esc_attr( $rate['fee'] ) . '" /></td>
                                <td class="override" data-title="' . __( 'Override', 'wcvendors-pro' ) . '"><label class="wcv-checkbox-container"><input type="checkbox" id="_wcv_shipping_overrides_" name="_wcv_shipping_overrides_" ' . checked( $rate['qty_override'], 'yes' ) . ' />' . __( 'QTY', 'wcvendors-pro' ) . '<span class="checkmark"></span></label></td>
                                <td width="1%"><a href="#" class="delete"><svg class="wcv-icon wcv-icon-sm"><use xlink:href="' . WCV_PRO_PUBLIC_ASSETS_URL . 'svg/wcv-icons.svg#wcv-icon-times"></use></svg></a></td>
                            </tr>';

                    echo esc_attr( $file_data_row );
                    ?>
                    "><?php esc_html_e( 'Add Rate', 'wcvendors-pro' ); ?></a>
                </th>
            </tr>
        </tfoot>
    </table>
</div>

<!-- <td class="country"><input type="text" placeholder="'. __( "Country", "wcvendors-pro" ) .'" name="_wcv_shipping_countries[]" value="' .esc_attr( $rate["country"] ). '" /></td> -->
