<?php
/**
 * Admin View: Importer - Done!
 *
 * @package WooCommerce\Admin\Importers
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<div class="wc-progress-form-content woocommerce-importer">
    <section class="woocommerce-importer-done">
        <?php
        $results = array();

        if ( 0 < $imported ) {
            $results[] = sprintf(
                /* translators: %d: products count */
                _n( '%s product imported', '%s products imported', $imported, 'wcvendors-pro' ),
                '<strong>' . number_format_i18n( $imported ) . '</strong>'
            );
        }

        if ( 0 < $updated ) {
            $results[] = sprintf(
                /* translators: %d: products count */
                _n( '%s product updated', '%s products updated', $updated, 'wcvendors-pro' ),
                '<strong>' . number_format_i18n( $updated ) . '</strong>'
            );
        }

        if ( 0 < $imported_variations ) {
            $results[] = sprintf(
                /* translators: %d: products count */
                _n( '%s variations imported', '%s variations imported', $imported_variations, 'wcvendors-pro' ),
                '<strong>' . number_format_i18n( $imported_variations ) . '</strong>'
            );
        }

        if ( 0 < $skipped ) {
            $results[] = sprintf(
                /* translators: %d: products count */
                _n( '%s product was skipped', '%s products were skipped', $skipped, 'wcvendors-pro' ),
                '<strong>' . number_format_i18n( $skipped ) . '</strong>'
            );
        }

        if ( 0 < $failed ) {
            $results [] = sprintf(
                /* translators: %d: products count */
                _n( 'Failed to import %s product', 'Failed to import %s products', $failed, 'wcvendors-pro' ),
                '<strong>' . number_format_i18n( $failed ) . '</strong>'
            );
        }

        if ( 0 < $failed || 0 < $skipped ) {
            $results[] = '<a href="#" class="woocommerce-importer-done-view-errors">' . __( 'View import log', 'wcvendors-pro' ) . '</a>';
        }

        if ( ! empty( $file_name ) ) {
            $results[] = sprintf(
                /* translators: %s: File name */
                __( 'File uploaded: %s', 'wcvendors-pro' ),
                '<strong>' . $file_name . '</strong>'
            );
        }

        /* translators: %d: import results */
        echo wp_kses_post( __( 'Import complete!', 'wcvendors-pro' ) . ' ' . implode( '. ', $results ) );
        ?>
    </section>
    <section class="wc-importer-error-log" style="display:none">
        <table class="widefat wc-importer-error-log-table">
            <thead>
                <tr>
                    <th><?php esc_html_e( 'Product', 'wcvendors-pro' ); ?></th>
                    <th><?php esc_html_e( 'Reason for failure', 'wcvendors-pro' ); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ( count( $errors ) ) {
                    foreach ( $errors as $err ) {
                        if ( ! is_wp_error( $err ) ) {
                            continue;
                        }
                        $error_data = $err->get_error_data();
                        ?>
                        <tr>
                            <th><code><?php echo esc_html( $error_data['row'] ); ?></code></th>
                            <td><?php echo esc_html( $err->get_error_message() ); ?></td>
                        </tr>
                        <?php
                    }
                }
                ?>
            </tbody>
        </table>
    </section>
    <script type="text/javascript">
        jQuery(function() {
            jQuery( '.woocommerce-importer-done-view-errors' ).on( 'click', function() {
                jQuery( '.wc-importer-error-log' ).slideToggle();
                return false;
            } );
        } );
    </script>
    <br/>
    <div class="wc-actions">
        <a class="button button-primary" href="<?php echo esc_url( WCVendors_Pro_Dashboard::get_dashboard_page_url() . 'product' ); ?>"><?php esc_html_e( 'View products', 'wcvendors-pro' ); ?></a>
    </div>
</div>
