<?php
/**
 * Admin View: Product import form
 *
 * @package WCVendors\Public\Dashboard
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<form class="wc-progress-form-content wcv-importer" enctype="multipart/form-data" method="post">
    <header>
        <h2><?php esc_html_e( 'Import products from a CSV file', 'wcv' ); ?></h2>
        <p><?php esc_html_e( 'This tool allows you to import (or merge) product data to your store from a CSV or TXT file.', 'wcv' ); ?></p>
    </header>
    <section>
        <table class="form-table wcv-importer-options">
            <tbody>
                <tr>
                    <th scope="row">
                        <label for="upload">
                            <?php esc_html_e( 'Choose a CSV file from your computer:', 'wcv' ); ?>
                        </label>
                    </th>
                    <td>
                        <?php
                        if ( ! empty( $upload_dir['error'] ) ) {
                            ?>
                            <div class="inline error">
                                <p><?php esc_html_e( 'Before you can upload your import file, you will need to fix the following error:', 'wcv' ); ?></p>
                                <p><strong><?php echo esc_html( $upload_dir['error'] ); ?></strong></p>
                            </div>
                            <?php
                        } else {
                            ?>
                            <input type="file" id="upload" name="import" size="25" />
                            <input type="hidden" name="action" value="save" />
                            <input type="hidden" name="max_file_size" value="<?php echo esc_attr( $bytes ); ?>" />
                            <br>
                            <small>
                                <?php
                                printf(
                                    /* translators: %s: maximum upload size */
                                    esc_html__( 'Maximum size: %s', 'wcv' ),
                                    esc_html( $size )
                                );
                                ?>
                            </small>
                            <?php
                        }
                        ?>
                    </td>
                </tr>
                <tr>
                    <th><label><?php esc_html_e( 'Import Mode', 'wcvendors-pro' ); ?></label><br/></th>
                    <td>
                        <input type="hidden" name="update_existing" value="0" />
                        <input type="hidden" name="hybrid_mode" value="0" />
                        
                        <div class="wcv-import-mode-options">
                            <p>
                                <input type="radio" id="wcv-importer-create-only" name="import_mode" value="create_only" checked="checked" />
                                <label for="wcv-importer-create-only">
                                    <strong><?php esc_html_e( 'Create new products only', 'wcvendors-pro' ); ?></strong><br/>
                                    <span class="description"><?php esc_html_e( 'Skip products that already exist (by ID or SKU). Only import new products.', 'wcvendors-pro' ); ?></span>
                                </label>
                            </p>
                            
                            <p>
                                <input type="radio" id="wcv-importer-update-only" name="import_mode" value="update_only" />
                                <label for="wcv-importer-update-only">
                                    <strong><?php esc_html_e( 'Update existing products only', 'wcvendors-pro' ); ?></strong><br/>
                                    <span class="description"><?php esc_html_e( 'Update products that match by ID or SKU. Skip products that do not exist.', 'wcvendors-pro' ); ?></span>
                                </label>
                            </p>
                            
                            <p>
                                <input type="radio" id="wcv-importer-hybrid-mode" name="import_mode" value="hybrid" />
                                <label for="wcv-importer-hybrid-mode">
                                    <strong><?php esc_html_e( 'Update existing and create new products (Hybrid)', 'wcvendors-pro' ); ?></strong><br/>
                                    <span class="description"><?php esc_html_e( 'Update products that match by ID or SKU, and create new products for rows that do not match. Best for master CSV files.', 'wcvendors-pro' ); ?></span>
                                </label>
                            </p>
                        </div>
                    </td>
                </tr>
                <tr class="wcv-importer-advanced hidden">
                    <th><label><?php esc_html_e( 'CSV Delimiter', 'wcv' ); ?></label><br/></th>
                    <td><input type="text" name="delimiter" placeholder="," size="2" /></td>
                </tr>
                <tr class="wcv-importer-advanced hidden">
                    <th><label><?php esc_html_e( 'Use previous column mapping preferences?', 'wcv' ); ?></label><br/></th>
                    <td><input type="checkbox" id="wcv-importer-map-preferences" name="map_preferences" value="1" /></td>
                </tr>
            </tbody>
        </table>
    </section>
    <script type="text/javascript">
        jQuery(function() {
            // Handle advanced options toggle
            jQuery( '.wcv-importer-toggle-advanced-options' ).on( 'click', function() {
                var elements = jQuery( '.wcv-importer-advanced' );
                if ( elements.is( '.hidden' ) ) {
                    elements.removeClass( 'hidden' );
                    jQuery( this ).text( jQuery( this ).data( 'hidetext' ) );
                } else {
                    elements.addClass( 'hidden' );
                    jQuery( this ).text( jQuery( this ).data( 'showtext' ) );
                }
                return false;
            } );
            
            // Handle import mode changes
            function updateImportModeFields() {
                var selectedMode = jQuery('input[name="import_mode"]:checked').val();
                
                switch(selectedMode) {
                    case 'create_only':
                        jQuery('input[name="update_existing"]').val('0');
                        jQuery('input[name="hybrid_mode"]').val('0');
                        break;
                    case 'update_only':
                        jQuery('input[name="update_existing"]').val('1');
                        jQuery('input[name="hybrid_mode"]').val('0');
                        break;
                    case 'hybrid':
                        jQuery('input[name="update_existing"]').val('0');
                        jQuery('input[name="hybrid_mode"]').val('1');
                        break;
                }
            }
            
            // Set initial values and bind change event
            updateImportModeFields();
            jQuery('input[name="import_mode"]').on('change', updateImportModeFields);
        });
    </script>
    <div class="wcv-actions  wcv-cols-group">
        <div class="all-50 align-left">
            <a href="#" class="wcv-importer-toggle-advanced-options" data-hidetext="<?php esc_attr_e( 'Hide advanced options', 'wcvendors-pro' ); ?>" data-showtext="<?php esc_attr_e( 'Show advanced options', 'wcvendors-pro' ); ?>"><?php esc_html_e( 'Show advanced options', 'wcvendors-pro' ); ?></a>
        </div>
        <div class="all-50 align-right">
            <button type="submit" class="button button-primary button-next" value="<?php esc_attr_e( 'Continue', 'wcvendors-pro' ); ?>" name="save_step"><?php esc_html_e( 'Continue', 'wcvendors-pro' ); ?></button>
            <?php wp_nonce_field( 'woocommerce-csv-importer' ); ?>
        </div>
    </div>
</form>
