<?php
/**
 * Commission Table Main Actions
 *
 * This file is used to add the table actions before and after a table
 *
 * @link       http://www.wcvendors.com
 * @since      1.8.4
 *
 * @package    WCVendors_Pro
 * @subpackage WCVendors_Pro/public/partials/product
 */

$date_format = WCVendors_Pro_Dashboard::get_date_format();
?>

<div class="wcv_dashboard_table_header wcv_actions wcv-cols-group horizontal-gutters wcv-commission-header">
    <div class="all-100 small-100">
        <form method="post" action="" class="wcv-form wcv-form-exclude">
            <div class="wcv-cols-group wcv-horizontal-gutters">
            <?php


            // Start Date.
            WCVendors_Pro_Form_Helper::input(
                apply_filters(
                    'wcv_commission_start_date_input',
                    array(
                        'id'                  => '_wcv_commission_start_date_input',
                        'label'               => __( 'Start date', 'wcvendors-pro' ),
                        'class'               => 'wcv-datepicker-dashboard-filter no_limit wcv-datepicker wcv-init-picker',
                        'value'               => gmdate( $date_format['format'], $this->get_start_date() ),
                        'placeholder'         => $date_format['placeholder'],
                        'wrapper_start'       => '<div class="all-70 medium-100 small-100"><div class="wcv-cols-group wcv-horizontal-gutters wcv-cols-group-narrow"><div class="all-50 small-50">',
                        'wrapper_end'         => '</div>',
                        'append_before'       => '<span class="wcv-flex" title="toggle" data-toggle>' . wcv_get_icon( 'wcv-icon wcv-icon-dashboard-icon', 'wcv-icon-calendar' ) . '</span>',
                        'input_wrapper_class' => 'wcv-datepicker-wrapper wcv-flex',
                        'custom_attributes'   => array(
                            'data-default' => gmdate( $date_format['format'], $this->get_default_start_date() ),
                            'maxlenth'     => '10',
                            'pattern'      => $date_format['pattern'],
                        ),
                    )
                )
            );

            // End Date.
            WCVendors_Pro_Form_Helper::input(
                apply_filters(
                    'wcv_commission_end_date_input',
                    array(
                        'id'                  => '_wcv_commission_end_date_input',
                        'label'               => __( 'End date', 'wcvendors-pro' ),
                        'class'               => 'wcv-datepicker-dashboard-filter no_limit wcv-datepicker wcv-init-picker',
                        'value'               => gmdate( $date_format['format'], $this->get_end_date() ),
                        'placeholder'         => $date_format['placeholder'],
                        'wrapper_start'       => '<div class="all-50 small-50">',
                        'wrapper_end'         => '</div></div></div>',
                        'append_before'       => '<span class="wcv-flex" title="toggle" data-toggle>' . wcv_get_icon( 'wcv-icon wcv-icon-dashboard-icon', 'wcv-icon-calendar' ) . '</span>',
                        'input_wrapper_class' => 'wcv-datepicker-wrapper wcv-flex',
                        'custom_attributes'   => array(
                            'data-default' => gmdate( $date_format['format'], strtotime( apply_filters( 'wcv_commission_end_date', 'now' ) ) ),
                            'maxlenth'     => '10',
                            'pattern'      => $date_format['pattern'],
                        ),
                    )
                )
            );

            // Update Button.
            WCVendors_Pro_Form_helper::button(
                apply_filters(
                    'wcv_commission_date_update',
                    array(
                        'id'            => 'update_button',
                        'value'         => __( 'Update', 'wc-vendors' ),
                        'type'          => 'submit',
                        'button_text'   => __( 'Update', 'wc-vendors' ),
                        'after_text'    => '</span>',
                        'class'         => 'wcv-button wcv-flex wcv-button-link-secondary text-blue',
                        'wrapper_start' => '<div class="all-30 medium-100 small-100 tiny-100 wcv-flex wcv-flex-end"><div class="control-group no-margin"><label class="wcv_desktop">&nbsp;&nbsp;</label>',
                        'wrapper_end'   => '</div>',
                        'before_text'   => wcv_get_icon( 'wcv-icon wcv-icon-24', 'wcv-icon-round-update' ) . '<span>',
                    )
                )
            );

            // Update Button.
            WCVendors_Pro_Form_helper::button(
                apply_filters(
                    'wcv_commission_filter_clear_button',
                    array(
                        'id'            => 'clear_button_commission',
                        'button_text'   => __( 'Clear', 'wc-vendors' ),
                        'class'         => 'wcv-button wcv-flex wcv-button-link-danger',
                        'type'          => 'submit',
                        'wrapper_start' => '<div class="control-group no-margin"><label class="wcv_desktop">&nbsp;&nbsp;</label>',
                        'wrapper_end'   => '</div></div>',
                    )
                )
            );

            wp_nonce_field( 'wcv-commission-date-update', 'wcv_commission_date_update' );
            ?>
            </div>
        </form>
    </div>

    <div class="all-100 small-100"  style="display: flex; align-items: center; flex-wrap: wrap-reverse;">
        <?php if ( $this->max_num_pages > 1 ) : ?>
        <div class="all-100 small-100 wcv-order-table-pagination-right">
            <?php
            echo wp_kses_post( $pagination_wrapper['wrapper_start'] );
            echo wp_kses_post(
                paginate_links(
                    apply_filters(
                        'wcv_order_pagination_args',
                        array(
                            'base'      => add_query_arg( 'paged', '%#%' ),
                            'format'    => 'paged=%#%',
                            'current'   => get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1,
                            'total'     => $this->max_num_pages,
                            'prev_next' => true,
                            'type'      => 'list',
                            'end_size'  => 2,
                            'mid_size'  => 2,
                        ),
                    )
                )
            );
            echo wp_kses_post( $pagination_wrapper['wrapper_end'] );
            ?>

        </div>
        <?php endif; ?>
    </div>

</div>
