<?php
/**
 * Plugin Name:       WC Vendors Pro
 * Requires Plugins:  woocommerce, wc-vendors
 * Plugin URI:        https://www.wcvendors.com/product/wc-vendors-pro/
 * Update URI:        www.wcvendors.com
 * Description:       The WC Vendors Pro plugin
 * Version:           2.0.2.1
 * Author:            WC Vendors
 * Author URI:        http://www.wcvendors.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       wcvendors-pro
 * Domain Path:       /languages
 *
 * @link              http://www.wcvendors.com
 * @since             1.0.5
 * @package           WCVendors_Pro
 *
 * Requires at least:    5.3
 * Tested up to:         6.9
 * WC requires at least: 4.5
 * WC tested up to:      10.4
 *
 * WC Vendors Pro is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * WC Vendors Pro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WC Vendors. If not, see http://www.gnu.org/licenses/gpl-2.0.txt.
 *
 * You have purchased a support contract for the duration of one year from the date
 * of purchase that entitles you access to updates of WC Vendors Pro and support
 * for WC Vendors Pro.
 */

use Automattic\WooCommerce\Utilities\FeaturesUtil;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
    die;
}

// Define Constants.
if ( ! defined( 'WCV_PRO_PLUGIN_FILE' ) ) {
    define( 'WCV_PRO_PLUGIN_FILE', __FILE__ );
}
if ( ! defined( 'WCV_PRO_VERSION' ) ) {
    define( 'WCV_PRO_VERSION', '2.0.2.1' );
}
if ( ! defined( 'WCV_PRO_ABSPATH_ADMIN' ) ) {
    define( 'WCV_PRO_ABSPATH_ADMIN', __DIR__ . '/admin/' );
}
if ( ! defined( 'WCV_PRO_ABSPATH_INCLUDES' ) ) {
    define( 'WCV_PRO_ABSPATH_INCLUDES', __DIR__ . '/includes/' );
}
if ( ! defined( 'WCV_PRO_ABSPATH_TEMPLATES' ) ) {
    define( 'WCV_PRO_ABSPATH_TEMPLATES', __DIR__ . '/templates/' );
}
if ( ! defined( 'WCV_PRO_PUBLIC_ASSETS_URL' ) ) {
    define( 'WCV_PRO_PUBLIC_ASSETS_URL', plugin_dir_url( __FILE__ ) . 'public/assets/' );
}
if ( ! defined( 'WCVP_SOFTWARE_KEY' ) ) {
    define( 'WCVP_SOFTWARE_KEY', 'WCVP' );
}
if ( ! defined( 'WCV_LICENSE_SERVER' ) ) {
    define( 'WCV_LICENSE_SERVER', 'https://www.wcvendors.com' );
}
if ( ! defined( 'WCVP_STATIC_PING_FILE' ) ) {
    define( 'WCVP_STATIC_PING_FILE', WCV_LICENSE_SERVER . '/WCVP.json' );
}
if ( ! defined( 'WCV_PRO_PLUGIN_DIR' ) ) {
    define( 'WCV_PRO_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}

/**
 * Declare HPOS incompatibility.
 *
 * @since   1.8.8
 * @version 1.8.8
 */
add_action(
    'before_woocommerce_init',
    function () {
        if ( class_exists( FeaturesUtil::class ) ) {
            FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__ );
        }
    }
);

/**
 * Declare Cart and Checkout Blocks incompatibility.
 *
 * @since   1.8.8
 * @version 1.8.8
 */
add_action(
    'before_woocommerce_init',
    function () {
        if ( class_exists( FeaturesUtil::class ) ) {
                FeaturesUtil::declare_compatibility( 'cart_checkout_blocks', __FILE__, false );
        }
    }
);

/**
 * Check if WC Vendors Marketplace is new version
 *
 * @since 1.9.2
 * @return bool
 */
function is_new_wcvf() {
    $is_new_wcvf = false;
    $wcv_path    = WP_PLUGIN_DIR . '/wc-vendors';
    $legacy_path = $wcv_path . '/legacy/classes/class-wc-vendors-bootstrap-legacy.php';
    if ( file_exists( $legacy_path ) ) {
        $is_new_wcvf = true;
    }

    return $is_new_wcvf;
}
/**
 * Required functions
 */
require_once plugin_dir_path( WCV_PRO_PLUGIN_FILE ) . 'includes/wcv-functions.php';
require_once plugin_dir_path( __FILE__ ) . 'includes/class-wcvendors-pro-activator.php';
require_once plugin_dir_path( __FILE__ ) . 'includes/class-wcvendors-pro-deactivator.php';

register_activation_hook( __FILE__, array( 'WCVendors_Pro_Activator', 'activate' ) );
register_deactivation_hook( __FILE__, array( 'WCVendors_Pro_Deactivator', 'deactivate' ) );
/**
 * Remove the commission tab from free version
 */
add_filter( 'wcvendors_product_commission_tab', '__return_false' );
/**
 * Include the update and support system
 */
require_once WCV_PRO_ABSPATH_ADMIN . 'class-wcvendors-pro-admin-license.php';
/**
 * WC_Software_License_Client instance.
 */
function wcslc_instance() {
    return WCVendors_Pro_Admin_License::get_instance( WCV_PRO_PLUGIN_FILE );
}

wcslc_instance();

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
if ( is_new_wcvf() ) {
    require plugin_dir_path( __FILE__ ) . 'includes/class-wcvendors-pro.php';
} else {
    require plugin_dir_path( __FILE__ ) . 'legacy/class-wcvendors-pro.php';
}

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @version 1.7.6
 * @since   1.0.0
 */
function run_wcvendors_pro() {
    global $wcvendors_pro;
    if ( is_woocommerce_active() ) {
        if ( is_wcvendors_active() ) {
            $wcvendors_pro = new WCVendors_Pro();
            $wcvendors_pro->run();
        } else {
            add_action( 'admin_notices', 'wcvendors_required_notice' );
        }
    } else {
        add_action( 'admin_notices', 'woocommerce_required_notice' );
    }
}

add_action( 'setup_theme', 'run_wcvendors_pro', 100 );


/**
 * Since 2.0.2
 * Migrate the settings from the old version to the new version.
 */
function wcvendors_pro_migrate_settings_on_update() {

    $db_version              = get_option( 'wcvendors_pro_version', 0 );
    $migrate_policy_settings = get_option( 'wcvendors_migrate_policy_settings', 'no' );

    if ( version_compare( $db_version, '2.0.2', '<' ) && 'no' === $migrate_policy_settings ) {
        // Only run migration if the function is available (requires dependencies to be active).
        if ( function_exists( 'wc_vendors_pro_migrate_policy_settings' ) ) {
            wc_vendors_pro_migrate_policy_settings();
            update_option( 'wcvendors_migrate_policy_settings', 'yes' );
        }
    }
}


add_action( 'init', 'wcvendors_pro_migrate_settings_on_update' );
