<?php
/**
 * Abstract class to handle all the modules on the plugin.
 *
 * @package WebToffee\CookieConsent\Lite\Includes
 */

namespace WebToffee\CookieConsent\Lite\Admin\Modules\Cache\Services;

use WebToffee\CookieConsent\Lite\Admin\Modules\Cache\Services\Services;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Module
 */
class Breeze extends Services {

	/**
	 * Load hooks of each plugin.
	 *
	 * @return void
	 */
	public function run() {
		$this->load_hooks();
	}

	/**
	 * Check if the the cache service is installed/active;
	 *
	 * @return boolean
	 */
	public function is_active() {
		return class_exists( \Breeze_Admin::class );
	}

	/**
	 * Clear the cache if any.
	 *
	 * @return void
	 */
	public function clear_cache() {
		do_action( 'breeze_clear_all_cache' );
	}
}
