<?php
/**
 * Class Cookies file.
 *
 * @package WebToffee
 */

namespace WebToffee\CookieConsent\Lite\Admin\Modules\Cookies;

use WebToffee\CookieConsent\Lite\Includes\Modules;
use WebToffee\CookieConsent\Lite\Admin\Modules\Cookies\Includes\Cookie_Controller;
use WebToffee\CookieConsent\Lite\Admin\Modules\Cookies\Includes\Category_Controller;
use WebToffee\CookieConsent\Lite\Admin\Modules\Cookies\Api\Categories_API;
use WebToffee\CookieConsent\Lite\Admin\Modules\Cookies\Api\Cookies_API;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Handles Cookies Operation
 *
 * @class       Cookies
 * @version     3.0.0
 * @package     WebToffee
 */
class Cookies extends Modules {

	/**
	 * Constructor.
	 */
	public function init() {
		$this->load_apis();
		add_action( 'admin_init', array( Category_Controller::get_instance(), 'install_tables' ) );
		add_action( 'wcc_after_update_cookie', array( Category_Controller::get_instance(), 'delete_cache' ) );
		add_action( 'wcc_after_update_cookie_category', array( Cookie_Controller::get_instance(), 'delete_cache' ) );
		add_action( 'wcc_after_update_cookie_category', array( Category_Controller::get_instance(), 'delete_cache' ) );
		add_action( 'admin_init', array( Cookie_Controller::get_instance(), 'reset_cache' ) );
		add_action( 'admin_init', array( Category_Controller::get_instance(), 'reset_cache' ) );
		add_action( 'admin_init', array( Cookie_Controller::get_instance(), 'install_tables' ) );
		add_filter( 'wcc_registered_admin_menus', array( $this, 'register_menus' ) );
		add_action( 'wcc_reinstall_tables', array( Category_Controller::get_instance(), 'reinstall' ) );
		add_action( 'wcc_reinstall_tables', array( Cookie_Controller::get_instance(), 'reinstall' ) );
	}

	/**
	 * Load API files
	 *
	 * @return void
	 */
	public function load_apis() {
		$cookie_cat_api = new Categories_API();
		$cookie_api     = new Cookies_API();
	}

	/**
	 * Pass menu items to be registered.
	 *
	 * @param array $menus Sub menu array.
	 * @return array
	 */
	public function register_menus( $menus ) {
		$menus['cookies'] = array(
			'name'     => __( 'Manage Cookies', 'webtoffee-cookie-consent' ),
			'callback' => array( $this, 'menu_page_template' ),
			'order'    => 3,

		);
		return $menus;
	}

	/**
	 * Main menu template
	 *
	 * @return void
	 */
	public function menu_page_template() {
		echo '<div id="wcc-app"></div>';
	}
}
