<?php
/**
 * Class LicenseManger file.
 *
 * @package WebToffee\CookieConsent
 */

namespace WebToffee\CookieConsent\Lite\Admin\Modules\License;

use WebToffee\CookieConsent\Lite\Includes\Modules;
use WebToffee\CookieConsent\Lite\Admin\Modules\License\Includes\Controller;
use WebToffee\CookieConsent\Lite\Admin\Modules\License\Api\Api;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Handles Cookies Operation
 *
 * @class       LicenseManger
 * @version     3.0.0
 * @package     WebToffee\CookieConsent
 */
class License extends Modules {

	/**
	 * Logs controller class.
	 *
	 * @var object
	 */
	private $controller;

	/**
	 * Constructor.
	 */
	public function init() {
		$this->load_apis();
		$this->controller = Controller::get_instance();
		add_filter( 'wcc_registered_admin_menus', array( $this, 'register_menus' ) );
	}

	/**
	 * Load API files
	 *
	 * @return void
	 */
	public function load_apis() {
		new Api();
	}

	/**
	 * Register menus for this module.
	 *
	 * @param array $menus Registered menus.
	 * @return array
	 */
	public function register_menus( $menus ) {
		$menus['license'] = array(
			'name'     => __( 'License', 'webtoffee-cookie-consent' ),
			'callback' => array( $this, 'menu_page_template' ),
			'order'    => 2,
		);
		return $menus;
	}

	/**
	 * Main menu template
	 *
	 * @return void
	 */
	public function menu_page_template() {
		echo '<div id="wcc-app"></div>';
	}
}
