<?php
/**
 * Class Policies file.
 *
 * @package WebToffee
 */

namespace WebToffee\CookieConsent\Lite\Admin\Modules\Policies;

use WebToffee\CookieConsent\Lite\Includes\Modules;
use WebToffee\CookieConsent\Lite\Admin\Modules\Policies\Includes\Controller;
use WebToffee\CookieConsent\Lite\Admin\Modules\Policies\Api\Api;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Handles Cookies Operation
 *
 * @class       Policies
 * @version     3.0.0
 * @package     WebToffee
 */
class Policies extends Modules {

	/**
	 * Policies controller class.
	 *
	 * @var object
	 */
	private $controller;

	/**
	 * Constructor.
	 */
	public function init() {
		$this->load_apis();
		$this->controller = Controller::get_instance();
		add_action( 'admin_init', array( $this->controller, 'install_tables' ) );
		add_action( 'admin_init', array( $this->controller, 'reset_cache' ) );
		add_filter( 'wcc_registered_admin_menus', array( $this, 'register_menus' ) );
		add_action( 'wcc_reinstall_tables', array( $this->controller, 'reinstall' ) );
	}



	public function load_apis() {
		new Api();
	}


	/**
	 * Pass menu items to be registered.
	 *
	 * @param array $menus Sub menu array.
	 * @return array
	 */
	public function register_menus( $menus ) {
		$menus['policies'] = array(
			'name'     => __( ' Cookie policy', 'webtoffee-cookie-consent' ),
			'callback' => array( $this, 'menu_page_template' ),
			'order'    => 5,
		);
		return $menus;
	}

	/**
	 * Main menu template
	 *
	 * @return void
	 */
	public function menu_page_template() {
		echo '<div id="wcc-app"></div>';
	}
}
