<?php
/**
 * Class Controller file.
 *
 * @package WebToffee\CookieConsent
 */

namespace WebToffee\CookieConsent\Lite\Admin\Modules\Policies\Includes;

use WebToffee\CookieConsent\Lite\Includes\Base_Controller;
use WebToffee\CookieConsent\Lite\Includes\Filesystem;
use stdClass;
use WP_Error;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Handles Cookies Operation
 *
 * @class       Controller
 * @version     3.0.0
 * @package     WebToffee\CookieConsent
 */
class Controller extends Base_Controller {

	/**
	 * Instance of the current class
	 *
	 * @var object
	 */
	private static $instance;
	/**
	 * Cookie items
	 *
	 * @var array
	 */
	protected $content;
	/**
	 * Cache group
	 *
	 * @var array
	 */
	protected $table_option = 'policies';

	/**
	 * Unique item identifier.
	 *
	 * @var string
	 */

	protected $id = 'id';

	/**
	 * Return the current instance of the class
	 *
	 * @return object
	 */

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Create policy page
	 *
	 * @since 3.0.0
	 *
	 * @param WP_REST_Request $request Full details about the request.
	 * @return WP_Error|WP_REST_Response
	 */

	public function create_page( $request ) {
		$content = isset( $request['content'] ) ? $request['content'] : '';
		// Prepare page data
		$new_page = array(
			'post_title'   => 'Cookie policy',
			'post_content' => $content,
			'post_status'  => 'draft',
			'post_type'    => 'page',
		);
		// Insert the page into the database
		$page_id = wp_insert_post( $new_page );
		update_option( 'wcc_policy_id', $page_id );
		return $page_id;
	}

	/**
	 * Decode a JSON string if necessary
	 *
	 * @param string $data String data.
	 * @return array
	 */
	public function prepare_json( $data ) {
		return is_string( $data ) ? json_decode( $data, true ) : $data;
	}

	/**
	 * Get contents by default.
	 *
	 * @return array
	 */
	public static function get_defaults() {
		$contents = wp_cache_get( 'wcc_default_policy_contents_en', 'wcc_default_contents' );
		if ( ! $contents ) {
			$contents = wcc_read_json_file( __DIR__ . '/contents/default.json' );
			wp_cache_set( 'wcc_default_policy_contents_en', $contents, 'wcc_default_contents', 12 * HOUR_IN_SECONDS );
		}
		return $contents;
	}
	public function update_custom_meta_field() {}
	public function update_item( $content ) {}
	public function delete_item( $content ) {}
	public function create_item( $content ) {}
	protected function get_schema() {}
	protected function get_tables() {}
	protected function load_default() {}
	public function get_item_from_db( $args = array(), $fields = '' ) {
		return array();}
	public function prepare_item( $item ) {}
}
