import store from '@/store/store'
import wccRest from '@/helpers/api';
/**
 * Get a single option value.
 *
 * @param {string} key Option key.
 * @param {string} group Option group.
 * @param {string|boolean|array|integer|object} value Default value.
 *
 * @since 3.2.4
 *
 * @return {string|boolean}
 */
export function getOption(key, value = false) {
    let current = value;
    const settings = store.state.settings.options
    // Only if set.
    if (settings[key]) {
        current = settings[key]
    }
    return current
}

export function getInfo(key = false, value = false) {
    let current = value;
    const settings = store.state.settings.info
    if (key === false) return settings;
    if (settings[key]) {
        current = settings[key]
    }
    return current
}
export async function loadInfo(force = false) {
    return await store.dispatch('settings/loadInfo', force)
}
/**
 * Set a single option value.
 *
 * Note: This will not update the value in db.
 * You need to call saveOptions() for that.
 *
 * @param {string} key Option key.
 * @param {string} group Option group.
 * @param {string|boolean|array} value Default value.
 *
 * @since 3.2.4
 *
 * @return {string|boolean}
 */
export function setOption(key, value) {
    store.dispatch('settings/set', {
        key: key,
        value: value,
    })
}

/**
 * Update the latest values in db.
 *
 * We will take the latest value from settings
 * vuex store and update it.
 *
 *
 * @since 3.2.4
 *
 * @return {string | string}
 */
export async function saveOptions() {
    return store.dispatch('settings/save');
}

export async function reloadSettings() {
    return await store.dispatch('settings/reInit');
}

export function getDefaultLanguage() {
    return store.state.languages.default && store.state.languages.default || 'en';
}

export async function setDefaultLanguage( lang = 'en') {
    await store.dispatch("languages/setDefault", lang);
}

export function getAssetsURL() {
    return window.wccGlobals.app.url;
}
export async function purgeCache() {
    await wccRest
        .post({
            path: `/settings/cache/purge`,
            data: {}
        })
}
export function isRTLLanguage(language = false) {
    if (language === false) {
        language = store.state.languages.current;
    }
    return ["ar", "az", "dv", "he", "ku", "fa", "ur"].includes(language);
}
export function checkDomain() {
    try {
        const { hostname: actual } = new URL(window.wccGlobals.site.url);
        const registered = new URL( store.state.settings.info.url );
        const registeredDomain = registered.hostname;
        const domains = actual.split(".");

        let isValidDomain = false;
        for (let index = 0; index < domains.length; index++) {
            const domain = domains.slice(index).join(".");
            isValidDomain =
                isValidDomain ||
                domain === registeredDomain ||
                domain.replace(/^www./, "") === registeredDomain.replace(/^www./, "");
            if (isValidDomain) break;
        }
        return isValidDomain;
    } catch (error) {
        return false;
    }
}
export async function updateConsentStatus(data) {
    try {
        const response = await wccRest.post({
            path: `/settings/renewconsentnotice`,
            data:{ status: data },
        });
        return response;
    } catch (error) {
        console.error(error);
    }
}
export async function updateReviewData(data) {
    try {
        const response = await wccRest.post({
            path: `/settings/reviewdata`,
            data:{ status: data },
        });
        return response;
    } catch (error) {
        console.error(error);
    }
}