import wccRest from "@/helpers/api";

export default {

    async getCookies(params = {}) {
        try {
            const response = await wccRest.get({
                path: "cookies/",
                params: params,
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async getCookie(id) {
        try {
            const response = await wccRest.get({
                path: `cookies/${id}`,
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async createCookie(data) {
        try {
            const response = await wccRest.post({
                path: `cookies/`,
                data: data,
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async updateCookie(id, data) {
        try {
            const response = await wccRest.put({
                path: `/cookies/${id}`,
                data: data,
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async deleteCookie(id) {
        try {
            const response = await wccRest.delete({
                path: `/cookies/${id}`,
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async getCookieCategories(params = {}) {
        try {
            const response = await wccRest.get({
                path: "cookies/categories",
                params: params,
            });
            if (response) return response;
        } catch (error) {
            console.error(error);
        }
    },
    async getCookieCategory(id) {
        try {
            const response = await wccRest.get({
                path: `cookies/categories/${id}`,
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async createCookieCategory(data) {
        try {
            const response = await wccRest.post({
                path: `cookies/categories`,
                data: data,
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async updateCookieCategory(id, data) {
        try {
            const response = await wccRest.put({
                path: `/cookies/categories/${id}`,
                data: data,
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async deleteCookieCategory(id) {
        try {
            const response = await wccRest.delete({
                path: `/cookies/categories/${id}`,
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async bulkUpdateCookieCategory(data) {
        data.forEach((item) => {
            item.cookie_list && delete item.cookie_list;
        });
        try {
            const response = await wccRest.post({
                path: `/cookies/categories/bulk`,
                data: { categories: data },
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async updateNoCookieScripts(data) {
        console.log(data);
        try {
            const response = await wccRest.post({
                path: `cookies/categories/nocookiescripts`,
                data: { no_cookie_script: data },
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
}