import wccRest from "@/helpers/api";

export default {
    async defaultPage() {
        try {
            const response = await wccRest.get({
                path: `/policies`,
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async createPage(content) {
        try {
            const response = await wccRest.post({
                path: `/policies/create`,
                data: { content: content },
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async updatedDate(page_id) {
        try {
            const response = await wccRest.get({
                path: `/policies/update`,
                params: { page_id: page_id },
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async pageExists(page_id) {
        try {
            const response = await wccRest.get({
                path: `/policies/pageexist`,
                params: { page_id: page_id },
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    }
}