import wccRest from "@/helpers/api";

export default {

    async initiateScan() {
        
        const response = await wccRest.post({
            path: `/scans/initiate`,
        });
        return response;
    },
    async startScan(scanId,scanToken) {
        try {
            const response = await wccRest.post({
                path: `/scans/start/${scanId}`,
                data: { scanToken: scanToken },
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async abortScan(scanId,scanToken) {
        try {
            const response = await wccRest.post({
                path: `/scans/abort/${scanId}`,
                data: { scanToken: scanToken },
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async checkScanHistory() {
        try {
            const response = await wccRest.get({
                path: `/scans`,
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async fetchScanStatus(scanId,scanToken) {
        try {
            const response = await wccRest.get({
                path: `/scans/status/${scanId}`,
                params: { scanToken: scanToken },
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async getScanResult(scanId,scanToken) {
        try {
            const response = await wccRest.get({
                path: `/scans/result/${scanId}`,
                params: { scanToken: scanToken },
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async fetchItem(scanId) {
        try {
            const response = await wccRest.get({
                path: `/scans/${scanId}`,
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    },
    async getIP()
    {
        try {
            const response = await wccRest.get({
                path: `/scans/ip`,
            });
            return response;
        } catch (error) {
            console.error(error);
        }
    }
}