<?php
/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://www.webtoffee.com/
 * @since      3.0.0
 *
 * @package    WebToffee
 * @subpackage CookieConsent/includes
 */

namespace WebToffee\CookieConsent\Lite\Includes;

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      3.0.0
 * @package    WebToffee
 * @subpackage CookieConsent/includes
 * @author     WebToffee <info@webtoffee.com>
 */
class I18n {

	/**
	 * Instance of the current class
	 *
	 * @var object
	 */
	private static $instance;

	/**
	 * Return the current instance of the class
	 *
	 * @return object
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    3.0.0
	 */
	public function load_plugin_textdomain() {
		// @codingStandardsIgnoreLine PluginCheck.CodeAnalysis.DiscouragedFunctions.load_plugin_textdomainFound -- Required for custom translation loading
		load_plugin_textdomain(
			'webtoffee-cookie-consent',
			false,
			dirname( CLI_PLUGIN_BASENAME, 2 ) . '/languages/'
		);
	}
}
