<?php
/**
 * CookieYes Integration
 *
 * @link       https://www.cookieyes.com/
 * @since      3.0.0
 *
 * @package    WebToffee\CookieConsent\Lite\Integrations\Cookieyes
 */

namespace WebToffee\CookieConsent\Lite\Integrations;

use WebToffee\CookieConsent\Lite\Includes\Request;
use WebToffee\CookieConsent\Lite\Admin\Modules\Settings\Includes\Settings;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class Request
 */
class Cookieyes extends Request {

	/**
	 * API Key
	 *
	 * @var string
	 */
	private $api_key = '';

	/**
	 * CookieYes web site id
	 *
	 * @var integer
	 */
	private $website_id;
	/**
	 * License object
	 *
	 * @var object
	 */
	/**
	 * Base URL of WebToffee API
	 */
	const API_BASE_PATH = WCC_WT_APP_URL;
	/**
	 * Base URL of CookieYes Scanner API
	 */
	const CKY_BASE_PATH = WCC_CKY_APP_SCANNER_URL . '/api/webtoffee-scan';

	/**
	 * Constructor
	 */
	public function __construct() {
		$this->init();
	}
	/**
	 * Initialize necessary variables to make an API call
	 *
	 * @return void
	 */
	public function init() {
		$settings         = new Settings();
		$this->api_key    = $settings->get_token();
		$this->website_id = $settings->get_website_id();
		$this->add_header_argument( 'Content-Type', 'application/json' );
		$this->add_header_argument( 'Accept', 'application/json' );
	}
	/**
	 * Get API URL.
	 *
	 * @param string $path  Endpoint path.
	 *
	 * @return string
	 */
	public function get_api_url( $path = '', $start_scan = false ) {
		if ( defined( 'self::API_BASE_PATH' ) && self::API_BASE_PATH && ! $start_scan ) {
			return self::API_BASE_PATH . $path;
		} elseif ( defined( 'self::CKY_BASE_PATH' ) && self::CKY_BASE_PATH && $start_scan ) {
			return self::CKY_BASE_PATH . $path;
		}
	}

	/**
	 * Get API key.
	 *
	 * @return string
	 */
	protected function get_api_key() {
		return $this->api_key;
	}

	/**
	 * Make a authenticated request by adding
	 *
	 * @return void
	 */
	public function make_auth_request( $token = '' ) {

		if ( ! empty( $token ) ) {
			$this->add_header_argument( 'Authorization', 'Bearer ' . $token );
		}
	}

	/**
	 * Returns the website id
	 *
	 * @return integer
	 */
	protected function get_website_id() {
		return $this->website_id;
	}
	/**
	 * Get the license info
	 *
	 * @return array
	 */
	protected function get_license() {
		return true;
	}
}
