<?php
/**
 * Initialize the plugin.
 */

if ( ! function_exists( 'wcc_define_constants' ) ) {
	/**
	 * Return parsed URL
	 *
	 * @return void
	 */
	function wcc_define_constants() {
		if ( ! defined( 'WCC_PLUGIN_URL' ) ) {
			define( 'WCC_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
		}
		if ( ! defined( 'WCC_APP_ASSETS_URL' ) ) {
			define( 'WCC_APP_ASSETS_URL', plugin_dir_url( __FILE__ ) . 'frontend/images/' );
		}
	}
}

wcc_define_constants();

require_once CLI_PLUGIN_BASEPATH . 'class-autoloader.php';

$autoloader = new \WebToffee\CookieConsent\Lite\Autoloader();
$autoloader->register();

register_activation_hook( __FILE__, array( \WebToffee\CookieConsent\Lite\Includes\Activator::get_instance(), 'install' ) );

$wcc_loader = new \WebToffee\CookieConsent\Lite\Includes\CLI();
$wcc_loader->run();
