<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.webtoffee.com/
 * @since             1.6.6
 * @package           Cookie_Law_Info
 *
 * @wordpress-plugin
 * Plugin Name:       GDPR Cookie Consent
 * Plugin URI:        https://www.webtoffee.com/product/gdpr-cookie-consent/
 * Description:       A simple way to show your website complies with the EU Cookie Law / GDPR.
 * Version:           3.5.0
 * Author:            WebToffee
 * Author URI:        https://www.webtoffee.com/
 * License:           GPLv3
 * License URI:       https://www.gnu.org/licenses/gpl-3.0.html
 * Text Domain:       webtoffee-cookie-consent
 */

/*
	Copyright 2018  WebToffee

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License, version 2, as
	published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}
/**
 * Legacy Plugin active check
 */
if ( ! function_exists( 'is_plugin_active' ) ) {
	include_once ABSPATH . 'wp-admin/includes/plugin.php';
}

if ( is_plugin_active( 'webtoffee-gdpr-cookie-consent/cookie-law-info.php' ) ) {
    // phpcs:ignore Generic.WhiteSpace.DisallowSpaceIndent.SpacesUsed
    deactivate_plugins( plugin_basename( __FILE__ ) );

	if ( function_exists( 'wp_create_nonce' ) ) {
		$deactivation_url = wp_nonce_url(
			// phpcs:ignore Generic.WhiteSpace.DisallowSpaceIndent.SpacesUsed
			add_query_arg(
				array(
					'action' => 'deactivate',
					'plugin' => 'webtoffee-gdpr-cookie-consent/cookie-law-info.php',
				),
				admin_url( 'plugins.php' )
			),
			'deactivate-plugin_webtoffee-gdpr-cookie-consent/cookie-law-info.php'
		);
	} else {
		// Fallback in case wp_create_nonce is unavailable.
		$deactivation_url = admin_url( 'plugins.php' );
	}

	$message = '<h2>Heads up! Legacy Version Detected</h2>
        <p>Why am I not able to activate the plugin? You are unable to activate this version because the legacy version of the plugin is currently active on your site.</p>
        <p>What’s Happening? We have released a revamped version of the plugin. Since the legacy version is already active on your site, you need to deactivate it first to activate the new version.</p>
        <p><strong>Action Required:</strong></p>
        <ul>
            <li>Deactivate the legacy version of the plugin.</li>
            <li>Activate the revamped version.</li>
        </ul>
        <p>Note: This installation requires a new configuration.</p>
        <p>Rolling Back to Legacy Version: If you encounter any issues or prefer to use the previous version, you can easily roll back:</p>
        <ul>
            <li>Deactivate the new version.</li>
            <li>Reactivate the old plugin.</li>
        </ul>
        <p>How can I update my existing plugin? If you wish to update your existing plugin, you have two options:</p>
        <ul>
            <li>Activate the license: Go to the settings page of the currently installed plugin, activate the license, and check for updates.</li>
            <li>Download from Webtoffee account: Log in to your Webtoffee account, navigate to My Accounts > Downloads, and click on the Legacy version link to download the latest update.</li>
        </ul>
        <p>Thank you for your attention to these instructions. Should you have any questions or need further assistance, please do not hesitate to contact our support team.</p>
        <p><a href="' . esc_url( $deactivation_url ) . '" target="_blank">Deactivate Legacy Version</a></p>';

	wp_die(
		wp_kses_post( $message ),
		'',
		array(
			'link_url'  => esc_url( admin_url( 'plugins.php' ) ),
			'link_text' => esc_html__( 'Go to plugins page', 'webtoffee-cookie-consent' ),
		)
	);
}
define( 'CLI_VERSION', '3.5.0' );
define( 'CLI_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
define( 'CLI_PLUGIN_BASEPATH', plugin_dir_path( __FILE__ ) );
define( 'CLI_SETTINGS_FIELD', 'CookieLawInfo-0.9' );
// Previous version settings (deprecated from 0.9 onwards).
define( 'CLI_ADMIN_OPTIONS_NAME', 'CookieLawInfo-0.8.3' );
define( 'CLI_PLUGIN_FILENAME', __FILE__ );
define( 'CLI_POST_TYPE', 'cookielawinfo' );
define( 'CLI_DEFAULT_LANGUAGE', wcc_set_default_language() );
define( 'WCC_WT_APP_URL', 'https://cookie-scan.webtoffee.com' );
define( 'WCC_CKY_APP_SCANNER_URL', 'https://cookie-scanner.webtoffee.com' );
if ( ! defined( 'WCC_PLUGIN_FILENAME' ) ) {
	define( 'WCC_PLUGIN_FILENAME', __FILE__ );
}

/**
 * Load and set default language of the site.
 *
 * @return string
 */
function wcc_set_default_language() {
	$default = get_option( 'WPLANG', 'en_US' );
	if ( empty( $default ) || strlen( $default ) <= 1 ) {
		$default = 'en';
	}
	return substr( $default, 0, 2 );
}

/**
 * Return internal DB version.
 *
 * @return string
 */
function wcc_get_consent_db_version() {
	return get_option( 'wcc_cookie_consent_lite_db_version', '2.0' );
}
/**
 * Check if plugin is in legacy version.
 *
 * @return boolean
 */
require_once CLI_PLUGIN_BASEPATH . 'lite/loader.php';
